/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import java.util.Properties;
import rnasecondary.SecondaryStructure;
import secondarystructuredesign.SecondaryStructureScorer;

public class DummyEnergySecondaryStructureScorer
implements SecondaryStructureScorer {
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private boolean zeroMode = false;

    public double interactionEnergy(char c1, char c2) {
        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
            return 0.0;
        }
        if (c1 > c2) {
            return this.interactionEnergy(c2, c1);
        }
        switch (c1) {
            case 'A': {
                if (c2 == 'U') {
                    return this.energyAU;
                }
            }
            case 'C': {
                if (c2 != 'G') break;
                return this.energyGC;
            }
        }
        return 0.0;
    }

    private double energyStructureSequence(StringBuffer bseq, int[][] interactions) {
        assert (interactions.length == bseq.length());
        double score = 0.0;
        for (int i = 0; i < interactions.length; ++i) {
            for (int j = i + 2; j < interactions.length; ++j) {
                if (interactions[i][j] != 1) continue;
                score += this.interactionEnergy(bseq.charAt(i), bseq.charAt(j));
            }
        }
        return score;
    }

    private double energyStructureSequencePair(StringBuffer bseq1, StringBuffer bseq2, int[][] interactions) {
        assert (interactions.length == bseq1.length());
        assert (interactions[0].length == bseq2.length());
        double score = 0.0;
        for (int i = 0; i < interactions.length; ++i) {
            for (int j = 0; j < interactions[i].length; ++j) {
                if (interactions[i][j] == -1) continue;
                score += this.interactionEnergy(bseq1.charAt(i), bseq2.charAt(j));
            }
        }
        return score;
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        Properties resultProperties = new Properties();
        double score = 0.0;
        if (!this.zeroMode) {
            for (int i = 0; i < bseqs.length; ++i) {
                score += this.energyStructureSequence(bseqs[i], interactionMatrices[i][i]);
                for (int j = i + 1; j < bseqs.length; ++j) {
                    score += this.energyStructureSequencePair(bseqs[i], bseqs[j], interactionMatrices[i][j]);
                }
            }
        }
        resultProperties.setProperty("score", "" + score);
        return resultProperties;
    }

    public void setZeroMode(boolean b) {
        this.zeroMode = b;
    }
}

