/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import rnasecondary.SecondaryStructure;
import secondarystructuredesign.SecondaryStructureScorer;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.SimpleSequence;
import sequence.SimpleUnevenAlignment;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;

public abstract class AbstractSecondaryStructureScorer
implements SecondaryStructureScorer {
    private Alphabet alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;

    protected UnevenAlignment generateAlignment(StringBuffer[] bseqs) throws UnknownSymbolException, DuplicateNameException {
        SimpleUnevenAlignment ali = new SimpleUnevenAlignment();
        for (int i = 0; i < bseqs.length; ++i) {
            SimpleSequence seq = new SimpleSequence(bseqs[i].toString().toUpperCase(), "s" + (i + 1), this.alphabet);
            ali.addSequence(seq);
        }
        return ali;
    }

    protected double scorePrediction(int[][] prediction, int[][] reference) {
        assert (prediction.length == reference.length);
        assert (prediction[0].length == reference[0].length);
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        for (int i = 0; i < prediction.length; ++i) {
            for (int j = 0; j < prediction[0].length; ++j) {
                int vp = prediction[i][j];
                int vr = reference[i][j];
                if (vr == -1) {
                    if (vp == -1) {
                        ++tn;
                        continue;
                    }
                    ++fp;
                    continue;
                }
                if (vp == -1) {
                    ++fn;
                    continue;
                }
                ++tp;
            }
        }
        return fp + fn;
    }

    protected double scorePrediction(SecondaryStructure prediction, SecondaryStructure reference, int[][][][] interactionMatrices) {
        assert (prediction != null);
        assert (reference != null);
        assert (interactionMatrices != null);
        double result = 0.0;
        for (int i = 0; i < prediction.getSequenceCount(); ++i) {
            for (int j = i; j < prediction.getSequenceCount(); ++j) {
                result += this.scorePrediction(prediction.toInteractionMatrix(i, j), interactionMatrices[i][j]);
            }
        }
        return result;
    }

    public void setAlphabet(Alphabet val) {
        this.alphabet = val;
    }
}

