/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.util.ArrayList;
import java.util.List;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SimpleInteractionSet;
import rnasecondary.SimpleSecondaryStructure;
import sequence.Alphabet;
import sequence.DuplicateNameException;
import sequence.SimpleSequence;
import sequence.SimpleUnevenAlignment;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;

public class SimpleMutableSecondaryStructure
extends SimpleSecondaryStructure
implements MutableSecondaryStructure {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final int STRAND_ADDED_EVENT = 1;
    public static final int STEM_ADDED_EVENT = 2;
    private ArrayList<ModelChangeListener> listeners = new ArrayList();

    public SimpleMutableSecondaryStructure(UnevenAlignment alignment, InteractionSet interactions) {
        super(alignment, interactions);
    }

    public SimpleMutableSecondaryStructure(UnevenAlignment alignment, InteractionSet interactions, List<List<Double>> weights) {
        super(alignment, interactions, weights);
    }

    public SimpleMutableSecondaryStructure() {
        super(new SimpleUnevenAlignment(), new SimpleInteractionSet());
    }

    @Override
    public String getClassName() {
        return "MutableSecondaryStructure";
    }

    @Override
    public void removeInteraction(Interaction i) {
        this.getInteractions().remove(i);
    }

    @Override
    public void clear() {
        this.setSequences(new SimpleUnevenAlignment());
        this.setInteractions(new SimpleInteractionSet());
    }

    @Override
    public void addStrand(String name, String seq, Alphabet a) {
        try {
            this.addSequence(new SimpleSequence(seq, name, a));
            this.fireModelChanged(new ModelChangeEvent((Object)this, 1));
        }
        catch (DuplicateNameException e1) {
        }
        catch (UnknownSymbolException e2) {
            // empty catch block
        }
    }

    @Override
    public void addModelChangeListener(ModelChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void fireModelChanged(ModelChangeEvent event) {
        for (ModelChangeListener l : this.listeners) {
            l.modelChanged(event);
        }
    }
}

