/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import graphtools.PermutationGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import numerictools.IntegerArrayTools;
import numerictools.PotentialND;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnadesign.rnamodel.SimpleConnectivityIterator;
import rnadesign.rnamodel.SingleStrandBridgeFinder;
import tools3d.GeometryTools;
import tools3d.Matrix3DTools;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class TraceRnaPotential
implements PotentialND {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private LinkSet links;
    private Object3DSet objSet;
    private int[][] bestPerms;
    private List<List<Integer>> linkIds;
    private List<BranchDescriptor3D> branchDescriptors;
    private List<Integer> helixLengths;
    private int helixLengthMax = 100;
    private double turnHeight;
    private double offset;
    private double distMax = 7.0;
    private double distMin = 3.0;
    private double collisionDistance = 4.0;
    private double collisionPenalty = 0.0;
    private int bridgeLenMax = 5;
    private int verboseLevel = 1;
    private char c1 = (char)71;
    private char c2 = (char)67;
    private double crossingDistanceLimit = 7.0;
    private boolean generateBridgesMode = true;

    public TraceRnaPotential(Object3DSet objSet, LinkSet links, double turnHeight, double offset, double distMax, double distMin, int _helixLengthMax) {
        assert (TraceRnaPotential.validate(objSet, links, turnHeight, offset));
        this.links = links;
        this.objSet = objSet;
        this.turnHeight = turnHeight;
        this.offset = offset;
        this.distMax = distMax;
        this.distMin = distMin;
        this.helixLengthMax = _helixLengthMax;
        this.init();
        assert (this.getDimension() == links.size());
        assert (this.validate());
    }

    public boolean getGenerateBridgesMode() {
        return this.generateBridgesMode;
    }

    public void setGenerateBridgesMode(boolean mode) {
        this.generateBridgesMode = mode;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int n) {
        this.verboseLevel = n;
    }

    public static boolean validate(double edgeDistance, double turnHeight, double offset) {
        double helLen = edgeDistance - 2.0 * offset;
        return helLen > RnaConstants.HELIX_RISE;
    }

    public static boolean validate(Object3DSet objSet, LinkSet links, double turnHeight, double offset) {
        for (int i = 0; i < links.size(); ++i) {
            if (TraceRnaPotential.validate(links.get(i).getObj1().distance(links.get(i).getObj2()), turnHeight, offset)) continue;
            return false;
        }
        return true;
    }

    public Object3DLinkSetBundle generateRna(double[] angles, String baseName, Object3D nucleotideDB, List<Object3DLinkSetBundle> bridgeBundle) {
        assert (angles != null && baseName != null && Object3DTools.validateName(baseName) && nucleotideDB != null);
        assert (angles.length == this.branchDescriptors.size());
        this.log.info("Starting generateRna");
        for (int i = 0; i < this.objSet.size(); ++i) {
            this.log.info(((Object)this.objSet.get(i)).toString());
        }
        double value = this.getValue(angles);
        SimpleObject3D root = new SimpleObject3D(baseName);
        SimpleLinkSet links = new SimpleLinkSet();
        for (int i = 0; i < this.branchDescriptors.size(); ++i) {
            String name = baseName + "_" + (i + 1);
            int len = this.helixLengths.get(i);
            BranchDescriptor3D bd = this.branchDescriptors.get(i);
            this.log.info("Generating helix for branch descriptor " + (i + 1) + " " + bd.getPosition().toString() + " " + bd.getDirection().toString());
            Object3DLinkSetBundle helixBundle = ConnectJunctionTools.generateIdealStem(bd, this.c1, this.c2, name, nucleotideDB, len);
            Object3D obj = helixBundle.getObject3D();
            obj.rotate(bd.getDirection(), angles[i]);
            root.insertChild(helixBundle.getObject3D());
            links.merge(helixBundle.getLinks());
        }
        if (this.generateBridgesMode) {
            Object3DSet strands = Object3DTools.collectByClassName(root, "RnaStrand");
            SingleStrandBridgeFinder bridgeFinder = new SingleStrandBridgeFinder(bridgeBundle);
            bridgeFinder.setLenMax(this.bridgeLenMax);
            for (int i = 0; i < this.objSet.size(); ++i) {
                List<Object3DLinkSetBundle> bridges = this.generateVertexBridges(angles, i, strands, bridgeFinder);
                if (bridges != null) {
                    this.log.info("Generated " + bridges.size() + " bridges for vertex " + (i + 1));
                    for (int j = 0; j < bridges.size(); ++j) {
                        root.insertChildSafe(bridges.get(j).getObject3D());
                        links.merge(bridges.get(j).getLinks());
                    }
                    continue;
                }
                this.log.info("No bridges could be generated for vertex " + (i + 1));
            }
        }
        this.log.info("Finished generateRna");
        return new SimpleObject3DLinkSetBundle(root, links);
    }

    Nucleotide3D findClosestStrandEnd(Object3DSet strands, Vector3D pos) {
        assert (strands != null && strands.size() > 0);
        double bestDist = 99999.8;
        Residue3D result = null;
        for (int i = 0; i < strands.size(); ++i) {
            RnaStrand strand = (RnaStrand)strands.get(i);
            Residue3D nuc = strand.getResidue3D(0);
            double d = nuc.getChild(0).getPosition().distance(pos);
            if (d < bestDist) {
                bestDist = d;
                result = nuc;
            }
            if (!((d = (nuc = strand.getResidue3D(strand.getResidueCount() - 1)).getChild(0).getPosition().distance(pos)) < bestDist)) continue;
            bestDist = d;
            result = nuc;
        }
        assert (result != null);
        return (Nucleotide3D)result;
    }

    private List<Object3DLinkSetBundle> generateVertexBridges(double[] angles, int vertexId, Object3DSet strands, SingleStrandBridgeFinder bridgeFinder) {
        Nucleotide3D resThreeB;
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        Vector3D[] posFive = this.computeFivePrimePositions(angles, vertexId);
        Vector3D[] posThree = this.computeThreePrimePositions(angles, vertexId);
        int[] perm = this.bestPerms[vertexId];
        assert (posFive.length == posThree.length);
        assert (perm.length + 1 == posFive.length);
        for (int i = 1; i < perm.length; ++i) {
            Nucleotide3D resThree;
            Nucleotide3D resFive = this.findClosestStrandEnd(strands, posFive[perm[i - 1]]);
            List<Object3DLinkSetBundle> bridges = bridgeFinder.findBridge(resFive, resThree = this.findClosestStrandEnd(strands, posThree[perm[i]]));
            if (bridges == null || bridges.size() <= 0) continue;
            result.add(bridges.get(0));
        }
        Vector3D lastFivePos1 = posFive[perm[perm.length - 1]];
        Vector3D firstThreePos1 = posThree[posThree.length - 1];
        Vector3D lastFivePos2 = posFive[posFive.length - 1];
        Vector3D firstThreePos2 = posThree[perm[0]];
        Nucleotide3D resFiveB = this.findClosestStrandEnd(strands, lastFivePos1);
        List<Object3DLinkSetBundle> bridges = bridgeFinder.findBridge(resFiveB, resThreeB = this.findClosestStrandEnd(strands, firstThreePos1));
        if (bridges != null && bridges.size() > 0) {
            result.add(bridges.get(0));
        }
        Nucleotide3D resFiveC = this.findClosestStrandEnd(strands, lastFivePos2);
        Nucleotide3D resThreeC = this.findClosestStrandEnd(strands, firstThreePos2);
        bridges = bridgeFinder.findBridge(resFiveB, resThreeB);
        if (bridges != null && bridges.size() > 0) {
            result.add(bridges.get(0));
        }
        return result;
    }

    List<Integer> generateObjectLinkIds(int n) {
        assert (n >= 0 && n < this.objSet.size());
        ArrayList<Integer> result = new ArrayList<Integer>();
        Object3D obj = this.objSet.get(n);
        for (int i = 0; i < this.links.size(); ++i) {
            Link link = this.links.get(i);
            int order = link.linkOrder(obj);
            assert (order < 2);
            if (order == 1) {
                result.add(i);
                continue;
            }
            assert (order == 0);
        }
        assert (result != null);
        return result;
    }

    private void init() {
        assert (this.links != null);
        this.linkIds = new ArrayList<List<Integer>>();
        for (int i = 0; i < this.objSet.size(); ++i) {
            this.linkIds.add(this.generateObjectLinkIds(i));
        }
        this.initHelices();
        this.bestPerms = new int[this.objSet.size()][0];
        assert (this.validate());
    }

    private void initHelix(Vector3D p1Pos, Vector3D p2Pos) {
        Vector3D dir = p2Pos.minus(p1Pos);
        double helLen = dir.length() - 2.0 * this.offset;
        assert (helLen > 0.0);
        assert (dir.length() > 0.0);
        dir.normalize();
        Vector3D base = p1Pos.plus(dir.mul(this.offset));
        Vector3D y = Vector3DTools.generateRandomOrthogonalDirection(dir);
        Vector3D x = y.cross(dir);
        CoordinateSystem3D cs = new CoordinateSystem3D(base, x, y);
        SimpleBranchDescriptor3D bd = new SimpleBranchDescriptor3D(new CoordinateSystem3D(Vector3D.ZVEC));
        bd.setCoordinateSystem(cs);
        this.branchDescriptors.add(bd);
        int numBp = SimpleConnectivityIterator.estimateNumberBasePairs(helLen);
        if (numBp > this.helixLengthMax) {
            numBp = this.helixLengthMax;
        }
        this.helixLengths.add(numBp);
        this.log.info("Added length of helix " + this.helixLengths.size() + " : " + numBp);
    }

    private void initHelix(int n) {
        Link link = this.links.get(n);
        this.initHelix(link.getObj1().getPosition(), link.getObj2().getPosition());
    }

    private void initHelices() {
        this.branchDescriptors = new ArrayList<BranchDescriptor3D>();
        this.helixLengths = new ArrayList<Integer>();
        for (int i = 0; i < this.links.size(); ++i) {
            this.initHelix(i);
        }
    }

    public boolean validate() {
        boolean check3;
        boolean check2;
        boolean check1;
        boolean bl = check1 = this.branchDescriptors != null && this.helixLengths != null && this.links != null && this.objSet != null && this.linkIds != null;
        if (!check1) {
            return false;
        }
        boolean bl2 = check2 = this.links.size() == this.branchDescriptors.size() && this.links.size() == this.helixLengths.size();
        if (!check2) {
            return false;
        }
        boolean bl3 = check3 = this.objSet.size() == this.linkIds.size();
        return check3;
    }

    @Override
    public double[] generateLowPosition() {
        double[] result = new double[this.getDimension()];
        Random rand = Randomizer.getInstance();
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.PI * 2 * rand.nextDouble();
        }
        return result;
    }

    @Override
    public double[] generateHighPosition() {
        return this.generateLowPosition();
    }

    @Override
    public int getDimension() {
        return this.links.size();
    }

    @Override
    public double getValue(double[] angles) {
        double sum = 0.0;
        for (int i = 0; i < this.objSet.size(); ++i) {
            sum += this.computeVertexValue(angles, i);
        }
        return sum;
    }

    private double computeStrandConnectionValue(Vector3D posFive, Vector3D posThree) {
        double dist = posFive.distance(posThree);
        if (dist > this.distMax) {
            return dist - this.distMax;
        }
        if (dist < this.distMin) {
            return this.distMin - dist;
        }
        return 0.0;
    }

    private double getVertexValue(Vector3D[] posFive, Vector3D[] posThree, int[] perm) {
        assert (posFive.length == posThree.length);
        assert (perm.length + 1 == posFive.length);
        double sum = 0.0;
        ArrayList<Vector3D> startPositions = new ArrayList<Vector3D>();
        ArrayList<Vector3D> endPositions = new ArrayList<Vector3D>();
        for (int i = 1; i < perm.length; ++i) {
            sum += this.computeStrandConnectionValue(posFive[perm[i - 1]], posThree[perm[i]]);
            startPositions.add(posFive[perm[i - 1]]);
            endPositions.add(posThree[perm[i]]);
        }
        Vector3D lastFivePos1 = posFive[perm[perm.length - 1]];
        Vector3D firstThreePos1 = posThree[posThree.length - 1];
        Vector3D lastFivePos2 = posFive[posFive.length - 1];
        Vector3D firstThreePos2 = posThree[perm[0]];
        startPositions.add(lastFivePos1);
        endPositions.add(firstThreePos1);
        sum += this.computeStrandConnectionValue(lastFivePos1, firstThreePos1);
        startPositions.add(lastFivePos2);
        endPositions.add(firstThreePos2);
        sum += this.computeStrandConnectionValue(lastFivePos2, firstThreePos2);
        return sum += this.scoreLineCrossings(startPositions, endPositions);
    }

    private double scoreLineCrossing(Vector3D p0, Vector3D p1, Vector3D q0, Vector3D q1) {
        Vector3D u = p1.minus(p0);
        Vector3D v = q1.minus(q0);
        assert (u.lengthSquare() > 0.0);
        assert (v.lengthSquare() > 0.0);
        double dist = GeometryTools.distanceOfLines(p0, u, q0, v);
        double result = 0.0;
        if (dist < this.crossingDistanceLimit) {
            result = this.crossingDistanceLimit - dist;
        }
        return result;
    }

    private double scoreLineCrossings(List<Vector3D> startPositions, List<Vector3D> stopPositions) {
        assert (startPositions.size() == stopPositions.size());
        double sum = 0.0;
        for (int i = 0; i < startPositions.size(); ++i) {
            for (int j = i + 1; j < startPositions.size(); ++j) {
                sum += this.scoreLineCrossing(startPositions.get(i), stopPositions.get(i), startPositions.get(j), stopPositions.get(j));
            }
        }
        return sum;
    }

    private int countCollisions(Vector3D[] pv, double distance) {
        int result = 0;
        for (int i = 0; i < pv.length; ++i) {
            for (int j = i + 1; j < pv.length; ++j) {
                if (!(pv[i].distance(pv[j]) < distance)) continue;
                ++result;
            }
        }
        return result;
    }

    private int countCollisions(Vector3D[] posFive, Vector3D[] posThree, double distance) {
        int result = this.countCollisions(posFive, distance) + this.countCollisions(posThree, distance);
        for (int i = 0; i < posFive.length; ++i) {
            for (int j = 0; j < posThree.length; ++j) {
                if (!(posFive[i].distance(posThree[j]) < distance)) continue;
                ++result;
            }
        }
        return result;
    }

    private double computeVertexValue(Vector3D[] posFive, Vector3D[] posThree, int vertexId) {
        assert (posFive.length == posThree.length);
        int order = posFive.length;
        if (order < 2) {
            return 0.0;
        }
        PermutationGenerator perm = new PermutationGenerator(order - 1);
        double bestScore = 1.0E30;
        do {
            double score;
            if (!((score = this.getVertexValue(posFive, posThree, perm.get())) < bestScore)) continue;
            bestScore = score;
            this.bestPerms[vertexId] = IntegerArrayTools.clone(perm.get());
        } while (perm.hasNext() && perm.inc());
        bestScore = this.collisionPenalty * (double)this.countCollisions(posFive, posThree, this.collisionDistance);
        return bestScore;
    }

    private double computeVertexValue(double[] angles, int vertexId) {
        Vector3D[] posFiveVec = this.computeFivePrimePositions(angles, vertexId);
        Vector3D[] posThreeVec = this.computeThreePrimePositions(angles, vertexId);
        return this.computeVertexValue(posFiveVec, posThreeVec, vertexId);
    }

    private boolean hasBranchDescriptor(int linkId, int vertexId) {
        assert (linkId >= 0 && linkId < this.links.size());
        assert (vertexId >= 0 && vertexId < this.objSet.size());
        Link link = this.links.get(linkId);
        Object3D obj = this.objSet.get(vertexId);
        if (link.getObj1() == obj) {
            return true;
        }
        assert (link.getObj2() == obj);
        return false;
    }

    private Vector3D computeFivePrimePosition(int linkId, double angle, int vertexId) {
        assert (this.branchDescriptors != null && this.branchDescriptors.size() == this.links.size());
        BranchDescriptor3D bd = this.branchDescriptors.get(linkId);
        Vector3D p = this.hasBranchDescriptor(linkId, vertexId) ? bd.computeHelixPosition(0, 2) : bd.computeHelixPosition(this.helixLengths.get(linkId), 1);
        p = Matrix3DTools.rotate(p, bd.getDirection(), angle, bd.getPosition());
        return p;
    }

    private Vector3D computeThreePrimePosition(int linkId, double angle, int vertexId) {
        assert (this.branchDescriptors != null && this.branchDescriptors.size() == this.links.size());
        BranchDescriptor3D bd = this.branchDescriptors.get(linkId);
        Vector3D p = this.hasBranchDescriptor(linkId, vertexId) ? bd.computeHelixPosition(0, 1) : bd.computeHelixPosition(this.helixLengths.get(linkId), 2);
        p = Matrix3DTools.rotate(p, bd.getDirection(), angle, bd.getPosition());
        return p;
    }

    private Vector3D[] computeFivePrimePositions(double[] angles, int vertexId) {
        List<Integer> linkId = this.linkIds.get(vertexId);
        Vector3D[] result = new Vector3D[linkId.size()];
        if (this.verboseLevel > 2) {
            System.out.print("5' positions of helices at vertex " + (vertexId + 1) + " : ");
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.computeFivePrimePosition(linkId.get(i), angles[linkId.get(i)], vertexId);
            if (this.verboseLevel <= 2) continue;
            System.out.print("" + result[i] + " " + this.objSet.get(vertexId).getPosition().distance(result[i]) + " ; ");
        }
        if (this.verboseLevel > 2) {
            System.out.println();
        }
        return result;
    }

    private Vector3D[] computeThreePrimePositions(double[] angles, int vertexId) {
        List<Integer> linkId = this.linkIds.get(vertexId);
        Vector3D[] result = new Vector3D[linkId.size()];
        if (this.verboseLevel > 2) {
            System.out.print("3' positions of helices at vertex " + (vertexId + 1) + " : ");
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.computeThreePrimePosition(linkId.get(i), angles[linkId.get(i)], vertexId);
            if (this.verboseLevel <= 2) continue;
            System.out.print("" + result[i] + " " + this.objSet.get(vertexId).getPosition().distance(result[i]) + " ; ");
        }
        if (this.verboseLevel > 2) {
            System.out.println();
        }
        return result;
    }

    public void setBasepairCharacters(char c1, char c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    public int getHelixLengthMax() {
        return this.helixLengthMax;
    }

    private void setHelixLengthMax(int len) {
        this.helixLengthMax = len;
    }
}

