/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.PackageConstants;

public class TilingStatistics {
    private double averageAngle = 0.0;
    private double averageDistance = 0.0;
    private int numberAngles = 0;
    private int numberDistances = 0;
    private int numberPlaced = 0;
    private int numberUnplaced = 0;
    private double sumAngle = 0.0;
    private double sumDistance = 0.0;

    public TilingStatistics() {
    }

    public TilingStatistics(TilingStatistics other) {
        this.copy(other);
    }

    public Object clone() {
        return new TilingStatistics(this);
    }

    public void copy(TilingStatistics other) {
        this.averageAngle = other.averageAngle;
        this.averageDistance = other.averageDistance;
        this.numberAngles = other.numberAngles;
        this.numberDistances = other.numberDistances;
        this.numberPlaced = other.numberPlaced;
        this.numberUnplaced = other.numberUnplaced;
        this.sumAngle = other.sumAngle;
        this.sumDistance = other.sumDistance;
    }

    public double getAverageAngle() {
        return this.averageAngle;
    }

    public double getCoverage() {
        if (this.getNumberTrials() <= 0) {
            return 0.0;
        }
        return (double)this.numberPlaced / (double)this.getNumberTrials();
    }

    public double getAverageDistance() {
        return this.averageDistance;
    }

    public int getNumberPlaced() {
        return this.numberPlaced;
    }

    public int getNumberUnplaced() {
        return this.numberUnplaced;
    }

    public int getNumberTrials() {
        return this.getNumberPlaced() + this.getNumberUnplaced();
    }

    public void setAverageAngle(double a) {
        this.averageAngle = a;
    }

    public void setAverageDistance(double d) {
        this.averageDistance = d;
    }

    public void updateAverageAngle(double angle) {
        this.sumAngle += angle;
        ++this.numberAngles;
        this.averageAngle = this.sumAngle / (double)this.numberAngles;
        this.setAverageAngle(this.averageAngle);
    }

    public void updateAverageDistance(double distance) {
        this.sumDistance += distance;
        ++this.numberDistances;
        this.averageDistance = this.sumDistance / (double)this.numberDistances;
        this.setAverageDistance(this.averageDistance);
    }

    public void updateCoverage(boolean placedFlag) {
        if (placedFlag) {
            ++this.numberPlaced;
        } else {
            ++this.numberUnplaced;
        }
    }

    public String toString() {
        String string = new String("");
        string = string + PackageConstants.ENDL + PackageConstants.ENDL + "Placed: " + this.numberPlaced + PackageConstants.ENDL + "Unplaced: " + this.numberUnplaced;
        string = string + PackageConstants.ENDL + "Coverage: " + (int)(this.getCoverage() * 100.0) + "%";
        string = string + PackageConstants.ENDL + "Average best angle: " + this.getAverageAngle();
        return string;
    }
}

