/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;

public class StructureQualityTools {
    public static final String[] backboneNames = new String[]{"P", "O5*", "C5*", "C4*", "C3*", "O3*"};
    public static final String[] backboneNames5 = new String[]{"O5*", "C5*", "C4*", "C3*", "O3*"};
    public static final String[] backboneNames3 = backboneNames;

    public static boolean containsChildren(Object3D obj, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (obj.getIndexOfChild(names[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    private static double findMaximumBackboneGap(Nucleotide3D nuc) throws RnaModelException {
        String[] usedBackboneNames = backboneNames;
        if (NucleotideTools.is5PrimeNucleotide(nuc)) {
            usedBackboneNames = backboneNames5;
        }
        if (!StructureQualityTools.containsChildren(nuc, usedBackboneNames)) {
            throw new RnaModelException("Missing backbone atoms in nucleotide " + nuc.getName());
        }
        double maxDist = 0.0;
        for (int i = 1; i < usedBackboneNames.length; ++i) {
            double dist = nuc.getChild(usedBackboneNames[i - 1]).distance(nuc.getChild(usedBackboneNames[i]));
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        return maxDist;
    }

    public static void assertChild(Object3D obj, String name) throws RnaModelException {
        if (obj.getIndexOfChild(name) < 0) {
            throw new RnaModelException("Could not find child " + name + " in object " + obj.getClassName() + " " + obj.getName());
        }
    }

    private static double getInterNucleotideBackboneGap(Nucleotide3D nuc1, Nucleotide3D nuc2) throws RnaModelException {
        StructureQualityTools.assertChild(nuc1, backboneNames[backboneNames.length - 1]);
        StructureQualityTools.assertChild(nuc2, backboneNames[0]);
        double dist = nuc1.getChild(backboneNames[backboneNames.length - 1]).distance(nuc2.getChild(backboneNames[0]));
        return dist;
    }

    public static int countBackboneGaps(RnaStrand strand, double cutoff) {
        int count = 0;
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            double gapMax;
            try {
                gapMax = StructureQualityTools.findMaximumBackboneGap((Nucleotide3D)strand.getResidue3D(i));
                if (gapMax > cutoff) {
                    ++count;
                }
            }
            catch (RnaModelException rme) {
                System.out.println("Count as gap! Rna model exception in nucleotide " + strand.getResidue3D(i).getName() + " : " + rme.getMessage());
                ++count;
            }
            if (i <= 0) continue;
            try {
                gapMax = StructureQualityTools.getInterNucleotideBackboneGap((Nucleotide3D)strand.getResidue(i - 1), (Nucleotide3D)strand.getResidue(i));
                if (!(gapMax > cutoff)) continue;
                ++count;
                continue;
            }
            catch (RnaModelException rme) {
                System.out.println("Count as gap! Rna model exception in nucleotides " + strand.getResidue3D(i - 1).getName() + " and " + strand.getResidue3D(i).getName() + " : " + rme.getMessage());
                ++count;
            }
        }
        return count;
    }

    public static int countAllBackboneGaps(Object3D root, double cutoff) {
        int count = 0;
        Object3DSet strandSet = Object3DTools.collectByClassName(root, "RnaStrand");
        for (int i = 0; i < strandSet.size(); ++i) {
            RnaStrand strand = (RnaStrand)strandSet.get(i);
            int numGaps = StructureQualityTools.countBackboneGaps(strand, cutoff);
            count += numGaps;
        }
        return count;
    }
}

