/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.CollectionTools;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import rnadesign.rnamodel.AbstractPdbReader;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.RnaLinkTools;
import rnadesign.rnamodel.RnaNtlWriter;
import rnadesign.rnamodel.RnaPdbReader;
import rnadesign.rnamodel.RnaPdbRnaviewReader;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnadesign.rnamodel.SimpleRnaStrand;
import rnadesign.rnamodel.SimpleStrandJunction3D;
import rnadesign.rnamodel.StemTools;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import rnadesign.rnamodel.StrandJunctionTools;
import sequence.SimpleAlphabet;
import sequence.SimpleLetterSymbol;
import sequence.SimpleSequence;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DSet;
import tools3d.objects3d.modeling.CollisionForceField;

public class StrandJunctionDBTools {
    public static final String NTL_EXTENSION = ".ntl";
    private static final double stemFitRmsTolerance = 3.0;
    public static final double JUNCTION_DIST_MAX = 20.0;
    public static final double KISSINGLOOP_DIST_MAX = 20.0;
    public static final boolean SUBJUNCTION_ALLOWED = true;
    public static boolean regularJunctionMode = false;
    public static final double COLLINEAR_LIMIT_RAD = Math.PI;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    private static boolean isSubStrand(NucleotideStrand smallStrand, NucleotideStrand largeStrand, int offset) {
        if (smallStrand.getResidueCount() + 2 * offset != largeStrand.getResidueCount()) {
            return false;
        }
        String largeSeqCut = largeStrand.sequenceString().substring(offset, largeStrand.sequenceString().length() - offset);
        return smallStrand.sequenceString().equals(largeSeqCut);
    }

    private static int findSubStrandIndex(StrandJunction3D junction, NucleotideStrand strand, int offset) {
        for (int i = 0; i < junction.getStrandCount(); ++i) {
            if (!StrandJunctionDBTools.isSubStrand(junction.getStrand(i), strand, offset)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isSubJunction(StrandJunction3D junction1, StrandJunction3D junction2, int offset) {
        if (junction1.getStrandCount() != junction2.getStrandCount()) {
            return false;
        }
        for (int i = 0; i < junction1.getStrandCount(); ++i) {
            int id = StrandJunctionDBTools.findSubStrandIndex(junction2, junction1.getStrand(i), offset);
            if (id >= 0) continue;
            return false;
        }
        return true;
    }

    private static int findSubJunction(StrandJunction3D junction, Object3D junctions, int offset) {
        log.fine("Starting findSubJunction " + junction.getFullName() + " " + offset + " " + junction.infoString());
        for (int i = 0; i < junctions.size(); ++i) {
            StrandJunction3D junction2;
            if (!(junctions.getChild(i) instanceof StrandJunction3D) || !StrandJunctionDBTools.isSubJunction(junction, junction2 = (StrandJunction3D)junctions.getChild(i), offset)) continue;
            log.fine("Subjunction found: " + junction2.infoString());
            return i;
        }
        log.fine("Finished findSubJunction " + junction.getFullName() + " " + offset + " : -1");
        return -1;
    }

    public static boolean verifyJunction(StrandJunction3D junction, Object3D tree, Object3D junctionsZero, int offset) {
        boolean clashFree;
        int i;
        if (junction.getStrandCount() != junction.getBranchCount()) {
            log.info("Strand count is not equal to branch count " + junction.getFullName());
            if (regularJunctionMode) {
                return false;
            }
        }
        ArrayList<NucleotideStrand> strandSet = new ArrayList<NucleotideStrand>();
        for (i = 0; i < junction.getStrandCount(); ++i) {
            NucleotideStrand strand = junction.getStrand(i);
            log.fine("Testing junction sequence: " + strand.sequenceString());
            if (CollectionTools.containsIdentical(strandSet, strand) != null) {
                log.info("Junction does not validate because it containts identical strands: " + junction.getFullName());
                return false;
            }
            for (NucleotideStrand strand2 : strandSet) {
                if (!strand2.isProbablyEqual(strand)) continue;
                log.info("Junction does not validate because it containts probably equal strands: " + junction.getFullName());
                return false;
            }
            strandSet.add(strand);
        }
        for (i = 0; i < junction.getBranchCount(); ++i) {
            BranchDescriptor3D branch = junction.getBranch(i);
            log.fine("Testing branch " + (i + 1) + " " + branch.getPosition() + " : " + branch.getDirection() + " " + branch.getIncomingStrand().sequenceString() + " " + branch.getOutgoingStrand().sequenceString());
            double ang = branch.getRelativePosition().angle(branch.getDirection());
            if (ang > Math.PI) {
                log.fine("ang: " + ang + " > COLLINEAR_LIMIT_RAD");
            }
            if (branch.getIncomingStrand() != branch.getOutgoingStrand()) continue;
            log.info("Junction does not validate because an incoming strand is equal to an outgoing strand: " + junction.getFullName());
            return false;
        }
        Object3DSet atomSet = Object3DTools.collectByClassName(tree, "Atom3D");
        if (atomSet.size() == 0) {
            log.info("Junction does not validate because it does not contain any atoms: " + junction.getFullName());
            return false;
        }
        Vector3D pos = junction.getPosition();
        double dMin = atomSet.get(0).getPosition().distance(pos);
        for (int i2 = 1; i2 < atomSet.size(); ++i2) {
            Object3D obj = atomSet.get(i2);
            double d = obj.getPosition().distance(pos);
            if (!(d < dMin)) continue;
            dMin = d;
        }
        if (dMin > 20.0) {
            log.fine("dMin > JUNCTION_DIST_MAX");
        }
        if (!(clashFree = StrandJunctionTools.stericalCheck(junction))) {
            log.info("Clash detected! Omitting junction: " + junction.getFullName());
            return false;
        }
        return true;
    }

    public static boolean verifyKissingLoop(KissingLoop3D kissingLoop, Object3D tree) {
        for (int i = 0; i < kissingLoop.getBranchCount(); ++i) {
            BranchDescriptor3D branch = kissingLoop.getBranch(i);
            double ang = branch.getRelativePosition().angle(branch.getDirection());
            if (!(ang > Math.PI)) continue;
            log.fine("ang: " + ang + " > COLLINEAR_LIMIT_RAD");
            return false;
        }
        Object3DSet atomSet = Object3DTools.collectByClassName(tree, "Atom3D");
        if (atomSet.size() == 0) {
            log.fine("atomSet.size() == 0");
            return false;
        }
        Vector3D pos = kissingLoop.getPosition();
        double dMin = atomSet.get(0).getPosition().distance(pos);
        for (int i = 1; i < atomSet.size(); ++i) {
            Object3D obj = atomSet.get(i);
            double d = obj.getPosition().distance(pos);
            if (!(d < dMin)) continue;
            dMin = d;
        }
        if (dMin > 20.0) {
            log.fine("dMin > KISSINGLOOP_DIST_MAX");
            return false;
        }
        return true;
    }

    public static void parsePdbFilesToDB(StrandJunctionDB junctionDB, StrandJunctionDB kissingLoopDB, String fileName, int cloneDownSize, String readDir, String writeDir, boolean noWriteFlag, boolean rnaviewMode, boolean randomMode, int branchDescriptorOffset, int stemLengthMin, CorridorDescriptor corridorDescriptor, int loopLengthSumMax) throws IOException {
        assert (fileName != null && fileName.length() > 0);
        assert (rnaviewMode);
        assert (branchDescriptorOffset >= 0);
        String idname = fileName.substring(0, 4);
        Date startDate = new Date();
        long startTime = new Long(startDate.getTime());
        log.fine("Starting StrandJunctionDBTools.parsePdbFilesToDB(2)");
        CollisionForceField collisionDetector = new CollisionForceField();
        String frontChar = fileName.substring(0, 1);
        if (!frontChar.equals(PackageConstants.SLASH) && !frontChar.equals(".") && readDir != null && readDir.length() > 0) {
            fileName = readDir + PackageConstants.SLASH + fileName;
        }
        log.info("Processing file : " + fileName);
        int id = 0;
        if (fileName.endsWith(NTL_EXTENSION)) {
            log.fine("NanoTiler generated file found: " + fileName);
            StrandJunction3D ntlFile = StrandJunctionDBTools.readNtl(fileName);
            SimpleLinkSet links = new SimpleLinkSet();
            ntlFile.setFilename(idname + StrandJunctionDBTools.intToChar(id));
            ++id;
            if (ntlFile instanceof KissingLoop3D) {
                kissingLoopDB.addJunction(ntlFile, links);
            } else {
                junctionDB.addJunction(ntlFile, links);
            }
        } else {
            AbstractPdbReader reader;
            FileInputStream is = new FileInputStream(fileName);
            if (rnaviewMode) {
                reader = new RnaPdbRnaviewReader();
            } else {
                log.severe("Only reading of RNAview augmented PDB files is currently supported.");
                assert (false);
                reader = new RnaPdbReader();
            }
            Object3DLinkSetBundle bundle = reader.readBundle(is);
            Object3D root = bundle.getObject3D();
            LinkSet links = bundle.getLinks();
            SimpleLinkSet emptyLinks = new SimpleLinkSet();
            if (randomMode) {
                log.fine("NOT randomizing orientation of object tree: " + root.getName());
            }
            Object3DSet atomSet = Object3DTools.collectByClassName(root, "Atom3D");
            log.fine(" " + atomSet.size() + " atoms found in PDB file.");
            double collisionEnergy = collisionDetector.energy(atomSet, links);
            if (collisionEnergy > 0.0) {
                log.warning("Sorry, collisions detected in structure: " + fileName);
            } else {
                log.fine("No collisions detected!");
            }
            Object3DLinkSetBundle stemBundle = null;
            if (rnaviewMode) {
                stemBundle = StemTools.generateStemsFromLinks(root, links, stemLengthMin);
                log.fine("Generated " + stemBundle.getObject3D().size() + " stems using a minimum length cutoff " + stemLengthMin);
            } else {
                assert (false);
                stemBundle = StemTools.generateStems(root);
            }
            Object3D stemRoot = stemBundle.getObject3D();
            Object3DTools.balanceTree(stemRoot);
            if (stemRoot.size() > 0) {
                int j;
                log.fine("StrandJunctionDBTools: Generating junctions from " + stemRoot.size() + " stems.");
                Object3D junctions = BranchDescriptorTools.generateJunctions(stemRoot, "dummy", branchDescriptorOffset, corridorDescriptor, 3.0, loopLengthSumMax);
                Object3D junctionsZero = null;
                if (branchDescriptorOffset != 0) {
                    junctionsZero = BranchDescriptorTools.generateJunctions(stemRoot, "dummy", 0, corridorDescriptor, 3.0, loopLengthSumMax);
                    for (j = junctionsZero.size() - 1; j >= 0; --j) {
                        if (StrandJunctionDBTools.verifyJunction((StrandJunction3D)junctionsZero.getChild(j), root, null, 0)) continue;
                        junctionsZero.removeChild(j);
                    }
                }
                log.fine("Number of detected junctions in structure: " + junctions.size());
                for (j = 0; j < junctions.size(); ++j) {
                    StrandJunction3D junction = (StrandJunction3D)junctions.getChild(j);
                    String junctionName = fileName + "_junc" + (j + 1);
                    if (cloneDownSize < 1) {
                        junction.setProperty("filename_orig", fileName);
                        junction.setProperty("filename", junctionName);
                        if (!StrandJunctionDBTools.verifyJunction(junction, root, junctionsZero, branchDescriptorOffset)) {
                            log.info("junction " + junctionName + " with position: " + junction.getPosition() + " is not usable!");
                            continue;
                        }
                        log.fine("junction of order " + junction.getBranchCount() + " and name " + junctionName + " is usable. Adding junction!");
                        RnaNtlWriter ntlWriter = new RnaNtlWriter();
                        if (writeDir != null && !writeDir.equals("")) {
                            ntlWriter.write(writeDir, junctionName, junction);
                        }
                        junction.setFilename(idname + StrandJunctionDBTools.intToChar(id));
                        ++id;
                        junctionDB.addJunction(junction, emptyLinks);
                        continue;
                    }
                    Object3DSet smallerJunctions = junction.cloneDown(cloneDownSize);
                    for (int i = 0; i < smallerJunctions.size(); ++i) {
                        StrandJunction3D sJunction = (StrandJunction3D)smallerJunctions.get(i);
                        assert (sJunction.getBranchCount() == cloneDownSize);
                        String sJunctionName = junctionName + "_" + (i + 1);
                        sJunction.setProperty("filename_orig", fileName);
                        sJunction.setProperty("filename", junctionName);
                        sJunction.setName(sJunctionName);
                        if (!StrandJunctionDBTools.verifyJunction(sJunction, root, junctionsZero, branchDescriptorOffset)) {
                            log.info("junction " + junctionName + " with position: " + junction.getPosition() + " is not usable!");
                            continue;
                        }
                        junction.setFilename(idname + StrandJunctionDBTools.intToChar(id));
                        ++id;
                        log.info("Adding Junction!");
                        junctionDB.addJunction(sJunction, emptyLinks);
                    }
                }
                Object3D kissingLoops = BranchDescriptorTools.generateKissingLoops(stemRoot, "dummy", branchDescriptorOffset, 3.0);
                SimpleLinkSet tmpLinks = new SimpleLinkSet();
                log.fine("Number of detected kissing loops in structure: " + kissingLoops.size());
                for (int j2 = 0; j2 < kissingLoops.size(); ++j2) {
                    KissingLoop3D kissingLoop = (KissingLoop3D)kissingLoops.getChild(j2);
                    String name = fileName + "_kl" + (j2 + 1);
                    kissingLoop.setName(name);
                    kissingLoop.setProperty("filename_orig", fileName);
                    kissingLoop.setProperty("filename", name);
                    log.fine("Adding kissing loop " + kissingLoop.getName() + " with position: " + kissingLoop.getPosition());
                    if (!StrandJunctionDBTools.verifyKissingLoop(kissingLoop, root)) {
                        log.info("kissing loop " + kissingLoop.getName() + " with position: " + kissingLoop.getPosition() + " is not usable!");
                        continue;
                    }
                    log.fine("kissing loop " + kissingLoop.getName() + " was usable");
                    String kissingLoopName = new String();
                    RnaNtlWriter ntlWriter = new RnaNtlWriter();
                    if (writeDir != null && !writeDir.equals("")) {
                        ntlWriter.write(writeDir, kissingLoop.getName(), kissingLoop);
                    }
                    log.fine("Adding kissing loop. Number of current entries: " + kissingLoopDB.size(2));
                    kissingLoop.setFilename(idname + StrandJunctionDBTools.intToChar(id));
                    ++id;
                    kissingLoopDB.addJunction(kissingLoop, tmpLinks);
                    log.fine("Added kissing loop. Number of current entries: " + kissingLoopDB.size(2));
                    assert (kissingLoopDB.size(2) > 0);
                }
            } else {
                log.info("Could not find any stems using stem length min " + stemLengthMin + " and links: ");
                for (int i = 0; i < links.size(); ++i) {
                    if (!RnaLinkTools.isBasePairLink(links.get(i))) continue;
                    System.out.println("" + (i + 1) + ((Object)links.get(i)).toString());
                }
            }
            ((InputStream)is).close();
        }
        Date endDate = new Date();
        long endTime = new Long(endDate.getTime());
        Long totalMilli = new Long(endTime - startTime);
        int totalSec = totalMilli.intValue() / 1000;
        int totalMin = totalSec / 60;
        totalSec -= totalMin * 60;
        int totalHour = totalMin / 60;
        totalMin -= totalHour * 60;
        String timeString = "";
        if (totalHour < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalHour + ":";
        if (totalMin < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalMin + ":";
        if (totalSec < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalSec;
        log.fine(PackageConstants.NEWLINE + PackageConstants.NEWLINE + "parsePdbFilesToDB(2) took " + timeString + PackageConstants.NEWLINE);
        log.fine("parsePdbFilesToDB (2) ended");
    }

    public static void parsePdbFilesToDB(StrandJunctionDB junctionDB, StrandJunctionDB kissingLoopDB, String fileName, int cloneDownSize, String readDir, String writeDir, boolean noWriteFlag, boolean rnaviewMode, boolean randomMode, int branchDescriptorOffset, int stemLengthMin, CorridorDescriptor corridorDescriptor, int loopLengthSumMax, boolean IntHelicesCheck) throws IOException {
        assert (fileName != null && fileName.length() > 0);
        assert (rnaviewMode);
        assert (branchDescriptorOffset >= 0);
        String idname = fileName.substring(0, 4);
        Date startDate = new Date();
        long startTime = new Long(startDate.getTime());
        log.fine("Starting StrandJunctionDBTools.parsePdbFilesToDB(2)");
        CollisionForceField collisionDetector = new CollisionForceField();
        String frontChar = fileName.substring(0, 1);
        if (!frontChar.equals(PackageConstants.SLASH) && !frontChar.equals(".") && readDir != null && readDir.length() > 0) {
            fileName = readDir + PackageConstants.SLASH + fileName;
        }
        log.info("Processing file : " + fileName);
        int id = 0;
        if (fileName.endsWith(NTL_EXTENSION)) {
            log.fine("NanoTiler generated file found: " + fileName);
            StrandJunction3D ntlFile = StrandJunctionDBTools.readNtl(fileName);
            SimpleLinkSet links = new SimpleLinkSet();
            ntlFile.setFilename(idname + StrandJunctionDBTools.intToChar(id));
            ++id;
            if (ntlFile instanceof KissingLoop3D) {
                kissingLoopDB.addJunction(ntlFile, links);
            } else {
                junctionDB.addJunction(ntlFile, links);
            }
        } else {
            AbstractPdbReader reader;
            FileInputStream is = new FileInputStream(fileName);
            if (rnaviewMode) {
                reader = new RnaPdbRnaviewReader();
            } else {
                log.severe("Only reading of RNAview augmented PDB files is currently supported.");
                assert (false);
                reader = new RnaPdbReader();
            }
            Object3DLinkSetBundle bundle = reader.readBundle(is);
            Object3D root = bundle.getObject3D();
            LinkSet links = bundle.getLinks();
            SimpleLinkSet emptyLinks = new SimpleLinkSet();
            if (randomMode) {
                log.fine("NOT randomizing orientation of object tree: " + root.getName());
            }
            Object3DSet atomSet = Object3DTools.collectByClassName(root, "Atom3D");
            log.fine(" " + atomSet.size() + " atoms found in PDB file.");
            double collisionEnergy = collisionDetector.energy(atomSet, links);
            if (collisionEnergy > 0.0) {
                log.warning("Sorry, collisions detected in structure: " + fileName);
            } else {
                log.fine("No collisions detected!");
            }
            Object3DLinkSetBundle stemBundle = null;
            if (rnaviewMode) {
                stemBundle = StemTools.generateStemsFromLinks(root, links, stemLengthMin);
                log.fine("Generated " + stemBundle.getObject3D().size() + " stems using a minimum length cutoff " + stemLengthMin);
            } else {
                assert (false);
                stemBundle = StemTools.generateStems(root);
            }
            Object3D stemRoot = stemBundle.getObject3D();
            Object3DTools.balanceTree(stemRoot);
            if (stemRoot.size() > 0) {
                int j;
                log.fine("StrandJunctionDBTools: Generating junctions from " + stemRoot.size() + " stems.");
                Object3D junctions = BranchDescriptorTools.generateJunctions(stemRoot, "dummy", branchDescriptorOffset, corridorDescriptor, 3.0, loopLengthSumMax, IntHelicesCheck);
                Object3D junctionsZero = null;
                if (branchDescriptorOffset != 0) {
                    junctionsZero = BranchDescriptorTools.generateJunctions(stemRoot, "dummy", 0, corridorDescriptor, 3.0, loopLengthSumMax);
                    for (j = junctionsZero.size() - 1; j >= 0; --j) {
                        if (StrandJunctionDBTools.verifyJunction((StrandJunction3D)junctionsZero.getChild(j), root, null, 0)) continue;
                        junctionsZero.removeChild(j);
                    }
                }
                log.fine("Number of detected junctions in structure: " + junctions.size());
                for (j = 0; j < junctions.size(); ++j) {
                    StrandJunction3D junction = (StrandJunction3D)junctions.getChild(j);
                    String junctionName = fileName + "_junc" + (j + 1);
                    if (cloneDownSize < 1) {
                        junction.setProperty("filename_orig", fileName);
                        junction.setProperty("filename", junctionName);
                        if (!StrandJunctionDBTools.verifyJunction(junction, root, junctionsZero, branchDescriptorOffset)) {
                            log.info("junction " + junctionName + " with position: " + junction.getPosition() + " is not usable!");
                            continue;
                        }
                        log.fine("junction of order " + junction.getBranchCount() + " and name " + junctionName + " is usable. Adding junction!");
                        RnaNtlWriter ntlWriter = new RnaNtlWriter();
                        if (writeDir != null && !writeDir.equals("")) {
                            ntlWriter.write(writeDir, junctionName, junction);
                        }
                        junction.setFilename(idname + StrandJunctionDBTools.intToChar(id));
                        ++id;
                        junctionDB.addJunction(junction, emptyLinks);
                        continue;
                    }
                    Object3DSet smallerJunctions = junction.cloneDown(cloneDownSize);
                    for (int i = 0; i < smallerJunctions.size(); ++i) {
                        StrandJunction3D sJunction = (StrandJunction3D)smallerJunctions.get(i);
                        assert (sJunction.getBranchCount() == cloneDownSize);
                        String sJunctionName = junctionName + "_" + (i + 1);
                        sJunction.setProperty("filename_orig", fileName);
                        sJunction.setProperty("filename", junctionName);
                        sJunction.setName(sJunctionName);
                        if (!StrandJunctionDBTools.verifyJunction(sJunction, root, junctionsZero, branchDescriptorOffset)) {
                            log.info("junction " + junctionName + " with position: " + junction.getPosition() + " is not usable!");
                            continue;
                        }
                        junction.setFilename(idname + StrandJunctionDBTools.intToChar(id));
                        ++id;
                        log.info("Adding Junction!");
                        junctionDB.addJunction(sJunction, emptyLinks);
                    }
                }
                Object3D kissingLoops = BranchDescriptorTools.generateKissingLoops(stemRoot, "dummy", branchDescriptorOffset, 3.0, IntHelicesCheck);
                SimpleLinkSet tmpLinks = new SimpleLinkSet();
                log.fine("Number of detected kissing loops in structure: " + kissingLoops.size());
                for (int j2 = 0; j2 < kissingLoops.size(); ++j2) {
                    KissingLoop3D kissingLoop = (KissingLoop3D)kissingLoops.getChild(j2);
                    String name = fileName + "_kl" + (j2 + 1);
                    kissingLoop.setName(name);
                    kissingLoop.setProperty("filename_orig", fileName);
                    kissingLoop.setProperty("filename", name);
                    log.fine("Adding kissing loop " + kissingLoop.getName() + " with position: " + kissingLoop.getPosition());
                    if (!StrandJunctionDBTools.verifyKissingLoop(kissingLoop, root)) {
                        log.info("kissing loop " + kissingLoop.getName() + " with position: " + kissingLoop.getPosition() + " is not usable!");
                        continue;
                    }
                    log.fine("kissing loop " + kissingLoop.getName() + " was usable");
                    String kissingLoopName = new String();
                    RnaNtlWriter ntlWriter = new RnaNtlWriter();
                    if (writeDir != null && !writeDir.equals("")) {
                        ntlWriter.write(writeDir, kissingLoop.getName(), kissingLoop);
                    }
                    log.fine("Adding kissing loop. Number of current entries: " + kissingLoopDB.size(2));
                    kissingLoop.setFilename(idname + StrandJunctionDBTools.intToChar(id));
                    ++id;
                    kissingLoopDB.addJunction(kissingLoop, tmpLinks);
                    log.fine("Added kissing loop. Number of current entries: " + kissingLoopDB.size(2));
                    assert (kissingLoopDB.size(2) > 0);
                }
            } else {
                log.info("Could not find any stems using stem length min " + stemLengthMin + " and links: ");
                for (int i = 0; i < links.size(); ++i) {
                    if (!RnaLinkTools.isBasePairLink(links.get(i))) continue;
                    System.out.println("" + (i + 1) + ((Object)links.get(i)).toString());
                }
            }
            ((InputStream)is).close();
        }
        Date endDate = new Date();
        long endTime = new Long(endDate.getTime());
        Long totalMilli = new Long(endTime - startTime);
        int totalSec = totalMilli.intValue() / 1000;
        int totalMin = totalSec / 60;
        totalSec -= totalMin * 60;
        int totalHour = totalMin / 60;
        totalMin -= totalHour * 60;
        String timeString = "";
        if (totalHour < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalHour + ":";
        if (totalMin < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalMin + ":";
        if (totalSec < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalSec;
        log.fine(PackageConstants.NEWLINE + PackageConstants.NEWLINE + "parsePdbFilesToDB(2) took " + timeString + PackageConstants.NEWLINE);
        log.fine("parsePdbFilesToDB (2) ended");
    }

    private static String intToChar(int i) {
        String[] charVals = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        int rem = i % 26;
        return charVals[rem];
    }

    public static void parsePdbFilesToDB(StrandJunctionDB junctionDB, StrandJunctionDB kissingLoopDB, String[] fileNames, int[] cloneDownSizes, String readDir, String writeDir, boolean noWriteFlag, boolean rnaviewMode, boolean randomMode, int branchDescriptorOffset, int stemLengthMin, CorridorDescriptor corridorDescriptor, int loopLengthSumMax) {
        assert (fileNames != null);
        log.fine("Starting StrandJunctionDBTools.parsePdbFilesToDB(1)!");
        Date startDate = new Date();
        long startTime = new Long(startDate.getTime());
        CollisionForceField collisionDetector = new CollisionForceField();
        if (fileNames == null) {
            log.warning("No filenames specified for reading junction database!");
            return;
        }
        for (int i = 0; i < fileNames.length; ++i) {
            assert (fileNames[i] != null);
            assert (fileNames[i].length() != 0);
            int cloneDownSize = 0;
            if (cloneDownSizes != null) {
                assert (i < cloneDownSizes.length);
                cloneDownSize = cloneDownSizes[i];
            }
            try {
                StrandJunctionDBTools.parsePdbFilesToDB(junctionDB, kissingLoopDB, fileNames[i], cloneDownSize, readDir, writeDir, noWriteFlag, rnaviewMode, randomMode, branchDescriptorOffset, stemLengthMin, corridorDescriptor, loopLengthSumMax);
                continue;
            }
            catch (IOException exp) {
                log.severe("Error: " + exp.getMessage() + " using input file: " + fileNames[i]);
            }
        }
        log.fine("Generated junction database info: ");
        log.fine(StrandJunctionDBTools.junctionDBInfo(junctionDB));
        log.fine(junctionDB.infoString());
        Date endDate = new Date();
        long endTime = new Long(endDate.getTime());
        Long totalMilli = new Long(endTime - startTime);
        int totalSec = totalMilli.intValue() / 1000;
        int totalMin = totalSec / 60;
        totalSec -= totalMin * 60;
        int totalHour = totalMin / 60;
        totalMin -= totalHour * 60;
        String timeString = "";
        if (totalHour < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalHour + ":";
        if (totalMin < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalMin + ":";
        if (totalSec < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalSec;
        log.fine(PackageConstants.NEWLINE + PackageConstants.NEWLINE + "parsePdbFilesToDB(1) took " + timeString + PackageConstants.NEWLINE);
        log.fine("parsePdbFilesToDB(1) ended");
    }

    public static void parsePdbFilesToDB(StrandJunctionDB junctionDB, StrandJunctionDB kissingLoopDB, String[] fileNames, int[] cloneDownSizes, String readDir, String writeDir, boolean noWriteFlag, boolean rnaviewMode, boolean randomMode, int branchDescriptorOffset, int stemLengthMin, CorridorDescriptor corridorDescriptor, int loopLengthSumMax, boolean intHelix) {
        assert (fileNames != null);
        log.fine("Starting StrandJunctionDBTools.parsePdbFilesToDB(1)!");
        Date startDate = new Date();
        long startTime = new Long(startDate.getTime());
        CollisionForceField collisionDetector = new CollisionForceField();
        if (fileNames == null) {
            log.warning("No filenames specified for reading junction database!");
            return;
        }
        for (int i = 0; i < fileNames.length; ++i) {
            assert (fileNames[i] != null);
            assert (fileNames[i].length() != 0);
            int cloneDownSize = 0;
            if (cloneDownSizes != null) {
                assert (i < cloneDownSizes.length);
                cloneDownSize = cloneDownSizes[i];
            }
            try {
                StrandJunctionDBTools.parsePdbFilesToDB(junctionDB, kissingLoopDB, fileNames[i], cloneDownSize, readDir, writeDir, noWriteFlag, rnaviewMode, randomMode, branchDescriptorOffset, stemLengthMin, corridorDescriptor, loopLengthSumMax, intHelix);
                continue;
            }
            catch (IOException exp) {
                log.severe("Error: " + exp.getMessage() + " using input file: " + fileNames[i]);
            }
        }
        log.fine("Generated junction database info: ");
        log.fine(StrandJunctionDBTools.junctionDBInfo(junctionDB));
        log.fine(junctionDB.infoString());
        Date endDate = new Date();
        long endTime = new Long(endDate.getTime());
        Long totalMilli = new Long(endTime - startTime);
        int totalSec = totalMilli.intValue() / 1000;
        int totalMin = totalSec / 60;
        totalSec -= totalMin * 60;
        int totalHour = totalMin / 60;
        totalMin -= totalHour * 60;
        String timeString = "";
        if (totalHour < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalHour + ":";
        if (totalMin < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalMin + ":";
        if (totalSec < 10) {
            timeString = timeString + "0";
        }
        timeString = timeString + totalSec;
        log.fine(PackageConstants.NEWLINE + PackageConstants.NEWLINE + "parsePdbFilesToDB(1) took " + timeString + PackageConstants.NEWLINE);
        log.fine("parsePdbFilesToDB(1) ended");
    }

    public static StrandJunction3D readNtl(String fileName) {
        assert (fileName.endsWith(NTL_EXTENSION));
        try {
            FileInputStream is = new FileInputStream(fileName);
            DataInputStream dis = new DataInputStream(is);
            assert (StrandJunctionDBTools.readWord(dis).equals("nanotiler"));
            String word = StrandJunctionDBTools.readWord(dis);
            if (word.equals("(StrandJunction3D")) {
                String junctionName = StrandJunctionDBTools.readWord(dis);
                word = StrandJunctionDBTools.readWord(dis);
                assert (word.equals("(v3"));
                Vector3D junctionPos = new Vector3D();
                junctionPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                junctionPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                junctionPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                int junctionChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                SimpleObject3DSet branches = new SimpleObject3DSet();
                for (int i_A = 0; i_A < junctionChildren; ++i_A) {
                    String junctionChild = StrandJunctionDBTools.readWord(dis);
                    if (junctionChild.equals("(BranchDescriptor3D")) {
                        String branchName = StrandJunctionDBTools.readWord(dis);
                        assert (StrandJunctionDBTools.readWord(dis).equals("(RnaStrand"));
                        SimpleRnaStrand incoming = new SimpleRnaStrand();
                        incoming.setName(StrandJunctionDBTools.readWord(dis));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                        Vector3D incomingPos = new Vector3D();
                        incomingPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        incomingPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        incomingPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        incoming.setPosition(incomingPos);
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                        int incomingChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        assert (incoming != null);
                        for (int i_B = 0; i_B < incomingChildren; ++i_B) {
                            assert (incoming != null);
                            assert (StrandJunctionDBTools.readWord(dis).equals("(Nucleotide3D"));
                            Nucleotide3D nucleotide = new Nucleotide3D();
                            char symbol = StrandJunctionDBTools.readWord(dis).charAt(0);
                            String alphaString = StrandJunctionDBTools.readWord(dis);
                            int alphaType = 2;
                            if (alphaString.equals("DNA")) {
                                alphaType = 2;
                            } else if (alphaString.equals("DNA_A")) {
                                alphaType = 1;
                            } else if (alphaString.equals("RNA")) {
                                alphaType = 4;
                            } else if (alphaString.equals("RNA_A")) {
                                alphaType = 3;
                            }
                            try {
                                nucleotide.setSymbol(new SimpleLetterSymbol(symbol, new SimpleAlphabet(alphaType)));
                            }
                            catch (UnknownSymbolException e) {
                                log.severe("Generated UnknownSymbolException while reading NanoTiler-generated file!");
                            }
                            nucleotide.setName(StrandJunctionDBTools.readWord(dis));
                            assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                            Vector3D nucleotidePos = new Vector3D();
                            nucleotidePos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotide.setPosition(nucleotidePos);
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                            int nucleotideChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                            for (int i_C = 0; i_C < nucleotideChildren; ++i_C) {
                                assert (incoming != null);
                                assert (StrandJunctionDBTools.readWord(dis).equals("(Atom3D"));
                                Atom3D atom = new Atom3D();
                                atom.setName(StrandJunctionDBTools.readWord(dis));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                Vector3D atomPos = new Vector3D();
                                atomPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atom.setPosition(atomPos);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                                assert (Integer.parseInt(StrandJunctionDBTools.readWord(dis)) == 0);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                nucleotide.insertChild(atom);
                            }
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            incoming.insertChild(nucleotide);
                        }
                        assert (incoming != null);
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(Sequence"));
                        String incSequenceName = StrandJunctionDBTools.readWord(dis);
                        String incTypeString = StrandJunctionDBTools.readWord(dis);
                        int incSequenceType = 2;
                        if (incTypeString.equals("DNA")) {
                            incSequenceType = 2;
                        } else if (incTypeString.equals("DNA_A")) {
                            incSequenceType = 1;
                        } else if (incTypeString.equals("RNA")) {
                            incSequenceType = 4;
                        } else if (incTypeString.equals("RNA_A")) {
                            incSequenceType = 3;
                        }
                        String incSequenceString = StrandJunctionDBTools.readWord(dis);
                        SimpleAlphabet incSequenceAlphabet = new SimpleAlphabet(incSequenceType);
                        try {
                            SimpleSequence incSequence = new SimpleSequence(incSequenceString, incSequenceName, incSequenceAlphabet);
                        }
                        catch (UnknownSymbolException e) {
                            log.severe("UnknownSymbolException generated when reading NanoTiler generated junction.");
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        int incomingIndex = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        log.fine("Finished incoming strand.");
                        assert (incoming != null);
                        assert (StrandJunctionDBTools.readWord(dis).equals("(RnaStrand"));
                        SimpleRnaStrand outgoing = new SimpleRnaStrand();
                        outgoing.setName(StrandJunctionDBTools.readWord(dis));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                        Vector3D outgoingPos = new Vector3D();
                        outgoingPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        outgoingPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        outgoingPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        outgoing.setPosition(outgoingPos);
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                        int outgoingChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        for (int i_B = 0; i_B < outgoingChildren; ++i_B) {
                            assert (StrandJunctionDBTools.readWord(dis).equals("(Nucleotide3D"));
                            Nucleotide3D nucleotide = new Nucleotide3D();
                            nucleotide.setName(StrandJunctionDBTools.readWord(dis));
                            char symbol = StrandJunctionDBTools.readWord(dis).charAt(0);
                            String alphaString = StrandJunctionDBTools.readWord(dis);
                            int alphaType = 2;
                            if (alphaString.equals("DNA")) {
                                alphaType = 2;
                            } else if (alphaString.equals("DNA_A")) {
                                alphaType = 1;
                            } else if (alphaString.equals("RNA")) {
                                alphaType = 4;
                            } else if (alphaString.equals("RNA_A")) {
                                alphaType = 3;
                            }
                            try {
                                nucleotide.setSymbol(new SimpleLetterSymbol(symbol, new SimpleAlphabet(alphaType)));
                            }
                            catch (UnknownSymbolException e) {
                                log.severe("Generated UnknownSymbolException while reading NanoTiler-generated file!");
                            }
                            assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                            Vector3D nucleotidePos = new Vector3D();
                            nucleotidePos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotide.setPosition(nucleotidePos);
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                            int nucleotideChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                            for (int i_C = 0; i_C < nucleotideChildren; ++i_C) {
                                assert (StrandJunctionDBTools.readWord(dis).equals("(Atom3D"));
                                Atom3D atom = new Atom3D();
                                atom.setName(StrandJunctionDBTools.readWord(dis));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                Vector3D atomPos = new Vector3D();
                                atomPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atom.setPosition(atomPos);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                                assert (Integer.parseInt(StrandJunctionDBTools.readWord(dis)) == 0);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                nucleotide.insertChild(atom);
                            }
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            outgoing.insertChild(nucleotide);
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(Sequence"));
                        String outSequenceName = StrandJunctionDBTools.readWord(dis);
                        String outTypeString = StrandJunctionDBTools.readWord(dis);
                        int outSequenceType = 2;
                        if (outTypeString.equals("DNA")) {
                            outSequenceType = 2;
                        } else if (outTypeString.equals("DNA_A")) {
                            outSequenceType = 1;
                        } else if (outTypeString.equals("RNA")) {
                            outSequenceType = 4;
                        } else if (outTypeString.equals("RNA_A")) {
                            outSequenceType = 3;
                        }
                        String outSequenceString = StrandJunctionDBTools.readWord(dis);
                        SimpleAlphabet outSequenceAlphabet = new SimpleAlphabet(outSequenceType);
                        try {
                            SimpleSequence outSequence = new SimpleSequence(outSequenceString, outSequenceName, outSequenceAlphabet);
                        }
                        catch (UnknownSymbolException e) {
                            log.severe("UnknownSymbolException generated when reading NanoTiler generated junction.");
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        int outgoingIndex = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        log.fine("Finished outgoing strand.");
                        Vector3D branchPosition = new Vector3D();
                        assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                        branchPosition.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        branchPosition.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        branchPosition.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                        int branchChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        CoordinateSystem3D coordinateSystem = new CoordinateSystem3D(Vector3D.ZVEC);
                        for (int i_D = 0; i_D < branchChildren; ++i_D) {
                            String className = StrandJunctionDBTools.readWord(dis);
                            if (className.equals("(CoordinateSystem3D")) {
                                coordinateSystem.setName(StrandJunctionDBTools.readWord(dis));
                                Vector3D coordinatePos = new Vector3D();
                                assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                coordinatePos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                coordinatePos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                coordinatePos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                coordinateSystem.setPosition(coordinatePos);
                                int coordinateChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                                for (int i_E = 0; i_E < coordinateChildren; ++i_E) {
                                    Vector3D childPos = new Vector3D();
                                    assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                    childPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                    childPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                    childPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                    assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                    childPos = childPos.plus(branchPosition);
                                    SimpleObject3D child = new SimpleObject3D(childPos);
                                    coordinateSystem.insertChild(child);
                                }
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                continue;
                            }
                            log.severe("NanoTiler does not know how to read: " + className + " as a child of a BranchDescriptor3D");
                            assert (false);
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        SimpleBranchDescriptor3D branch = new SimpleBranchDescriptor3D(incoming, outgoing, incomingIndex, outgoingIndex, coordinateSystem);
                        branch.setName(branchName);
                        branches.add(branch);
                        continue;
                    }
                    if (junctionChild.equals("(RnaStrand")) {
                        log.fine("Reading over RnaStrand child.");
                        word = StrandJunctionDBTools.readWord(dis);
                        if (word.equals(")")) continue;
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        int numChildren1 = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        for (int i_1A = 0; i_1A < numChildren1; ++i_1A) {
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            int numChildren2 = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                            for (int i_1B = 0; i_1B < numChildren2; ++i_1B) {
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                            }
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                        }
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        continue;
                    }
                    log.severe("NanoTiler does not know how to read: " + junctionChild);
                    assert (false);
                }
                SimpleStrandJunction3D junction = new SimpleStrandJunction3D(branches);
                junction.setName(junctionName);
                junction.setPosition(junctionPos);
                ((InputStream)is).close();
                return junction;
            }
            if (word.equals("(KissingLoop3D")) {
                String kissingLoopName = StrandJunctionDBTools.readWord(dis);
                word = StrandJunctionDBTools.readWord(dis);
                assert (word.equals("(v3"));
                Vector3D kissingLoopPos = new Vector3D();
                kissingLoopPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                kissingLoopPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                kissingLoopPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                int kissingLoopChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                SimpleObject3DSet branches = new SimpleObject3DSet();
                for (int i_A = 0; i_A < kissingLoopChildren; ++i_A) {
                    String kissingLoopChild = StrandJunctionDBTools.readWord(dis);
                    if (kissingLoopChild.equals("(BranchDescriptor3D")) {
                        String branchName = StrandJunctionDBTools.readWord(dis);
                        assert (StrandJunctionDBTools.readWord(dis).equals("(RnaStrand"));
                        SimpleRnaStrand incoming = new SimpleRnaStrand();
                        incoming.setName(StrandJunctionDBTools.readWord(dis));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                        Vector3D incomingPos = new Vector3D();
                        incomingPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        incomingPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        incomingPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        incoming.setPosition(incomingPos);
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                        int incomingChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        assert (incoming != null);
                        for (int i_B = 0; i_B < incomingChildren; ++i_B) {
                            assert (incoming != null);
                            assert (StrandJunctionDBTools.readWord(dis).equals("(Nucleotide3D"));
                            Nucleotide3D nucleotide = new Nucleotide3D();
                            char symbol = StrandJunctionDBTools.readWord(dis).charAt(0);
                            String alphaString = StrandJunctionDBTools.readWord(dis);
                            int alphaType = 2;
                            if (alphaString.equals("DNA")) {
                                alphaType = 2;
                            } else if (alphaString.equals("DNA_A")) {
                                alphaType = 1;
                            } else if (alphaString.equals("RNA")) {
                                alphaType = 4;
                            } else if (alphaString.equals("RNA_A")) {
                                alphaType = 3;
                            }
                            try {
                                nucleotide.setSymbol(new SimpleLetterSymbol(symbol, new SimpleAlphabet(alphaType)));
                            }
                            catch (UnknownSymbolException e) {
                                log.severe("Generated UnknownSymbolException while reading NanoTiler-generated file!");
                            }
                            nucleotide.setName(StrandJunctionDBTools.readWord(dis));
                            assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                            Vector3D nucleotidePos = new Vector3D();
                            nucleotidePos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotide.setPosition(nucleotidePos);
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                            int nucleotideChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                            for (int i_C = 0; i_C < nucleotideChildren; ++i_C) {
                                assert (incoming != null);
                                assert (StrandJunctionDBTools.readWord(dis).equals("(Atom3D"));
                                Atom3D atom = new Atom3D();
                                atom.setName(StrandJunctionDBTools.readWord(dis));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                Vector3D atomPos = new Vector3D();
                                atomPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atom.setPosition(atomPos);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                                assert (Integer.parseInt(StrandJunctionDBTools.readWord(dis)) == 0);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                nucleotide.insertChild(atom);
                            }
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            incoming.insertChild(nucleotide);
                        }
                        assert (incoming != null);
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(Sequence"));
                        String incSequenceName = StrandJunctionDBTools.readWord(dis);
                        String incTypeString = StrandJunctionDBTools.readWord(dis);
                        int incSequenceType = 2;
                        if (incTypeString.equals("DNA")) {
                            incSequenceType = 2;
                        } else if (incTypeString.equals("DNA_A")) {
                            incSequenceType = 1;
                        } else if (incTypeString.equals("RNA")) {
                            incSequenceType = 4;
                        } else if (incTypeString.equals("RNA_A")) {
                            incSequenceType = 3;
                        }
                        String incSequenceString = StrandJunctionDBTools.readWord(dis);
                        SimpleAlphabet incSequenceAlphabet = new SimpleAlphabet(incSequenceType);
                        try {
                            SimpleSequence incSequence = new SimpleSequence(incSequenceString, incSequenceName, incSequenceAlphabet);
                        }
                        catch (UnknownSymbolException e) {
                            log.severe("UnknownSymbolException generated when reading NanoTiler generated kissing loop.");
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        int incomingIndex = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        log.fine("Finished incoming strand.");
                        assert (incoming != null);
                        assert (StrandJunctionDBTools.readWord(dis).equals("(RnaStrand"));
                        SimpleRnaStrand outgoing = new SimpleRnaStrand();
                        outgoing.setName(StrandJunctionDBTools.readWord(dis));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                        Vector3D outgoingPos = new Vector3D();
                        outgoingPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        outgoingPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        outgoingPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        outgoing.setPosition(outgoingPos);
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                        int outgoingChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        for (int i_B = 0; i_B < outgoingChildren; ++i_B) {
                            assert (StrandJunctionDBTools.readWord(dis).equals("(Nucleotide3D"));
                            Nucleotide3D nucleotide = new Nucleotide3D();
                            nucleotide.setName(StrandJunctionDBTools.readWord(dis));
                            char symbol = StrandJunctionDBTools.readWord(dis).charAt(0);
                            String alphaString = StrandJunctionDBTools.readWord(dis);
                            int alphaType = 2;
                            if (alphaString.equals("DNA")) {
                                alphaType = 2;
                            } else if (alphaString.equals("DNA_A")) {
                                alphaType = 1;
                            } else if (alphaString.equals("RNA")) {
                                alphaType = 4;
                            } else if (alphaString.equals("RNA_A")) {
                                alphaType = 3;
                            }
                            try {
                                nucleotide.setSymbol(new SimpleLetterSymbol(symbol, new SimpleAlphabet(alphaType)));
                            }
                            catch (UnknownSymbolException e) {
                                log.severe("Generated UnknownSymbolException while reading NanoTiler-generated file!");
                            }
                            assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                            Vector3D nucleotidePos = new Vector3D();
                            nucleotidePos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotidePos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                            nucleotide.setPosition(nucleotidePos);
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                            int nucleotideChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                            for (int i_C = 0; i_C < nucleotideChildren; ++i_C) {
                                assert (StrandJunctionDBTools.readWord(dis).equals("(Atom3D"));
                                Atom3D atom = new Atom3D();
                                atom.setName(StrandJunctionDBTools.readWord(dis));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                Vector3D atomPos = new Vector3D();
                                atomPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atomPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                atom.setPosition(atomPos);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                                assert (Integer.parseInt(StrandJunctionDBTools.readWord(dis)) == 0);
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                nucleotide.insertChild(atom);
                            }
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                            outgoing.insertChild(nucleotide);
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(Sequence"));
                        String outSequenceName = StrandJunctionDBTools.readWord(dis);
                        String outTypeString = StrandJunctionDBTools.readWord(dis);
                        int outSequenceType = 2;
                        if (outTypeString.equals("DNA")) {
                            outSequenceType = 2;
                        } else if (outTypeString.equals("DNA_A")) {
                            outSequenceType = 1;
                        } else if (outTypeString.equals("RNA")) {
                            outSequenceType = 4;
                        } else if (outTypeString.equals("RNA_A")) {
                            outSequenceType = 3;
                        }
                        String outSequenceString = StrandJunctionDBTools.readWord(dis);
                        SimpleAlphabet outSequenceAlphabet = new SimpleAlphabet(outSequenceType);
                        try {
                            SimpleSequence outSequence = new SimpleSequence(outSequenceString, outSequenceName, outSequenceAlphabet);
                        }
                        catch (UnknownSymbolException e) {
                            log.severe("UnknownSymbolException generated when reading NanoTiler generated kissing loop.");
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        int outgoingIndex = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        log.fine("Finished outgoing strand.");
                        Vector3D branchPosition = new Vector3D();
                        assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                        branchPosition.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        branchPosition.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        branchPosition.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals("(children"));
                        int branchChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        CoordinateSystem3D coordinateSystem = new CoordinateSystem3D(Vector3D.ZVEC);
                        for (int i_D = 0; i_D < branchChildren; ++i_D) {
                            String className = StrandJunctionDBTools.readWord(dis);
                            if (className.equals("(CoordinateSystem3D")) {
                                coordinateSystem.setName(StrandJunctionDBTools.readWord(dis));
                                Vector3D coordinatePos = new Vector3D();
                                assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                coordinatePos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                coordinatePos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                coordinatePos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                coordinateSystem.setPosition(coordinatePos);
                                int coordinateChildren = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                                for (int i_E = 0; i_E < coordinateChildren; ++i_E) {
                                    Vector3D childPos = new Vector3D();
                                    assert (StrandJunctionDBTools.readWord(dis).equals("(v3"));
                                    childPos.setX(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                    childPos.setY(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                    childPos.setZ(Double.parseDouble(StrandJunctionDBTools.readWord(dis)));
                                    assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                    childPos = childPos.plus(branchPosition);
                                    SimpleObject3D child = new SimpleObject3D(childPos);
                                    coordinateSystem.insertChild(child);
                                }
                                assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                                continue;
                            }
                            log.severe("NanoTiler does not know how to read: " + className + " as a child of a BranchDescriptor3D");
                            assert (false);
                        }
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        assert (StrandJunctionDBTools.readWord(dis).equals(")"));
                        SimpleBranchDescriptor3D branch = new SimpleBranchDescriptor3D(incoming, outgoing, incomingIndex, outgoingIndex, coordinateSystem);
                        branch.setName(branchName);
                        branches.add(branch);
                        continue;
                    }
                    if (kissingLoopChild.equals("(RnaStrand")) {
                        log.fine("Reading over RnaStrand child.");
                        word = StrandJunctionDBTools.readWord(dis);
                        if (word.equals(")")) continue;
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        int numChildren1 = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                        for (int i_1A = 0; i_1A < numChildren1; ++i_1A) {
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                            int numChildren2 = Integer.parseInt(StrandJunctionDBTools.readWord(dis));
                            for (int i_1B = 0; i_1B < numChildren2; ++i_1B) {
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                                StrandJunctionDBTools.readWord(dis);
                            }
                            StrandJunctionDBTools.readWord(dis);
                            StrandJunctionDBTools.readWord(dis);
                        }
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        StrandJunctionDBTools.readWord(dis);
                        continue;
                    }
                    if (kissingLoopChild.equals("(BranchDescriptor3D")) {
                        log.severe("NanoTiler does not know how to read a BranchDescriptor child yet!");
                        continue;
                    }
                    log.severe("NanoTiler does not know how to read: " + kissingLoopChild);
                    assert (false);
                }
                KissingLoop3D kissingLoop = new KissingLoop3D(branches);
                kissingLoop.setName(kissingLoopName);
                kissingLoop.setPosition(kissingLoopPos);
                ((InputStream)is).close();
                return kissingLoop;
            }
            log.severe("NanoTiler does not know how to read this: " + word);
            assert (false);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            log.severe("Could not read ntl file: " + fileName + " " + e.getMessage());
        }
        return new SimpleStrandJunction3D();
    }

    public static String junctionDBInfo(StrandJunctionDB junctionDB) {
        StringBuffer buf = new StringBuffer();
        buf.append("Orders: " + junctionDB.size() + PackageConstants.ENDL);
        for (int i = 2; i < junctionDB.size(); ++i) {
            buf.append("order: " + i + " : " + junctionDB.size(i) + PackageConstants.ENDL);
        }
        buf.append(StrandJunctionDBTools.junctionDBGeomInfo(junctionDB));
        return buf.toString();
    }

    public static String junctionDBGeomInfo(StrandJunctionDB junctionDB) {
        StringBuffer buf = new StringBuffer();
        buf.append("Orders: " + junctionDB.size() + PackageConstants.ENDL);
        for (int i = 2; i < junctionDB.size(); ++i) {
            buf.append("order: " + i + " : " + junctionDB.size(i) + PackageConstants.ENDL);
            StrandJunction3D[] junctions = junctionDB.getJunctions(i);
            if (junctions == null) continue;
            for (int j = 0; j < junctions.length; ++j) {
                log.fine("Junction: " + (i + 1) + " " + (j + 1));
                buf.append(StrandJunctionTools.writeJunctionGeomInfo(junctions[j]));
            }
        }
        return buf.toString();
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            log.fine("found word: " + s);
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        log.fine("found word: " + s);
        return s;
    }
}

