/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import numerictools.PotentialND;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.RnaConstants;
import tools3d.LineShape;
import tools3d.Vector3D;

public class StemBranchDescriptorPotential
implements PotentialND {
    private int stemLength;
    private Vector3D firstStartPosition;
    private Vector3D firstStopPosition;
    private Vector3D lastStartPosition;
    private Vector3D lastStopPosition;
    public static final int DIMENSION = 9;

    StemBranchDescriptorPotential(int stemLength, BranchDescriptor3D branch1, BranchDescriptor3D branch2) {
        assert (branch1.isValid());
        assert (branch2.isValid());
        assert (false);
        this.stemLength = stemLength;
        assert (this.isValid());
    }

    @Override
    public double[] generateHighPosition() {
        assert (false);
        return null;
    }

    @Override
    public double[] generateLowPosition() {
        assert (this.firstStopPosition != null);
        assert (this.firstStartPosition != null);
        double[] result = new double[9];
        this.firstStopPosition.setArray(result, 0);
        this.firstStartPosition.setArray(result, 3);
        this.lastStartPosition.setArray(result, 6);
        return result;
    }

    @Override
    public int getDimension() {
        return 9;
    }

    public static double[] convertBranchDescriptor(BranchDescriptor3D b, int len) {
        double[] result = new double[9];
        Vector3D pos = b.getPosition();
        assert (false);
        Vector3D outPos = null;
        Vector3D dir = b.getDirection();
        Vector3D farPos = pos.plus(dir.mul((double)len * RnaConstants.HELIX_RISE));
        pos.setArray(result, 0);
        outPos.setArray(result, 3);
        farPos.setArray(result, 6);
        return result;
    }

    @Override
    public double getValue(double[] v) {
        assert (v.length == this.getDimension());
        Vector3D basePos = new Vector3D(v[0], v[1], v[2]);
        Vector3D fivePos = new Vector3D(v[3], v[4], v[5]);
        Vector3D direction = new Vector3D(v[6], v[7], v[8]).minus(basePos);
        if (direction.length() == 0.0) {
            direction.set(0.0, 0.0, 1.0);
        } else {
            direction.normalize();
        }
        assert (false);
        LineShape firstPair = null;
        LineShape lastPair = null;
        double term11 = firstPair.getPosition1().minus(this.firstStartPosition).lengthSquare();
        double term12 = firstPair.getPosition2().minus(this.firstStopPosition).lengthSquare();
        double term21 = lastPair.getPosition1().minus(this.lastStartPosition).lengthSquare();
        double term22 = lastPair.getPosition2().minus(this.lastStopPosition).lengthSquare();
        double result = Math.sqrt(0.25 * (term11 + term12 + term21 + term22));
        return result;
    }

    public boolean isValid() {
        return this.firstStartPosition != null && this.firstStopPosition != null && this.lastStartPosition != null && this.lastStopPosition != null;
    }
}

