/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import numerictools.ObjectPairScore;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SingleStrandBridgeFinder;
import rnadesign.rnamodel.StrandBridgeFinder;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;

public class SingleStrandsBridgeFinder
implements StrandBridgeFinder {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private double distMax = 30.0;
    private int lenMax = 3;
    private int lenMin = 1;
    private static double STRAND_BP_PENALTY = 20.0;
    private SingleStrandBridgeFinder bridgeFinder;

    public void setDistMax(double x) {
        this.distMax = x;
    }

    @Override
    public void setRms(double rms) {
        this.bridgeFinder.setRms(rms);
    }

    @Override
    public void setAngleWeight(double weight) {
        this.bridgeFinder.setAngleWeight(weight);
    }

    @Override
    public void setLenMax(int n) {
        this.bridgeFinder.setLenMax(n);
    }

    public SingleStrandsBridgeFinder(List<Object3DLinkSetBundle> bundleList) {
        this.bridgeFinder = new SingleStrandBridgeFinder(bundleList);
        this.bridgeFinder.setLenMax(this.lenMax);
        this.bridgeFinder.setLenMin(this.lenMin);
    }

    private Object3DLinkSetBundle generateBridge(RnaStrand strand1, RnaStrand strand2) {
        List<Object3DLinkSetBundle> result = this.bridgeFinder.findBridge(strand1.getResidue3D(strand1.getResidueCount() - 1), strand2.getResidue3D(0));
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    private double threePrimeFivePrimeDistance(RnaStrand strand1, RnaStrand strand2) {
        Object3D atom2b;
        Object3D atom1b;
        double dist2;
        Object3D atom1 = strand1.getResidue3D(strand1.getResidueCount() - 1).getChild("O3*");
        Object3D atom2 = strand2.getResidue3D(0).getChild("P");
        double dist1 = atom1.distance(atom2);
        if (strand1.size() > 2 && strand2.size() > 2 && dist1 < RnaConstants.HELIX_BP_P_O3_DIST && (dist2 = (atom1b = strand1.getResidue3D(strand1.getResidueCount() - 3).getChild("O3*")).distance(atom2b = strand2.getResidue3D(2).getChild("P"))) < RnaConstants.HELIX_BP_P_O3_DIST) {
            dist1 += STRAND_BP_PENALTY;
        }
        return dist1;
    }

    @Override
    public List<Object3DLinkSetBundle> findBridges(Object3DSet strands) {
        int i;
        int i2;
        this.log.info("Starting findBridges");
        ArrayList<Object3DLinkSetBundle> bridges = new ArrayList<Object3DLinkSetBundle>();
        double[][] distMatrix = new double[strands.size()][strands.size()];
        ArrayList<ObjectPairScore> indexList = new ArrayList<ObjectPairScore>();
        for (i2 = 0; i2 < strands.size(); ++i2) {
            RnaStrand strand1 = (RnaStrand)strands.get(i2);
            distMatrix[i2][i2] = 0.0;
            for (int j = i2 + 1; j < strands.size(); ++j) {
                RnaStrand strand2 = (RnaStrand)strands.get(j);
                double score = this.threePrimeFivePrimeDistance(strand1, strand2);
                indexList.add(new ObjectPairScore(score, new Integer(i2), new Integer(j)));
                score = this.threePrimeFivePrimeDistance(strand2, strand1);
                indexList.add(new ObjectPairScore(score, new Integer(j), new Integer(i2)));
            }
        }
        Collections.sort(indexList);
        System.out.println("Bridge sores:");
        for (i2 = 0; i2 < 20; ++i2) {
            System.out.println("" + (i2 + 1) + " : " + indexList.get(i2));
        }
        boolean[] fivePrimeBridged = new boolean[strands.size()];
        boolean[] threePrimeBridged = new boolean[strands.size()];
        for (i = 0; i < strands.size(); ++i) {
            fivePrimeBridged[i] = false;
            threePrimeBridged[i] = false;
        }
        for (i = 0; i < indexList.size(); ++i) {
            int id1 = (Integer)((ObjectPairScore)indexList.get(i)).getObject1();
            int id2 = (Integer)((ObjectPairScore)indexList.get(i)).getObject2();
            double score = ((ObjectPairScore)indexList.get(i)).getScore();
            if (score > this.distMax) break;
            if (fivePrimeBridged[id2] || threePrimeBridged[id1]) continue;
            this.log.info("Generating bridge between strands " + strands.get(id1).getName() + " and " + strands.get(id2).getName());
            Object3DLinkSetBundle bridge = this.generateBridge((RnaStrand)strands.get(id1), (RnaStrand)strands.get(id2));
            if (bridge != null && bridge.getObject3D().size() > 0) {
                bridges.add(bridge);
            } else {
                this.log.info("Could not generating bridge!");
            }
            fivePrimeBridged[id2] = true;
            threePrimeBridged[id1] = true;
        }
        this.log.info("Finished findBridges");
        return bridges;
    }
}

