/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.IntegerArrayIncreasingGenerator;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunction3DLispWriter;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DSet;

public class SimpleStrandJunction3D
extends SimpleObject3D
implements StrandJunction3D {
    public static final double BRANCH_MEET_DIST = 30.0;
    public static final String NEWLINE = System.getProperty("line.separator");
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private int branchCount = 0;
    private boolean internalHelices = false;
    private int[] incomingBranchIds = new int[100];
    private int[] outgoingBranchIds = new int[100];
    private int[] incomingSeqIds = new int[100];
    private int[] outgoingSeqIds = new int[100];
    public static final String CLASS_NAME = "StrandJunction3D";

    public SimpleStrandJunction3D() {
    }

    public SimpleStrandJunction3D(Object3DSet branchesOrig) {
        assert (branchesOrig != null && branchesOrig.size() > 0);
        Vector3D pos = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < branchesOrig.size(); ++i) {
            BranchDescriptor3D branch = (BranchDescriptor3D)((BranchDescriptor3D)branchesOrig.get(i)).cloneDeep();
            assert (!branch.isSingleSequence() || branchesOrig.size() == 1);
            pos.add(branch.getPosition());
            this.insertChild(branch);
        }
        pos.scale(1.0 / (double)branchesOrig.size());
        this.setIsolatedPosition(pos);
        this.setFragmentStatus();
        assert (this.checkChildrenUnique());
    }

    public SimpleStrandJunction3D(Object3DSet branchesOrig, Object3DSet additionalObjects) {
        this(branchesOrig);
        SimpleObject3D additionalNode = new SimpleObject3D();
        additionalNode.setName("additional");
        additionalNode.setPosition(this.getPosition());
        for (int i = 0; i < additionalObjects.size(); ++i) {
            additionalNode.insertChild(additionalObjects.get(i));
        }
        this.insertChild(additionalNode);
    }

    @Override
    public Object3DSet cloneDown(int junctionOrder) {
        assert (junctionOrder < this.getBranchCount());
        SimpleObject3DSet result = new SimpleObject3DSet();
        IntegerArrayIncreasingGenerator permGen = new IntegerArrayIncreasingGenerator(junctionOrder, this.getBranchCount());
        SimpleObject3DSet bSet = new SimpleObject3DSet();
        Object3D additional = this.getChild("additional");
        do {
            int[] perm = permGen.get();
            assert (perm.length == junctionOrder);
            bSet.clear();
            for (int i = 0; i < junctionOrder; ++i) {
                bSet.add(this.getBranch(perm[i]));
            }
            Object3D currentAdditional = this.getChild("additional");
            SimpleObject3D newAdditional = new SimpleObject3D();
            if (currentAdditional != null) {
                for (int i = 0; i < currentAdditional.size(); ++i) {
                    newAdditional.insertChild((Object3D)currentAdditional.getChild(i).cloneDeep());
                }
            }
            SimpleStrandJunction3D newJunction = new SimpleStrandJunction3D(bSet);
            for (int i = 0; i < this.getStrandCount(); ++i) {
                if (newJunction.findStrandIndex(this.getStrand(i)) >= 0) continue;
                newAdditional.insertChild((Object3D)this.getStrand(i).cloneDeep());
            }
            if (newAdditional.size() > 0) {
                log.info("Adding additional cloned child nodes to junction " + newJunction.getFullName() + " : " + newAdditional.size());
                newJunction.insertChild(newAdditional);
            }
            result.add(newJunction);
        } while (permGen.hasNext() && permGen.inc());
        return result;
    }

    public static void setFragmentStatus(NucleotideStrand strand) {
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            strand.getResidue(i).setProperty("sequence_status", "fragment");
        }
    }

    private void setFragmentStatus() {
        for (int i = 0; i < this.getStrandCount(); ++i) {
            NucleotideStrand strand = this.getStrand(i);
            SimpleStrandJunction3D.setFragmentStatus(strand);
        }
    }

    private void addStrands(BranchDescriptor3D branch) {
        assert (branch.isValid());
        int branchIndex = this.getChildClassCounter(branch);
        assert (branchIndex < this.getBranchCount());
        assert (branchIndex >= 0);
        NucleotideStrand incoming = branch.getIncomingStrand();
        NucleotideStrand outgoing = branch.getOutgoingStrand();
        int inId = this.findStrandIndex(incoming);
        if (inId < 0) {
            this.insertChild(incoming);
            inId = this.size() - 1;
        } else {
            branch.setIncomingStrand(this.getStrand(inId));
        }
        this.incomingBranchIds[inId] = branchIndex;
        this.incomingSeqIds[branchIndex] = inId;
        int outId = this.findStrandIndex(outgoing);
        if (outId < 0) {
            this.insertChild(outgoing);
            outId = this.size() - 1;
        } else {
            branch.setOutgoingStrand(this.getStrand(outId));
        }
        this.outgoingBranchIds[outId] = branchIndex;
        this.outgoingSeqIds[branchIndex] = outId;
    }

    @Override
    public boolean corridorCheck(CorridorDescriptor corridorDescriptor) {
        double corridorRadius = corridorDescriptor.radius;
        double corridorStart = corridorDescriptor.start;
        if (corridorRadius <= 0.0) {
            return true;
        }
        Object3DSet atomSet = Object3DTools.collectByClassName(this, "Atom3D");
        assert (atomSet.size() > 0);
        for (int i = 0; i < this.getBranchCount(); ++i) {
            BranchDescriptor3D branch = this.getBranch(i);
            if (Object3DTools.corridorCheck(branch.getPosition(), branch.getDirection(), corridorRadius, corridorStart, atomSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isKissingLoop() {
        return false;
    }

    private void updateIndices() {
        log.fine("updateIndices not yet implemented !!!");
    }

    @Override
    public void fuseStrands(int n, int m) {
        log.fine("Starting SimpleStrandJunction3D.fuseStrands");
        assert (n < this.getStrandCount());
        assert (m < this.getStrandCount());
        int strandCountOrig = this.getStrandCount();
        NucleotideStrand strand1 = this.getStrand(n);
        int size1 = strand1.size();
        NucleotideStrand strand2 = this.getStrand(m);
        strand1.append(strand2);
        super.removeChild(strand2);
        int branchCount = this.getBranchCount();
        log.fine("strand2: " + strand2 + NEWLINE + "strand1: " + strand1);
        for (int i = 0; i < branchCount; ++i) {
            BranchDescriptor3D branch = this.getBranch(i);
            if (branch.getOutgoingStrand() == strand2) {
                branch.setOutgoingStrand(strand1);
                branch.setOutgoingIndex(branch.getOutgoingIndex() + size1);
            }
            if (branch.getIncomingStrand() != strand2) continue;
            branch.setIncomingStrand(strand1);
            branch.setIncomingIndex(branch.getIncomingIndex() + size1);
        }
        this.updateIndices();
    }

    @Override
    public Object cloneDeepThis() {
        SimpleStrandJunction3D obj = new SimpleStrandJunction3D();
        obj.copyDeepThisCore(this);
        obj.branchCount = this.branchCount;
        obj.internalHelices = this.internalHelices;
        obj.incomingBranchIds = new int[100];
        obj.outgoingBranchIds = new int[100];
        obj.incomingSeqIds = new int[100];
        obj.outgoingSeqIds = new int[100];
        for (int i = 0; i < 100; ++i) {
            obj.incomingBranchIds[i] = this.incomingBranchIds[i];
            obj.outgoingBranchIds[i] = this.outgoingBranchIds[i];
            obj.incomingSeqIds[i] = this.incomingSeqIds[i];
            obj.outgoingSeqIds[i] = this.outgoingSeqIds[i];
        }
        return obj;
    }

    @Override
    public Object cloneDeep() {
        SimpleStrandJunction3D newObj = (SimpleStrandJunction3D)this.cloneDeepThis();
        newObj.setFilename(this.getFilename());
        for (int i = 0; i < this.size(); ++i) {
            newObj.insertRawChild((Object3D)this.getChild(i).cloneDeep());
        }
        NucleotideStrand[] strands = this.getStrands();
        int branchCount = this.getBranchCount();
        newObj.branchCount = this.getBranchCount();
        for (int i = 0; i < branchCount; ++i) {
            BranchDescriptor3D branch = this.getBranch(i);
            BranchDescriptor3D newBranch = newObj.getBranch(i);
            NucleotideStrand inStrand = branch.getIncomingStrand();
            NucleotideStrand outStrand = branch.getOutgoingStrand();
            for (int j = 0; j < strands.length; ++j) {
                if (inStrand == strands[j]) {
                    newBranch.setIncomingStrand(newObj.getStrand(j));
                }
                if (outStrand != strands[j]) continue;
                newBranch.setOutgoingStrand(newObj.getStrand(j));
            }
        }
        return newObj;
    }

    @Override
    public int findStrandIndex(NucleotideStrand strand) {
        int sc = this.getStrandCount();
        for (int i = 0; i < sc; ++i) {
            if (!this.getStrand(i).isProbablyEqual(strand)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getBranchCount() {
        assert (this.branchCount == this.getChildCount("BranchDescriptor3D"));
        return this.branchCount;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public int[] getIncomingSeqIds() {
        return this.incomingSeqIds;
    }

    @Override
    public boolean hasInternalHelices() {
        return this.internalHelices;
    }

    @Override
    public int getLoopLength(int strandId) {
        int inBId = this.getIncomingBranchId(strandId);
        int outBId = this.getOutgoingBranchId(strandId);
        BranchDescriptor3D inBranch = this.getBranch(inBId);
        BranchDescriptor3D outBranch = this.getBranch(outBId);
        int inId = inBranch.getIncomingIndex() + inBranch.getOffset() + 1;
        int outId = outBranch.getOutgoingIndex() - outBranch.getOffset() - 1;
        int diff = outId - inId + 1;
        if (diff < 0) {
            log.fine("Warning: bad loop length indices: " + inBId + " " + outBId + " strand: " + strandId);
        }
        return diff;
    }

    @Override
    public int[] getOutgoingSeqIds() {
        return this.outgoingSeqIds;
    }

    @Override
    public int getStrandCount() {
        int counter = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getChild(i) instanceof NucleotideStrand)) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public BranchDescriptor3D getBranch(int n) {
        int idx = this.getIndexOfChild(n, "BranchDescriptor3D");
        assert (idx >= 0);
        BranchDescriptor3D result = (BranchDescriptor3D)this.getChild(idx);
        assert (result.getParent() == this);
        return result;
    }

    @Override
    public NucleotideStrand getStrand(int n) {
        int counter = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getChild(i) instanceof NucleotideStrand) || ++counter != n) continue;
            return (NucleotideStrand)this.getChild(i);
        }
        assert (false);
        return null;
    }

    @Override
    public NucleotideStrand[] getStrands() {
        int strandCount = this.getStrandCount();
        NucleotideStrand[] strands = new NucleotideStrand[strandCount];
        for (int i = 0; i < strandCount; ++i) {
            strands[i] = this.getStrand(i);
        }
        assert (strands.length == this.getStrandCount());
        return strands;
    }

    @Override
    public int getIncomingBranchId(int n) {
        assert (n < this.incomingBranchIds.length);
        assert (this.incomingBranchIds[n] < this.getBranchCount());
        assert (this.getBranch(this.incomingBranchIds[n]) != null);
        return this.incomingBranchIds[n];
    }

    @Override
    public int[] getIncomingBranchIds() {
        return this.incomingBranchIds;
    }

    @Override
    public int getOutgoingBranchId(int n) {
        return this.outgoingBranchIds[n];
    }

    @Override
    public int[] getOutgoingBranchIds() {
        return this.outgoingBranchIds;
    }

    public void insertRawChild(Object3D obj) {
        if (obj instanceof BranchDescriptor3D) {
            ++this.branchCount;
        }
        super.insertChild(obj);
    }

    @Override
    public void insertChild(Object3D obj) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getChild(i).isProbablyEqual(obj)) assert (false);
        }
        super.insertChild(obj);
        if (obj instanceof BranchDescriptor3D) {
            ++this.branchCount;
            BranchDescriptor3D branch = (BranchDescriptor3D)obj;
            assert (branch.isValid());
            this.addStrands(branch);
        }
    }

    @Override
    public void removeChild(Object3D obj) {
        if (obj instanceof BranchDescriptor3D) {
            log.warning("Sorry, removing helix descriptors from junctions is currently not allowed.");
            return;
        }
        super.removeChild(obj);
        if (obj instanceof BranchDescriptor3D) {
            --this.branchCount;
            assert (false);
        }
    }

    @Override
    public boolean isConnected(int incomingBranchId, int outgoingBranchId) {
        return this.incomingSeqIds[incomingBranchId] == this.outgoingSeqIds[outgoingBranchId];
    }

    @Override
    public boolean isRegular() {
        return this.getBranchCount() == this.getStrandCount();
    }

    @Override
    public boolean isValid() {
        int i;
        if (!super.isValid()) {
            return false;
        }
        int branchCount = this.getBranchCount();
        int strandCount = this.getStrandCount();
        if (branchCount == 0 || strandCount == 0) {
            return false;
        }
        if (branchCount != strandCount) {
            log.info("Warning: BranchCount is not equal Strand count: " + this.getBranchCount() + " " + this.getStrandCount());
            return false;
        }
        log.fine("starting SimpleStrandJunction3D.isValid with junction of size: " + branchCount);
        for (i = 0; i < branchCount; ++i) {
            BranchDescriptor3D branch = this.getBranch(i);
            if (!branch.isValid()) {
                return false;
            }
            NucleotideStrand strand = branch.getIncomingStrand();
            int startId = branch.getIncomingIndex();
            int bestId = 0;
            int bestDiff = 10000;
            boolean found = false;
            for (int j = 0; j < branchCount; ++j) {
                int diff;
                int stopId;
                BranchDescriptor3D branch2;
                if (i == j || (branch2 = this.getBranch(j)).getOutgoingStrand() != strand || (stopId = branch2.getOutgoingIndex()) <= startId || (diff = stopId - startId) >= bestDiff) continue;
                bestDiff = diff;
                bestId = j;
                found = true;
            }
            if (found) continue;
            log.fine("Warning: bad strand " + i);
            StrandJunction3DLispWriter writer = new StrandJunction3DLispWriter();
            log.fine("SimpleStandJunction3D is not valid!");
            return false;
        }
        for (i = 0; i < this.getStrandCount(); ++i) {
            if (this.getLoopLength(i) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int findBranchConnectionLink(StrandJunction3D junction, LinkSet links) {
        int branchCount = this.getBranchCount();
        for (int i = 0; i < branchCount; ++i) {
            BranchDescriptor3D branch1 = this.getBranch(i);
            for (int j = 0; j < branchCount; ++j) {
                BranchDescriptor3D branch2 = junction.getBranch(j);
                for (int k = 0; k < links.size(); ++k) {
                    Link link = links.get(k);
                    if (!link.isLinked(branch1, branch2)) continue;
                    return k;
                }
            }
        }
        return -1;
    }

    @Override
    public void setInternalHelices(boolean flag) {
        this.internalHelices = flag;
    }

    @Override
    public String infoString() {
        StringBuffer buf = new StringBuffer();
        if (this.isKissingLoop()) {
            buf.append("kl ");
        } else {
            buf.append("j ");
        }
        buf.append("" + this.getStrandCount() + " ");
        for (int i = 0; i < this.getStrandCount(); ++i) {
            buf.append(this.getStrand(i).sequenceString() + " | ");
        }
        return buf.toString();
    }
}

