/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.RnaStem3D;
import rnasecondary.Stem;
import tools3d.Vector3D;
import tools3d.objects3d.SimpleObject3D;

public class SimpleRnaStem3D
extends SimpleObject3D
implements RnaStem3D {
    public int strand1_end5_index = 0;
    public int strand1_end3_index = 1;
    public int strand2_end5_index = 2;
    public int strand2_end3_index = 3;
    public static final String STRAND1_END5_NAME = "STRAND1_END5";
    public static final String STRAND1_END3_NAME = "STRAND1_END3";
    public static final String STRAND2_END5_NAME = "STRAND2_END5";
    public static final String STRAND2_END3_NAME = "STRAND2_END3";
    public static String CLASS_NAME = "RnaStem3D";
    private Stem stemInfo;

    public SimpleRnaStem3D() {
    }

    public SimpleRnaStem3D(Stem stem) {
        this.stemInfo = stem;
    }

    public SimpleRnaStem3D(Stem stem, Vector3D pos) {
        this.stemInfo = stem;
        this.setPosition(pos);
    }

    @Override
    public Object cloneDeepThis() {
        SimpleRnaStem3D obj = new SimpleRnaStem3D();
        obj.copyDeepThisCore(this);
        obj.strand1_end5_index = this.strand1_end5_index;
        obj.strand1_end3_index = this.strand1_end3_index;
        obj.strand2_end5_index = this.strand2_end5_index;
        obj.strand2_end3_index = this.strand2_end3_index;
        obj.stemInfo = (Stem)this.stemInfo.clone();
        return obj;
    }

    @Override
    public RnaStem3D generateReverseStem() {
        return new SimpleRnaStem3D(this.stemInfo.generateReverseStem(), this.getPosition());
    }

    @Override
    public int getLength() {
        return this.stemInfo.size();
    }

    @Override
    public int getStrand1End5Index() {
        return this.strand1_end5_index;
    }

    @Override
    public int getStrand1End3Index() {
        return this.strand1_end3_index;
    }

    @Override
    public int getStrand2End5Index() {
        return this.strand2_end5_index;
    }

    @Override
    public int getStrand2End3Index() {
        return this.strand2_end3_index;
    }

    @Override
    public Vector3D getCenter1Position() {
        Vector3D sum = this.getChild(this.getStrand1End5Index()).getPosition();
        sum.add(this.getChild(this.getStrand2End3Index()).getPosition());
        sum.scale(0.5);
        return sum;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Vector3D getCenter2Position() {
        Vector3D sum = this.getChild(this.getStrand1End3Index()).getPosition();
        sum.add(this.getChild(this.getStrand2End5Index()).getPosition());
        sum.scale(0.5);
        return sum;
    }

    @Override
    public NucleotideStrand getStrand1() {
        NucleotideStrand strand = (NucleotideStrand)this.stemInfo.getSequence1();
        return strand;
    }

    @Override
    public NucleotideStrand getStrand2() {
        NucleotideStrand strand = (NucleotideStrand)this.stemInfo.getSequence2();
        return strand;
    }

    @Override
    public Nucleotide3D getStartResidue(int n) {
        return (Nucleotide3D)this.getStrand1().getResidue(this.stemInfo.getStartPos(n).getPos());
    }

    @Override
    public Nucleotide3D getStopResidue(int n) {
        return (Nucleotide3D)this.getStrand2().getResidue(this.stemInfo.getStopPos(n).getPos());
    }

    @Override
    public Stem getStemInfo() {
        return this.stemInfo;
    }

    @Override
    public void setStemInfo(Stem stem) {
        this.stemInfo = stem;
    }

    @Override
    public void setStrand1End5Index(int n) {
        this.strand1_end5_index = n;
    }

    @Override
    public void setStrand1End3Index(int n) {
        this.strand1_end3_index = n;
    }

    @Override
    public void setStrand2End5Index(int n) {
        this.strand2_end5_index = n;
    }

    @Override
    public void setStrand2End3Index(int n) {
        this.strand2_end3_index = n;
    }

    @Override
    public String toString() {
        String result = new String();
        result = "(" + this.getClassName() + " " + this.toStringBody() + " )";
        return result;
    }

    @Override
    public String toStringBody() {
        String result = new String();
        assert (this.stemInfo != null);
        assert (this.getStrand1() != null);
        assert (this.getStrand2() != null);
        result = this.getName() + " " + this.getStrand1().getName() + " " + this.getStrand2().getName() + " ";
        result = result + this.getRelativePosition().toString();
        result = result + " " + this.stemInfo.toString();
        return result;
    }
}

