/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.GraphBase;
import graphtools.GraphBaseOrderSetTools;
import graphtools.IntegerListList;
import graphtools.SimpleGraphBaseOrderSet;
import java.util.logging.Logger;
import rnadesign.rnamodel.AbstractGridTiler;
import rnadesign.rnamodel.GridPathTools;
import rnadesign.rnamodel.GridTiler;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaStrand;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class SimpleGridTiler
extends AbstractGridTiler
implements GridTiler {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private int offset = 2;
    private Object3D nucleotideDB;

    public SimpleGridTiler(Object3D nucleotideDB) {
        this.nucleotideDB = nucleotideDB;
    }

    @Override
    public Object3DLinkSetBundle generateTiling(Object3D objects, LinkSet links, String baseName, char defaultSequenceChar, boolean onlyFirstPathMode) {
        int i;
        log.fine("Starting generateTiling!");
        SimpleObject3DSet objectSet = new SimpleObject3DSet(objects);
        GraphBase graph = GridPathTools.generateGraph(objectSet, links);
        SimpleGraphBaseOrderSet graphOrderSet = new SimpleGraphBaseOrderSet(graph, 4);
        IntegerListList circularPaths = GraphBaseOrderSetTools.getUniqueCyclicalPaths(graphOrderSet);
        SimpleObject3D resultObjects = new SimpleObject3D();
        SimpleObject3DSet strandSet = new SimpleObject3DSet();
        SimpleLinkSet newLinks = new SimpleLinkSet();
        resultObjects.setName("tilingroot");
        log.fine("generating strand for each circular path out of " + circularPaths.size());
        for (i = 0; i < circularPaths.size(); ++i) {
            String strandName = baseName + ".strand" + (i + 1);
            Object3DLinkSetBundle bundle = this.generateStrand(circularPaths.get(i), objectSet, strandName, defaultSequenceChar, 2 * this.offset);
            RnaStrand strand = (RnaStrand)bundle.getObject3D();
            log.fine("Strand " + strand.getName() + " with size " + strand.getResidueCount() + " " + strand.size() + " generated.");
            resultObjects.insertChild(strand);
            strandSet.add(strand);
            newLinks.merge(bundle.getLinks());
        }
        log.fine("generating Stem3D for each link");
        for (i = 0; i < links.size(); ++i) {
            String stemName = baseName + ".stem" + (i + 1);
            Object3DLinkSetBundle stemBundle = this.generateStem3D(circularPaths, objectSet, strandSet, links.get(i), stemName, this.nucleotideDB, this.offset);
            if (stemBundle == null) continue;
            resultObjects.insertChild(stemBundle.getObject3D());
            newLinks.merge(stemBundle.getLinks());
        }
        for (i = 0; i < strandSet.size(); ++i) {
            Rna3DTools.interpolateNonStems((RnaStrand)strandSet.get(i), resultObjects);
        }
        SimpleObject3DLinkSetBundle resultBundle = new SimpleObject3DLinkSetBundle(resultObjects, newLinks);
        log.fine("Finished generateTiling!");
        return resultBundle;
    }
}

