/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaConstants;
import tools3d.CoordinateSystem;
import tools3d.LineShape;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3D;

public class SimpleBranchDescriptor3D
extends SimpleObject3D
implements BranchDescriptor3D {
    private NucleotideStrand incomingStrand;
    private NucleotideStrand outgoingStrand;
    private HelixParameters helixParameters;
    private int incomingStartIndex = 0;
    private int outgoingStopIndex = 0;
    private int offset = 0;
    public static final String CLASS_NAME = "BranchDescriptor3D";
    public static final String COORD_NAME = "coordinate-system";
    public static final String BASE_NAME = "base";
    public static final double ANGLE_DIFF_MAX = 89.0;

    public SimpleBranchDescriptor3D() {
        this.helixParameters = new HelixParameters();
    }

    public SimpleBranchDescriptor3D(CoordinateSystem3D coordinateSystem) {
        this.helixParameters = new HelixParameters();
        CoordinateSystem3D lcs = new CoordinateSystem3D(coordinateSystem);
        lcs.setName(COORD_NAME);
        this.setPosition(coordinateSystem.getPosition());
        this.insertChild(lcs);
    }

    public SimpleBranchDescriptor3D(NucleotideStrand incomingStrand, NucleotideStrand outgoingStrand, int incomingIndex, int outgoingIndex, CoordinateSystem coordinateSystem) {
        assert (coordinateSystem.isValid());
        this.helixParameters = new HelixParameters();
        this.incomingStrand = incomingStrand;
        this.outgoingStrand = outgoingStrand;
        this.incomingStartIndex = incomingIndex;
        this.outgoingStopIndex = outgoingIndex;
        String myName = incomingStrand.getName() + "_" + (incomingIndex + 1) + "_" + outgoingStrand.getName() + "_" + (outgoingIndex + 1);
        this.setName(myName);
        Vector3D pIn = incomingStrand.getResidue3D(incomingIndex).getPosition();
        Vector3D pOut = outgoingStrand.getResidue3D(outgoingIndex).getPosition();
        Vector3D newPos = coordinateSystem.getPosition();
        this.setIsolatedPosition(newPos);
        CoordinateSystem3D lcs = new CoordinateSystem3D(coordinateSystem);
        lcs.setName(COORD_NAME);
        this.insertChild(lcs);
        if (!this.isValid()) {
            System.out.println(" Invalid branch descriptor: " + this.toString());
            assert (this.isValid());
        }
    }

    @Override
    public Object cloneDeepThis() {
        SimpleBranchDescriptor3D obj = new SimpleBranchDescriptor3D();
        obj.copyDeepThisCore(this);
        obj.helixParameters = new HelixParameters(this.helixParameters);
        obj.incomingStartIndex = this.incomingStartIndex;
        obj.outgoingStopIndex = this.outgoingStopIndex;
        obj.incomingStrand = (NucleotideStrand)this.incomingStrand.cloneDeep();
        obj.offset = this.offset;
        obj.outgoingStrand = !this.isSingleSequence() ? (NucleotideStrand)this.outgoingStrand.cloneDeep() : obj.incomingStrand;
        return obj;
    }

    @Override
    public Vector3D computeHelixPosition(int basePair, int strand) {
        CoordinateSystem cs = this.getCoordinateSystem();
        LineShape line = Rna3DTools.computeHelix(basePair, cs, this.helixParameters);
        Vector3D result = null;
        switch (strand) {
            case 1: {
                result = line.getPosition1();
                break;
            }
            case 2: {
                result = line.getPosition2();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    @Override
    public Vector3D getBasePosition() {
        return this.getPosition();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        Object3D child = this.getChild(COORD_NAME);
        if (child == null) {
            assert (false);
            return null;
        }
        return (CoordinateSystem3D)child;
    }

    @Override
    public Vector3D getDirection() {
        return this.getCoordinateSystem().getZ();
    }

    @Override
    public HelixParameters getHelixParameters() {
        return this.helixParameters;
    }

    @Override
    public NucleotideStrand getIncomingStrand() {
        return this.incomingStrand;
    }

    @Override
    public NucleotideStrand getOutgoingStrand() {
        return this.outgoingStrand;
    }

    @Override
    public int getIncomingIndex() {
        return this.incomingStartIndex;
    }

    @Override
    public int getOutgoingIndex() {
        return this.outgoingStopIndex;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public static CoordinateSystem3D generatePropagatedCoordinateSystem(CoordinateSystem3D csOrig, HelixParameters helixParameters, int offset) {
        CoordinateSystem3D cs = (CoordinateSystem3D)csOrig.cloneDeep();
        cs.translate(cs.getZ().mul(helixParameters.getRise() * (double)offset));
        double ang = Math.PI * 2 / helixParameters.getBasePairsPerTurn() * (double)offset;
        cs.rotate(cs.getZ(), ang);
        return cs;
    }

    @Override
    public CoordinateSystem generatePropagatedCoordinateSystem(int offset) {
        CoordinateSystem3D cs = new CoordinateSystem3D(this.getCoordinateSystem());
        return SimpleBranchDescriptor3D.generatePropagatedCoordinateSystem(cs, this.helixParameters, offset);
    }

    @Override
    public void propagate(int offset) {
        CoordinateSystem cs = this.getCoordinateSystem();
        cs.translate(cs.getZ().mul(RnaConstants.HELIX_RISE * (double)offset));
        double ang = Math.PI * 2 / RnaConstants.HELIX_BASE_PAIRS_PER_TURN * (double)offset;
        cs.rotate(cs.getZ(), ang);
        this.incomingStartIndex += offset;
        this.outgoingStopIndex -= offset;
    }

    @Override
    public void setBasePosition(Vector3D p) {
        this.setPosition(p);
    }

    @Override
    public void setCoordinateSystem(CoordinateSystem other) {
        this.setPosition(other.getPosition());
        CoordinateSystem cs = this.getCoordinateSystem();
        cs.copy(other);
    }

    @Override
    public void setHelixParameters(HelixParameters prm) {
        this.helixParameters = prm;
    }

    @Override
    public boolean isSingleSequence() {
        return this.isStrandPairProbablyEqual(this.incomingStrand, this.outgoingStrand);
    }

    private boolean isStrandPairProbablyEqual(BioPolymer strand1, BioPolymer strand2) {
        if (strand1 == strand2) {
            return true;
        }
        if (!strand1.getName().equals(strand2.getName())) {
            return false;
        }
        if (strand1.size() != strand2.size()) {
            return false;
        }
        return strand1.size() == 0 || strand1.getChild(0).distance(strand2.getChild(0)) < 0.01;
    }

    private boolean isResiduePairProbablyEqual(Residue3D residue1, Residue3D residue2) {
        if (!residue1.getSymbol().equals(residue2.getSymbol())) {
            return false;
        }
        if (residue1.size() != residue2.size()) {
            return false;
        }
        return !(residue1.getPosition().distance(residue2.getPosition()) > 1.0E-4);
    }

    @Override
    public boolean isValid() {
        CoordinateSystem cs = this.getCoordinateSystem();
        if (cs == null) {
            System.out.println("Warning: BranchDescriptor coordinate system undefined.");
            return false;
        }
        if (cs.getPosition().distance(this.getPosition()) > 0.01) {
            System.out.println("Warning: BranchDescriptor coordinate system position inconsistent.");
            return false;
        }
        char c1 = this.getIncomingStrand().getResidue(this.getIncomingIndex()).getSymbol().getCharacter();
        char c2 = this.getOutgoingStrand().getResidue(this.getOutgoingIndex()).getSymbol().getCharacter();
        return true;
    }

    @Override
    public void setIncomingIndex(int n) {
        this.incomingStartIndex = n;
    }

    @Override
    public void setIncomingStrand(NucleotideStrand strand) {
        this.incomingStrand = strand;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void setOutgoingIndex(int n) {
        this.outgoingStopIndex = n;
    }

    @Override
    public void setOutgoingStrand(NucleotideStrand strand) {
        this.outgoingStrand = strand;
    }

    @Override
    public String infoString() {
        String result = this.getClassName() + " " + this.getName() + " " + this.getPosition() + " dir: " + this.getDirection();
        if (this.incomingStrand != null) {
            result = result + " incoming: " + (this.incomingStartIndex + 1) + " " + Object3DTools.getFullName(this.incomingStrand.getResidue3D(this.incomingStartIndex)) + " ";
        }
        if (this.outgoingStrand != null) {
            result = " outgoing: " + (this.outgoingStopIndex + 1) + " " + Object3DTools.getFullName(this.outgoingStrand.getResidue3D(this.outgoingStopIndex)) + " " + " position: " + this.getPosition();
        }
        return result;
    }

    @Override
    public String toString() {
        String result = "(" + this.getClassName() + " " + this.getName() + " " + this.getIncomingStrand().toString() + " " + this.incomingStartIndex + " " + this.getOutgoingStrand().toString() + " " + this.outgoingStopIndex + " " + this.getPosition() + " (children " + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + ((Object)this.getChild(i)).toString() + " ";
        }
        result = result + " ) )";
        return result;
    }
}

