/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.StringTools;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Logger;
import launchtools.SimpleQueueManager;
import rnadesign.rnamodel.AbstractPdbReader;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.InteractionLinkImp;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleRnaStrand;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteraction;
import sequence.DnaTools;
import sequence.SimpleLetterSymbol;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class RnaPdbRnaviewReader
extends AbstractPdbReader
implements Object3DFactory {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static String nanotilerHome = System.getenv("NANOTILER_HOME");
    public static String RNAVIEW_BIN = nanotilerHome + "/bin/addrnaview";
    public static final int RNAVIEW_STRAND_MAX = 36;
    public static String PDB_REMARKS = "pdb_remarks";
    public static final int WATSON_CRICK_BP = 1;
    public static final int CANONICAL_BP = 2;
    public static final int NON_CANONICAL_BP = 3;
    public static final int ALL_BP = 4;
    public static final int NOT_STACKED = 5;
    public boolean addRnaviewMode = true;
    public boolean allowBackwardJump = false;
    public int allowedMode = 2;
    public static boolean debugMode = false;
    public boolean dnaMode = false;
    public boolean residueRenumberMode = false;
    public int verboseLevel = 1;

    public boolean getResidueRenumberMode() {
        return this.residueRenumberMode;
    }

    public boolean getAllowBackwardJump() {
        return this.allowBackwardJump;
    }

    public boolean getAddRnaviewMode() {
        return this.addRnaviewMode;
    }

    public void setAddRnaviewMode(boolean b) {
        this.addRnaviewMode = b;
    }

    public void setAllowedMode(int mode) {
        this.allowedMode = mode;
    }

    public void setAllowBackwardJump(boolean b) {
        assert (!b);
        this.allowBackwardJump = b;
    }

    private boolean sameStrandNames(String assignedName, String pdbName) {
        if (" ".equals(pdbName)) {
            return "A".equals(assignedName);
        }
        return assignedName.equals(pdbName);
    }

    private String parseRnaviewStrandPairing(String line) {
        line = line.trim();
        line = line.replace("\\s{2,}", " ");
        StringTokenizer tokens = new StringTokenizer(line);
        int count = 0;
        String chainName1 = "";
        String chainName2 = "";
        int res1 = 0;
        int res2 = 0;
        try {
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (count == 1) {
                    if (token.length() == 2) {
                        chainName1 = token.substring(0, 1);
                    } else if (token.length() == 1) {
                        chainName1 = "A";
                    } else {
                        log.warning("Weird line, no first chain name extracted: " + line);
                        return null;
                    }
                }
                if (count == 5) {
                    if (token.length() == 2) {
                        chainName2 = token.substring(0, 1);
                    } else if (token.length() == 1) {
                        chainName2 = "A";
                    } else {
                        log.warning("Weird line, no second chain name extracted: " + line);
                        return null;
                    }
                }
                if (count == 2) {
                    res1 = Integer.parseInt(token) - 1;
                }
                if (count == 4) {
                    res2 = Integer.parseInt(token) - 1;
                }
                ++count;
            }
        }
        catch (NumberFormatException nfe) {
            log.info("Could not interpret RNAview line: " + line);
            return null;
        }
        if (chainName1 == null || chainName2 == null) {
            return null;
        }
        if (chainName1.length() != 1 || chainName2.length() != 1) {
            return null;
        }
        TreeSet<Character> sortedSet = new TreeSet<Character>();
        sortedSet.add(new Character(chainName1.charAt(0)));
        sortedSet.add(new Character(chainName2.charAt(0)));
        Iterator iterator = sortedSet.iterator();
        String result = "";
        while (iterator.hasNext()) {
            result = result + iterator.next();
        }
        if (result.length() == 1) {
            result = result + result;
        }
        return result;
    }

    private Set<String> parseRnaviewStrandPairings(String[] lines) {
        HashSet<String> result = new HashSet<String>();
        boolean mode = false;
        for (int i = 0; i < lines.length; ++i) {
            String strandPairing;
            if (lines[i].length() < 10 || !lines[i].startsWith("REMARK")) continue;
            String line = lines[i].substring(8);
            if (line.startsWith("BEGIN_base-pair")) {
                mode = true;
            } else if (line.startsWith("END_base-pair")) break;
            if (!mode || (strandPairing = this.parseRnaviewStrandPairing(line)) == null) continue;
            result.add(strandPairing);
        }
        return result;
    }

    private LinkSet parseRnaviewLinks(String[] lines, NucleotideStrand strand, NucleotideStrand strand2, int strand1OffStart, int strand1OffEnd, int strand2OffStart, int strand2OffEnd) {
        assert (lines != null);
        assert (strand != null);
        SimpleLinkSet links = new SimpleLinkSet();
        if (lines == null) {
            log.warning("Object3D " + strand.getName() + " has no muliple lines of RNAVIEW properties defined.");
            return links;
        }
        log.finest("Parsing " + lines.length + " RNAVIEW info lines." + PackageConstants.NEWLINE);
        int i = 0;
        for (i = 0; i < lines.length; ++i) {
            String line;
            if (lines[i].length() < 10 || !(line = lines[i].substring(8)).startsWith("BEGIN_base-pair")) continue;
            ++i;
            break;
        }
        if (i >= lines.length) {
            log.warning("Could not find RNAVIEW keyword BEGIN_base-pair");
            return links;
        }
        int lineCounter = 0;
        while (i < lines.length) {
            ++lineCounter;
            if (lines[i].length() < 10) {
                log.finest("RNAVIEW ine too short, skipping: " + lines[i]);
            } else {
                String line = lines[i].substring(8);
                if (line.startsWith("END_base-pair")) break;
                Link newLink = this.parseRnaviewLine(line, strand, strand2, strand1OffStart, strand1OffEnd, strand2OffStart, strand2OffEnd);
                if (newLink != null) {
                    links.add(newLink);
                } else {
                    log.fine("No proper Watson-Crick pair in line: " + line);
                }
            }
            ++i;
        }
        log.finest("Anlyzed " + lineCounter + " RNAVIEW lines.");
        if (i >= lines.length) {
            log.warning("Could not find RNAVIEW keyword END_base-pair");
            return links;
        }
        return links;
    }

    Link parseRnaviewLine(String line, NucleotideStrand strand, NucleotideStrand strand2, int strand1OffStart, int strand1OffEnd, int strand2OffStart, int strand2OffEnd) {
        assert (line != null);
        assert (strand != null);
        line = line.trim();
        line = line.replace("\\s{2,}", " ");
        boolean sameNameMode = strand != strand2 && strand.getProperty("pdb_chain_char") != null && strand.getProperty("pdb_chain_char").equals(strand2.getProperty("pdb_chain_char")) && strand1OffStart == strand2OffStart;
        StringTokenizer tokens = new StringTokenizer(line);
        String intClass = "";
        int count = 0;
        int res1 = 0;
        int res2 = 0;
        String chainName1 = "" + this.getDefaultStrandName(0);
        String chainName2 = "" + this.getDefaultStrandName(0);
        String[] words = line.split(" ");
        if (words.length < 5) {
            log.warning("Strange line (less then 5 words: " + line);
            return null;
        }
        String[] numberWords = words[0].split("_");
        if (numberWords.length != 2) {
            log.warning("Strange RNAview word: " + words[0] + " in line: " + line);
            return null;
        }
        int absNumber1 = Integer.parseInt(numberWords[0]) - 1;
        int absNumber2 = Integer.parseInt(numberWords[1].replaceAll(",", "")) - 1;
        if (absNumber1 < strand1OffStart || absNumber1 >= strand1OffEnd || absNumber2 < strand2OffStart || absNumber2 >= strand2OffEnd) {
            log.fine("Non-matching indices: " + strand1OffStart + " " + strand1OffEnd + " " + strand2OffStart + " " + strand2OffEnd + " for residues in line:  " + absNumber1 + " " + absNumber2 + " " + line + " " + strand.getFullName() + " " + strand2.getFullName());
            return null;
        }
        while (tokens.hasMoreTokens()) {
            String token;
            intClass = token = tokens.nextToken();
            if (count == 1) {
                if (token.length() == 2) {
                    chainName1 = token.substring(0, 1);
                } else if (token.length() == 1) {
                    chainName1 = "A";
                } else {
                    log.warning("Weird line, no first chain name extracted: " + line);
                    return null;
                }
            }
            if (count == 5) {
                if (token.length() == 2) {
                    chainName2 = token.substring(0, 1);
                } else if (token.length() == 1) {
                    chainName2 = "A";
                } else {
                    log.warning("Weird line, no second chain name extracted: " + line);
                    return null;
                }
            }
            if (count == 2) {
                res1 = Integer.parseInt(token);
            }
            if (count == 4) {
                res2 = Integer.parseInt(token);
            }
            ++count;
        }
        if (!this.sameStrandNames(chainName1, strand.getProperty("pdb_chain_char")) || !this.sameStrandNames(chainName2, strand2.getProperty("pdb_chain_char"))) {
            log.fine("RNA strand names do not match:" + chainName1 + ":" + strand.getProperty("pdb_chain_char") + "|" + chainName2 + ":" + strand2.getProperty("pdb_chain_char") + ":line: " + line);
            return null;
        }
        if (this.isAllowedClass(intClass)) {
            Residue3D residue1 = strand.getResidueByPdbId(res1);
            Residue3D residue2 = strand2.getResidueByPdbId(res2);
            if (residue1 == null) {
                String debugResult = "";
                for (int i = 0; i < strand.getResidueCount(); ++i) {
                    debugResult = debugResult + " " + strand.getResidue(i).getProperty("pdb_residue_id");
                }
                log.info("Could not find residue with pdb number: " + res1 + " in: " + debugResult);
                return null;
            }
            if (residue2 == null) {
                String debugResult = "";
                for (int i = 0; i < strand2.getResidueCount(); ++i) {
                    debugResult = debugResult + " " + strand2.getResidue(i).getProperty("pdb_residue_id");
                }
                log.info("Could not find residue with pdb number: " + res2 + " in: " + debugResult);
                return null;
            }
            log.fine("Generating link between residues " + residue1.getFullName() + " " + residue1.getPos() + 1 + " ( " + res1 + " ) and " + residue2.getFullName() + " " + (residue2.getPos() + 1) + " ( " + res2 + " ) ");
            RnaInteractionType interactionType = new RnaInteractionType(1);
            SimpleInteraction interaction = new SimpleInteraction(residue1, residue2, interactionType);
            return new InteractionLinkImp(residue1, residue2, interaction);
        }
        log.fine("parseRnaviewLine failed for line: " + line);
        return null;
    }

    boolean isAllowedClass(String intClass) {
        if (intClass == null || intClass.length() == 0) {
            return false;
        }
        switch (this.allowedMode) {
            case 2: {
                return intClass.equals("XX") || intClass.equals("XIX") || intClass.equals("XXVIII");
            }
            case 1: {
                return intClass.equals("XX") || intClass.equals("XIX");
            }
            case 3: {
                return intClass.charAt(0) == 'X';
            }
            case 5: {
                return !intClass.equals("stacked") && !intClass.equals("!(s_s)") && !intClass.equals("n/a");
            }
            case 4: {
                return true;
            }
        }
        assert (false);
        return false;
    }

    String getRnaviewStrandPairing(NucleotideStrand strand1, NucleotideStrand strand2) {
        String chainName1 = strand1.getProperty("pdb_chain_char");
        String chainName2 = strand2.getProperty("pdb_chain_char");
        if (chainName1.length() > 1 && chainName2.charAt(0) == '_') {
            chainName1 = chainName1.substring(1);
        }
        if (chainName2.length() > 1 && chainName2.charAt(0) == '_') {
            chainName2 = chainName2.substring(1);
        }
        log.fine("Using chain names for strand pairings: " + strand1.getFullName() + " " + chainName1 + strand2.getFullName() + " " + " " + chainName2);
        if (chainName1 == null || chainName2 == null || chainName1.length() != 1 || chainName2.length() != 1) {
            return null;
        }
        char c1 = chainName1.charAt(0);
        char c2 = chainName2.charAt(0);
        if (c1 == ' ') {
            c1 = 'A';
        }
        if (c2 == ' ') {
            c2 = 'A';
        }
        String strandPairing = "";
        strandPairing = c1 <= c2 ? strandPairing + c1 + c2 : strandPairing + c2 + c1;
        return strandPairing;
    }

    private boolean containsRnaviewInfo(String[] lines) {
        if (lines == null || lines.length == 0) {
            return false;
        }
        boolean found1 = false;
        boolean found2 = false;
        for (String s : lines) {
            if (s.length() < 10 || !s.startsWith("REMARK")) continue;
            String line = s.substring(8);
            if (line.startsWith("BEGIN_base-pair")) {
                found1 = true;
                continue;
            }
            if (!found1 || !line.startsWith("END_base-pair")) continue;
            found2 = true;
            break;
        }
        return found1 && found2;
    }

    private boolean containsRnaviewInfo(String remarks) {
        if (remarks == null || remarks.length() == 0) {
            return false;
        }
        return this.containsRnaviewInfo(remarks.split("\\n"));
    }

    private boolean containsRnaviewInfo(Properties properties) {
        if (properties == null) {
            return false;
        }
        return this.containsRnaviewInfo(properties.getProperty(PDB_REMARKS));
    }

    public static void fileCopy(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = is.read(buf)) != -1) {
                os.write(buf, 0, i);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    int countStrands(Object3D root) {
        Object3DSet strands = Object3DTools.collectByClassName(root, "RnaStrand");
        return strands.size();
    }

    boolean checkStrandNamesSimple(Object3D root) {
        HashSet<String> strandNames = new HashSet<String>();
        Object3DSet strands = Object3DTools.collectByClassName(root, "RnaStrand");
        for (int i = 0; i < strands.size(); ++i) {
            String name = strands.get(i).getName();
            assert (name != null);
            if (name.length() != 1) {
                return false;
            }
            strandNames.add(name);
        }
        return strandNames.size() == strands.size();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object3DLinkSetBundle readBundle(InputStream isOrig) throws Object3DIOException {
        RnaPdbRnaviewReader.log.info("starting RnaPdbRnaviewReader.readBundle!");
        fileName = null;
        tmpFile = null;
        is = isOrig;
        obj = this.readAnyObject3D(is);
        links = new SimpleLinkSet();
        prop = obj.getProperties();
        remarkLines = new String[]{};
        if (RnaPdbRnaviewReader.debugMode) {
            strandSet = Object3DTools.collectByClassName(obj, "RnaStrand");
            System.out.println("Initially read strands:");
            for (i = 0; i < strandSet.size(); ++i) {
                System.out.println(strandSet.get(i).getFullName());
            }
        }
        if (this.addRnaviewMode && !this.containsRnaviewInfo(obj.getProperties())) {
            if (RnaPdbRnaviewReader.debugMode) {
                RnaPdbRnaviewReader.log.info("Adding RNAview info...");
            }
            if ((strandCount = this.countStrands(obj)) > 36) {
                throw new Object3DIOException("Cannot add RNAview info, because more than 36 strands detected: " + strandCount);
            }
            try {
                tmpFile = File.createTempFile("nanotiler", ".pdb");
                fileName = tmpFile.getAbsolutePath();
                if (!RnaPdbRnaviewReader.debugMode) {
                    tmpFile.deleteOnExit();
                }
                fos = new FileOutputStream(tmpFile);
                simpleStrands = this.checkStrandNamesSimple(obj);
                writer = new GeneralPdbWriter();
                if (!simpleStrands) {
                    RnaPdbRnaviewReader.log.warning("Duplicate or long strand names detected! Re-reading using renamed strands...");
                    writer.setOriginalMode(2);
                } else {
                    RnaPdbRnaviewReader.log.fine("All strand names are simple, no renaming necessary.");
                }
                RnaPdbRnaviewReader.log.fine("Writing structure in PDB format to temporary file: " + fileName);
                writer.write((OutputStream)fos, obj);
                fos.close();
                if (!RnaPdbRnaviewReader.$assertionsDisabled && fileName == null) {
                    throw new AssertionError();
                }
                mode = "n";
                command = RnaPdbRnaviewReader.RNAVIEW_BIN + " " + fileName + " " + mode;
                RnaPdbRnaviewReader.log.fine("Launching command: " + command);
                linesList = SimpleQueueManager.shell(command);
                if (!RnaPdbRnaviewReader.$assertionsDisabled && linesList == null) {
                    throw new AssertionError();
                }
                remarkLines = linesList.toArray(remarkLines);
                remarkLinesString = StringTools.convertArrayToString(remarkLines);
                if (!RnaPdbRnaviewReader.$assertionsDisabled && remarkLines.length != linesList.size()) {
                    throw new AssertionError();
                }
                is = new FileInputStream(tmpFile);
                obj = this.readAnyObject3D(is);
                obj.setProperty(RnaPdbRnaviewReader.PDB_REMARKS, remarkLinesString);
                is.close();
                if (!this.checkStrandNamesSimple(obj)) {
                    RnaPdbRnaviewReader.log.severe("Could not generate simple strand names even! Maybe more than 52 strands? RNAview base pair info might not be correctly assigned!");
                }
                if (!RnaPdbRnaviewReader.debugMode) ** GOTO lbl64
                RnaPdbRnaviewReader.log.info("Added base pair info by launching RNAview!");
                for (String s : remarkLines) {
                    System.out.println(s);
                }
            }
            catch (IOException ioe) {
                throw new Object3DIOException("Error in readBundle, trying to supplement RNAview info: " + ioe.getMessage());
            }
        } else if (prop != null && (remarks = prop.getProperty(RnaPdbRnaviewReader.PDB_REMARKS)) != null) {
            remarkLines = remarks.split("\\n");
        }
lbl64:
        // 5 sources

        if (this.addRnaviewMode && this.containsRnaviewInfo(remarkLines)) {
            if (RnaPdbRnaviewReader.debugMode) {
                RnaPdbRnaviewReader.log.info("Using RNAview info...");
            }
            rnaviewStrandPairings = this.parseRnaviewStrandPairings(remarkLines);
            strandSet = Object3DTools.collectByClassName(obj, "RnaStrand");
            sizeOffsets = Object3DSetTools.generateSizeOffsets(strandSet);
            if (this.verboseLevel > 0) {
                RnaPdbRnaviewReader.log.finest("Parsing info about " + strandSet.size() + " strands.");
            }
            for (i = 0; i < strandSet.size(); ++i) {
                strand = (NucleotideStrand)strandSet.get(i);
                RnaPdbRnaviewReader.log.fine("Parsing RNAVIEW info for strand " + strand.getName() + " with " + strand.getResidueCount() + " residues.");
                if (strand.size() == 0) {
                    throw new Object3DIOException("Strand " + strand.getFullName() + " has zero size.");
                }
                if (!RnaPdbRnaviewReader.$assertionsDisabled && strand.size() <= 0) {
                    throw new AssertionError();
                }
                if (!RnaPdbRnaviewReader.$assertionsDisabled && strand.getResidueCount() <= 0) {
                    throw new AssertionError();
                }
                for (j = 0; j < strandSet.size(); ++j) {
                    strand2 = (NucleotideStrand)strandSet.get(j);
                    RnaPdbRnaviewReader.log.fine("Parsing RNAVIEW info for strand " + strand.getName() + " with " + strand.getResidueCount() + " residues and " + strand2.getName() + " with " + strand2.getResidueCount() + " residues.");
                    if (strand2.size() == 0) {
                        throw new Object3DIOException("Strand2 " + strand2.getFullName() + " has zero size.");
                    }
                    if (!RnaPdbRnaviewReader.$assertionsDisabled && strand2.size() <= 0) {
                        throw new AssertionError();
                    }
                    if (!RnaPdbRnaviewReader.$assertionsDisabled && strand2.getResidueCount() <= 0) {
                        throw new AssertionError();
                    }
                    RnaPdbRnaviewReader.log.finest("Checking between strands (1) " + strand.getName() + " " + strand2.getName());
                    strandPairing = this.getRnaviewStrandPairing(strand, strand2);
                    if (strandPairing == null) {
                        RnaPdbRnaviewReader.log.warning("Could not extract PDB - Rnaview strand pairing for " + strand.getFullName() + " and " + strand2.getFullName());
                        continue;
                    }
                    if (!rnaviewStrandPairings.contains(strandPairing)) {
                        RnaPdbRnaviewReader.log.fine("Ignoring non-existent strand pairing: " + strandPairing);
                        continue;
                    }
                    rnaviewLinks = this.parseRnaviewLinks(remarkLines, strand, strand2, sizeOffsets[i], sizeOffsets[i + 1], sizeOffsets[j], sizeOffsets[j + 1]);
                    RnaPdbRnaviewReader.log.fine("Found " + rnaviewLinks.size() + " links between strands " + (i + 1) + " " + strand.getName() + " " + strand.getProperty("pdb_chain_char") + " and " + (j + 1) + " " + strand2.getName() + " " + strand2.getProperty("pdb_chain_char"));
                    links.merge(rnaviewLinks);
                    rnaviewLinks.clear();
                }
            }
        } else {
            RnaPdbRnaviewReader.log.warning("Object3D " + obj.getFullName() + " has no RNAVIEW properties defined.");
        }
        if (this.addRnaviewMode && tmpFile != null && !RnaPdbRnaviewReader.debugMode) {
            if (!RnaPdbRnaviewReader.$assertionsDisabled && fileName == null) {
                throw new AssertionError();
            }
            if (RnaPdbRnaviewReader.debugMode) {
                RnaPdbRnaviewReader.log.info("Removing temporary file " + fileName);
            }
            tmpFile.delete();
        }
        if (RnaPdbRnaviewReader.debugMode) {
            RnaPdbRnaviewReader.log.info("Adding covalent links...");
        }
        this.addCovalentLinks(obj, links);
        if (RnaPdbRnaviewReader.debugMode) {
            RnaPdbRnaviewReader.log.info("Finished RnaPdbRnaviewReader.readBundle: PDB file with " + obj.size() + " strands read: Position: " + obj.getPosition());
        }
        return new SimpleObject3DLinkSetBundle(obj, links);
    }

    @Override
    public Object3D readAnyObject3D(InputStream is) throws Object3DIOException {
        if (debugMode) {
            log.info("Starting RnaPdbRnaviewReader.readAnyObject3D! Renumber-mode: " + this.residueRenumberMode);
        }
        DataInputStream dis = new DataInputStream(is);
        SimpleObject3D root = new SimpleObject3D();
        SimpleObject3DSet atomSet = new SimpleObject3DSet();
        root.setName("PdbImport");
        String currentStrandName = "_";
        int currentResidueId = -9999;
        int currentPdbResidueId = -9999;
        if (this.residueRenumberMode) {
            currentResidueId = 0;
        }
        int currentAtomId = -9999;
        int lineCounter = 0;
        Object3D currentStrand = null;
        SimpleObject3D currentResidue = null;
        int strandCounter = 0;
        boolean strandEndFlag = false;
        StringBuffer remarkBuf = new StringBuffer();
        int tabooResidueVersionChar = 32;
        String strandNameMapFrom = "";
        String strandNameMapTo = "";
        String strandNameOrig = "undefined";
        String strandNameOrigOld = "undefined2";
        int mappedId = -1;
        HashSet<String> knownErrors = new HashSet<String>();
        try {
            String line;
            do {
                line = dis.readLine();
                ++lineCounter;
                if (debugMode) {
                    log.fine("Read line " + lineCounter + ": " + line);
                }
                if (line == null) {
                    if (debugMode) {
                        log.info("Quitting loop because end of file reached! Line number: " + lineCounter);
                    }
                    break;
                }
                if (this.isTer(line) || this.isEndMdl(line)) {
                    if (debugMode) {
                        log.fine("TER or ENDMDL keyword found!");
                    }
                    strandEndFlag = true;
                    continue;
                }
                if (this.isRemark(line)) {
                    remarkBuf.append(line + PackageConstants.NEWLINE);
                }
                if (RnaPdbRnaviewReader.isAtom(line)) {
                    double minDist;
                    if (debugMode) {
                        log.fine("Recognized atom in current line!");
                    }
                    int residueId = this.getResidueId(line);
                    int pdbResidueId = this.getResidueId(line);
                    if (this.residueRenumberMode) {
                        if (pdbResidueId != currentPdbResidueId) {
                            residueId = currentResidueId + 1;
                            log.fine("Renumber mode: setting new current residue to " + residueId + " instead of " + pdbResidueId);
                        } else {
                            residueId = currentResidueId;
                        }
                    }
                    String residueName = this.getResidueName(line);
                    String atomName = this.getAtomName(line);
                    String strandName = "" + this.getStrandName(line);
                    log.fine("Currently reading strand name: " + strandName);
                    strandNameOrigOld = strandNameOrig;
                    strandNameOrig = new String(strandName);
                    if (strandNameMapFrom.equals(strandName) && strandNameMapTo.length() > 0) {
                        strandName = strandNameMapTo;
                    }
                    char versionChar = this.getVersionChar(line);
                    int residueVersionChar = this.getResidueVersionChar(line);
                    if (tabooResidueVersionChar != 32 && residueVersionChar == tabooResidueVersionChar) {
                        log.warning("Warning: ignoring alternative residue version: " + line);
                    }
                    Atom3D atom = this.generateAtomFromPdb(line);
                    if (debugMode) {
                        log.fine("Read atom: " + atom.getName() + " with position: " + atom.getPosition());
                    }
                    if (atomSet.size() > 0 && (minDist = RnaPdbRnaviewReader.findMinimumDistance(atom, atomSet)) < 0.7) {
                        log.info("Warning: colliding atom " + line);
                    }
                    if (!this.isLegalResidueName(residueName)) {
                        String combined = residueName + "_" + residueId;
                        if (knownErrors.contains(combined)) continue;
                        log.info("Not legal RNA residue name: " + residueName + " " + residueId);
                        knownErrors.add(combined);
                        continue;
                    }
                    if (residueId < currentResidueId && strandName.equals(currentStrandName) && this.allowBackwardJump) {
                        if (mappedId < 0) {
                            mappedId = residueId;
                            residueId = currentResidueId + 1;
                        } else if (residueId != mappedId) {
                            mappedId = residueId;
                            residueId = currentResidueId + 1;
                        } else {
                            residueId = currentResidueId;
                        }
                        residueName = "" + residueName.charAt(0) + residueId;
                        log.info("Backward jump detected! Adjusting residue names: " + residueId + " " + residueName + " strand name (orig): " + strandNameOrig + " current strand name: " + currentStrandName);
                    } else {
                        mappedId = -1;
                    }
                    if (this.isLegalResidueName(residueName) && (currentStrand == null || strandEndFlag || !strandName.equals(" ") && !strandName.equals(currentStrandName) || residueId < currentResidueId && !this.allowBackwardJump)) {
                        RnaStrand lastStrand;
                        if (debugMode) {
                            if (residueId < currentResidueId) {
                                log.info("Detected backwards jump in residue ids! Starting new chain: " + residueId + " " + currentResidueId);
                            }
                            if (currentStrand == null) {
                                log.info("Current strand is null");
                            }
                            log.fine("Strand end flag, strand name, current strand name: " + strandEndFlag + " : " + strandName + " : " + currentStrandName + " : " + residueId + " : " + currentResidueId + " : " + this.allowBackwardJump);
                        }
                        mappedId = -1;
                        String tmp = "";
                        tmp = currentStrand == null ? "null" : currentStrand.getName();
                        log.fine("Starting a new strand for line: " + line);
                        log.fine(":" + tmp + ":" + strandEndFlag + ":" + strandName + ":" + currentStrandName + ":" + residueId + ":" + currentResidueId);
                        if (strandName.equals(" ")) {
                            strandName = "" + this.getDefaultStrandName(strandCounter);
                        }
                        boolean renameOccured = false;
                        while (root.getIndexOfChild(strandName) >= 0) {
                            renameOccured = true;
                            strandNameMapTo = strandName = this.getHigherOrderStrandName(strandName);
                            strandNameMapFrom = strandNameOrig;
                        }
                        if (renameOccured) {
                            log.info("Strand with name " + strandNameOrig + " already existed: " + Object3DTools.generateChildNames(root) + " renaming to strand: " + strandName);
                        }
                        strandEndFlag = false;
                        ++strandCounter;
                        currentStrand = this.dnaMode ? new SimpleRnaStrand(DnaTools.DNA_ALPHABET) : new SimpleRnaStrand(DnaTools.RNA_ALPHABET);
                        currentStrand.setName(strandName);
                        currentStrand.setProperty("pdb_chain_char", "" + strandNameOrig.substring(strandNameOrig.length() - 1));
                        currentStrandName = new String(strandName);
                        if (root.getIndexOfChild(currentStrand.getName()) >= 0) {
                            throw new Object3DIOException("Strand with this name already exists: " + currentStrand.getName());
                        }
                        if (root.size() > 0 && (lastStrand = (RnaStrand)root.getChild(root.size() - 1)).getResidueCount() == 0) {
                            throw new Object3DIOException("Last strand had zero residues: " + lastStrand.getFullName());
                        }
                        root.insertChild(currentStrand);
                        log.fine("Adding strand with name: " + currentStrand.getFullName());
                    }
                    if (currentStrand == null) {
                        log.warning("Strand not generated yet! Ignoring atom!");
                        continue;
                    }
                    if (currentResidue == null || currentResidueId != residueId || currentStrand.getResidueCount() == 0) {
                        if (currentStrand.size() > 0 && currentStrand.getResidue3D(currentStrand.getResidueCount() - 1).size() < 2) {
                            Residue3D residue = currentStrand.getResidue3D(currentStrand.getResidueCount() - 1);
                            System.err.println("Problem in line: " + line);
                            System.err.println("Weird nucleotide: " + residue.getFullName() + " " + residue);
                            System.err.println("Current and actual residue ids: " + currentResidueId + " " + residueId);
                            if (currentResidue == null) {
                                System.err.println("Current residue is null!");
                            }
                        }
                        assert (currentStrand.size() == 0 || currentStrand.size() == 1 || currentStrand.getResidue3D(currentStrand.getResidueCount() - 1).size() > 1);
                        try {
                            assert (this.getResidueCharacter("U9") == 'U');
                            char c = this.getResidueCharacter(residueName);
                            assert (c != 'B');
                            if (c == 'X') {
                                log.severe("Could not parse residueName " + residueName);
                            }
                            SimpleLetterSymbol symbol = this.dnaMode ? new SimpleLetterSymbol(c, DnaTools.DNA_ALPHABET) : new SimpleLetterSymbol(c, DnaTools.RNA_ALPHABET);
                            assert (symbol.getCharacter() != 'B');
                            currentResidue = new Nucleotide3D(symbol, atom.getPosition());
                            ((Nucleotide3D)currentResidue).setAssignedNumber(residueId);
                            ((Nucleotide3D)currentResidue).setAssignedName(residueName);
                            currentResidue.setProperty("pdb_residue_id", "" + pdbResidueId);
                            String resName = "" + c + residueId;
                            currentResidue.setName(resName);
                            if (currentStrand.getIndexOfChild(currentResidue.getName()) >= 0) {
                                log.info("Ignoring duplicate residue: " + currentResidue.getName() + (char)residueVersionChar + " " + line);
                                tabooResidueVersionChar = residueVersionChar;
                                continue;
                            }
                            tabooResidueVersionChar = 32;
                            currentStrand.insertChild(currentResidue);
                            currentResidueId = residueId;
                            currentPdbResidueId = pdbResidueId;
                            log.fine("Added nucleotide: " + currentResidue.getFullName() + " " + (((Nucleotide3D)currentResidue).getPos() + 1) + " " + ((Nucleotide3D)currentResidue).getAssignedNumber() + " " + currentResidue.getProperty("pdb_residue_id"));
                        }
                        catch (UnknownSymbolException e) {
                            log.info("Warning: could not interpret nucleotide symbol from line: " + line);
                        }
                    }
                    assert (line != null);
                    if (atom == null) {
                        log.warning("No atom defined for line: " + line);
                        continue;
                    }
                    if (currentResidue == null) {
                        log.warning("No current residue defined for line: " + line);
                        continue;
                    }
                    if (currentResidue.getIndexOfChild(atom.getName()) >= 0) {
                        log.warning("Ignoring duplicate atom: " + atom.getName() + " for residue " + currentResidue.getFullName());
                        continue;
                    }
                    if (debugMode) {
                        log.fine("Inserting atom into strand " + strandCounter + " " + currentStrandName + " residue " + currentResidue.getFullName() + " " + ((Nucleotide3D)currentResidue).getPos() + " : " + atom);
                    }
                    ((Nucleotide3D)currentResidue).insertChild(atom);
                    Vector3D newAtomPos = currentResidue.getChild(currentResidue.size() - 1).getPosition();
                    if (!(atom.getPosition().distance(newAtomPos) >= 0.001)) continue;
                    log.info("Error!!! root: " + root.getPosition() + " strand " + currentStrand.getPosition() + " residue " + currentResidue.getPosition() + " atom: " + atom.getPosition() + " new atom pos: " + newAtomPos);
                    assert (atom.getPosition().distance(newAtomPos) < 0.001);
                    continue;
                }
                if (!debugMode) continue;
                log.fine("Line is not ATOM : " + line);
            } while (line != null);
        }
        catch (IOException ioe) {
            if (ioe instanceof Object3DIOException) {
                throw (Object3DIOException)ioe;
            }
            throw new Object3DIOException(ioe);
        }
        Object3DTools.balanceTree(root);
        if (remarkBuf.length() > 0) {
            Properties prop = root.getProperties();
            if (prop == null) {
                prop = new Properties();
            }
            prop.setProperty(PDB_REMARKS, remarkBuf.toString());
            if (debugMode) {
                log.info("Set object " + root.getName() + " remark text to: " + prop.getProperty("pdb_remarks"));
            }
            root.setProperties(prop);
        }
        if (debugMode) {
            log.info("Finished RnaPdbRnaviewReader.readAnyObject3D. Number of read objects: " + new SimpleObject3DSet(root).size());
        }
        return root;
    }

    public void setResidueRenumberMode(boolean flag) {
        this.residueRenumberMode = flag;
    }
}

