/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DWriter;

public class RnaNtlWriter
implements Object3DWriter {
    public static final String NANOTILER_STRING = "nanotiler";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String NTL_EXTENSION = ".ntl";
    public static final String PDB_EXTENSION = ".pdb";
    public static String SLASH = File.separator;
    private Logger log = Logger.getLogger("NanoTiler_debug");

    public void write(String writeDir, String fileName, StrandJunction3D junction) {
        assert (writeDir != null);
        assert (fileName != null);
        assert (junction != null);
        this.log.info("Writing ntl file for: " + fileName + " to directory: " + writeDir);
        fileName = fileName.substring(fileName.lastIndexOf(SLASH) + 1);
        writeDir = writeDir + SLASH + fileName.substring(0, fileName.indexOf(PDB_EXTENSION)) + SLASH;
        new File(writeDir).mkdir();
        if (fileName.endsWith(PDB_EXTENSION)) {
            fileName = fileName.substring(0, fileName.lastIndexOf(PDB_EXTENSION));
        }
        if (!fileName.endsWith(NTL_EXTENSION)) {
            fileName = fileName + NTL_EXTENSION;
        }
        fileName = writeDir + fileName;
        try {
            this.log.info("Writing file: " + fileName);
            FileWriter fw = new FileWriter(fileName);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(NANOTILER_STRING + NEWLINE);
            bw.write(junction.toString());
            bw.close();
            this.log.info("Finished writing file: " + fileName);
        }
        catch (IOException e) {
            this.log.severe("Could not write file: " + fileName);
        }
    }

    @Override
    public int getFormatId() {
        assert (false);
        return 0;
    }

    public void reset() {
    }

    @Override
    public void write(OutputStream os, LinkSet links) {
        assert (false);
    }

    @Override
    public void write(OutputStream os, Object3D obj) {
        assert (false);
    }

    @Override
    public String writeString(Object3D obj) {
        assert (false);
        return new String();
    }
}

