/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ApplicationBugException;
import generaltools.SimpleConstraintDouble;
import rnadesign.rnamodel.BasePairStackingForceField2;
import rnadesign.rnamodel.ConstraintForceField;
import rnadesign.rnamodel.GaussianFunctor;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.SquareFunctor;
import tools3d.objects3d.modeling.ForceField;
import tools3d.objects3d.modeling.ForceFieldFactory;
import tools3d.objects3d.modeling.ForceFieldPairElement;
import tools3d.objects3d.modeling.SimpleCompositeForceField;
import tools3d.objects3d.modeling.SimpleDistanceForceFieldPairElement;
import tools3d.objects3d.modeling.SimpleFlexibleForceField;

public class RnaForceFieldFactory
implements ForceFieldFactory {
    private double nucPairForceFieldWeight = 1.0;
    private double nucLinkForceFieldWeight = 1.0;
    public static final int DEFAULT_FORCEFIELD = 0;
    public static final int FANCY_FORCEFIELD = 1;
    public static final String[] FORCEFIELD_NAMES = new String[]{"default", "fancy"};
    private int forceFieldId = 0;

    @Override
    public int getForceFieldId() {
        return this.forceFieldId;
    }

    private ForceFieldPairElement generateDefaultNucleotideForceFieldPairElement() {
        double sigma = 6.0;
        GaussianFunctor gaussFunctor = new GaussianFunctor(sigma, 0.0, 1000.0);
        Nucleotide3D nucleotide = new Nucleotide3D();
        SimpleDistanceForceFieldPairElement ffPairElement = new SimpleDistanceForceFieldPairElement(nucleotide, gaussFunctor, -1, -1);
        return ffPairElement;
    }

    private ForceField generateDefaultNucleotideLinkForceField() {
        double cd = 3.5;
        double cdt = 0.5;
        double ca = 0.6283185307179586;
        double cat = 0.08726646259971647;
        double cb = 0.0;
        double cbt = 0.08726646259971647;
        SimpleConstraintDouble constraint = new SimpleConstraintDouble(cd - cdt, cd + cdt, 1.0);
        SquareFunctor functor = new SquareFunctor(0.0, 1.0, 0.0);
        SimpleConstraintDouble angleConstraint = new SimpleConstraintDouble(ca - cat, ca + cat, 1.0);
        SquareFunctor angleFunctor = new SquareFunctor(0.0, 1.0, 0.0);
        SimpleConstraintDouble bendConstraint = new SimpleConstraintDouble(cb - cbt, cb + cbt, 1.0);
        SquareFunctor bendFunctor = new SquareFunctor(0.0, 1.0, 0.0);
        BasePairStackingForceField2 ff = new BasePairStackingForceField2(constraint, functor, angleConstraint, angleFunctor, bendConstraint, bendFunctor);
        return ff;
    }

    private ForceField generateDefaultForceField() {
        SimpleCompositeForceField forceField = new SimpleCompositeForceField();
        forceField.addForceField(new ConstraintForceField(1.0), 1.0);
        SimpleFlexibleForceField flexField = new SimpleFlexibleForceField();
        ForceFieldPairElement nucPairForceField = this.generateDefaultNucleotideForceFieldPairElement();
        flexField.addForceFieldPairElement(nucPairForceField);
        forceField.addForceField(flexField, this.nucPairForceFieldWeight);
        ForceField nucLinkForceField = this.generateDefaultNucleotideLinkForceField();
        forceField.addForceField(nucLinkForceField, this.nucLinkForceFieldWeight);
        return forceField;
    }

    private ForceField generateFancyForceField() {
        ConstraintForceField forceField = new ConstraintForceField(1.0);
        return forceField;
    }

    @Override
    public ForceField generateForceField() {
        ForceField ff = null;
        switch (this.forceFieldId) {
            case 0: {
                ff = this.generateDefaultForceField();
                break;
            }
            case 1: {
                ff = this.generateFancyForceField();
                break;
            }
            default: {
                throw new ApplicationBugException("Internal error in line 20!");
            }
        }
        return ff;
    }

    @Override
    public String[] getForceFieldNames() {
        return FORCEFIELD_NAMES;
    }

    @Override
    public void setForceFieldId(int n) {
        this.forceFieldId = n;
    }
}

