/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ResourceBundle;
import tools3d.Matrix3D;
import tools3d.Matrix4D;
import tools3d.Vector3D;

public class RnaConstants {
    private static final ResourceBundle rb = ResourceBundle.getBundle("RnaConstants");
    public static final double ATOM_COLLISION_DISTANCE = Double.parseDouble(rb.getString("ATOM_COLLISION_DISTANCE"));
    public static final double HELIX_PHASE_OFFSET = Double.parseDouble(rb.getString("HELIX_PHASE_OFFSET")) * (Math.PI / 180);
    public static final double RESIDUE_DIST = Double.parseDouble(rb.getString("RESIDUE_DIST"));
    public static final double WATSON_CRICK_DIST = Double.parseDouble(rb.getString("WATSON_CRICK_DIST"));
    public static final double HELIX_BASE_PAIRS_PER_TURN = Double.parseDouble(rb.getString("HELIX_BASE_PAIRS_PER_TURN"));
    public static final double HELIX_RADIUS = Double.parseDouble(rb.getString("HELIX_RADIUS"));
    public static final double HELIX_BP_P_O3_DIST = Double.parseDouble(rb.getString("HELIX_BP_P_O3_DIST"));
    public static final Vector3D C4_NORM_POS = new Vector3D(HELIX_RADIUS, 0.0, 0.0);
    public static final double HELIX_RISE = Double.parseDouble(rb.getString("HELIX_RISE"));
    public static final double TURN_HEIGHT = HELIX_RISE * HELIX_BASE_PAIRS_PER_TURN;
    public static final double JUNCTION_OFFSET = HELIX_RADIUS;
    public static final double HELIX_OFFSET = Double.parseDouble(rb.getString("HELIX_OFFSET"));
    public static final Matrix4D HELIX_MATRIX4D = RnaConstants.getHelixPropagationMatrix();

    public static Matrix4D getHelixPropagationMatrix() {
        double anglePerBp;
        Vector3D translation = new Vector3D(0.0, 0.0, HELIX_RISE);
        double phi = anglePerBp = Math.PI / 180 * (360.0 / HELIX_BASE_PAIRS_PER_TURN);
        Matrix3D rotMatrix = new Matrix3D(Math.cos(phi), Math.sin(phi), 0.0, -Math.sin(phi), Math.cos(phi), 0.0, 0.0, 0.0, 1.0);
        return new Matrix4D(rotMatrix, translation);
    }
}

