/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ScoreWrapper;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.AI3DTools;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;

public class RingFuser
implements Runnable {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private static final double STRAND_ANGLE_MAX = 1.5707963267948966;
    private static final double ANGLE_PENALTY = 50.0;
    private static final double STRAND_CONNECTION_SCORE_CUTOFF = 20.0;
    private static final String TMP_TOKEN = "__RINGFUSE_STATUS";
    private static final String TMP_TOKEN_OCCUPIED = "occupied";
    private static final String TMP_TOKEN_JUNCTIONCLASS = "__RINGFUSE_JUNCTION_CLASS";
    private double distanceCutoff = 10.0;
    private List<List<StrandJunction3D>> junctionClasses;
    private static boolean debugMode = true;
    private List<StrandJunction3D> junctions = new ArrayList<StrandJunction3D>();
    private List<RnaStrand> strands = new ArrayList<RnaStrand>();
    private List<RnaStrand> fusedStrands;

    public RingFuser(List<StrandJunction3D> junctions, List<RnaStrand> strands) {
        this.junctions.addAll(junctions);
        this.strands.addAll(strands);
        this.junctionClasses = AI3DTools.classifyJunctions(junctions);
        this.strands = this.cleanStrands(this.strands);
        this.log.info("Initial strands: " + strands.size() + " cleaned version: " + this.strands.size());
    }

    public RingFuser(Object3DSet junctionSet, Object3DSet strandSet) {
        Object3D obj;
        int i;
        for (i = 0; i < junctionSet.size(); ++i) {
            obj = junctionSet.get(i);
            if (obj instanceof StrandJunction3D) {
                this.junctions.add((StrandJunction3D)obj);
                continue;
            }
            assert (false);
        }
        for (i = 0; i < strandSet.size(); ++i) {
            obj = strandSet.get(i);
            if (obj instanceof RnaStrand) {
                this.strands.add((RnaStrand)obj);
                continue;
            }
            this.log.severe("Internal error in RingFuse: 3D object is not RNA strand: " + obj.getFullName() + " " + obj.getClassName());
            assert (false);
        }
        this.junctionClasses = AI3DTools.classifyJunctions(this.junctions);
        this.strands = this.cleanStrands(this.strands);
        this.log.info("Initial strands: " + strandSet.size() + " cleaned version: " + this.strands.size());
    }

    private boolean isDuplicateStrand(RnaStrand strand, List<RnaStrand> strands) {
        for (RnaStrand strand2 : strands) {
            if (strand2 == strand || !AI3DTools.checkStrandDuplicate(strand, strand2, 2.0, "C4*")) continue;
            this.log.info("Strand duplicate found: " + strand.getFullName() + " " + strand.sequenceString() + strand2.getFullName() + " " + strand2.sequenceString());
            return true;
        }
        return false;
    }

    private List<RnaStrand> cleanStrands(List<RnaStrand> strands) {
        ArrayList<RnaStrand> result = new ArrayList<RnaStrand>();
        for (RnaStrand strand : strands) {
            if (this.findJunctionClass(strand) < 0 && this.isDuplicateStrand(strand, strands)) continue;
            result.add(strand);
        }
        return result;
    }

    static int[] computeJunctionOrder(List<List<StrandJunction3D>> junctionClasses) {
        int[] result = new int[junctionClasses.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    private void printJunctionClasses(PrintStream ps) {
        for (int i = 0; i < this.junctionClasses.size(); ++i) {
            ps.print("Class " + (i + 1) + " ");
            for (int j = 0; j < this.junctionClasses.get(i).size(); ++j) {
                ps.print(this.junctionClasses.get(i).get(j).getFullName() + " ");
            }
            ps.println();
        }
    }

    @Override
    public void run() {
        this.log.info("Starting automatic ring fusing!");
        this.fusedStrands = new ArrayList<RnaStrand>();
        if (debugMode) {
            this.log.info("Junction classes: ");
            this.printJunctionClasses(System.out);
        }
        int[] junctionOrder = RingFuser.computeJunctionOrder(this.junctionClasses);
        int[] strandUsed = new int[this.strands.size()];
        for (int jClass : junctionOrder) {
            for (int i = 0; i < this.junctionClasses.get(jClass).size(); ++i) {
                StrandJunction3D junction = this.junctionClasses.get(jClass).get(i);
                for (int j = 0; j < junction.getStrandCount(); ++j) {
                    NucleotideStrand strand = junction.getStrand(j);
                    if (!this.checkStrandAvailable(strand)) continue;
                    int strandId = this.strands.indexOf(strand);
                    assert (strandId >= 0);
                    List<Integer> fusionIds = this.generateFusionStrandIds(this.strands, strandId);
                    this.fusedStrands.add(this.applyStrandFusion(fusionIds));
                }
            }
        }
        this.log.info("Finished automatic ring fusing!");
    }

    private RnaStrand applyStrandFusion(List<Integer> strandIds) {
        assert (strandIds != null && strandIds.size() > 0);
        RnaStrand newStrand = (RnaStrand)this.strands.get(strandIds.get(0)).cloneDeep();
        this.log.info("Starting sequence path with " + newStrand.getFullName() + " strand id: " + (strandIds.get(0) + 1) + " junction class: " + (this.findJunctionClass(this.strands.get(strandIds.get(0))) + 1));
        this.setStrandOccupied(this.strands.get(strandIds.get(0)));
        assert (!this.checkStrandAvailable(this.strands.get(strandIds.get(0))));
        int count = this.strands.get(strandIds.get(0)).getResidueCount();
        for (int i = 1; i < strandIds.size(); ++i) {
            RnaStrand tmpStrand = this.strands.get(strandIds.get(i));
            RnaStrand newStrand2 = (RnaStrand)tmpStrand.cloneDeep();
            this.setStrandOccupied(tmpStrand);
            assert (!this.checkStrandAvailable(tmpStrand));
            count += this.strands.get(strandIds.get(i)).getResidueCount();
            this.log.info("Fusing strand " + newStrand.getFullName() + " " + newStrand.sequenceString() + " with " + newStrand2.getFullName() + " " + newStrand2.sequenceString() + " strand id: " + (strandIds.get(i) + 1) + " junction class: " + (this.findJunctionClass(tmpStrand) + 1));
            newStrand.append(newStrand2);
        }
        assert (newStrand.getResidueCount() == count);
        return newStrand;
    }

    private boolean checkStrandAvailable(NucleotideStrand strand) {
        return strand.getProperty(TMP_TOKEN) != TMP_TOKEN_OCCUPIED;
    }

    private void setStrandOccupied(NucleotideStrand strand) {
        strand.setProperty(TMP_TOKEN, TMP_TOKEN_OCCUPIED);
    }

    private int findJunctionClass(StrandJunction3D junction) {
        for (int i = 0; i < this.junctionClasses.size(); ++i) {
            if (!this.junctionClasses.get(i).contains(junction)) continue;
            return i;
        }
        return -1;
    }

    private StrandJunction3D findJunction(RnaStrand strand) {
        return (StrandJunction3D)Object3DTools.findAncestor(strand, this.junctions);
    }

    private int findJunctionClass(RnaStrand strand) {
        StrandJunction3D junction = this.findJunction(strand);
        if (junction == null) {
            this.log.fine("Strand " + strand.getFullName() + " does not belong to a junction.");
            return -1;
        }
        int result = this.findJunctionClass(junction);
        assert (result >= 0);
        return result;
    }

    private double scoreStrandConnectivity(RnaStrand startStrand, RnaStrand endStrand) throws RnaModelException {
        Vector3D v2;
        Nucleotide3D startStrandResidue = (Nucleotide3D)startStrand.getResidue3D(startStrand.getResidueCount() - 1);
        Nucleotide3D endStrandResidue = (Nucleotide3D)endStrand.getResidue3D(0);
        Object3D ao21 = startStrandResidue.getChild("O2*");
        Object3D ap2 = endStrandResidue.getChild("P");
        if (ap2 == null) {
            NucleotideDBTools.addMissingPhosphor(endStrandResidue);
            ap2 = endStrandResidue.getChild("P");
            assert (ap2 != null);
        }
        if (ao21 == null) {
            throw new RnaModelException("Could not find atom O2* in residue: " + startStrandResidue.getFullName());
        }
        double distance = ao21.distance(ap2);
        Vector3D v1 = NucleotideDBTools.getBackwardDirectionVector(startStrandResidue, "C4*");
        double angle = Math.PI - v1.angle(v2 = NucleotideDBTools.getForwardDirectionVector(endStrandResidue, "C4*"));
        if (angle > 1.5707963267948966) {
            distance += 50.0;
        }
        return distance;
    }

    List<Integer> findJunctionClassIds(List<RnaStrand> strands, List<Integer> sofarStrandIds) {
        ArrayList<Integer> junctionIds = new ArrayList<Integer>();
        for (Integer i : sofarStrandIds) {
            int junctionId = this.findJunctionClass(strands.get(i));
            junctionIds.add(junctionId);
        }
        return junctionIds;
    }

    int findNextStrandId(List<RnaStrand> strands, List<Integer> sofarStrandIds) {
        assert (sofarStrandIds.size() > 0);
        int id = sofarStrandIds.get(sofarStrandIds.size() - 1);
        StrandJunction3D junction = this.findJunction(strands.get(id));
        List<Integer> junctionClassIds = this.findJunctionClassIds(strands, sofarStrandIds);
        ArrayList<ScoreWrapper> rankedList = new ArrayList<ScoreWrapper>();
        for (int i = 0; i < strands.size(); ++i) {
            if (i == id || sofarStrandIds.contains(i) || !this.checkStrandAvailable(strands.get(i))) continue;
            StrandJunction3D junction2 = this.findJunction(strands.get(i));
            int junctionClass2 = -1;
            if (junction2 != null) {
                junctionClass2 = this.findJunctionClass(junction2);
                assert (junctionClass2 >= 0);
                if (junctionClassIds.contains(junctionClass2)) continue;
                this.log.fine("Junction class of " + strands.get(i).getFullName() + " " + junctionClass2 + " is not being used so far in strands: " + sofarStrandIds + " and classes: " + junctionClassIds);
            }
            try {
                double score = this.scoreStrandConnectivity(strands.get(id), strands.get(i));
                if (!(score < 20.0)) continue;
                ScoreWrapper wrap = new ScoreWrapper(new Integer(i), score);
                rankedList.add(wrap);
                continue;
            }
            catch (RnaModelException e) {
                this.log.warning("Bad nucleotide for strand fusing encountered: " + e.getMessage());
            }
        }
        if (rankedList.size() == 0) {
            return -1;
        }
        Collections.sort(rankedList);
        Integer strandIndexInt = (Integer)((ScoreWrapper)rankedList.get(0)).getObject();
        int result = strandIndexInt;
        assert (this.checkStrandAvailable(strands.get(result)));
        assert (this.findJunctionClass(strands.get(result)) < 0 || !junctionClassIds.contains(this.findJunctionClass(strands.get(result))));
        assert (((ScoreWrapper)rankedList.get(0)).getScore() <= 20.0);
        return result;
    }

    private List<Integer> generateFusionStrandIds(List<RnaStrand> strands, int currentId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int startJunctionClass = this.findJunctionClass(strands.get(currentId));
        result.add(currentId);
        while ((currentId = this.findNextStrandId(strands, result)) >= 0) {
            result.add(currentId);
        }
        return result;
    }

    public List<RnaStrand> getFusedStrands() {
        if (this.fusedStrands == null) {
            this.run();
        }
        return this.fusedStrands;
    }
}

