/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import rnadesign.rnamodel.AminoAcid3D;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.SimpleProteinStrand;
import sequence.ProteinTools;
import sequence.SimpleLetterSymbol;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class ProteinPdbReader
implements Object3DFactory {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final int PRECISION = 3;
    public static final int NO_TRANSLATION = 0;
    public static final int AMBER_TO_STANDARD = 1;
    private int translationMode = 0;
    char badChar = (char)88;

    @Override
    public Object3DLinkSetBundle readBundle(InputStream is) throws Object3DIOException {
        Object3D obj = this.readAnyObject3D(is);
        SimpleLinkSet links = new SimpleLinkSet();
        for (int i = 1; i < obj.size(); ++i) {
            links.add(new SimpleLink(obj.getChild(i - 1), obj.getChild(i)));
        }
        return new SimpleObject3DLinkSetBundle(obj, links);
    }

    private String getKeyword(String line) {
        if (line != null && line.length() > 7) {
            return line.substring(0, 7).trim();
        }
        return null;
    }

    private boolean isAtom(String line) {
        if (line.length() < 50) {
            return false;
        }
        String keyword = this.getKeyword(line);
        return keyword.equals("ATOM");
    }

    private char getStrandName(String line) {
        return line.charAt(21);
    }

    private String getResidueName(String line) {
        String result = line.substring(17, 20).trim();
        switch (this.translationMode) {
            case 0: {
                break;
            }
            case 1: {
                result = this.translateAmberToStandardResidueName(result);
            }
        }
        return result;
    }

    private String translateAmberToStandardAtomName(String s) {
        return s.replace('\'', '*');
    }

    private String translateAmberToStandardResidueName(String s) {
        if (s.length() > 1 && s.charAt(0) == 'R') {
            return s.substring(1, 2);
        }
        return s;
    }

    private String getAtomName(String line) {
        String result = line.substring(12, 16).trim();
        switch (this.translationMode) {
            case 0: {
                break;
            }
            case 1: {
                result = this.translateAmberToStandardAtomName(result);
            }
        }
        return result;
    }

    private int getResidueId(String line) {
        String word = line.substring(22, 26).trim();
        return Integer.parseInt(word);
    }

    private int getAtomCounter(String line) {
        return Integer.parseInt(line.substring(7, 11).trim());
    }

    private double getX(String line) {
        return Double.parseDouble(line.substring(30, 38).trim());
    }

    private double getY(String line) {
        return Double.parseDouble(line.substring(38, 46).trim());
    }

    private double getZ(String line) {
        int startPos = 46;
        return Double.parseDouble(line.substring(startPos, startPos + 5 + 3).trim());
    }

    private Atom3D generateAtomFromPdb(String line) {
        Vector3D pos = new Vector3D(this.getX(line), this.getY(line), this.getZ(line));
        String name = this.getAtomName(line);
        Atom3D atom = new Atom3D();
        atom.setPosition(pos);
        atom.setName(name);
        return atom;
    }

    private char getResidueCharacter(String residueName) {
        if (residueName.equals("ALA")) {
            return 'A';
        }
        if (residueName.equals("CYS")) {
            return 'C';
        }
        if (residueName.equals("ASP")) {
            return 'D';
        }
        if (residueName.equals("GLU")) {
            return 'E';
        }
        if (residueName.equals("CYS")) {
            return 'F';
        }
        if (residueName.equals("GLY")) {
            return 'G';
        }
        if (residueName.equals("HIS")) {
            return 'H';
        }
        if (residueName.equals("ILE")) {
            return 'I';
        }
        if (residueName.equals("LYS")) {
            return 'K';
        }
        if (residueName.equals("LEU")) {
            return 'L';
        }
        if (residueName.equals("MET")) {
            return 'M';
        }
        if (residueName.equals("ASN")) {
            return 'N';
        }
        if (residueName.equals("PRO")) {
            return 'P';
        }
        if (residueName.equals("GLN")) {
            return 'Q';
        }
        if (residueName.equals("ARG")) {
            return 'R';
        }
        if (residueName.equals("SER")) {
            return 'S';
        }
        if (residueName.equals("THR")) {
            return 'T';
        }
        if (residueName.equals("VAL")) {
            return 'V';
        }
        if (residueName.equals("TRP")) {
            return 'W';
        }
        if (residueName.equals("TYR")) {
            return 'Y';
        }
        return this.badChar;
    }

    public int getTranslationMode() {
        return this.translationMode;
    }

    @Override
    public Object3D readAnyObject3D(InputStream is) throws Object3DIOException {
        DataInputStream dis = new DataInputStream(is);
        SimpleObject3D root = new SimpleObject3D();
        root.setName("PdbImport");
        char currentStrandName = '_';
        int currentResidueId = -9999;
        int currentAtomId = -9999;
        SimpleProteinStrand currentStrand = null;
        SimpleObject3D currentResidue = null;
        try {
            String line;
            while ((line = dis.readLine()) != null) {
                if (this.isAtom(line)) {
                    int residueId = this.getResidueId(line);
                    String residueName = this.getResidueName(line);
                    String atomName = this.getAtomName(line);
                    char strandName = this.getStrandName(line);
                    Atom3D atom = this.generateAtomFromPdb(line);
                    if (currentStrand == null || strandName != currentStrandName) {
                        currentStrand = new SimpleProteinStrand(ProteinTools.PROTEIN_ALPHABET);
                        currentStrand.setName("" + strandName);
                        currentStrandName = strandName;
                        currentStrand.setPosition(atom.getPosition());
                        root.insertChild(currentStrand);
                    }
                    if (currentResidue == null || currentResidueId != residueId) {
                        try {
                            char c = this.getResidueCharacter(residueName);
                            SimpleLetterSymbol symbol = new SimpleLetterSymbol(c, ProteinTools.PROTEIN_ALPHABET);
                            currentResidue = new AminoAcid3D(symbol, currentStrand.getResidueCount(), atom.getPosition());
                            String resName = residueName + residueId;
                            currentResidue.setName(resName);
                            currentStrand.insertChild(currentResidue);
                            currentResidueId = residueId;
                        }
                        catch (UnknownSymbolException e) {
                            log.warning("Warning: could not interpret amino acid symbol from line: " + line);
                        }
                    }
                    currentResidue.insertChild(atom);
                }
                if (line != null) continue;
                break;
            }
        }
        catch (IOException exp) {
            // empty catch block
        }
        return root;
    }

    public static Vector3D readVector3D(DataInputStream dis) throws Object3DIOException {
        String word = ProteinPdbReader.readWord(dis);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Vector3D " + word);
        }
        word = ProteinPdbReader.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Vector3D " + word);
        }
        word = ProteinPdbReader.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Vector3D " + word);
        }
        return new Vector3D(x, y, z);
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
        }
        return s;
    }

    public void setTranslationMode(int mode) {
        this.translationMode = mode;
    }
}

