/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import java.util.Properties;
import java.util.Random;
import rnadesign.rnamodel.AbstractBranchDescriptorOptimizer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.RnaStem3D;
import tools3d.AxisAngle;
import tools3d.CoordinateSystem;
import tools3d.GaussianOrientableMutator;
import tools3d.Matrix3D;
import tools3d.OrientableModifier;

public class MorphBranchDescriptorOptimizer
extends AbstractBranchDescriptorOptimizer {
    private static Random rnd = Randomizer.getInstance();
    private double annealFactor = 0.95;
    public static final double TRANSLATION_STEP_DEFAULT = 0.1;
    public static final double ANGLE_STEP_DEFAULT = Math.PI / 360;
    public static final String CLASS_NAME = "MorphCarloBranchDescriptorOptimizer";
    private double translationStepLimit = 0.001;
    private double angleStepLimit = 0.001;
    private double angleWeight = 1.0;
    private double shiftWeight = 1.0;
    private FitParameters prm;
    private OrientableModifier mutator = new GaussianOrientableMutator(0.1, Math.PI / 360);

    public MorphBranchDescriptorOptimizer(FitParameters prm) {
        this.prm = prm;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private void mutateHelixParameters(HelixParameters prm) {
        CoordinateSystem def = prm.getDeformation();
        assert (def != null);
        this.mutator.rotate(def);
        this.mutator.translate(def);
    }

    public double scoreHelixDeformation(HelixParameters hpar) {
        CoordinateSystem defCoord = hpar.getDeformation();
        AxisAngle axisAngle = new AxisAngle(new Matrix3D(defCoord.generateMatrix4D()));
        double angle = axisAngle.getAngle();
        double shift = defCoord.getPosition().length();
        double cosang = 0.5 * (1.0 - Math.cos(angle));
        double result = this.angleWeight * cosang + this.shiftWeight * shift;
        return result;
    }

    @Override
    public BranchDescriptor3D optimize(RnaStem3D stem, BranchDescriptor3D branch1, BranchDescriptor3D branch2) {
        log.info("Starting optimizeBranchDescriptor!");
        assert (branch1.isValid());
        assert (branch2.isValid());
        boolean bestAngle = false;
        double deformScore = 999.9;
        double rmsLimit = this.prm.getRmsLimit();
        log.info("Starting optimizeStretchedBranchDescriptor with rms limit: " + rmsLimit);
        double bestError = rmsLimit + 1.0E-4;
        FitParameters prmInit = new FitParameters(100.0, Math.PI);
        BranchDescriptor3D b = MorphBranchDescriptorOptimizer.propagateBranchDescriptor(stem, branch1);
        HelixParameters hprm = b.getHelixParameters();
        HelixParameters hBest = new HelixParameters(b.getHelixParameters());
        if (hprm.getDeformation() == null) {
            hprm.initDeformation();
        }
        assert (b != null);
        for (int iter = 0; iter < this.prm.getIterMax(); ++iter) {
            HelixParameters hSafe = new HelixParameters(b.getHelixParameters());
            this.mutateHelixParameters(b.getHelixParameters());
            double errorVal = MorphBranchDescriptorOptimizer.computeBranchDescriptorError(stem.getLength(), branch1, branch2, b);
            if (errorVal < bestError) {
                log.fine("Iteration: " + iter + " : New solution in MC optimization of stem: " + errorVal + " with mutator: " + this.mutator);
                bestError = errorVal;
                hBest = new HelixParameters(b.getHelixParameters());
                this.mutator.scaleTranslationStep(this.annealFactor);
                this.mutator.scaleAngleStep(this.annealFactor);
                if (!(this.mutator.getTranslationStep() < this.translationStepLimit) || !(this.mutator.getAngleStep() < this.angleStepLimit)) continue;
                break;
            }
            b.setHelixParameters(hSafe);
        }
        if (bestError > rmsLimit) {
            log.info("Could not find stem solution: " + bestError);
            return null;
        }
        deformScore = this.scoreHelixDeformation(hBest);
        log.info("Could find stem solution: " + bestError + " deformation score: " + deformScore);
        log.info("Best found helix parameters: " + b.getHelixParameters());
        Properties prop = b.getProperties();
        if (prop == null) {
            prop = new Properties();
            b.setProperties(prop);
        }
        prop.setProperty("fit_score", "" + bestError);
        prop.setProperty("deform_score", "" + deformScore);
        assert (b.getProperties() != null);
        log.info("Finished optimizeBranchDescriptor!");
        return b;
    }
}

