/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class KnotPlotReader
implements Object3DFactory {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private int formatMode = 1;

    @Override
    public Object3DLinkSetBundle readBundle(InputStream is) throws Object3DIOException {
        Object3D obj = this.readAnyObject3D(is);
        SimpleLinkSet links = new SimpleLinkSet();
        for (int i = 1; i < obj.size(); ++i) {
            links.add(new SimpleLink(obj.getChild(i - 1), obj.getChild(i)));
        }
        if (obj.size() > 2) {
            links.add(new SimpleLink(obj.getChild(0), obj.getChild(obj.size() - 1)));
        }
        return new SimpleObject3DLinkSetBundle(obj, links);
    }

    @Override
    public Object3D readAnyObject3D(InputStream is) throws Object3DIOException {
        log.fine("Starting readAnyObject3D!");
        DataInputStream dis = new DataInputStream(is);
        SimpleObject3D root = new SimpleObject3D();
        root.setName("KnotPlotImport");
        for (int i = 0; i < 1000000; ++i) {
            try {
                Vector3D pos = KnotPlotReader.readVector3D(dis);
                SimpleObject3D child = new SimpleObject3D();
                child.setPosition(pos);
                child.setName("p" + i);
                root.insertChild(child);
                continue;
            }
            catch (Object3DIOException e) {
                break;
            }
        }
        return root;
    }

    public static Vector3D readVector3D(DataInputStream dis) throws Object3DIOException {
        log.fine("starting readVector!");
        String word = KnotPlotReader.readWord(dis);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Vector3D " + word);
        }
        word = KnotPlotReader.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Vector3D " + word);
        }
        word = KnotPlotReader.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Vector3D " + word);
        }
        log.fine("ending readVector!");
        return new Vector3D(x, y, z);
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            log.fine("found word: " + s);
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        log.fine("found word: " + s);
        return s;
    }
}

