/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import generaltools.StringTools;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.KissingLoopPotential;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import tools3d.Matrix3D;
import tools3d.MinSuperpose;
import tools3d.SuperpositionResult;
import tools3d.Vector3D;
import tools3d.objects3d.BrownianMotionOptimizer;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class KissingLoopTools {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static Random rnd = Randomizer.getInstance();

    private static int computeBestStemLength(BranchDescriptor3D branch1, BranchDescriptor3D branch2) {
        return ConnectJunctionTools.computeBestStemLength(branch1, branch2);
    }

    private static double optimizeKissingLoopPosition(BranchDescriptor3D branch1, BranchDescriptor3D branch2, KissingLoop3D kissingLoop) {
        kissingLoop.setPosition(Vector3D.average(branch1.getPosition(), branch2.getPosition()));
        BrownianMotionOptimizer optimizer = new BrownianMotionOptimizer();
        optimizer.setIterMax(2000);
        optimizer.setTransStep(0.0);
        KissingLoopPotential potential = new KissingLoopPotential(branch1, branch2);
        double result = optimizer.optimize(kissingLoop, potential);
        return result;
    }

    private static Vector3D[] generate4DVectorsFromPair(Vector3D v1, Vector3D v2) {
        Vector3D dv = v2.minus(v1);
        assert (dv.length() > 0.0);
        Vector3D[] result = new Vector3D[4];
        result[2] = Vector3D.average(v1, v2);
        result[0] = v1.minus(result[2]);
        result[0].normalize();
        result[0].add(result[2]);
        result[1] = v2.minus(result[2]);
        result[1].normalize();
        result[1].add(result[2]);
        while (result[3] == null) {
            Vector3D rv = new Vector3D(rnd.nextDouble(), rnd.nextDouble(), rnd.nextDouble());
            result[3] = rv.cross(dv);
            if (result[3].lengthSquare() == 0.0) {
                result[3] = null;
                continue;
            }
            result[3].normalize();
            result[3].add(result[2]);
        }
        return result;
    }

    private static Vector3D[] generate3DVectorsFromPair(Vector3D v1, Vector3D v2) {
        Vector3D dv = v2.minus(v1);
        assert (dv.length() > 0.0);
        Vector3D[] result = new Vector3D[3];
        result[2] = Vector3D.average(v1, v2);
        result[0] = v1.minus(result[2]);
        result[0].normalize();
        result[0].add(result[2]);
        while (result[1] == null) {
            Vector3D rv = new Vector3D(rnd.nextDouble(), rnd.nextDouble(), rnd.nextDouble());
            result[1] = rv.cross(dv);
            if (result[1].lengthSquare() == 0.0) {
                result[1] = null;
                continue;
            }
            result[1].normalize();
            result[1].add(result[2]);
        }
        return result;
    }

    private static double optimizeKissingLoopPosition2(BranchDescriptor3D branch1, BranchDescriptor3D branch2, KissingLoop3D kissingLoop) {
        log.finest("Starting KissingLoopTools.optimizeKissingLoopPosition ! " + branch1.getPosition() + " " + branch2.getPosition() + " " + kissingLoop.getBranch(0).getPosition() + " " + kissingLoop.getBranch(1).getPosition());
        Vector3D[] given = KissingLoopTools.generate3DVectorsFromPair(branch1.getPosition(), branch2.getPosition());
        Vector3D[] fitting1 = KissingLoopTools.generate3DVectorsFromPair(kissingLoop.getBranch(0).getPosition(), kissingLoop.getBranch(1).getPosition());
        Vector3D[] fitting2 = KissingLoopTools.generate3DVectorsFromPair(kissingLoop.getBranch(1).getPosition(), kissingLoop.getBranch(0).getPosition());
        MinSuperpose superposer = new MinSuperpose();
        SuperpositionResult result1 = superposer.superpose(given, fitting1);
        SuperpositionResult result2 = superposer.superpose(given, fitting2);
        SuperpositionResult result = result1;
        if (result1.getRms() > result2.getRms()) {
            result = result2;
        }
        result.applyTransformation(kissingLoop);
        log.finest("Ending KissingLoopTools.optimizeKissingLoopPosition ! " + branch1.getPosition() + " " + branch2.getPosition() + " " + kissingLoop.getBranch(0).getPosition() + " " + kissingLoop.getBranch(1).getPosition());
        return result.getRms();
    }

    private static double optimizeKissingLoopPosition3(BranchDescriptor3D branch1, BranchDescriptor3D branch2, KissingLoop3D kissingLoop, double axialAngle) {
        Vector3D klCenter = Vector3D.average(kissingLoop.getBranch(0).getPosition(), kissingLoop.getBranch(1).getPosition());
        kissingLoop.setIsolatedPosition(klCenter);
        kissingLoop.setPosition(Vector3D.average(branch1.getPosition(), branch2.getPosition()));
        Vector3D dv = branch2.getPosition().minus(branch1.getPosition());
        Vector3D dvk = kissingLoop.getBranch(1).getPosition().minus(kissingLoop.getBranch(0).getPosition());
        double angle = dv.angle(dvk);
        if (angle == 0.0) {
            return 0.0;
        }
        Vector3D cv = dv.cross(dvk);
        if (cv.lengthSquare() == 0.0) {
            return 0.0;
        }
        cv.normalize();
        Matrix3D rotationMatrix = Matrix3D.rotationMatrix(cv, -angle);
        Matrix3D rotationMatrix2 = Matrix3D.rotationMatrix(dv, axialAngle);
        kissingLoop.rotate(cv, -angle);
        kissingLoop.rotate(dv, axialAngle);
        return 0.0;
    }

    public static Object3DLinkSetBundle generateConnectingStem(BranchDescriptor3D branch1, BranchDescriptor3D branch2, char c1, char c2, String baseName, FitParameters fitParameters, Object3D nucleotideDB, StrandJunctionDB kissingLoopDB, int connectionAlgorithm, int axialSteps) {
        RnaStrand strand;
        assert (branch1 != branch2);
        assert (branch1.isValid());
        assert (branch2.isValid());
        assert (axialSteps > 0);
        log.fine("Starting KissingLoopTools.generateConnectingStem: " + branch1.getName() + " ; " + branch2.getName() + " ; " + baseName);
        if (kissingLoopDB == null || kissingLoopDB.size() == 0) {
            return null;
        }
        double angleError = Math.PI - branch1.getDirection().angle(branch2.getDirection());
        assert (angleError >= 0.0);
        if (angleError > fitParameters.getAngleLimit()) {
            return null;
        }
        Vector3D avgPos = Vector3D.average(branch1.getPosition(), branch2.getPosition());
        assert (branch1.isValid());
        assert (branch2.isValid());
        Vector3D savedDirection1 = branch1.getDirection();
        Vector3D stemDir = branch2.getBasePosition().minus(branch1.getBasePosition());
        assert (stemDir.lengthSquare() > 0.0);
        stemDir.normalize();
        assert (branch1.isValid());
        assert (branch2.isValid());
        Vector3D basePos = branch1.getBasePosition();
        int numPairs = KissingLoopTools.computeBestStemLength(branch1, branch2);
        String s1 = "";
        String s2 = "";
        assert (branch1.isValid());
        assert (branch2.isValid());
        s1 = StringTools.stringFromChar('G', numPairs);
        s2 = StringTools.stringFromChar('C', numPairs);
        String strand1Name = baseName + "_" + "forw";
        String strand2Name = baseName + "_" + "back";
        String stemName = baseName + "_stem";
        SimpleObject3D resultTree = new SimpleObject3D();
        String setName = baseName + "_root";
        resultTree.setName(setName);
        resultTree.setPosition(avgPos);
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        StrandJunction3D[] kissingLoops = kissingLoopDB.getJunctions(2);
        if (kissingLoops == null || kissingLoops.length == 0) {
            return null;
        }
        double bestFitScore = 1.0E30;
        boolean stem1Found = false;
        boolean stem2Found = false;
        boolean reverseMode = false;
        boolean reverseMode2 = false;
        Object3DLinkSetBundle bestStem1Bundle = null;
        Object3DLinkSetBundle bestStem2Bundle = null;
        KissingLoop3D kissingLoop = null;
        for (int i = 0; i < axialSteps; ++i) {
            Object3DLinkSetBundle stem1Bundle;
            double axialAngle = (double)i * (Math.PI * 2) / (double)axialSteps;
            log.fine("Working on kissing loop axial angle: " + 180.0 * axialAngle / Math.PI);
            kissingLoop = (KissingLoop3D)kissingLoops[0].cloneDeep();
            KissingLoopTools.optimizeKissingLoopPosition3(branch1, branch2, kissingLoop, axialAngle);
            if (i == 0) {
                reverseMode = !(branch1.distance(kissingLoop.getBranch(0)) < branch1.distance(kissingLoop.getBranch(1)));
                reverseMode2 = !(branch2.distance(kissingLoop.getBranch(1)) < branch2.distance(kissingLoop.getBranch(0)));
            }
            int[] seqIds = kissingLoop.getIncomingSeqIds();
            double totFitScore = 0.0;
            assert (!kissingLoop.getBranch(0).isProbablyEqual(kissingLoop.getBranch(1)));
            try {
                stem1Bundle = !reverseMode ? ConnectJunctionTools.generateConnectingStem(branch1, kissingLoop.getBranch(0), c1, c2, baseName + "_is1", fitParameters, nucleotideDB, connectionAlgorithm, -1) : ConnectJunctionTools.generateConnectingStem(branch1, kissingLoop.getBranch(1), c1, c2, baseName + "_is1", fitParameters, nucleotideDB, connectionAlgorithm, -1);
            }
            catch (RuntimeException e) {
                log.severe(NEWLINE + NEWLINE + "KissingLoopTools Exception: " + e.getMessage());
                stem1Bundle = null;
            }
            double totFitScoreTerm1 = 1.0E30;
            double totFitScoreTerm2 = 1.0E30;
            if (stem1Bundle != null) {
                Object3DSet stemSet = Object3DTools.collectByClassName(stem1Bundle.getObject3D(), "RnaStem3D");
                assert (stemSet.size() == 1);
                stem1Found = true;
                RnaStem3D stem = (RnaStem3D)stemSet.get(0);
                log.fine("Kissing loop stem 1 found: " + stem);
                Properties properties = stem.getProperties();
                assert (properties != null);
                String optScore = properties.getProperty("fit_score");
                assert (optScore != null);
                log.fine("fit_score 1: " + optScore);
                totFitScoreTerm1 = 0.5 * Double.parseDouble(optScore);
                Object3DTools.setRecursiveProperty(stem.getStrand1(), "sequence_status", "adhoc", "Nucleotide3D");
                Object3DTools.setRecursiveProperty(stem.getStrand2(), "sequence_status", "adhoc", "Nucleotide3D");
            } else {
                log.info("Stem1Bundle was null!");
            }
            Object3DLinkSetBundle stem2Bundle = !reverseMode2 ? ConnectJunctionTools.generateConnectingStem(branch2, kissingLoop.getBranch(1), c1, c2, baseName + "_is2", fitParameters, nucleotideDB, connectionAlgorithm, -1) : ConnectJunctionTools.generateConnectingStem(branch2, kissingLoop.getBranch(0), c1, c2, baseName + "_is2", fitParameters, nucleotideDB, connectionAlgorithm, -1);
            if (stem2Bundle != null) {
                Object3DSet stemSet = Object3DTools.collectByClassName(stem2Bundle.getObject3D(), "RnaStem3D");
                assert (stemSet.size() == 1);
                stem2Found = true;
                RnaStem3D stem = (RnaStem3D)stemSet.get(0);
                log.fine("Kissing loop stem 2 found: " + stem);
                Properties properties = stem.getProperties();
                assert (properties != null);
                String optScore = properties.getProperty("fit_score");
                assert (optScore != null);
                log.fine("fit_score 2: " + optScore);
                totFitScoreTerm2 = 0.5 * Double.parseDouble(optScore);
                Object3DTools.setRecursiveProperty(stem.getStrand1(), "sequence_status", "adhoc", "Nucleotide3D");
                Object3DTools.setRecursiveProperty(stem.getStrand2(), "sequence_status", "adhoc", "Nucleotide3D");
            } else {
                log.info("Stem2Bundle was null!");
            }
            totFitScore = totFitScoreTerm1 + totFitScoreTerm2;
            log.fine("Total fitting score of this axial angle: " + totFitScore);
            if (i != 0 && !(totFitScore < bestFitScore)) continue;
            log.info("Saving so far best stem / kissing loop solution!");
            bestFitScore = totFitScore;
            bestStem1Bundle = stem1Bundle;
            bestStem2Bundle = stem2Bundle;
        }
        if (!stem1Found) {
            log.warning("No solution for stem 1 connecting to kissing loop found!");
        }
        if (!stem2Found) {
            log.warning("No solution for stem 2 connecting to kissing loop found!");
        }
        log.info("Best fitting score found: " + bestFitScore);
        assert (kissingLoop != null);
        if (bestStem1Bundle != null) {
            Object3DSet stemSet = Object3DTools.collectByClassName(bestStem1Bundle.getObject3D(), "RnaStem3D");
            assert (stemSet.size() == 1);
            RnaStem3D stem = (RnaStem3D)stemSet.get(0);
            strand = (RnaStrand)branch1.getOutgoingStrand();
            strand.append(stem.getStrand1());
            if (!reverseMode) {
                strand.append(kissingLoop.getBranch(0).getIncomingStrand());
            } else {
                strand.append(kissingLoop.getBranch(1).getIncomingStrand());
            }
            strand.append(stem.getStrand2());
            resultLinks.merge(bestStem1Bundle.getLinks());
        } else {
            log.info("bestStem1Bundle was null!");
        }
        if (bestStem2Bundle != null) {
            Object3DSet stemSet = Object3DTools.collectByClassName(bestStem2Bundle.getObject3D(), "RnaStem3D");
            assert (stemSet.size() == 1);
            RnaStem3D stem = (RnaStem3D)stemSet.get(0);
            strand = (RnaStrand)branch2.getOutgoingStrand();
            strand.append(stem.getStrand1());
            if (!reverseMode2) {
                strand.append(kissingLoop.getBranch(1).getIncomingStrand());
            } else {
                strand.append(kissingLoop.getBranch(0).getIncomingStrand());
            }
            strand.append(stem.getStrand2());
            resultLinks.merge(bestStem2Bundle.getLinks());
        } else {
            log.info("bestStem2Bundle was null!");
        }
        return new SimpleObject3DLinkSetBundle(resultTree, resultLinks);
    }
}

