/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.PermutationGenerator;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionTools;
import tools3d.CoordinateSystem;
import tools3d.Matrix4D;
import tools3d.Matrix4DTools;
import tools3d.Vector3D;
import tools3d.numerics3d.Geom3DTools;
import tools3d.objects3d.CoordinateSystem3D;

public class JunctionHashGenerator {
    int offsetMax = 21;
    double epsilonRot = 0.5;
    double epsilonTrans = 2.0;

    public List<CoordinateSystem3D> generateNormalizedCoordinates(List<BranchDescriptor3D> branches) throws NoninvertibleTransformException {
        assert (branches.size() > 1);
        Vector3D center = StrandJunctionTools.computeJunctionCenter(branches);
        ArrayList<CoordinateSystem3D> csList = new ArrayList<CoordinateSystem3D>();
        for (int i = 0; i < branches.size(); ++i) {
            double d = Geom3DTools.computeDistanceLinePoint(center, branches.get(i).getPosition(), branches.get(i).getCoordinateSystem().getZ());
            int offsetBest2 = (int)Math.round(d / branches.get(i).getHelixParameters().getRise());
            csList.add((CoordinateSystem3D)branches.get(i).generatePropagatedCoordinateSystem(offsetBest2));
        }
        return csList;
    }

    public List<CoordinateSystem3D> generateNormalizedCoordinates(List<CoordinateSystem3D> branches, HelixParameters helixParameters) throws NoninvertibleTransformException {
        assert (branches.size() > 1);
        Vector3D p1 = new Vector3D(branches.get(0).getPosition());
        Vector3D center = StrandJunctionTools.computeCS3DJunctionCenter(branches);
        Vector3D p2 = new Vector3D(branches.get(0).getPosition());
        assert (p1.distance(p2) < 0.001);
        ArrayList<CoordinateSystem3D> csList = new ArrayList<CoordinateSystem3D>();
        for (int i = 0; i < branches.size(); ++i) {
            double d = Geom3DTools.computeDistanceLinePoint(center, branches.get(i).getPosition(), branches.get(i).getZ());
            int offsetBest2 = (int)Math.round(d / helixParameters.getRise());
            csList.add(SimpleBranchDescriptor3D.generatePropagatedCoordinateSystem(branches.get(i), helixParameters, offsetBest2));
        }
        p2 = new Vector3D(branches.get(0).getPosition());
        assert (p1.distance(p2) < 0.001);
        return csList;
    }

    public List<CoordinateSystem3D> generateNormalizedCoordinates(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransformations) throws NoninvertibleTransformException {
        assert (branches.size() > 1);
        assert (branches.size() == activeTransformations.size());
        Vector3D center = StrandJunctionTools.computeJunctionCenter(branches, activeTransformations);
        ArrayList<CoordinateSystem3D> csList = new ArrayList<CoordinateSystem3D>();
        for (int i = 0; i < branches.size(); ++i) {
            CoordinateSystem cs = activeTransformations.get(i);
            double d = Geom3DTools.computeDistanceLinePoint(center, cs.activeTransform(branches.get(i).getPosition()), cs.activeTransform(branches.get(i).getCoordinateSystem().getZ()));
            int offsetBest2 = (int)Math.round(d / branches.get(i).getHelixParameters().getRise());
            CoordinateSystem3D csNew = (CoordinateSystem3D)branches.get(i).generatePropagatedCoordinateSystem(offsetBest2);
            csNew.activeTransform(activeTransformations.get(i));
            csList.add(csNew);
        }
        return csList;
    }

    private double getMatrix4DSignatureSum(Matrix4D m) {
        double sum = m.getXY() + m.getXZ() + m.getYZ();
        return sum;
    }

    public List<Matrix4D> generateNormalizedTransformations(List<CoordinateSystem3D> csList) {
        ArrayList<Matrix4D> homogs = new ArrayList<Matrix4D>();
        for (int i = 0; i < csList.size(); ++i) {
            homogs.add(csList.get(i).generateMatrix4D());
        }
        assert (homogs.size() == csList.size());
        ArrayList<Matrix4D> result = new ArrayList<Matrix4D>();
        for (int i = 0; i < csList.size(); ++i) {
            for (int j = i + 1; j < csList.size(); ++j) {
                double s2;
                Matrix4D m1 = ((Matrix4D)homogs.get(i)).inverse().multiply((Matrix4D)homogs.get(j));
                Matrix4D m2 = ((Matrix4D)homogs.get(j)).inverse().multiply((Matrix4D)homogs.get(i));
                double s1 = this.getMatrix4DSignatureSum(m1);
                if (s1 < (s2 = this.getMatrix4DSignatureSum(m2))) {
                    result.add(m1);
                    continue;
                }
                result.add(m2);
            }
        }
        Collections.sort(result);
        return result;
    }

    public List<Matrix4D> generateCompleteNormalizedTransformations(StrandJunction3D junction) throws NoninvertibleTransformException {
        ArrayList<BranchDescriptor3D> branches = new ArrayList<BranchDescriptor3D>();
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            branches.add(junction.getBranch(i));
        }
        List<CoordinateSystem3D> csList = this.generateNormalizedCoordinates(branches);
        List<Matrix4D> result = this.generateNormalizedTransformations(csList);
        return result;
    }

    public List<Matrix4D> generateCompleteNormalizedTransformations(List<BranchDescriptor3D> branches) throws NoninvertibleTransformException {
        List<CoordinateSystem3D> csList = this.generateNormalizedCoordinates(branches);
        List<Matrix4D> result = this.generateNormalizedTransformations(csList);
        return result;
    }

    public List<Matrix4D> generateCompleteNormalizedTransformations(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransforms) throws NoninvertibleTransformException {
        List<CoordinateSystem3D> csList = this.generateNormalizedCoordinates(branches, activeTransforms);
        List<Matrix4D> result = this.generateNormalizedTransformations(csList);
        return result;
    }

    public List<String> generateCompleteHashes(List<BranchDescriptor3D> branches) throws NoninvertibleTransformException {
        assert (branches.size() > 0);
        List<Matrix4D> mList = this.generateCompleteNormalizedTransformations(branches);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < mList.size(); ++i) {
            result.add(Matrix4DTools.computeEpsilonHash(mList.get(i), this.epsilonRot, this.epsilonTrans));
            result.add(Matrix4DTools.computeEpsilonHash(mList.get(i).inverse(), this.epsilonRot, this.epsilonTrans));
        }
        return result;
    }

    public List<String> generateCompleteHashes(List<BranchDescriptor3D> branches, List<CoordinateSystem> activeTransforms) throws NoninvertibleTransformException {
        assert (branches.size() > 0);
        List<Matrix4D> mList = this.generateCompleteNormalizedTransformations(branches, activeTransforms);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < mList.size(); ++i) {
            result.add(Matrix4DTools.computeEpsilonHash(mList.get(i), this.epsilonRot, this.epsilonTrans));
            result.add(Matrix4DTools.computeEpsilonHash(mList.get(i).inverse(), this.epsilonRot, this.epsilonTrans));
        }
        return result;
    }

    private double scoreNormalizedTransformations(Matrix4D trafo1, Matrix4D trafo2) {
        double norm2;
        double norm1 = trafo2.minus(trafo1).norm();
        return norm1 < (norm2 = trafo2.minus(trafo1.inverse()).norm()) ? norm1 : norm2;
    }

    private double scoreNormalizedTransformations(List<Matrix4D> trafos1, List<Matrix4D> trafos2, int[] perm) {
        assert (trafos1.size() == trafos2.size());
        assert (perm.length == trafos1.size());
        double score = 0.0;
        for (int i = 0; i < trafos1.size(); ++i) {
            assert (i < trafos1.size());
            assert (perm[i] < trafos1.size());
            score += this.scoreNormalizedTransformations(trafos1.get(i), trafos2.get(perm[i]));
        }
        return score;
    }

    public double scoreNormalizedTransformations(List<Matrix4D> trafos1, List<Matrix4D> trafos2) {
        assert (trafos1.size() == trafos2.size());
        PermutationGenerator permutator = new PermutationGenerator(trafos1.size());
        double bestScore = 1.0E30;
        do {
            int[] perm;
            double score;
            if (!((score = this.scoreNormalizedTransformations(trafos1, trafos2, perm = permutator.get())) < bestScore)) continue;
            bestScore = score;
        } while (permutator.inc());
        return bestScore;
    }
}

