/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Optimizer;
import generaltools.Randomizer;
import graphtools.AdjacencyTools;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import numerictools.DoubleArrayTools;
import numerictools.DoubleTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.HelixConstraintLink;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.CoordinateSystem;
import tools3d.GaussianOrientableMutator;
import tools3d.LineShape;
import tools3d.Vector3D;
import tools3d.objects3d.ConstraintLink;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3DSet;
import tools3d.symmetry2.SymCopies;
import tools3d.symmetry2.SymCopySingleton;

public class HelixOptimizer
implements Optimizer {
    public static final double TRANSLATION_STEP = 4.0;
    public static final double ANGLE_STEP = Math.toRadians(15.0);
    private HelixParameters defaultHelixParameters = new HelixParameters();
    private boolean addHelicesMode = false;
    private double annealingFactor = 0.985;
    private int annealingInterval = 10000;
    private boolean keepFirstFixedMode = true;
    private int outputInterval = 10000;
    private Object3D root;
    private boolean firstPass = true;
    private double scaleLimit = 10.0;
    private double scaleMult = 0.02;
    private List<HelixConstraintLink> helixConstraints;
    private List<ConstraintLink> distanceConstraints;
    private LinkSet allLinks;
    private int[][] branchDescriptorGroups;
    private int[] branchDescriptorGroupIds;
    private int[] groupConstraintCounts;
    private List<BranchDescriptor3D> branchDescriptors;
    private List<CoordinateSystem> origCoordinateSystems;
    private List<CoordinateSystem> optCoordinateSystems;
    private double[] coordScoreAverages;
    private double[] coordScoreAveragesTmp;
    private double[] coordScoreAveragesSaved;
    private int helixMutInterval = 0;
    private double helixConstraintMutationProb = 0.5;
    private boolean[] moveFlags;
    private int numberSteps;
    private double ktOrig = 10.0;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double errorScoreLimit;
    private double errorScoreInitialLimit = 1.0E10;
    private GaussianOrientableMutator mutator = new GaussianOrientableMutator(4.0, ANGLE_STEP);
    private GaussianOrientableMutator mutatorOrig = new GaussianOrientableMutator(4.0, ANGLE_STEP);
    private Object3DSet parentObjects;
    private static SymCopies symCopies;

    public HelixOptimizer(Object3D graph, LinkSet links, int numberSteps, double errorScoreLimit, Object3DSet parents) {
        int i;
        this.root = graph;
        this.numberSteps = numberSteps;
        this.errorScoreLimit = errorScoreLimit;
        this.errorScoreInitialLimit = this.errorScoreInitialLimit;
        this.helixConstraints = new ArrayList<HelixConstraintLink>();
        this.distanceConstraints = new ArrayList<ConstraintLink>();
        this.allLinks = links;
        this.setParentObjects(parents);
        for (i = 0; i < links.size(); ++i) {
            Link link = links.get(i);
            if (link instanceof HelixConstraintLink) {
                this.helixConstraints.add((HelixConstraintLink)link);
                continue;
            }
            if (!(link instanceof ConstraintLink)) continue;
            this.distanceConstraints.add((ConstraintLink)link);
        }
        if (this.helixConstraints.size() == 0) {
            log.warning("No helix constraints defined! Use command helixconstraint before start opthelices");
        } else {
            this.branchDescriptors = this.findBranchDescriptors(this.helixConstraints);
            this.branchDescriptorGroups = this.findBranchDescriptorGroups(this.branchDescriptors, this.allLinks);
            this.branchDescriptorGroupIds = this.findGroupIds(this.branchDescriptorGroups, this.branchDescriptors.size());
            this.origCoordinateSystems = HelixOptimizer.findCoordinateSystems(this.branchDescriptors, this.branchDescriptorGroups);
            this.optCoordinateSystems = HelixOptimizer.findCoordinateSystems(this.branchDescriptors, this.branchDescriptorGroups);
            this.coordScoreAverages = new double[this.branchDescriptorGroups.length];
            this.coordScoreAveragesTmp = new double[this.branchDescriptorGroups.length];
            this.coordScoreAveragesSaved = new double[this.branchDescriptorGroups.length];
            this.resetCoordScoreAverages();
            this.moveFlags = new boolean[this.coordScoreAverages.length];
            for (i = 0; i < this.moveFlags.length; ++i) {
                this.moveFlags[i] = true;
            }
            this.groupConstraintCounts = new int[this.origCoordinateSystems.size()];
            String outCount = "";
            for (int i2 = 0; i2 < this.groupConstraintCounts.length; ++i2) {
                this.groupConstraintCounts[i2] = this.countGroupConstraints(i2);
                outCount = outCount + this.groupConstraintCounts[i2] + " ";
            }
        }
        symCopies = SymCopySingleton.getInstance();
    }

    public double getKtOrig() {
        return this.ktOrig;
    }

    private int findObjectGroupId(Object3D object) {
        Object3D parent = this.findSuitableParentObject(object);
        if (parent == null) {
            return -1;
        }
        for (int i = 0; i < this.branchDescriptors.size(); ++i) {
            if (this.findSuitableParentObject(this.branchDescriptors.get(i)) != parent) continue;
            return this.branchDescriptorGroupIds[i];
        }
        return -1;
    }

    public double getErrorScoreInitialLimit() {
        return this.errorScoreInitialLimit;
    }

    public void setErrorScoreInitialLimit(double limit) {
        this.errorScoreInitialLimit = limit;
    }

    public void setHelixMutInterval(int value) {
        this.helixMutInterval = value;
    }

    public void setKtOrig(double kt) {
        this.ktOrig = kt;
    }

    private void setMovableObject(Object3D object) {
        int id = this.findObjectGroupId(object);
        if (id >= 0) {
            this.moveFlags[id] = true;
            log.fine("Setting object " + object.getName() + " to movable group: " + (id + 1));
        } else {
            log.warning("Could not find suitable parent object for " + object.getName());
            assert (false);
        }
    }

    public void setMovableObjects(Object3DSet objects) {
        int i;
        assert (objects != null);
        assert (this.moveFlags != null);
        if (objects.size() == 0) {
            return;
        }
        for (i = 0; i < this.moveFlags.length; ++i) {
            this.moveFlags[i] = false;
        }
        for (i = 0; i < objects.size(); ++i) {
            this.setMovableObject(objects.get(i));
        }
    }

    private void resetCoordScoreAverages() {
        for (int i = 0; i < this.coordScoreAverages.length; ++i) {
            this.coordScoreAverages[i] = 1.0;
            this.coordScoreAveragesTmp[i] = 1.0;
        }
    }

    private void saveCoordScoreAverages() {
        for (int i = 0; i < this.coordScoreAverages.length; ++i) {
            this.coordScoreAveragesSaved[i] = this.coordScoreAverages[i];
        }
    }

    private void restoreCoordScoreAverages() {
        for (int i = 0; i < this.coordScoreAverages.length; ++i) {
            this.coordScoreAverages[i] = this.coordScoreAveragesSaved[i];
        }
    }

    private void setParentObjects(Object3DSet parentObjects) {
        this.parentObjects = parentObjects;
    }

    private Object3D findSuitableParentObject(Object3D b) {
        assert (b != null);
        if (this.parentObjects != null && this.parentObjects.size() > 0) {
            Object3D result = Object3DSetTools.findAncestor(this.parentObjects, b);
            if (result == null) {
                System.out.println("Could not find parent object for " + b.getFullName() + " in: ");
                for (int i = 0; i < this.parentObjects.size(); ++i) {
                    System.out.println(this.parentObjects.get(i).getFullName());
                }
                return null;
            }
            assert (result != null);
            log.fine("Suitable parent object of " + b.getFullName() + " is: " + result.getFullName());
            return result;
        }
        if (b instanceof StrandJunction3D) {
            return b;
        }
        Object3D result = Object3DTools.findAncestorByClassName(b, "StrandJunction3D");
        if (result != null) {
            return result;
        }
        result = Object3DTools.findAncestorByClassName(b, "KissingLoop3D");
        if (result != null) {
            return result;
        }
        return null;
    }

    private void applyTransformations(List<CoordinateSystem> coords) {
        ArrayList<Object3D> appliedObjects = new ArrayList<Object3D>();
        assert (coords.size() == this.branchDescriptorGroups.length);
        assert (this.moveFlags.length == coords.size());
        log.fine("Number of transformations to be applied: " + this.branchDescriptorGroups.length);
        for (int i = 0; i < this.branchDescriptorGroups.length; ++i) {
            if (!this.moveFlags[i]) continue;
            for (int j = 0; j < this.branchDescriptorGroups[i].length; ++j) {
                Object3D newRoot = this.findSuitableParentObject(this.branchDescriptors.get(this.branchDescriptorGroups[i][j]));
                if (newRoot == null || Object3DTools.findAncestorOrEqual(newRoot, appliedObjects) != null) continue;
                newRoot.activeTransform(coords.get(i));
                appliedObjects.add(newRoot);
            }
        }
    }

    private int findGroupId(int[][] groups, int id) {
        for (int i = 0; i < groups.length; ++i) {
            for (int j = 0; j < groups[i].length; ++j) {
                if (groups[i][j] != id) continue;
                return i;
            }
        }
        return -1;
    }

    private int[] findGroupIds(int[][] groups, int size) {
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.findGroupId(groups, i);
        }
        return result;
    }

    static double computeBranchDescriptorError(BranchDescriptor3D branch1, BranchDescriptor3D branch2, CoordinateSystem cs1, CoordinateSystem cs2, int stemLength) {
        assert (cs1.isValid());
        assert (cs2.isValid());
        int lastBp = stemLength - 1;
        double[] t = new double[4];
        Vector3D p1o = branch1.computeHelixPosition(stemLength + 1, 1);
        Vector3D p1i = branch1.computeHelixPosition(stemLength + 1, 2);
        Vector3D p2o = branch2.computeHelixPosition(stemLength + 1, 1);
        Vector3D p2i = branch2.computeHelixPosition(stemLength + 1, 2);
        Vector3D q2i = branch2.computeHelixPosition(0, 2);
        Vector3D q2o = branch2.computeHelixPosition(0, 1);
        Vector3D q1i = branch1.computeHelixPosition(0, 2);
        Vector3D q1o = branch1.computeHelixPosition(0, 1);
        assert (p1o.isValid());
        assert (p2o.isValid());
        assert (p1i.isValid());
        assert (p2i.isValid());
        assert (q1o.isValid());
        assert (q1i.isValid());
        assert (q2o.isValid());
        assert (q2i.isValid());
        assert (p1o.isReasonable());
        assert (p2o.isReasonable());
        assert (p1i.isReasonable());
        assert (p2i.isReasonable());
        assert (q1o.isReasonable());
        assert (q1i.isReasonable());
        assert (q2o.isReasonable());
        assert (q2i.isReasonable());
        p1o = cs1.activeTransform(p1o);
        p1i = cs1.activeTransform(p1i);
        p2o = cs2.activeTransform(p2o);
        p2i = cs2.activeTransform(p2i);
        q1o = cs1.activeTransform(q1o);
        q1i = cs1.activeTransform(q1i);
        q2o = cs2.activeTransform(q2o);
        q2i = cs2.activeTransform(q2i);
        assert (p1o.isValid());
        assert (p2o.isValid());
        assert (p1i.isValid());
        assert (p2i.isValid());
        assert (q1o.isValid());
        assert (q1i.isValid());
        assert (q2o.isValid());
        assert (q2i.isValid());
        assert (p1o.isReasonable());
        assert (p2o.isReasonable());
        assert (p1i.isReasonable());
        assert (p2i.isReasonable());
        assert (q1o.isReasonable());
        assert (q1i.isReasonable());
        assert (q2o.isReasonable());
        assert (q2i.isReasonable());
        Vector3D h = p1o.minus(q2i);
        assert (h.isValid());
        double d2 = h.getX() * h.getX() + h.getY() * h.getY() + h.getZ() * h.getZ();
        if (!DoubleTools.isValidAndNotNegative(d2)) {
            log.severe("Could not compute length square of vector: " + h + " : " + d2);
            assert (false);
        }
        double d = h.lengthSquare();
        t[0] = p1o.distanceSquare(q2i);
        assert (Math.abs(t[0] - d) < 0.001);
        t[1] = p1i.distanceSquare(q2o);
        t[2] = p2o.distanceSquare(q1i);
        t[3] = p2i.distanceSquare(q1o);
        for (int i = 0; i < 4; ++i) {
            if (DoubleTools.isValid(t[i])) continue;
            log.info("Not a number in t " + i + " " + t[i] + " in computeBranchDescriptorError: " + branch1.getName() + " " + branch2.getName() + cs1 + " " + cs2 + " points: " + p1o + "," + q2i + " " + p1i + "," + q2o + " " + p2o + "," + q1i + " " + p2i + "," + q1o);
        }
        double result = t[DoubleArrayTools.findHighestElement(t)];
        assert (DoubleTools.isValidAndNotNegative(result));
        assert (result >= 0.0);
        if (result >= 0.0) {
            result = Math.sqrt(result);
        } else {
            log.severe("Could not generate square root of " + result);
            assert (false);
        }
        if (!DoubleTools.isValidAndNotNegative(result)) {
            log.info("Weird score in computeBranchDescriptorError: " + result + " " + branch1.getName() + " " + branch2.getName() + cs1 + " " + cs2 + " points: " + p1o + "," + q2i + " " + p1i + "," + q2o + " " + p2o + "," + q1i + " " + p2i + "," + q1o);
        }
        assert (DoubleTools.isValidAndNotNegative(result));
        return result;
    }

    public static double computeBranchDescriptorError(BranchDescriptor3D branch1, BranchDescriptor3D branch2, HelixConstraintLink constraint) {
        assert (false);
        return HelixOptimizer.computeBranchDescriptorError(branch1, branch2, CoordinateSystem3D.CARTESIAN, CoordinateSystem3D.CARTESIAN, constraint.getBasePairMax());
    }

    private double scoreHelixConstraint(HelixConstraintLink helixConstraint, List<CoordinateSystem> coordinateSystems) {
        BranchDescriptor3D b1 = (BranchDescriptor3D)helixConstraint.getObj1();
        BranchDescriptor3D b2 = (BranchDescriptor3D)helixConstraint.getObj2();
        int id1 = this.branchDescriptors.indexOf(b1);
        int id2 = this.branchDescriptors.indexOf(b2);
        int g1 = this.branchDescriptorGroupIds[id1];
        int g2 = this.branchDescriptorGroupIds[id2];
        assert (g1 >= 0);
        assert (g2 >= 0);
        assert (b1 != b2);
        assert (coordinateSystems.get(g1).isValid());
        assert (coordinateSystems.get(g2).isValid());
        int stemLength = helixConstraint.getBasePairMax();
        CoordinateSystem3D cs1 = (CoordinateSystem3D)coordinateSystems.get(g1);
        CoordinateSystem3D cs2 = (CoordinateSystem3D)coordinateSystems.get(g2);
        if (helixConstraint.getSymId1() > 0) {
            cs1 = (CoordinateSystem3D)cs1.cloneDeep();
            CoordinateSystem s1 = (CoordinateSystem)symCopies.get(helixConstraint.getSymId1());
            cs1.passiveTransform(s1);
        }
        if (helixConstraint.getSymId2() > 0) {
            cs2 = (CoordinateSystem3D)cs2.cloneDeep();
            CoordinateSystem s2 = (CoordinateSystem)symCopies.get(helixConstraint.getSymId2());
            cs2.passiveTransform(s2);
        }
        double result = HelixOptimizer.computeBranchDescriptorError(b1, b2, cs1, cs2, stemLength);
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        if (result > 0.0) {
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g1]));
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g2]));
        } else {
            log.fine("Zero constraint score between " + result + " " + b1.getName() + " and " + b2.getName());
        }
        return result;
    }

    public void setKeepFirstFixedMode(boolean mode) {
        this.keepFirstFixedMode = mode;
    }

    private double applyEndPointHelixConstraint(HelixConstraintLink helixConstraint, List<CoordinateSystem> coordinateSystems) throws FittingException {
        assert (helixConstraint != null);
        BranchDescriptor3D b1 = (BranchDescriptor3D)helixConstraint.getObj1();
        BranchDescriptor3D b2 = (BranchDescriptor3D)helixConstraint.getObj2();
        int id1 = this.branchDescriptors.indexOf(b1);
        int id2 = this.branchDescriptors.indexOf(b2);
        int g1 = this.branchDescriptorGroupIds[id1];
        int g2 = this.branchDescriptorGroupIds[id2];
        assert (g1 >= 0);
        assert (g2 >= 0);
        assert (b1 != b2);
        assert (coordinateSystems.get(g1).isValid());
        assert (coordinateSystems.get(g2).isValid());
        boolean valid = false;
        if (this.groupConstraintCounts[g2] == 1) {
            this.perfectlyMatchHelixConstraint(helixConstraint, coordinateSystems);
            valid = true;
        } else if (this.groupConstraintCounts[g1] == 1) {
            HelixConstraintLink constraintLink = (HelixConstraintLink)helixConstraint.clone();
            constraintLink.swap();
            this.perfectlyMatchHelixConstraint(constraintLink, coordinateSystems);
            valid = true;
        }
        double result = HelixOptimizer.computeBranchDescriptorError(b1, b2, coordinateSystems.get(g1), coordinateSystems.get(g2), helixConstraint.getBasePairMax());
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        if (valid) {
            if (this.addHelicesMode) {
                // empty if block
            }
            if (result >= 0.0) {
                assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g1]));
                assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g2]));
                log.fine("The placement score is: " + result);
            } else {
                log.fine("Negative constraint score between " + result + " " + b1.getName() + " and " + b2.getName());
            }
        }
        return result;
    }

    private CoordinateSystem perfectlyMatchHelixConstraint(int n, CoordinateSystem cs1, HelixParameters prm) {
        LineShape line = Rna3DTools.computeHelix(n + 1, cs1, prm);
        Vector3D zDir = cs1.getZ();
        zDir.normalize();
        Vector3D newBase = cs1.getPosition().plus(zDir.mul((double)(n + 1) * prm.rise).plus(zDir.mul(prm.offset)));
        Vector3D newX = line.getPosition2().minus(newBase);
        assert (newX.length() > 0.0);
        newX.normalize();
        Vector3D newZ = zDir.mul(-1.0);
        Vector3D newY = newZ.cross(newX);
        log.fine("Initializing coordinate system with " + newBase + " " + newX + " " + newY + " " + newX.angle(newY) * 57.29577951308232 + " " + newZ.angle(newX) * 57.29577951308232);
        return new CoordinateSystem3D(newBase, newX, newY);
    }

    private double perfectlyMatchHelixConstraint(HelixConstraintLink helixConstraint, List<CoordinateSystem> coordinateSystems) throws FittingException {
        BranchDescriptor3D b1 = (BranchDescriptor3D)helixConstraint.getObj1();
        BranchDescriptor3D b2 = (BranchDescriptor3D)helixConstraint.getObj2();
        int id1 = this.branchDescriptors.indexOf(b1);
        int id2 = this.branchDescriptors.indexOf(b2);
        int g1 = this.branchDescriptorGroupIds[id1];
        int g2 = this.branchDescriptorGroupIds[id2];
        if (!this.moveFlags[g2]) {
            throw new FittingException("Not allowed to move coordinate system " + g2);
        }
        assert (g1 >= 0);
        assert (g2 >= 0);
        assert (b1 != b2);
        CoordinateSystem cs1 = coordinateSystems.get(g1);
        CoordinateSystem cs2 = coordinateSystems.get(g2);
        assert (coordinateSystems.get(g1).isValid());
        assert (coordinateSystems.get(g2).isValid());
        CoordinateSystem cs = b1.getCoordinateSystem();
        CoordinateSystem newCs = this.perfectlyMatchHelixConstraint(helixConstraint.getBasePairMin(), cs, this.defaultHelixParameters);
        newCs.activeTransform(cs1);
        CoordinateSystem cTmp = b2.getCoordinateSystem().inverse();
        cTmp.activeTransform(newCs);
        cs2 = cTmp;
        coordinateSystems.set(g2, cs2);
        double result = HelixOptimizer.computeBranchDescriptorError(b1, b2, cs1, cs2, helixConstraint.getBasePairMax());
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        if (result > 0.0) {
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g1]));
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g2]));
        } else {
            log.fine("Zero constraint score between " + result + " " + b1.getName() + " and " + b2.getName());
        }
        return result;
    }

    private double scoreCoordinateSystems(List<CoordinateSystem> coordinateSystems) {
        int i;
        double score = 0.0;
        this.resetCoordScoreAverages();
        for (i = 0; i < this.helixConstraints.size(); ++i) {
            double term = this.scoreHelixConstraint(this.helixConstraints.get(i), coordinateSystems);
            score += term * term;
        }
        for (i = 0; i < this.coordScoreAverages.length; ++i) {
            this.coordScoreAveragesTmp[i] = Math.pow(this.coordScoreAveragesTmp[i], 1.0 / (double)this.groupConstraintCounts[i]);
            this.coordScoreAverages[i] = this.coordScoreAveragesTmp[i];
        }
        this.firstPass = false;
        return score;
    }

    private Object3DSet convertToObject3DSet(List<Object3D> objects) {
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (int i = 0; i < objects.size(); ++i) {
            result.add(objects.get(i));
        }
        return result;
    }

    public static CoordinateSystem findCoordinateSystem(List<BranchDescriptor3D> branchDescriptors, int[] branchDescriptorGroup) {
        SimpleObject3DSet set = new SimpleObject3DSet();
        for (int i = 0; i < branchDescriptorGroup.length; ++i) {
            set.add(branchDescriptors.get(branchDescriptorGroup[i]));
        }
        CoordinateSystem3D result = new CoordinateSystem3D(new Vector3D(0.0, 0.0, 0.0), Vector3D.EX, Vector3D.EY);
        return result;
    }

    private static List<CoordinateSystem> findCoordinateSystems(List<BranchDescriptor3D> branchDescriptors, int[][] branchDescriptorGroups) {
        ArrayList<CoordinateSystem> result = new ArrayList<CoordinateSystem>();
        for (int i = 0; i < branchDescriptorGroups.length; ++i) {
            result.add(HelixOptimizer.findCoordinateSystem(branchDescriptors, branchDescriptorGroups[i]));
        }
        return result;
    }

    private List<BranchDescriptor3D> findBranchDescriptors(List<HelixConstraintLink> helixConstraints) {
        ArrayList<BranchDescriptor3D> result = new ArrayList<BranchDescriptor3D>();
        for (int i = 0; i < helixConstraints.size(); ++i) {
            BranchDescriptor3D b2;
            BranchDescriptor3D b1 = (BranchDescriptor3D)helixConstraints.get(i).getObj1();
            if (!result.contains(b1)) {
                result.add(b1);
            }
            if (result.contains(b2 = (BranchDescriptor3D)helixConstraints.get(i).getObj2())) continue;
            result.add(b2);
        }
        return result;
    }

    public boolean checkBranchDescriptorsConnected(BranchDescriptor3D b1, BranchDescriptor3D b2, LinkSet links) {
        return this.findSuitableParentObject(b1) == this.findSuitableParentObject(b2);
    }

    private int[][] findBranchDescriptorGroups(List<BranchDescriptor3D> branchDescriptors, LinkSet allLinks) {
        boolean[][] adjacencyMatrix = this.findBranchDescriptorGroupMatrix(branchDescriptors, allLinks);
        List<List<Integer>> groups = AdjacencyTools.findConnectedSets(adjacencyMatrix);
        int[][] result = new int[groups.size()][];
        for (int i = 0; i < groups.size(); ++i) {
            result[i] = new int[groups.get(i).size()];
            for (int j = 0; j < groups.get(i).size(); ++j) {
                result[i][j] = groups.get(i).get(j);
            }
        }
        return result;
    }

    private boolean[][] findBranchDescriptorGroupMatrix(List<BranchDescriptor3D> branchDescriptors, LinkSet allLinks) {
        assert (branchDescriptors.size() > 0);
        boolean[][] result = new boolean[branchDescriptors.size()][branchDescriptors.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i][i] = true;
            for (int j = i + 1; j < result[i].length; ++j) {
                result[i][j] = this.checkBranchDescriptorsConnected(branchDescriptors.get(i), branchDescriptors.get(j), allLinks);
                result[j][i] = result[i][j];
            }
        }
        return result;
    }

    private List<CoordinateSystem> cloneCoordinateSystems(List<CoordinateSystem> coords) {
        ArrayList<CoordinateSystem> result = new ArrayList<CoordinateSystem>();
        for (int i = 0; i < coords.size(); ++i) {
            CoordinateSystem3D csClone = (CoordinateSystem3D)coords.get(i).cloneDeep();
            assert (csClone.size() == ((CoordinateSystem3D)coords.get(i)).size());
            assert (csClone.size() == 3);
            result.add(csClone);
        }
        return result;
    }

    private void copyCoordinateSystems(List<CoordinateSystem> optCoords, List<CoordinateSystem> origCoords) {
        assert (optCoords != null);
        assert (origCoords != null);
        assert (optCoords.size() == origCoords.size());
        for (int i = 0; i < origCoords.size(); ++i) {
            CoordinateSystem3D cs = (CoordinateSystem3D)optCoords.get(i);
            optCoords.get(i).copy(origCoords.get(i));
        }
    }

    private int countGroupConstraints(int n) {
        int count = 0;
        for (int i = 0; i < this.helixConstraints.size(); ++i) {
            int id2;
            int g2;
            BranchDescriptor3D b1 = (BranchDescriptor3D)this.helixConstraints.get(i).getObj1();
            BranchDescriptor3D b2 = (BranchDescriptor3D)this.helixConstraints.get(i).getObj2();
            int id1 = this.branchDescriptors.indexOf(b1);
            int g1 = this.branchDescriptorGroupIds[id1];
            if (g1 == (g2 = this.branchDescriptorGroupIds[id2 = this.branchDescriptors.indexOf(b2)]) && this.helixConstraints.get(i).getSymId1() == this.helixConstraints.get(i).getSymId2()) {
                log.warning("Helix constraint + " + (i + 1) + " points twice to the same group: " + this.helixConstraints.get(i));
                assert (this.helixConstraints.get(i) instanceof HelixConstraintLink);
            }
            if (g1 == n) {
                ++count;
            }
            if (g2 != n) continue;
            ++count;
        }
        return count;
    }

    private void mutateCoordinateSystems(List<CoordinateSystem> coords, double annealingMult) {
        int i;
        assert (coords != null);
        assert (!Double.isInfinite(annealingMult));
        assert (!Double.isNaN(annealingMult));
        int startId = 0;
        if (this.keepFirstFixedMode && coords.size() > 1) {
            startId = 1;
        }
        this.assertMovables();
        for (i = startId; i < coords.size(); ++i) {
            if (!this.moveFlags[i]) {
                log.info("Not mutating coordinate system " + i + " because it is not allowed to move");
                continue;
            }
            if (this.groupConstraintCounts[i] < 1) {
                log.info("Not mutating coordinate system " + i + " because it has no constraint: " + this.groupConstraintCounts[i]);
                continue;
            }
            this.mutator.copy(this.mutatorOrig);
            assert (this.coordScoreAverages[i] >= 0.0);
            assert (!Double.isInfinite(this.coordScoreAverages[i]));
            assert (!Double.isNaN(this.coordScoreAverages[i]));
            double totalScale = annealingMult * this.scaleMult * this.coordScoreAverages[i];
            assert (DoubleTools.isReasonable(totalScale));
            if (totalScale > this.scaleLimit) {
                totalScale = this.scaleLimit;
            }
            assert (!Double.isInfinite(totalScale));
            assert (!Double.isNaN(totalScale));
            this.mutator.scaleAngleStep(totalScale);
            this.mutator.scaleTranslationStep(totalScale);
            log.fine("Mutator used for coordinate system: " + (i + 1) + " " + coords.get(i) + " : " + totalScale + " mut: " + this.mutator);
            this.mutator.rotate(coords.get(i));
            this.mutator.translate(coords.get(i));
        }
        this.assertMovables();
        for (i = 0; i < this.helixConstraints.size(); ++i) {
            try {
                this.applyEndPointHelixConstraint(this.helixConstraints.get(i), coords);
                continue;
            }
            catch (FittingException fe) {
                log.info("Not allowed to move coordinate system for end point fitting: " + fe.getMessage());
            }
        }
        this.assertMovables();
    }

    private void printCoordinateSystems(List<CoordinateSystem> coords) {
        for (int i = 0; i < coords.size(); ++i) {
            System.out.println("" + (i + 1) + " " + coords.get(i).toString());
        }
    }

    private boolean hasComplexGroups() {
        return true;
    }

    private String boolFlagString(boolean[] flags) {
        String s = "";
        for (int i = 0; i < flags.length; ++i) {
            s = s + flags[i] + " ";
        }
        return s;
    }

    private void extractHelixConstraintLengths(List<HelixConstraintLink> helixConstraints, int[] helixLengths) {
        assert (helixLengths != null);
        assert (helixConstraints != null);
        assert (helixLengths.length == helixConstraints.size());
        for (int i = 0; i < helixLengths.length; ++i) {
            assert (helixConstraints.get(i).getBasePairMin() == helixConstraints.get(i).getBasePairMax());
            helixLengths[i] = helixConstraints.get(i).getBasePairMin();
        }
    }

    private void setHelixConstraintLengths(int[] helixLengths, List<HelixConstraintLink> helixConstraints) {
        assert (helixLengths.length == helixConstraints.size());
        for (int i = 0; i < helixLengths.length; ++i) {
            assert (helixConstraints.get(i).getBasePairMin() == helixConstraints.get(i).getBasePairMax());
            helixConstraints.get(i).setBasePairMin(helixLengths[i]);
            helixConstraints.get(i).setBasePairMax(helixLengths[i]);
        }
    }

    void mutateHelixLengths(List<HelixConstraintLink> helixConstraints, double helixConstraintMutationProb) {
        int i;
        Random rand = Randomizer.getInstance();
        boolean modified = false;
        for (i = 0; i < helixConstraints.size(); ++i) {
            double x = rand.nextDouble();
            if (!(x < helixConstraintMutationProb)) continue;
            HelixConstraintLink hcLink = helixConstraints.get(i);
            assert (hcLink.getBasePairMin() == hcLink.getBasePairMax());
            int bp = hcLink.getBasePairMin();
            if (x < 0.5 * helixConstraintMutationProb) {
                if (bp <= 0) continue;
                hcLink.setBasePairMin(bp - 1);
                hcLink.setBasePairMax(bp - 1);
                assert (helixConstraints.get(i).getBasePairMin() == bp - 1);
                assert (helixConstraints.get(i).getBasePairMax() == bp - 1);
                modified = true;
                continue;
            }
            hcLink.setBasePairMin(bp + 1);
            hcLink.setBasePairMax(bp + 1);
            modified = true;
            assert (helixConstraints.get(i).getBasePairMin() == bp + 1);
            assert (helixConstraints.get(i).getBasePairMax() == bp + 1);
        }
        if (!modified) {
            log.warning("No helix lengths were modified!");
        } else {
            System.out.print("Modified helix constraint lengths: ");
            for (i = 0; i < helixConstraints.size(); ++i) {
                System.out.print("" + helixConstraints.get(i).getBasePairMin() + " ");
            }
            System.out.println();
        }
    }

    @Override
    public Properties optimize() {
        log.info("Starting helix optimization! Number of found helix constraints: " + this.helixConstraints.size() + " Number of found distance constraints: " + this.distanceConstraints.size() + " error limit: " + this.errorScoreLimit + " initial error limit: " + this.errorScoreInitialLimit + " keep-first-fixed: " + this.keepFirstFixedMode);
        Properties properties = new Properties();
        Random rand = Randomizer.getInstance();
        if (this.optCoordinateSystems == null || this.optCoordinateSystems.size() == 0) {
            String errMsg = "No coordinate systems defined for optimization. Maybe add helix constraints?";
            log.fine(errMsg);
            properties.setProperty("message", errMsg);
            properties.setProperty("error", errMsg);
            return properties;
        }
        log.fine("Number of relevant coordinate systems: " + this.origCoordinateSystems.size());
        log.fine("Movable coordinate systems: " + this.boolFlagString(this.moveFlags));
        String s2 = "";
        assert (this.branchDescriptors != null);
        for (int i = 0; i < this.branchDescriptors.size(); ++i) {
            assert (this.branchDescriptors.get(i) != null);
            if (this.findSuitableParentObject(this.branchDescriptors.get(i)) == null) {
                properties.setProperty("error", "No suitable parent found for " + this.branchDescriptors.get(i).getFullName());
                return properties;
            }
            assert (this.findSuitableParentObject(this.branchDescriptors.get(i)) != null);
            assert (this.branchDescriptorGroupIds != null);
            s2 = s2 + " " + i + " " + this.branchDescriptors.get(i).getFullName();
            s2 = s2 + " " + this.branchDescriptorGroupIds[i];
            s2 = s2 + " parent: " + this.findSuitableParentObject(this.branchDescriptors.get(i)).getFullName() + " " + PackageConstants.NEWLINE;
        }
        log.fine("Branch descriptors in optimization: " + s2);
        log.fine("Number of relevant coordinate systems: " + this.origCoordinateSystems.size());
        this.firstPass = true;
        this.copyCoordinateSystems(this.optCoordinateSystems, this.origCoordinateSystems);
        List<CoordinateSystem> saveCoords = this.cloneCoordinateSystems(this.optCoordinateSystems);
        List<CoordinateSystem> bestCoords = this.cloneCoordinateSystems(this.optCoordinateSystems);
        int[] helixBestLengths = new int[this.helixConstraints.size()];
        int[] helixSavedLengths = new int[this.helixConstraints.size()];
        this.extractHelixConstraintLengths(this.helixConstraints, helixSavedLengths);
        this.extractHelixConstraintLengths(this.helixConstraints, helixBestLengths);
        double oldScore = this.scoreCoordinateSystems(this.optCoordinateSystems);
        if (oldScore > this.errorScoreInitialLimit) {
            String errMsg = "No helix optimization started because the initial score " + oldScore + " is higher than the maximum initial error score limit: " + this.errorScoreInitialLimit;
            log.warning(errMsg);
            properties.setProperty("message", errMsg);
            properties.setProperty("error", errMsg);
            return properties;
        }
        this.saveCoordScoreAverages();
        double bestScore = oldScore;
        double kt = this.ktOrig;
        double oldScoreMul = 0.1;
        if (oldScoreMul * oldScore > kt) {
            kt = oldScoreMul * oldScore;
        }
        properties.setProperty("start_score", "" + bestScore);
        int iter = 0;
        this.assertMovables();
        for (iter = 0; iter < this.numberSteps; ++iter) {
            boolean mutateConstraintsMode = false;
            if (this.helixMutInterval > 0 && iter > 0 && iter % this.helixMutInterval == 0) {
                mutateConstraintsMode = true;
                log.info("Mutating helix constraints!");
            }
            double annealingMult = Math.pow(this.annealingFactor, iter / this.annealingInterval);
            kt = this.ktOrig * annealingMult;
            if (iter % this.outputInterval == 1 || mutateConstraintsMode) {
                int i;
                String scoreString = "";
                for (i = 0; i < this.coordScoreAverages.length; ++i) {
                    scoreString = scoreString + Math.sqrt(this.coordScoreAverages[i]) + " ";
                }
                if (mutateConstraintsMode) {
                    log.info("Iteration: " + iter + " Best score so far: " + bestScore + " . Annealing paramenters: " + annealingMult + ", " + kt + " Helix lengths: ");
                    for (i = 0; i < helixSavedLengths.length; ++i) {
                        System.out.print("" + helixSavedLengths[i] + " ( " + helixBestLengths[i] + " ) ");
                    }
                } else {
                    log.info("Iteration: " + iter + " Best score so far: " + bestScore + " . Annealing parameters: " + annealingMult + " , " + kt);
                }
            }
            this.copyCoordinateSystems(saveCoords, this.optCoordinateSystems);
            if (!mutateConstraintsMode) {
                this.mutateCoordinateSystems(this.optCoordinateSystems, annealingMult);
            } else {
                assert (helixSavedLengths.length == this.helixConstraints.size());
                this.extractHelixConstraintLengths(this.helixConstraints, helixSavedLengths);
                this.mutateHelixLengths(this.helixConstraints, this.helixConstraintMutationProb);
            }
            double newScore = this.scoreCoordinateSystems(this.optCoordinateSystems);
            if (Math.exp(-((newScore - oldScore) / kt)) > rand.nextDouble()) {
                oldScore = newScore;
                this.saveCoordScoreAverages();
                if (newScore < bestScore) {
                    bestScore = newScore;
                    this.copyCoordinateSystems(bestCoords, this.optCoordinateSystems);
                    if (this.helixMutInterval > 0) {
                        this.extractHelixConstraintLengths(this.helixConstraints, helixBestLengths);
                    }
                    log.info("New best score found: " + bestScore + " at iteration " + (iter + 1) + " using kt " + kt);
                    if (this.helixMutInterval > 0) {
                        System.out.println("Currently best helix constraint lengths: ");
                        for (int i = 0; i < helixSavedLengths.length; ++i) {
                            System.out.print("" + helixBestLengths[i] + " ");
                        }
                    }
                }
            } else {
                log.fine("Rejecting step : " + newScore + " with so far best score: " + bestScore);
                this.copyCoordinateSystems(this.optCoordinateSystems, saveCoords);
                if (mutateConstraintsMode) {
                    this.setHelixConstraintLengths(helixSavedLengths, this.helixConstraints);
                }
                this.restoreCoordScoreAverages();
            }
            if (newScore < this.errorScoreLimit) {
                log.fine("Optimization goal achieved!");
                break;
            }
            if (this.hasComplexGroups()) continue;
            log.fine("Quitting optimization loop, because all coordinate systems could be placed analytically.");
            break;
        }
        this.applyTransformations(bestCoords);
        if (this.helixMutInterval > 0) {
            this.setHelixConstraintLengths(helixBestLengths, this.helixConstraints);
        }
        properties.setProperty("number_steps", "" + (iter + 1));
        properties.setProperty("final_score", "" + bestScore);
        log.fine("Optimization finished: " + properties);
        this.assertMovables();
        return properties;
    }

    void outputCoordinateSystems(PrintStream ps, List<CoordinateSystem> coords) {
        ps.println("Coordinate systems: ");
        for (int i = 0; i < coords.size(); ++i) {
            ps.println("" + i + " " + coords.get(i));
        }
    }

    void assertMovables() {
        for (int i = 0; i < this.moveFlags.length; ++i) {
            if (this.origCoordinateSystems.get(i) == this.optCoordinateSystems.get(i)) assert (false);
            if (!this.moveFlags[i] && this.origCoordinateSystems.get(i).distance(this.optCoordinateSystems.get(i)) > 0.1) assert (false);
        }
    }

    public boolean validate() {
        return this.moveFlags != null && this.moveFlags.length > 0;
    }
}

