/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.GraphBase;
import graphtools.IntegerList;
import graphtools.IntegerListList;
import graphtools.SimpleGraph;
import graphtools.SimpleGraphBaseOrderSet;
import java.util.logging.Logger;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class Grid3DTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public static Vector3D unitCellPos(Vector3D startPos, Vector3D v1, Vector3D v2, Vector3D v3, int n1, int n2, int n3) {
        Vector3D result = new Vector3D(startPos);
        result.add(v1.mul(n1));
        result.add(v2.mul(n2));
        result.add(v3.mul(n3));
        return result;
    }

    public static Object3DLinkSetBundle generateCubicGrid(Vector3D startPos, Vector3D v1, Vector3D v2, Vector3D v3, int n1, int n2, int n3, String name) {
        Object3D[][][] grid = new Object3D[n1][n2][n3];
        SimpleObject3D groupObj = new SimpleObject3D(startPos);
        groupObj.setName(name);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    SimpleObject3D obj = new SimpleObject3D(Grid3DTools.unitCellPos(startPos, v1, v2, v3, i, j, k));
                    String objName = name + "." + i + "." + j + "." + k;
                    obj.setName(objName);
                    grid[i][j][k] = obj;
                    groupObj.insertChild(obj);
                }
            }
        }
        SimpleLinkSet links = new SimpleLinkSet();
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    if (i > 0) {
                        SimpleLink link1 = new SimpleLink(grid[i][j][k], grid[i - 1][j][k]);
                        links.add(link1);
                    }
                    if (j > 0) {
                        SimpleLink link2 = new SimpleLink(grid[i][j][k], grid[i][j - 1][k]);
                        links.add(link2);
                    }
                    if (k <= 0) continue;
                    SimpleLink link3 = new SimpleLink(grid[i][j][k], grid[i][j][k - 1]);
                    links.add(link3);
                }
            }
        }
        SimpleObject3DLinkSetBundle result = new SimpleObject3DLinkSetBundle(groupObj, links);
        return result;
    }

    public static Object3DLinkSetBundle generateGraphitGrid(Vector3D startPos, Vector3D v1, Vector3D v2, Vector3D v3, int n1, int n2, int n3, String name) {
        Object3D obj;
        int j;
        int i;
        Object3D[][][] grid = new Object3D[n1][n2][n3];
        SimpleObject3D groupObj = new SimpleObject3D(startPos);
        groupObj.setName(name);
        for (int i2 = 0; i2 < n1; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                for (int k = 0; k < n3; ++k) {
                    SimpleObject3D obj2 = new SimpleObject3D(Grid3DTools.unitCellPos(startPos, v1, v2, v3, i2, j2, k));
                    String objName = name + "." + i2 + "." + j2 + "." + k;
                    obj2.setName(objName);
                    grid[i2][j2][k] = obj2;
                    groupObj.insertChild(obj2);
                }
            }
        }
        SimpleLinkSet links = new SimpleLinkSet();
        for (i = 0; i < n1; ++i) {
            for (j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    if (k == 0) {
                        if (i > 0) {
                            SimpleLink link1 = new SimpleLink(grid[i][j][k], grid[i - 1][j][k]);
                            links.add(link1);
                        }
                        if (j > 0) {
                            SimpleLink link2 = new SimpleLink(grid[i][j][k], grid[i][j - 1][k]);
                            links.add(link2);
                        }
                        if (k > 0) {
                            SimpleLink link3 = new SimpleLink(grid[i][j][k], grid[i][j][k - 1]);
                            links.add(link3);
                        }
                        if (j <= 0 || i + 1 >= grid.length) continue;
                        SimpleLink link4 = new SimpleLink(grid[i][j][k], grid[i + 1][j - 1][k]);
                        links.add(link4);
                        continue;
                    }
                    SimpleLink link = new SimpleLink(grid[i][j][k], grid[i][j][k - 1]);
                    links.add(link);
                }
            }
        }
        for (i = 0; i < n1; ++i) {
            for (j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    obj = grid[i][j][k];
                    if (links.getLinkOrder(obj) < 6) continue;
                    grid[i][j][k] = null;
                    groupObj.removeChild(obj);
                    links.removeBadLinks(groupObj);
                }
            }
        }
        for (i = 0; i < n1; ++i) {
            for (j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    obj = grid[i][j][k];
                    if (obj == null || links.getLinkOrder(obj) != 0) continue;
                    grid[i][j][k] = null;
                    groupObj.removeChild(obj);
                }
            }
        }
        SimpleObject3DLinkSetBundle result = new SimpleObject3DLinkSetBundle(groupObj, links);
        return result;
    }

    public static Object3DLinkSetBundle generateGraphitGrid(Vector3D startPos, double a, double c, int n1, int n2, String name) {
        int n3 = 2;
        double ang = 1.0471975511965976;
        Vector3D v1 = new Vector3D(1.0, 0.0, 0.0);
        Vector3D v2 = new Vector3D(Math.sin(ang), Math.cos(ang), 0.0);
        Vector3D v3 = new Vector3D(0.0, 0.0, 1.0);
        v1.scale(a);
        v2.scale(a);
        v3.scale(c);
        Object3DLinkSetBundle result = Grid3DTools.generateGraphitGrid(startPos, v1, v2, v3, n1, n2, n3, name);
        return result;
    }

    public static GraphBase generateGraph(Object3D rootNode, LinkSet links) {
        SimpleObject3DSet object3DSet = new SimpleObject3DSet(rootNode);
        int nn = object3DSet.size();
        SimpleGraph graph = new SimpleGraph(nn);
        for (int i = 0; i < nn; ++i) {
            for (int j = i + 1; j < nn; ++j) {
                if (links.find(object3DSet.get(i), object3DSet.get(j)) == null) continue;
                graph.setConnected(i, j, true);
            }
        }
        return graph;
    }

    public static void findCyclicalPaths(Object3D rootNode, LinkSet links, int pathOrder) {
        log.fine("Starting findCyclicalPaths!");
        GraphBase graph = Grid3DTools.generateGraph(rootNode, links);
        SimpleGraphBaseOrderSet graphSet = new SimpleGraphBaseOrderSet(graph, pathOrder);
        log.fine("Generated path set:");
        log.fine(((Object)graphSet).toString());
        for (int i = 0; i < graphSet.size(); ++i) {
            IntegerListList cyclicalPaths = graphSet.getCyclicalPaths(i);
            log.fine("Checking object " + i + " : ");
            if (cyclicalPaths != null && cyclicalPaths.size() > 0) {
                log.fine("Number of cyclical paths of node " + i);
                for (int j = 0; j < cyclicalPaths.size(); ++j) {
                    IntegerList path = cyclicalPaths.get(j);
                    log.fine("Path " + j + " : ");
                    for (int k = 0; k < path.size(); ++k) {
                        log.fine(" " + path.get(k));
                    }
                    log.fine("");
                }
                continue;
            }
            log.fine("No cyclical paths for node " + i);
        }
        log.fine("Finished findCyclicalPaths!");
    }
}

