/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory2;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class GraphBestJunctionFactory
implements Object3DFactory2 {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static final String SCORE_NAME = "score";
    private Object3D nucleotideDB;
    private char c1 = (char)71;
    private char c2 = (char)67;
    private int numBasePairs = 10;
    private int offsetMax = 20;
    private double offsetStep = 1.0;
    private double angleStep = 0.05235987755982988;
    private String rootName = "j";
    private double rotAngle;
    private double planeAngle;
    private int junctionOrder;
    private double collisionPenalty = 100.0;
    private double collisionDistance = 2.0;
    private boolean propagateMode = false;

    public GraphBestJunctionFactory(int numSides, double planeAngle, Object3D nucleotideDB) {
        this.junctionOrder = numSides;
        this.planeAngle = planeAngle;
        this.nucleotideDB = nucleotideDB;
        this.rotAngle = Math.PI * 2 / (double)numSides;
    }

    private Object3DLinkSetBundle generateHelix(double offset, double angle, int n) {
        log.finest("Starting generateHelix " + offset + " " + angle + " " + n);
        CoordinateSystem3D cs = new CoordinateSystem3D(new Vector3D(0.0, 0.0, 0.0));
        cs.translate(Vector3D.EZ.mul(offset));
        log.finest("CS after translation of " + offset + " : " + cs.toString());
        assert (Math.abs(cs.getPosition().getZ() - offset) < 0.01);
        double angZ = angle;
        if (this.propagateMode) {
            angZ = (double)n * this.rotAngle;
        }
        if (angZ != 0.0) {
            cs.rotate(Vector3D.EZ, angZ);
        }
        log.finest("CS after first z-axis rotation of angle: " + angle + " : " + cs.toString());
        double ang = 1.5707963267948966 + this.planeAngle;
        Vector3D axis = new Vector3D(Vector3D.EY);
        assert (axis.getX() == 0.0);
        assert (axis.getY() == 1.0);
        assert (axis.getZ() == 0.0);
        log.finest("Rotating around axis " + axis + " angle: " + Math.toDegrees(ang));
        cs.rotate(Vector3D.ZVEC, axis, ang);
        if (n != 0) {
            log.finest("Rotating around z-axis " + axis + " angle: " + Math.toDegrees((double)n * this.rotAngle));
            cs.rotate(Vector3D.ZVEC, Vector3D.EZ, (double)n * this.rotAngle);
        }
        log.finest("CS after second rotation: " + cs.toString());
        SimpleBranchDescriptor3D bd = new SimpleBranchDescriptor3D(cs);
        assert (bd.distance(cs) < 0.01);
        assert (Math.abs(bd.getPosition().length() - offset) < 0.1);
        Object3DLinkSetBundle result = this.generateHelix(bd, "h" + (n + 1));
        result.getObject3D().insertChild(bd);
        return result;
    }

    private double scoreTwoHelices(Object3D helix1, Object3D helix2) {
        String[] breakNames = new String[]{"Nucleotide3D"};
        Object3DSet strands1 = Object3DTools.collectByClassName(helix1, "RnaStrand", breakNames);
        Object3DSet strands2 = Object3DTools.collectByClassName(helix2, "RnaStrand", breakNames);
        assert (strands1.size() == 2);
        assert (strands2.size() == 2);
        RnaStrand strand1 = (RnaStrand)strands1.get(0);
        RnaStrand strand2 = (RnaStrand)strands1.get(1);
        double score = strand1.getResidue3D(0).getChild("O3*").distance(strand2.getResidue3D(strand2.getResidueCount() - 1).getChild("P"));
        int numColl = AtomTools.countExternalCollisions(helix1, helix2, this.collisionDistance);
        return score += (double)numColl * this.collisionPenalty;
    }

    private boolean verifyBranchDescriptors(List<BranchDescriptor3D> bdList) {
        int i;
        System.out.println("BranchDescriptors: ");
        for (i = 0; i < bdList.size(); ++i) {
            BranchDescriptor3D bd = bdList.get(i);
            System.out.println(bd.getPosition() + " " + bd.getDirection());
        }
        for (i = 0; i < bdList.size(); ++i) {
            BranchDescriptor3D bd1 = bdList.get(i);
            for (int j = i + 1; j < bdList.size(); ++j) {
                BranchDescriptor3D bd2 = bdList.get(j);
                if (!(bd1.distance(bd2) < 0.1)) continue;
                return false;
            }
        }
        return true;
    }

    private Object3DLinkSetBundle generateHelices(double offset, double angle) {
        assert (this.junctionOrder >= 2);
        SimpleObject3D root = new SimpleObject3D(this.rootName);
        SimpleLinkSet links = new SimpleLinkSet();
        ArrayList<BranchDescriptor3D> bdList = new ArrayList<BranchDescriptor3D>();
        for (int i = 0; i < this.junctionOrder; ++i) {
            Object3DLinkSetBundle helixBundle = this.generateHelix(offset, angle, i);
            Object3D obj = helixBundle.getObject3D();
            root.insertChild(obj);
            links.merge(helixBundle.getLinks());
            bdList.add((BranchDescriptor3D)obj.getChild(obj.size() - 1));
        }
        root.setProperty(SCORE_NAME, "" + this.scoreTwoHelices(root.getChild(0), root.getChild(1)));
        return new SimpleObject3DLinkSetBundle(root, links);
    }

    private Object3DLinkSetBundle generateBestHelices() {
        log.info("Starting generateBestHelices: " + this.junctionOrder + " angle: " + Math.toDegrees(this.planeAngle));
        Object3DLinkSetBundle bestHelices = null;
        double bestScore = 1.0E10;
        for (int offsetCount = 0; offsetCount < this.offsetMax; ++offsetCount) {
            double angle;
            double offset = this.offsetStep * (double)offsetCount;
            int angleCountMax = 1 + (int)(Math.PI * 2 / this.angleStep);
            for (int angleCount = 0; angleCount < angleCountMax && !((angle = (double)angleCount * this.angleStep) >= Math.PI * 2); ++angleCount) {
                log.fine("Working on offset, angle: " + offset + " " + Math.toDegrees(angle));
                Object3DLinkSetBundle bundle = this.generateHelices(offset, angle);
                double score = Double.parseDouble(bundle.getObject3D().getProperty(SCORE_NAME));
                if (!(score + 0.001 < bestScore)) continue;
                bestScore = score;
                bestHelices = bundle;
                log.info("New best score found at offset , angle : " + offset + " " + Math.toDegrees(angle) + " : " + score);
            }
        }
        log.info("Finished generateBestHelices with score " + bestScore);
        return bestHelices;
    }

    @Override
    public Object3DLinkSetBundle generate() {
        return this.generateBestHelices();
    }

    private Object3DLinkSetBundle generateHelix(BranchDescriptor3D bd, String helixName) {
        return ConnectJunctionTools.generateIdealStem(bd, this.c1, this.c2, helixName, this.nucleotideDB, this.numBasePairs);
    }

    public double getCollisionDistance() {
        return this.collisionDistance;
    }

    public boolean getPropagateMode() {
        return this.propagateMode;
    }

    public void setCollisionDistance(double x) {
        this.collisionDistance = x;
    }

    public void setPropagateMode(boolean b) {
        this.propagateMode = b;
    }
}

