/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import generaltools.TestTools;
import graphtools.IntegerList;
import graphtools.IntegerListList;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import numerictools.OptimizationNDResult;
import numerictools.SimulatedAnnealingOptimizer;
import org.testng.annotations.Test;
import rnadesign.rnamodel.BioPolymerTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.IncomingNomenclature;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.LilleyNomenclature;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaPdbReader;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnadesign.rnamodel.SimpleStrandJunction3D;
import rnadesign.rnamodel.StemBasePotential;
import rnadesign.rnamodel.StemTools;
import rnadesign.rnamodel.StrandJunction3D;
import rnasecondary.Stem;
import tools3d.CoordinateSystem;
import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.Matrix4D;
import tools3d.SuperpositionTools;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DSet;

public class BranchDescriptorTools {
    public static double RAD2DEG = 57.29577951308232;
    public static double DEG2RAD = Math.PI / 180;
    public static int junctionOrderMin = 2;
    public static boolean simpleStemDirectionMode = true;
    public static final double JUNCTION_PLAUSIBLE_DIST = 20.0;
    public static final double BRANCH_PLAUSIBLE_DIST = 50.0;
    public static final double KISSING_LOOP_DIST_MAX = 50.0;
    public static final int KISSING_LOOP_INTERNAL_HELIX_MAX = 1;
    public static final double HELIX_CENTER_ASSERTION_DIST = 50.0;
    public static final int STEM_FIND_ITER_MAX = 20;
    public static final String REF_ATOM_NAME = "C4*";
    public static final String REF_ATOM_NAME_ALT = "C4'";
    public static int residueRange = 30;
    public static final int STEM_ORIENTATION_ARRAY_LEN = 9;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static final int JUNCTION_PATH_ITER_MAX = 500;
    static int debugLevel = 2;

    public static Vector3D computeDirection(BranchDescriptor3D branch) {
        Vector3D p1 = BioPolymerTools.computeDirection(branch.getOutgoingStrand(), branch.getOutgoingIndex());
        Vector3D p2 = BioPolymerTools.computeDirection(branch.getIncomingStrand(), branch.getIncomingIndex());
        p1.sub(p2);
        p1.normalize();
        return p1;
    }

    public static double computeBranchDescriptorAngle(BranchDescriptor3D b1, BranchDescriptor3D b2) {
        return b1.getDirection().angle(b2.getDirection());
    }

    public static Matrix4D computeBranchDescriptorTransformation(BranchDescriptor3D b1, BranchDescriptor3D b2) {
        Matrix4D m1 = b1.getCoordinateSystem().generateMatrix4D();
        Matrix4D m2 = b2.getCoordinateSystem().generateMatrix4D();
        return m1.inverse().multiply(m2);
    }

    public static Matrix4D computeBranchDescriptorInvertedTransformation(Matrix4D m, int propagation) {
        CoordinateSystem3D cs = new CoordinateSystem3D(m);
        assert (Math.abs(cs.getX().length() - 1.0) < 0.1);
        assert (Math.abs(cs.getY().length() - 1.0) < 0.1);
        assert (Math.abs(cs.getZ().length() - 1.0) < 0.1);
        if (propagation != 0) {
            cs.translate(cs.getZ().mul((double)propagation * RnaConstants.HELIX_RISE));
            double ang = (double)propagation * (Math.PI * 2 / RnaConstants.HELIX_BASE_PAIRS_PER_TURN);
            cs.rotate(cs.getZ(), ang);
        }
        Vector3D newZ = cs.getZ().mul(-1.0);
        Vector3D newX = Matrix3DTools.rotate(cs.getX(), cs.getZ(), RnaConstants.HELIX_PHASE_OFFSET);
        assert (Math.abs(newX.length() - 1.0) < 0.1);
        Vector3D newY = newZ.cross(newX);
        Vector3D newBase = cs.getPosition().plus(cs.getZ().mul(RnaConstants.HELIX_OFFSET));
        return new CoordinateSystem3D(newBase, newX, newY).generateMatrix4D();
    }

    public static Matrix4D computeBranchDescriptorFlippedTransformation(BranchDescriptor3D b1, BranchDescriptor3D b2) {
        Matrix4D m1 = b1.getCoordinateSystem().generateMatrix4D();
        Matrix4D m2 = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(b2.getCoordinateSystem().generateMatrix4D(), 1);
        return m1.inverse().multiply(m2);
    }

    @Test(groups={"fast"})
    public void testComputeBranchDescriptorInvertedTransformation() {
        Matrix3D m3 = new Matrix3D(1.0);
        Vector3D v = new Vector3D(1.0, 2.0, 3.0);
        Matrix4D m4 = new Matrix4D(m3, v);
        assert (m4.isHomogenous());
        Matrix4D m4b = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(m4, 1);
        Matrix4D m4c = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(m4b, 1);
        assert (m4c.isHomogenous());
        assert (m4.minus(m4c).norm() < 0.01);
    }

    public static Matrix4D computeBranchDescriptorInvertedTransformation(BranchDescriptor3D b1, BranchDescriptor3D b2, int propagation) {
        Matrix4D m1 = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(b1.getCoordinateSystem().generateMatrix4D(), propagation);
        Matrix4D m2 = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(b2.getCoordinateSystem().generateMatrix4D(), propagation);
        return m1.inverse().multiply(m2);
    }

    public static void invertBranchDescriptor(BranchDescriptor3D b, int propagation) {
        CoordinateSystem origCs = b.getCoordinateSystem();
        Matrix4D origMatrix = origCs.generateMatrix4D();
        Vector3D origPos = origCs.getPosition();
        Vector3D oldDirection = origCs.getZ();
        Matrix4D mNew = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(origMatrix, propagation);
        Matrix4D mTransf = mNew.multiply(origMatrix.inverse());
        b.activeTransform(new CoordinateSystem3D(mTransf));
        Vector3D newPos = b.getCoordinateSystem().getPosition();
        Vector3D newDirection = b.getCoordinateSystem().getZ();
        double dist = origPos.distance(newPos);
        double slop = 5.0;
        assert (dist < slop + Math.abs(RnaConstants.HELIX_OFFSET) + (double)propagation * RnaConstants.HELIX_RISE);
        assert (oldDirection.angle(newDirection) > Math.toRadians(177.0));
    }

    private static double[] findStemBaseAndDirection(RnaStem3D stem, double rmsTolerance) throws FittingException {
        Stem stemInfo = stem.getStemInfo();
        int len = stemInfo.size();
        StemBasePotential stemBasePotential = new StemBasePotential(stem);
        SimulatedAnnealingOptimizer optimizer = new SimulatedAnnealingOptimizer();
        optimizer.setIterMax(2000);
        optimizer.setStepWidth(2.0);
        double[] scalings = new double[]{1.0, 1.0, 1.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
        double[] bestResult = new double[9];
        double bestValue = 999.0;
        for (int i = 0; i < 20; ++i) {
            String usedRefName1 = REF_ATOM_NAME;
            String usedRefName2 = REF_ATOM_NAME;
            if (stem.getStartResidue(0).getIndexOfChild(usedRefName1) < 0) {
                usedRefName1 = REF_ATOM_NAME_ALT;
            }
            if (stem.getStartResidue(len - 1).getIndexOfChild(usedRefName2) < 0) {
                usedRefName2 = REF_ATOM_NAME_ALT;
            }
            if (stem.getStartResidue(0).getIndexOfChild(usedRefName1) < 0) {
                throw new FittingException("Could not find atom with name: C4* or C4' in residue " + stem.getStartResidue(0).getName());
            }
            if (stem.getStartResidue(len - 1).getIndexOfChild(usedRefName2) < 0) {
                throw new FittingException("Could not find atom with name: C4* or C4' in residue " + stem.getStartResidue(len - 1).getName());
            }
            Vector3D fiveStartPosition = stem.getStartResidue(0).getChild(usedRefName1).getPosition().plus(SuperpositionTools.generateRandomVector(5.0));
            Vector3D fiveEndPosition = stem.getStartResidue(len - 1).getChild(usedRefName2).getPosition().plus(SuperpositionTools.generateRandomVector(5.0));
            Vector3D z = fiveEndPosition.minus(fiveStartPosition);
            assert (z.lengthSquare() > 0.0);
            z.normalize();
            Vector3D x = Vector3DTools.generateRandomOrthogonalDirection(z);
            x.normalize();
            Vector3D y = z.cross(x);
            y.normalize();
            double[] v = new double[9];
            fiveStartPosition.setArray(v, 0);
            x.setArray(v, 3);
            y.setArray(v, 6);
            OptimizationNDResult optimizationResult = optimizer.optimize(stemBasePotential, v);
            double[] result = optimizationResult.getBestPosition();
            if (i == 0 || optimizationResult.getBestValue() < bestValue) {
                bestValue = optimizationResult.getBestValue();
                for (int j = 0; j < bestResult.length; ++j) {
                    bestResult[j] = result[j];
                }
                if (bestValue < rmsTolerance) break;
            }
            if (i != 20) continue;
            log.info("Max Reached.");
        }
        assert (bestResult.length == 9);
        if (bestValue > rmsTolerance) {
            log.fine("Bad stem fit encountered!");
            throw new FittingException("Could not find stem position!");
        }
        return bestResult;
    }

    private static CoordinateSystem findStemCoordinateSystem(RnaStem3D stem, double rmsTolerance) throws FittingException {
        double[] csArray = BranchDescriptorTools.findStemBaseAndDirection(stem, rmsTolerance);
        assert (csArray.length == 9);
        return new CoordinateSystem3D(csArray);
    }

    private static Vector3D findStemBaseBackwards(RnaStem3D stem, Vector3D base, Vector3D directionOrig, int offset) {
        assert (offset < stem.getLength());
        assert (base != null);
        assert (directionOrig != null);
        assert (directionOrig.lengthSquare() > 0.0);
        Vector3D dir = new Vector3D(directionOrig);
        double newLength = RnaConstants.HELIX_RISE * (double)(stem.getLength() - offset);
        Vector3D newBase = base.plus(dir.mul(newLength));
        return newBase;
    }

    private static String generateBranchDescriptorResidueName(Residue3D residue) {
        char symbol = residue.getSymbol().getCharacter();
        return "" + symbol;
    }

    public static String generateBranchDescriptorStrandName(BranchDescriptor3D bd) {
        String outStrandName;
        NucleotideStrand inStrand = bd.getIncomingStrand();
        NucleotideStrand outStrand = bd.getOutgoingStrand();
        String inStrandName = inStrand.getProperty("pdb_chain_char");
        if (inStrandName == null) {
            inStrandName = inStrand.getName();
        }
        if ((outStrandName = outStrand.getProperty("pdb_chain_char")) == null) {
            outStrandName = outStrand.getName();
        }
        Residue3D inResidue = inStrand.getResidue3D(bd.getIncomingIndex() + bd.getOffset());
        Residue3D outResidue = outStrand.getResidue3D(bd.getOutgoingIndex() - bd.getOffset());
        char inChar = inResidue.getSymbol().getCharacter();
        char outChar = outResidue.getSymbol().getCharacter();
        String result = inStrandName + "_" + inChar + inResidue.getAssignedNumber() + "_" + outStrandName + "_" + outChar + outResidue.getAssignedNumber();
        return result;
    }

    public static CoordinateSystem generatePropagatedBranchDescriptorCoordinateSystem(BranchDescriptor3D branchOrig, int n) {
        BranchDescriptor3D branch = (BranchDescriptor3D)branchOrig.cloneDeep();
        HelixParameters prm = branchOrig.getHelixParameters();
        double rise = prm.rise;
        branch.translate(branch.getDirection().mul((double)n * rise));
        double angTarget = Math.PI * 2 / prm.basePairsPerTurn;
        branch.rotate(branch.getDirection(), angTarget);
        return branch.getCoordinateSystem();
    }

    private static Object3DSet generateBranchDescriptors(RnaStem3D stem, int branchDescriptorOffset, double rmsTolerance) throws FittingException {
        NucleotideStrand strand1 = stem.getStrand1();
        NucleotideStrand strand2 = stem.getStrand2();
        int offs = branchDescriptorOffset;
        int length = stem.getLength();
        SimpleObject3DSet objectSet = new SimpleObject3DSet();
        if (stem.getStemInfo().getStopPos() >= offs && stem.getStemInfo().getStartPos() + offs < strand1.size()) {
            CoordinateSystem cs = BranchDescriptorTools.findStemCoordinateSystem(stem, rmsTolerance);
            cs.translate(cs.getZ().mul(RnaConstants.HELIX_RISE * (double)offs));
            double ang = Math.PI * 2 / RnaConstants.HELIX_BASE_PAIRS_PER_TURN * (double)offs;
            cs.rotate(cs.getZ(), ang);
            SimpleBranchDescriptor3D branch1 = new SimpleBranchDescriptor3D(strand2, strand1, stem.getStemInfo().getStopPos() - offs, stem.getStemInfo().getStartPos() + offs, cs);
            branch1.setOffset(branchDescriptorOffset);
            assert (branch1.isValid());
            objectSet.add(branch1);
            stem.insertChild(branch1);
            assert (Object3DSetTools.distanceMin((Object3D)branch1, stem) < 50.0);
        }
        int off2 = length - offs - 1;
        if (stem.getStemInfo().getStartPos() + off2 < strand1.size() && stem.getStemInfo().getStopPos() - off2 >= 0 && stem.getStemInfo().getStartPos() + off2 >= 0 && stem.getStemInfo().getStopPos() - off2 < strand2.size()) {
            CoordinateSystem cs2 = BranchDescriptorTools.findStemCoordinateSystem(stem.generateReverseStem(), rmsTolerance);
            cs2.translate(cs2.getZ().mul(RnaConstants.HELIX_RISE * (double)offs));
            double ang = Math.PI * 2 / RnaConstants.HELIX_BASE_PAIRS_PER_TURN * (double)offs;
            cs2.rotate(cs2.getZ(), ang);
            SimpleBranchDescriptor3D branch2 = new SimpleBranchDescriptor3D(strand1, strand2, stem.getStemInfo().getStartPos() + off2, stem.getStemInfo().getStopPos() - off2, cs2);
            branch2.setOffset(branchDescriptorOffset);
            assert (branch2.isValid());
            objectSet.add(branch2);
            stem.insertChild(branch2);
            assert (Object3DSetTools.distanceMin((Object3D)branch2, stem) < 50.0);
        }
        assert (objectSet.size() == 2);
        return objectSet;
    }

    @Test(groups={"fast"})
    public void testGenerateBranchDescriptors() {
    }

    @Test(groups={"slow", "new"})
    public void testGenerateBranchDescriptorsSlow() {
        block13: {
            log.info(TestTools.generateMethodHeader("testGenerateBranchDescriptorsSlow"));
            int offset = 2;
            double rmsTolerance = 3.0;
            RnaPdbReader reader = new RnaPdbReader();
            Object stem = null;
            try {
                ResourceBundle rb = ResourceBundle.getBundle("JunctionScanner");
                assert (rb != null);
                String fileNames = rb.getString("testFileNames");
                assert (fileNames != null);
                StringTokenizer tokens = new StringTokenizer(fileNames, " ,");
                while (tokens.hasMoreTokens()) {
                    String fileName = tokens.nextToken();
                    if (fileName.length() < 2) continue;
                    log.info("Reading file: " + fileName);
                    FileInputStream is = new FileInputStream(fileName);
                    assert (is != null);
                    Object3DLinkSetBundle bundle = reader.readBundle(is);
                    Object3D root = bundle.getObject3D();
                    Object3D stems = StemTools.generateStems(root).getObject3D();
                    log.info("Detected " + stems.size() + " double-helices.");
                    assert (stems.size() > 0);
                    stem = (RnaStem3D)stems.getChild(0);
                    assert (stem.getLength() >= 3);
                    Object3DSet descriptorSet = BranchDescriptorTools.generateBranchDescriptors((RnaStem3D)stem, offset, rmsTolerance);
                    assert (descriptorSet.size() == 2);
                    BranchDescriptor3D branch1 = (BranchDescriptor3D)descriptorSet.get(0);
                    BranchDescriptor3D branch2 = (BranchDescriptor3D)descriptorSet.get(1);
                    log.info("Stem length: " + stem.getLength() + " stem: " + stem.getStemInfo());
                    log.info("Branch descriptor 1: " + branch1.getName() + " " + branch1.getCoordinateSystem());
                    log.info("Branch descriptor 2: " + branch2.getName() + " " + branch2.getCoordinateSystem());
                    double angle = RAD2DEG * branch1.getDirection().angle(branch2.getDirection());
                    assert (angle > 120.0);
                }
            }
            catch (IOException ioe) {
                log.severe(ioe.getMessage());
                assert (false);
            }
            catch (FittingException fe) {
                String tmp = "";
                if (stem != null) {
                    tmp = tmp + stem.toString();
                }
                log.warning("Could not find 3D fit for stem " + tmp);
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        log.info(TestTools.generateMethodFooter("testGenerateBranchDescriptorsSlow"));
    }

    public static Object3DSet generateBranchDescriptors(Object3DSet stems, int branchDescriptorOffset, double rmsTolerance) {
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (int i = 0; i < stems.size(); ++i) {
            Object3D obj = stems.get(i);
            if (!(obj instanceof RnaStem3D)) continue;
            RnaStem3D stem = (RnaStem3D)obj;
            try {
                Object3DSet tmpResult = BranchDescriptorTools.generateBranchDescriptors(stem, branchDescriptorOffset, rmsTolerance);
                result.merge(tmpResult);
                continue;
            }
            catch (FittingException fe) {
                log.fine("Ignoring stem because not able to find good 3D fit : " + stem.getStemInfo().toString());
            }
        }
        return result;
    }

    public static Object3DSet generateInvertedBranchDescriptors(Object3DSet stems, int branchDescriptorOffset, double rmsTolerance, int propagation) {
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (int i = 0; i < stems.size(); ++i) {
            Object3D obj = stems.get(i);
            if (!(obj instanceof RnaStem3D)) continue;
            RnaStem3D stem = (RnaStem3D)obj;
            try {
                Object3DSet tmpResult = BranchDescriptorTools.generateBranchDescriptors(stem, branchDescriptorOffset, rmsTolerance);
                if (tmpResult != null) {
                    for (int j = 0; j < tmpResult.size(); ++j) {
                        BranchDescriptorTools.invertBranchDescriptor((BranchDescriptor3D)tmpResult.get(j), propagation);
                    }
                }
                result.merge(tmpResult);
                continue;
            }
            catch (FittingException fe) {
                log.info("Ignoring stem because not able to find good 3D fit : " + stem.getStemInfo().toString());
            }
        }
        return result;
    }

    private static int[] generateLinkedClusterVector(int[][] mtx) {
        int[] clusterIds = new int[mtx.length];
        for (int i = 0; i < clusterIds.length; ++i) {
            clusterIds[i] = -1;
        }
        int clusterCount = 0;
        for (int i = 0; i < mtx.length; ++i) {
            if (clusterIds[i] < 0) {
                boolean found = false;
                for (int j = 0; j < mtx.length; ++j) {
                    if (mtx[i][j] <= 0 || clusterIds[j] < 0) continue;
                    found = true;
                    clusterIds[i] = clusterIds[j];
                    break;
                }
                if (!found) {
                    clusterIds[i] = clusterCount++;
                }
            }
            for (int j = 0; j < mtx.length; ++j) {
                if (i == j || clusterIds[j] >= 0 || mtx[i][j] <= 0) continue;
                clusterIds[j] = clusterIds[i];
            }
        }
        return clusterIds;
    }

    private static int[] generateLinkedClusterVector2(int[][] mtx) {
        int[] clusterIds = new int[mtx.length];
        for (int i = 0; i < clusterIds.length; ++i) {
            clusterIds[i] = -1;
        }
        int clusterCount = 0;
        for (int i = 0; i < mtx.length; ++i) {
            if (clusterIds[i] < 0) {
                boolean found = false;
                for (int j = 0; j < mtx.length; ++j) {
                    if (mtx[i][j] <= 0 || clusterIds[j] < 0) continue;
                    found = true;
                    clusterIds[i] = clusterIds[j];
                    break;
                }
                if (!found) {
                    clusterIds[i] = clusterCount++;
                }
            }
            for (int j = 0; j < mtx.length; ++j) {
                if (i == j || clusterIds[j] >= 0 || mtx[i][j] <= 0) continue;
                clusterIds[j] = clusterIds[i];
            }
        }
        return clusterIds;
    }

    private static int findHighestIndex(int[] v) {
        int bestId = 0;
        int bestVal = v[bestId];
        for (int i = 1; i < v.length; ++i) {
            if (v[i] <= bestVal) continue;
            bestVal = v[i];
            bestId = i;
        }
        return bestId;
    }

    private static IntegerListList translateClusterVectorToLists(int[] clusterVector) {
        int i;
        int numClusters = clusterVector[BranchDescriptorTools.findHighestIndex(clusterVector)] + 1;
        IntegerListList clusters = new IntegerListList();
        for (i = 0; i < numClusters; ++i) {
            clusters.add(new IntegerList());
        }
        for (i = 0; i < clusterVector.length; ++i) {
            IntegerList list = clusters.get(clusterVector[i]);
            list.add(i);
        }
        return clusters;
    }

    private static IntegerListList generateLinkedClusters(int[][] mtx) {
        int[] clusterVector = BranchDescriptorTools.generateLinkedClusterVector(mtx);
        return BranchDescriptorTools.translateClusterVectorToLists(clusterVector);
    }

    private static IntegerListList generateLinkedClusters2(int[][] mtx) {
        int[] clusterVector = BranchDescriptorTools.generateLinkedClusterVector2(mtx);
        return BranchDescriptorTools.translateClusterVectorToLists(clusterVector);
    }

    private static int[][] generateCompatibilityMatrix(Object3DSet branchDescriptors) {
        assert (branchDescriptors != null);
        assert (branchDescriptors.size() > 0);
        int nb = branchDescriptors.size();
        int[][] compMatrix = new int[nb][nb];
        for (int i = 0; i < nb; ++i) {
            compMatrix[i][i] = 0;
            for (int j = i + 1; j < nb; ++j) {
                compMatrix[i][j] = BranchDescriptorTools.isCompatible((BranchDescriptor3D)branchDescriptors.get(i), (BranchDescriptor3D)branchDescriptors.get(j)) ? 1 : 0;
                compMatrix[j][i] = compMatrix[i][j];
            }
        }
        assert (compMatrix.length > 0);
        return compMatrix;
    }

    private static IntegerList generateRandomPath(int[][] mtx, int[][] compMatrix, Object3DSet branchDescriptors, Random rand) {
        IntegerList lineList;
        assert (mtx.length > 0);
        assert (compMatrix.length > 0);
        assert (branchDescriptors.size() > 0);
        int nn = compMatrix.length;
        IntegerList result = new IntegerList();
        IntegerListList linked = new IntegerListList();
        for (int i = 0; i < mtx.length; ++i) {
            lineList = new IntegerList();
            for (int j = 0; j < mtx[i].length; ++j) {
                if (mtx[i][j] != 1) continue;
                lineList.add(j);
            }
            linked.add(lineList);
        }
        int curr = rand.nextInt(nn);
        result.add(curr);
        do {
            int succ;
            if ((lineList = linked.get(curr)).size() > 0) {
                int m = rand.nextInt(lineList.size());
                succ = lineList.get(m);
                for (int j = 0; j < result.size(); ++j) {
                    int otherId = result.get(j);
                    if (otherId == succ) {
                        return result;
                    }
                    if (compMatrix[otherId][succ] != 0) continue;
                    return result;
                }
            } else {
                return result;
            }
            result.add(succ);
            curr = succ;
        } while (result.size() < nn);
        return result;
    }

    private static int findSubsequentBranchDescriptor(int id, Object3DSet branchDescriptors, int[][] connMtx, int[][] compMatrix) {
        int bestDiff = 9999;
        int bestId = -1;
        for (int j = 0; j < connMtx.length; ++j) {
            int diff;
            if (j == id || !BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, id, j) || compMatrix[id][j] <= 0 || (diff = ((BranchDescriptor3D)branchDescriptors.get(j)).getOutgoingIndex() - ((BranchDescriptor3D)branchDescriptors.get(id)).getIncomingIndex()) <= 0 || diff >= bestDiff) continue;
            bestDiff = diff;
            bestId = j;
        }
        return bestId;
    }

    private static IntegerListList generateShortestPaths(int[][] mtx, Object3DSet branchDescriptors) {
        assert (mtx.length > 0);
        assert (branchDescriptors.size() > 0);
        int nn = branchDescriptors.size();
        IntegerListList finalResult = new IntegerListList();
        int[][] compMatrix = BranchDescriptorTools.generateCompatibilityMatrix(branchDescriptors);
        block0: for (int curr = 0; curr < nn; ++curr) {
            int succ2;
            IntegerList result = new IntegerList();
            result.add(curr);
            int succ = curr;
            while ((succ2 = BranchDescriptorTools.findSubsequentBranchDescriptor(succ, branchDescriptors, mtx, compMatrix)) != succ && succ2 >= 0 && compMatrix[succ2][succ] != 0) {
                int j;
                if (succ2 == curr) {
                    result = result.rotateToSmallest();
                    boolean found = false;
                    for (j = 0; j < finalResult.size(); ++j) {
                        IntegerList otherPath = finalResult.get(j);
                        if (!otherPath.equals(result)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue block0;
                    finalResult.add(result);
                    continue block0;
                }
                boolean dupFound = false;
                for (j = 1; j < result.size(); ++j) {
                    int otherId = result.get(j);
                    if (otherId != succ2) continue;
                    dupFound = true;
                    break;
                }
                if (dupFound) continue block0;
                result.add(succ2);
                succ = succ2;
                if (result.size() < nn) continue;
            }
        }
        return finalResult;
    }

    private static IntegerListList generateLinkedClusters3(int[][] mtx, Object3DSet branchDescriptors, int iterMax) {
        assert (mtx.length > 0);
        assert (branchDescriptors.size() > 0);
        Random rnd = Randomizer.getInstance();
        int nb = branchDescriptors.size();
        int[][] compMatrix = BranchDescriptorTools.generateCompatibilityMatrix(branchDescriptors);
        IntegerListList paths = new IntegerListList();
        for (int i = 0; i < iterMax; ++i) {
            IntegerList path = BranchDescriptorTools.generateRandomPath(mtx, compMatrix, branchDescriptors, rnd);
            boolean found = false;
            for (int j = 0; j < paths.size(); ++j) {
                IntegerList otherPath = paths.get(j);
                if (!otherPath.containsAll(path)) continue;
                found = true;
                break;
            }
            if (found) continue;
            paths.add(path);
        }
        return paths;
    }

    private static IntegerListList generateLinkedClusters4(int[][] mtx, Object3DSet branchDescriptors, int iterMax) {
        assert (mtx.length > 0);
        assert (branchDescriptors.size() > 0);
        Random rnd = Randomizer.getInstance();
        int nb = branchDescriptors.size();
        int[][] compMatrix = BranchDescriptorTools.generateCompatibilityMatrix(branchDescriptors);
        IntegerListList paths = new IntegerListList();
        IntegerListList rotatedPaths = new IntegerListList();
        for (int i = 0; i < iterMax; ++i) {
            IntegerList path = BranchDescriptorTools.generateRandomPath(mtx, compMatrix, branchDescriptors, rnd);
            assert (path.isUnique());
            if (path.size() > 1) assert (BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, path.get(0), path.get(1)));
            IntegerList rotPath = new IntegerList(path);
            rotPath = rotPath.rotateToSmallest();
            boolean found = false;
            for (int j = 0; j < rotatedPaths.size(); ++j) {
                IntegerList otherPath = paths.get(j);
                if (!otherPath.equals(rotPath)) continue;
                found = true;
                break;
            }
            if (found) continue;
            paths.add(path);
            rotatedPaths.add(rotPath);
        }
        return paths;
    }

    private static boolean isAllowedPosition(BranchDescriptor3D d, int n) {
        if (!d.isSingleSequence()) {
            return true;
        }
        if (d.getOutgoingIndex() > d.getIncomingIndex()) {
            return n < d.getOutgoingIndex() && n > d.getIncomingIndex();
        }
        return n >= d.getOutgoingIndex() || n <= d.getIncomingIndex();
    }

    private static boolean isCompatibleHalf(BranchDescriptor3D d1, BranchDescriptor3D d2) {
        if (d1.isSingleSequence()) {
            int n1 = d2.getIncomingIndex();
            if (d1.getIncomingStrand() == d2.getIncomingStrand() && !BranchDescriptorTools.isAllowedPosition(d1, n1)) {
                return false;
            }
            int n2 = d2.getOutgoingIndex();
            if (d1.getIncomingStrand() == d2.getOutgoingStrand() && !BranchDescriptorTools.isAllowedPosition(d1, n2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isCompatible(BranchDescriptor3D d1, BranchDescriptor3D d2) {
        return d1.distance(d2) <= 50.0 && BranchDescriptorTools.isCompatibleHalf(d1, d2) && BranchDescriptorTools.isCompatibleHalf(d2, d1);
    }

    private static boolean isConnectedIncomingOutgoing(Object3DSet branchDescriptors, int n1, int n2) {
        NucleotideStrand outgoing;
        assert (n1 != n2);
        BranchDescriptor3D d1 = (BranchDescriptor3D)branchDescriptors.get(n1);
        BranchDescriptor3D d2 = (BranchDescriptor3D)branchDescriptors.get(n2);
        RnaStem3D parent1 = (RnaStem3D)d1.getParent();
        Stem stemInfo1 = parent1.getStemInfo();
        String fullStem1Name = Object3DTools.getFullName(parent1);
        RnaStem3D parent2 = (RnaStem3D)d2.getParent();
        String fullStem2Name = Object3DTools.getFullName(parent2);
        if (parent1 != null && parent1 == parent2) {
            log.fine("Branch Descriptors belong to same stem! Quitting!");
            return false;
        }
        NucleotideStrand incoming = d1.getIncomingStrand();
        if (incoming != (outgoing = d2.getOutgoingStrand())) {
            log.fine("BranchDescriptors are not connected because their strands are different!");
            return false;
        }
        int resDiff = d2.getOutgoingIndex() - d1.getIncomingIndex();
        if (resDiff <= 0 || resDiff > residueRange) {
            log.fine("Branch descriptors are not connected because of wrong residue difference: " + resDiff);
            return false;
        }
        if (stemInfo1.isSingleSequence() && d1.getOutgoingIndex() < d2.getOutgoingIndex() && d1.getOutgoingIndex() > d1.getIncomingIndex()) {
            log.fine("Branch Descriptors are connect because of special case!");
            return false;
        }
        log.fine("BranchDescriptors are connected! " + resDiff);
        return true;
    }

    private static IntegerListList clusterBranchDescriptors(Object3DSet branchDescriptors, int iterMax) {
        assert (branchDescriptors.size() > 0);
        int n = branchDescriptors.size();
        int[][] mtx = new int[n][n];
        for (int i = 0; i < mtx.length; ++i) {
            for (int j = i + 1; j < mtx.length; ++j) {
                mtx[i][j] = BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, i, j) ? 1 : 0;
                mtx[j][i] = BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, j, i) ? 1 : 0;
            }
        }
        IntegerListList result = BranchDescriptorTools.generateShortestPaths(mtx, branchDescriptors);
        assert (result.size() == 0 || result.get(0).size() < 2 || BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, result.get(0).get(0), result.get(0).get(1)));
        return result;
    }

    public static void adjustBranchDescriptorPair(BranchDescriptor3D bIn, BranchDescriptor3D bOut) {
        assert (!bIn.isProbablyEqual(bOut));
        assert (bIn.getIncomingStrand().sequenceString().equals(bOut.getOutgoingStrand().sequenceString()));
        assert (bIn.isValid());
        assert (bOut.isValid());
        NucleotideStrand strandClone = (NucleotideStrand)bIn.getIncomingStrand().cloneDeep();
        bIn.setIncomingStrand(strandClone);
        bOut.setOutgoingStrand(strandClone);
        assert (bIn.getIncomingStrand() != bIn.getOutgoingStrand());
        assert (bOut.getIncomingStrand() != bOut.getOutgoingStrand());
        Residue3D incRes = bIn.getIncomingStrand().getResidue3D(bIn.getIncomingIndex());
        Residue3D outRes = bIn.getOutgoingStrand().getResidue3D(bIn.getOutgoingIndex());
        int startId = bIn.getIncomingIndex();
        int stopId = bOut.getOutgoingIndex();
        int desiredLen = stopId - startId + 1;
        int desiredRemoved = strandClone.size() - desiredLen;
        String newName = strandClone.getName() + "_" + (startId + 1) + "-" + (stopId + 1);
        strandClone.setName(newName);
        int removeCounterEnd = 0;
        int removeCounterStart = 0;
        int newStart = bIn.getIncomingIndex() - removeCounterStart;
        int newStop = bOut.getOutgoingIndex() - removeCounterStart;
        if (startId < stopId) {
            int ii;
            for (ii = strandClone.size() - 1; ii >= stopId + 1; --ii) {
                assert (strandClone.size() > 0);
                assert (strandClone.size() - 1 > stopId);
                strandClone.removeChild(strandClone.size() - 1);
                ++removeCounterEnd;
                bOut.setOutgoingStrand(strandClone);
            }
            for (ii = startId - 1; ii >= 0; --ii) {
                assert (ii < strandClone.size());
                strandClone.removeChild(0);
                bIn.setIncomingStrand(strandClone);
                bIn.setIncomingIndex(bIn.getIncomingIndex() - 1);
                bOut.setOutgoingIndex(bOut.getOutgoingIndex() - 1);
                bOut.setOutgoingStrand(strandClone);
                ++removeCounterStart;
            }
        } else if (startId > stopId) {
            return;
        }
        newStart = bIn.getIncomingIndex();
        newStop = bOut.getOutgoingIndex();
        bIn.setIncomingIndex(newStart);
        bOut.setOutgoingIndex(newStop);
        bIn.setIncomingStrand(strandClone);
        bOut.setOutgoingStrand(strandClone);
        Residue3D incRes2 = bIn.getIncomingStrand().getResidue3D(bIn.getIncomingIndex());
        assert (incRes.isProbablyEqual(incRes2));
        int newLen = newStop - newStart + 1;
        assert (bIn.isValid());
        assert (bOut.isValid());
        assert (bIn.getIncomingIndex() == 0);
    }

    public static void adjustBranchDescriptorLoop(BranchDescriptor3D b) {
        assert (b.isSingleSequence());
        NucleotideStrand strandClone = (NucleotideStrand)b.getIncomingStrand().cloneDeep();
        int startId = b.getIncomingIndex();
        int stopId = b.getOutgoingIndex();
        String newName = strandClone.getName() + "_" + (startId + 1) + "-" + (stopId + 1);
        strandClone.setName(newName);
        int removeCounter = 0;
        if (startId < stopId) {
            int ii;
            for (ii = strandClone.size() - 1; ii >= stopId + 1; --ii) {
                strandClone.removeChild(ii);
            }
            for (ii = startId - 1; ii >= 0; --ii) {
                assert (ii < strandClone.size());
                strandClone.removeChild(ii);
                ++removeCounter;
            }
        } else if (startId > stopId) {
            // empty if block
        }
        int newStart = b.getIncomingIndex() - removeCounter;
        assert (newStart >= 0);
        int newStop = b.getOutgoingIndex() - removeCounter;
        b.setIncomingIndex(newStart);
        b.setOutgoingIndex(newStop);
        b.setIncomingStrand(strandClone);
        b.setOutgoingStrand(strandClone);
    }

    private static int findConnectedBranchDescriptor(Object3DSet branchCluster, int n) {
        BranchDescriptor3D b = (BranchDescriptor3D)branchCluster.get(n);
        for (int i = 0; i < branchCluster.size(); ++i) {
            if (i == n || !BranchDescriptorTools.isConnectedIncomingOutgoing(branchCluster, n, i)) continue;
            return i;
        }
        return branchCluster.size();
    }

    private static boolean isProbablyEqual(Residue3D res1, Residue3D res2) {
        if (res1.size() != res2.size()) {
            return false;
        }
        if (!res1.getName().equals(res2.getName())) {
            return false;
        }
        return !(res1.distance(res2) > 0.001);
    }

    private static boolean isPartOfStrand(NucleotideStrand strand, Residue3D residue, int startIndex, int stopIndex) {
        int pos = residue.getPos();
        return residue.isSameSequence(strand.getResidue(0)) && pos >= startIndex && pos <= stopIndex;
    }

    private static boolean isInternalHelix(NucleotideStrand strand, BranchDescriptor3D branchDescriptor, int startIndex, int stopIndex) {
        int offset = branchDescriptor.getOffset();
        Residue3D inResidue = branchDescriptor.getIncomingStrand().getResidue3D(branchDescriptor.getIncomingIndex() + offset + 1);
        Residue3D outResidue = branchDescriptor.getOutgoingStrand().getResidue3D(branchDescriptor.getOutgoingIndex() - offset - 1);
        return BranchDescriptorTools.isPartOfStrand(strand, inResidue, startIndex, stopIndex) || BranchDescriptorTools.isPartOfStrand(strand, outResidue, startIndex, stopIndex);
    }

    private static boolean isInternalHelix(StrandJunction3D junction, BranchDescriptor3D branchDescriptor) {
        int strandCount = junction.getStrandCount();
        int offset = branchDescriptor.getOffset();
        int i = 0;
        while (strandCount < junction.getStrandCount()) {
            NucleotideStrand strand = junction.getStrand(i);
            int startIndex = offset + 1;
            int stopIndex = strand.getResidueCount() - offset - 2;
            assert (stopIndex >= 0);
            if (stopIndex >= startIndex && junction.getLoopLength(i) >= 3 && BranchDescriptorTools.isInternalHelix(strand, branchDescriptor, startIndex, stopIndex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean junctionHasInternalHelices(StrandJunction3D junction, Object3DSet branchDescriptors) {
        assert (false);
        for (int i = 0; i < branchDescriptors.size(); ++i) {
            if (!BranchDescriptorTools.isInternalHelix(junction, (BranchDescriptor3D)branchDescriptors.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isInternalStem(Stem stem, int offset) {
        if (stem.getStartPos() >= offset + 1 && stem.getStopPos() <= stem.getSequence1().size() - offset - 2) {
            return true;
        }
        return stem.getStopPos() >= offset + 1 && stem.getStopPos() <= stem.getSequence2().size() - offset - 2;
    }

    private static boolean junctionHasInternalHelices(StrandJunction3D junction) {
        int i;
        int offset = junction.getBranch(0).getOffset();
        SimpleObject3DSet allStems = new SimpleObject3DSet();
        for (i = 0; i < junction.getStrandCount(); ++i) {
            NucleotideStrand strand1 = junction.getStrand(i);
            for (int j = i + 1; j < junction.getStrandCount(); ++j) {
                NucleotideStrand strand2 = junction.getStrand(j);
                Object3DSet stems = StemTools.generateStems(strand1, strand2, "s_" + (i + 1) + "_" + (j + 1));
                allStems.merge(stems);
            }
        }
        for (i = 0; i < allStems.size(); ++i) {
            RnaStem3D stem = (RnaStem3D)allStems.get(i);
            if (!BranchDescriptorTools.isInternalStem(stem.getStemInfo(), offset)) continue;
            return true;
        }
        return false;
    }

    private static Object3DSet generateJunctions(Object3DSet branchDescriptors, CorridorDescriptor corridorDescriptor, int iterMax, int loopLengthSumMax) {
        log.fine("Starting generateJunctions (4) with corridorDescriptor " + corridorDescriptor);
        LilleyNomenclature lilleyNomenclature = new LilleyNomenclature();
        IncomingNomenclature incomingNomenclature = new IncomingNomenclature();
        if (branchDescriptors.size() == 0) {
            log.fine("No branch descriptors defined, returning empty set of junctions!");
            return new SimpleObject3DSet();
        }
        for (int i = 0; i < branchDescriptors.size(); ++i) {
            BranchDescriptor3D bd = (BranchDescriptor3D)branchDescriptors.get(i);
        }
        log.fine("Starting to cluster branch descriptors...");
        IntegerListList clusters = BranchDescriptorTools.clusterBranchDescriptors(branchDescriptors, iterMax);
        log.fine("Finished clustering branch descriptors: " + clusters.size());
        for (int i = 0; i < branchDescriptors.size(); ++i) {
        }
        SimpleObject3DSet result = new SimpleObject3DSet();
        HashSet<String> resultJunctionNames = new HashSet<String>();
        for (int i = 0; i < clusters.size(); ++i) {
            int j;
            boolean skipJunctionFlag = false;
            SimpleObject3DSet branchCluster = new SimpleObject3DSet();
            SimpleObject3DSet branchClonedCluster = new SimpleObject3DSet();
            IntegerList cluster = clusters.get(i);
            assert (cluster.isUnique());
            if (cluster.size() > 1) assert (BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, cluster.get(0), cluster.get(1)));
            if (debugLevel > 1) {
                for (int k = 0; k < cluster.size(); ++k) {
                }
            }
            for (j = 0; j < cluster.size(); ++j) {
                branchClonedCluster.add((Object3D)branchDescriptors.get(cluster.get(j)).cloneDeep());
                branchCluster.add(branchDescriptors.get(cluster.get(j)));
            }
            if (branchClonedCluster.size() > 1) {
                for (j = 0; j < branchClonedCluster.size(); ++j) {
                    int jj2 = j;
                    int jj1 = j - 1;
                    if (j == 0) {
                        jj1 = branchClonedCluster.size() - 1;
                    } else {
                        assert (BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, cluster.get(jj1), cluster.get(jj2)));
                        assert (BranchDescriptorTools.isConnectedIncomingOutgoing(branchCluster, jj1, jj2));
                    }
                    assert (jj1 != jj2);
                    BranchDescriptor3D b1 = (BranchDescriptor3D)branchClonedCluster.get(jj1);
                    BranchDescriptor3D b2 = (BranchDescriptor3D)branchClonedCluster.get(jj2);
                    if (!b1.getIncomingStrand().sequenceString().equals(b2.getOutgoingStrand().sequenceString())) {
                        log.fine("Different strands, even though they should be the same: " + b1.getIncomingStrand().sequenceString() + " " + b2.getOutgoingStrand().sequenceString() + " " + jj1 + " " + jj2);
                        skipJunctionFlag = true;
                        break;
                    }
                    assert (b1.getIncomingStrand().sequenceString().equals(b2.getOutgoingStrand().sequenceString()));
                    BranchDescriptorTools.adjustBranchDescriptorPair(b1, b2);
                }
                if (skipJunctionFlag) {
                    log.fine("Skipping ill defined junction!");
                    skipJunctionFlag = false;
                    continue;
                }
                SimpleStrandJunction3D junction = new SimpleStrandJunction3D(branchClonedCluster);
                if (!junction.isValid()) {
                    log.fine("Junction was not valid, skipping");
                    continue;
                }
                String incomingName = incomingNomenclature.generateNomenclature(junction);
                if (junction.getBranchCount() >= junctionOrderMin && junction.isValid() && !resultJunctionNames.contains(incomingName)) {
                    log.fine("Important junction test: corridor: " + junction.corridorCheck(corridorDescriptor) + " " + corridorDescriptor + " looplength sum: " + LilleyNomenclature.computeLoopLengthSum(junction) + " nomenclature: " + lilleyNomenclature.generateNomenclature(junction));
                    if (junction.corridorCheck(corridorDescriptor) && LilleyNomenclature.computeLoopLengthSum(junction) <= loopLengthSumMax && LilleyNomenclature.computeLoopLengthSum(junction) >= 0 && lilleyNomenclature.generateNomenclature(junction).length() > 0) {
                        if (BranchDescriptorTools.junctionHasInternalHelices(junction)) {
                            junction.setInternalHelices(true);
                        } else {
                            junction.setInternalHelices(false);
                        }
                        result.add(junction);
                        resultJunctionNames.add(incomingName);
                        if (debugLevel <= 1) continue;
                        continue;
                    }
                    log.fine("Ignoring junction " + junction.getName() + " because corridor test failed." + corridorDescriptor);
                    continue;
                }
                log.info("Warning: generated junction was not valid!");
                continue;
            }
            log.fine("BranchCloneCluster too small " + cluster.size());
        }
        int singleCount = 0;
        for (int i = 0; i < branchDescriptors.size(); ++i) {
            BranchDescriptor3D branch = (BranchDescriptor3D)branchDescriptors.get(i);
            if (!branch.isSingleSequence() || branch.getOutgoingIndex() <= branch.getIncomingIndex()) continue;
            BranchDescriptor3D branchClone = (BranchDescriptor3D)branchDescriptors.get(i).cloneDeep();
            SimpleObject3DSet branchSet = new SimpleObject3DSet();
            branchSet.add(branchClone);
            SimpleStrandJunction3D junction = new SimpleStrandJunction3D(branchSet);
            String incomingName = incomingNomenclature.generateNomenclature(junction);
            if (junction.getBranchCount() < junctionOrderMin || !junction.corridorCheck(corridorDescriptor) || resultJunctionNames.contains(incomingName)) continue;
            if (BranchDescriptorTools.junctionHasInternalHelices(junction, branchDescriptors)) {
                junction.setInternalHelices(true);
            } else {
                junction.setInternalHelices(false);
            }
            result.add(junction);
            resultJunctionNames.add(incomingName);
            ++singleCount;
        }
        return result;
    }

    private static Set<Integer> generateLoopStemIndices(BranchDescriptor3D branch, Object3DSet stemSet) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < stemSet.size(); ++i) {
            RnaStem3D stem = (RnaStem3D)stemSet.get(i);
            if (!KissingLoop3D.isLoopStem(branch, stem)) continue;
            result.add(new Integer(i));
        }
        return result;
    }

    private static Object3DSet generateJunctions(Object3DSet branchDescriptors, CorridorDescriptor corridorDescriptor, int iterMax, int loopLengthSumMax, boolean IntHelicesCheck) {
        log.fine("Starting generateJunctions (4) with corridorDescriptor " + corridorDescriptor);
        LilleyNomenclature lilleyNomenclature = new LilleyNomenclature();
        IncomingNomenclature incomingNomenclature = new IncomingNomenclature();
        if (branchDescriptors.size() == 0) {
            log.fine("No branch descriptors defined, returning empty set of junctions!");
            return new SimpleObject3DSet();
        }
        for (int i = 0; i < branchDescriptors.size(); ++i) {
            BranchDescriptor3D bd = (BranchDescriptor3D)branchDescriptors.get(i);
        }
        log.fine("Starting to cluster branch descriptors...");
        IntegerListList clusters = BranchDescriptorTools.clusterBranchDescriptors(branchDescriptors, iterMax);
        log.fine("Finished clustering branch descriptors: " + clusters.size());
        for (int i = 0; i < branchDescriptors.size(); ++i) {
        }
        SimpleObject3DSet result = new SimpleObject3DSet();
        HashSet<String> resultJunctionNames = new HashSet<String>();
        for (int i = 0; i < clusters.size(); ++i) {
            int j;
            boolean skipJunctionFlag = false;
            SimpleObject3DSet branchCluster = new SimpleObject3DSet();
            SimpleObject3DSet branchClonedCluster = new SimpleObject3DSet();
            IntegerList cluster = clusters.get(i);
            assert (cluster.isUnique());
            if (cluster.size() > 1) assert (BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, cluster.get(0), cluster.get(1)));
            if (debugLevel > 1) {
                for (int k = 0; k < cluster.size(); ++k) {
                }
            }
            for (j = 0; j < cluster.size(); ++j) {
                branchClonedCluster.add((Object3D)branchDescriptors.get(cluster.get(j)).cloneDeep());
                branchCluster.add(branchDescriptors.get(cluster.get(j)));
            }
            if (branchClonedCluster.size() > 1) {
                for (j = 0; j < branchClonedCluster.size(); ++j) {
                    int jj2 = j;
                    int jj1 = j - 1;
                    if (j == 0) {
                        jj1 = branchClonedCluster.size() - 1;
                    } else {
                        assert (BranchDescriptorTools.isConnectedIncomingOutgoing(branchDescriptors, cluster.get(jj1), cluster.get(jj2)));
                        assert (BranchDescriptorTools.isConnectedIncomingOutgoing(branchCluster, jj1, jj2));
                    }
                    assert (jj1 != jj2);
                    BranchDescriptor3D b1 = (BranchDescriptor3D)branchClonedCluster.get(jj1);
                    BranchDescriptor3D b2 = (BranchDescriptor3D)branchClonedCluster.get(jj2);
                    if (!b1.getIncomingStrand().sequenceString().equals(b2.getOutgoingStrand().sequenceString())) {
                        log.fine("Different strands, even though they should be the same: " + b1.getIncomingStrand().sequenceString() + " " + b2.getOutgoingStrand().sequenceString() + " " + jj1 + " " + jj2);
                        skipJunctionFlag = true;
                        break;
                    }
                    assert (b1.getIncomingStrand().sequenceString().equals(b2.getOutgoingStrand().sequenceString()));
                    BranchDescriptorTools.adjustBranchDescriptorPair(b1, b2);
                }
                if (skipJunctionFlag) {
                    log.fine("Skipping ill defined junction!");
                    skipJunctionFlag = false;
                    continue;
                }
                SimpleStrandJunction3D junction = new SimpleStrandJunction3D(branchClonedCluster);
                if (!junction.isValid()) {
                    log.fine("Junction was not valid, skipping");
                    continue;
                }
                String incomingName = incomingNomenclature.generateNomenclature(junction);
                if (junction.getBranchCount() >= junctionOrderMin && junction.isValid() && !resultJunctionNames.contains(incomingName)) {
                    log.fine("Important junction test: corridor: " + junction.corridorCheck(corridorDescriptor) + " " + corridorDescriptor + " looplength sum: " + LilleyNomenclature.computeLoopLengthSum(junction) + " nomenclature: " + lilleyNomenclature.generateNomenclature(junction));
                    if (junction.corridorCheck(corridorDescriptor) && LilleyNomenclature.computeLoopLengthSum(junction) <= loopLengthSumMax && LilleyNomenclature.computeLoopLengthSum(junction) >= 0 && lilleyNomenclature.generateNomenclature(junction).length() > 0) {
                        if (BranchDescriptorTools.junctionHasInternalHelices(junction) && IntHelicesCheck) {
                            junction.setInternalHelices(true);
                        } else {
                            junction.setInternalHelices(false);
                        }
                        result.add(junction);
                        resultJunctionNames.add(incomingName);
                        if (debugLevel <= 1) continue;
                        continue;
                    }
                    log.fine("Ignoring junction " + junction.getName() + " because corridor test failed." + corridorDescriptor);
                    continue;
                }
                log.info("Warning: generated junction was not valid!");
                continue;
            }
            log.fine("BranchCloneCluster too small " + cluster.size());
        }
        int singleCount = 0;
        for (int i = 0; i < branchDescriptors.size(); ++i) {
            BranchDescriptor3D branch = (BranchDescriptor3D)branchDescriptors.get(i);
            if (!branch.isSingleSequence() || branch.getOutgoingIndex() <= branch.getIncomingIndex()) continue;
            BranchDescriptor3D branchClone = (BranchDescriptor3D)branchDescriptors.get(i).cloneDeep();
            SimpleObject3DSet branchSet = new SimpleObject3DSet();
            branchSet.add(branchClone);
            SimpleStrandJunction3D junction = new SimpleStrandJunction3D(branchSet);
            String incomingName = incomingNomenclature.generateNomenclature(junction);
            if (junction.getBranchCount() < junctionOrderMin || !junction.corridorCheck(corridorDescriptor) || resultJunctionNames.contains(incomingName)) continue;
            if (BranchDescriptorTools.junctionHasInternalHelices(junction, branchDescriptors)) {
                junction.setInternalHelices(true);
            } else {
                junction.setInternalHelices(false);
            }
            result.add(junction);
            resultJunctionNames.add(incomingName);
            ++singleCount;
        }
        return result;
    }

    private static Object3DSet generateKissingLoops(Object3DSet branchDescriptors, Object3DSet stemSet) {
        int i;
        if (branchDescriptors.size() == 0) {
            return new SimpleObject3DSet();
        }
        SimpleObject3DSet result = new SimpleObject3DSet();
        boolean[] singleFlags = new boolean[branchDescriptors.size()];
        ArrayList<Set<Integer>> loopStemIndices = new ArrayList<Set<Integer>>();
        for (i = 0; i < branchDescriptors.size(); ++i) {
            singleFlags[i] = ((BranchDescriptor3D)branchDescriptors.get(i)).isSingleSequence();
            loopStemIndices.add(BranchDescriptorTools.generateLoopStemIndices((BranchDescriptor3D)branchDescriptors.get(i), stemSet));
        }
        for (i = 0; i < branchDescriptors.size(); ++i) {
            BranchDescriptor3D branch1 = (BranchDescriptor3D)branchDescriptors.get(i);
            if (!singleFlags[i]) continue;
            int numInternalHelices = ((Set)loopStemIndices.get(i)).size();
            if (numInternalHelices == 0 || numInternalHelices > 1) {
                log.fine("Ignoring branch descriptor because bad number of internal helices: " + branchDescriptors.get(i).getName());
                continue;
            }
            for (int j = i + 1; j < branchDescriptors.size(); ++j) {
                BranchDescriptor3D branch2 = (BranchDescriptor3D)branchDescriptors.get(j);
                if (!singleFlags[j]) {
                    log.fine("branch descriptor 2 does not correspond to single sequence: " + branch2.getName());
                    log.fine(branch2.getOutgoingStrand().getName() + " " + branch2.getIncomingStrand().getName());
                    continue;
                }
                int numInternalHelices2 = ((Set)loopStemIndices.get(j)).size();
                if (numInternalHelices2 == 0 || numInternalHelices2 > 1) {
                    log.fine("Ignoring second branch descriptor because of too many internal helices: " + branchDescriptors.get(j).getName());
                    continue;
                }
                log.fine("comparing branch descriptor " + branchDescriptors.get(j).getName() + " with " + ((Set)loopStemIndices.get(j)).size() + " internal helices.");
                if (branch2.distance(branch1) > 50.0) {
                    log.fine("The distance between the branch discriptors is too large: " + branch2.distance(branch1));
                    continue;
                }
                if (KissingLoop3D.isKissingLoop(branch1, branch2, stemSet, (Set)loopStemIndices.get(i), (Set)loopStemIndices.get(j))) {
                    SimpleObject3DSet branchSet = new SimpleObject3DSet();
                    BranchDescriptor3D b1 = (BranchDescriptor3D)branch1.cloneDeep();
                    BranchDescriptorTools.adjustBranchDescriptorLoop(b1);
                    branchSet.add(b1);
                    BranchDescriptor3D b2 = (BranchDescriptor3D)branch2.cloneDeep();
                    BranchDescriptorTools.adjustBranchDescriptorLoop(b2);
                    branchSet.add(b2);
                    KissingLoop3D kissingLoop = new KissingLoop3D(branchSet);
                    result.add(kissingLoop);
                    continue;
                }
                log.fine("No kissing loop found: " + (i + 1) + " " + (j + 1) + branch1.getName() + " " + branch2.getName());
            }
        }
        log.fine("Finished generateKissingLoops(3)");
        return result;
    }

    private static Object3DSet generateKissingLoops(Object3DSet branchDescriptors, Object3DSet stemSet, boolean IntHelixCheck) {
        int i;
        if (branchDescriptors.size() == 0) {
            return new SimpleObject3DSet();
        }
        SimpleObject3DSet result = new SimpleObject3DSet();
        boolean[] singleFlags = new boolean[branchDescriptors.size()];
        ArrayList<Set<Integer>> loopStemIndices = new ArrayList<Set<Integer>>();
        for (i = 0; i < branchDescriptors.size(); ++i) {
            singleFlags[i] = ((BranchDescriptor3D)branchDescriptors.get(i)).isSingleSequence();
            loopStemIndices.add(BranchDescriptorTools.generateLoopStemIndices((BranchDescriptor3D)branchDescriptors.get(i), stemSet));
        }
        for (i = 0; i < branchDescriptors.size(); ++i) {
            BranchDescriptor3D branch1 = (BranchDescriptor3D)branchDescriptors.get(i);
            if (!singleFlags[i]) continue;
            int numInternalHelices = ((Set)loopStemIndices.get(i)).size();
            if ((numInternalHelices == 0 || numInternalHelices > 1) && IntHelixCheck) {
                log.fine("Ignoring branch descriptor because bad number of internal helices: " + branchDescriptors.get(i).getName());
                continue;
            }
            for (int j = i + 1; j < branchDescriptors.size(); ++j) {
                BranchDescriptor3D branch2 = (BranchDescriptor3D)branchDescriptors.get(j);
                if (!singleFlags[j]) {
                    log.fine("branch descriptor 2 does not correspond to single sequence: " + branch2.getName());
                    log.fine(branch2.getOutgoingStrand().getName() + " " + branch2.getIncomingStrand().getName());
                    continue;
                }
                int numInternalHelices2 = ((Set)loopStemIndices.get(j)).size();
                if ((numInternalHelices2 == 0 || numInternalHelices2 > 1) && IntHelixCheck) {
                    log.fine("Ignoring second branch descriptor because of too many internal helices: " + branchDescriptors.get(j).getName());
                    continue;
                }
                log.fine("comparing branch descriptor " + branchDescriptors.get(j).getName() + " with " + ((Set)loopStemIndices.get(j)).size() + " internal helices.");
                if (branch2.distance(branch1) > 50.0) {
                    log.fine("The distance between the branch discriptors is too large: " + branch2.distance(branch1));
                    continue;
                }
                if (KissingLoop3D.isKissingLoop(branch1, branch2, stemSet, (Set)loopStemIndices.get(i), (Set)loopStemIndices.get(j))) {
                    SimpleObject3DSet branchSet = new SimpleObject3DSet();
                    BranchDescriptor3D b1 = (BranchDescriptor3D)branch1.cloneDeep();
                    BranchDescriptorTools.adjustBranchDescriptorLoop(b1);
                    branchSet.add(b1);
                    BranchDescriptor3D b2 = (BranchDescriptor3D)branch2.cloneDeep();
                    BranchDescriptorTools.adjustBranchDescriptorLoop(b2);
                    branchSet.add(b2);
                    KissingLoop3D kissingLoop = new KissingLoop3D(branchSet);
                    result.add(kissingLoop);
                    continue;
                }
                log.fine("No kissing loop found: " + (i + 1) + " " + (j + 1) + branch1.getName() + " " + branch2.getName());
            }
        }
        log.fine("Finished generateKissingLoops(3)");
        return result;
    }

    private static Object3DSet generateJunctions(Object3D stemRoot, int branchDescriptorOffset, CorridorDescriptor corridorDescriptor, double rmsTolerance, int loopLengthSumMax) {
        log.fine("Starting generateJunctions (3) using offset " + branchDescriptorOffset + " and rms: " + rmsTolerance + " loop length sum max: " + loopLengthSumMax + " and corridor " + corridorDescriptor);
        int iterMax = 500;
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRoot, "RnaStem3D");
        Object3DSet branchDescriptors = BranchDescriptorTools.generateBranchDescriptors(stemSet, branchDescriptorOffset, rmsTolerance);
        log.fine("Number of generated branch descriptors: " + branchDescriptors.size());
        for (int i = 0; i < branchDescriptors.size(); ++i) {
            log.fine("Branch Descriptor " + (i + 1) + " : " + ((BranchDescriptor3D)branchDescriptors.get(i)).infoString());
        }
        Object3DSet junctions = BranchDescriptorTools.generateJunctions(branchDescriptors, corridorDescriptor, iterMax, loopLengthSumMax);
        log.fine("Found branchDescriptors and Junctions: " + branchDescriptors.size() + " " + junctions.size());
        log.fine("Finished generateJunctions (3)");
        return junctions;
    }

    private static Object3DSet generateJunctions(Object3D stemRoot, int branchDescriptorOffset, CorridorDescriptor corridorDescriptor, double rmsTolerance, int loopLengthSumMax, boolean checkIntHelices) {
        log.fine("Starting generateJunctions (3) using offset " + branchDescriptorOffset + " and rms: " + rmsTolerance + " loop length sum max: " + loopLengthSumMax + " and corridor " + corridorDescriptor);
        int iterMax = 500;
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRoot, "RnaStem3D");
        Object3DSet branchDescriptors = BranchDescriptorTools.generateBranchDescriptors(stemSet, branchDescriptorOffset, rmsTolerance);
        log.fine("Number of generated branch descriptors: " + branchDescriptors.size());
        for (int i = 0; i < branchDescriptors.size(); ++i) {
            log.fine("Branch Descriptor " + (i + 1) + " : " + ((BranchDescriptor3D)branchDescriptors.get(i)).infoString());
        }
        Object3DSet junctions = BranchDescriptorTools.generateJunctions(branchDescriptors, corridorDescriptor, iterMax, loopLengthSumMax, checkIntHelices);
        log.fine("Found branchDescriptors and Junctions: " + branchDescriptors.size() + " " + junctions.size());
        log.fine("Finished generateJunctions (3)");
        return junctions;
    }

    private static Object3DSet generateKissingLoops(Object3D stemRoot, int branchDescriptorOffset, double rmsTolerance) {
        log.fine("Starting generateKissingLoops (2)!");
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRoot, "RnaStem3D");
        Object3DSet branchDescriptors = BranchDescriptorTools.generateBranchDescriptors(stemSet, branchDescriptorOffset, rmsTolerance);
        log.fine("Number of generated branch descriptors: " + branchDescriptors.size());
        Object3DSet kissingLoops = BranchDescriptorTools.generateKissingLoops(branchDescriptors, stemSet);
        return kissingLoops;
    }

    private static Object3DSet generateKissingLoops(Object3D stemRoot, int branchDescriptorOffset, double rmsTolerance, boolean intHelixChecker) {
        log.fine("Starting generateKissingLoops (2)!");
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRoot, "RnaStem3D");
        Object3DSet branchDescriptors = BranchDescriptorTools.generateBranchDescriptors(stemSet, branchDescriptorOffset, rmsTolerance);
        log.fine("Number of generated branch descriptors: " + branchDescriptors.size());
        Object3DSet kissingLoops = BranchDescriptorTools.generateKissingLoops(branchDescriptors, stemSet, intHelixChecker);
        return kissingLoops;
    }

    public static Object3D generateJunctions(Object3D stemRootOrig, String baseName, int branchDescriptorOffset, CorridorDescriptor corridorDescriptor, double rmsTolerance, int loopLengthSumMax) {
        assert (stemRootOrig != null);
        assert (baseName != null);
        log.fine("Starting BranchDescriptorTools.generateJunctions (2)!");
        SimpleObject3D root = new SimpleObject3D();
        root.setName(baseName);
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRootOrig, "RnaStem3D");
        assert (stemSet.size() > 0);
        if (stemSet.size() > 0) {
            Vector3D origPos = stemSet.get(0).getPosition();
            log.fine("First leaf vector: " + origPos);
            Object3D stemRoot = (Object3D)stemRootOrig.cloneDeep();
            Object3DSet junctions = BranchDescriptorTools.generateJunctions(stemRoot, branchDescriptorOffset, corridorDescriptor, rmsTolerance, loopLengthSumMax);
            if (junctions.size() == 0) {
                log.fine("no junctions were found in structure!");
            }
            for (int i = 0; i < junctions.size(); ++i) {
                Object3D junction = junctions.get(i);
                log.fine("Generated junction " + (i + 1) + " with position: " + junction.getPosition());
                String newName = "j" + (i + 1);
                junction.setName(newName);
                root.insertChild(junction);
            }
            assert (origPos.distance(Object3DTools.collectByClassName(stemRootOrig, "RnaStem3D").get(0).getPosition()) < 0.001);
            log.fine("First leaf vector at end of method: " + Object3DTools.findFirstLeaf(stemRootOrig));
        } else {
            log.fine("no atoms were found in structure!");
        }
        log.fine("Quitting BranchDescriptorTools.generateJunctions (2)!");
        return root;
    }

    public static Object3D generateJunctions(Object3D stemRootOrig, String baseName, int branchDescriptorOffset, CorridorDescriptor corridorDescriptor, double rmsTolerance, int loopLengthSumMax, boolean checkIntHelices) {
        assert (stemRootOrig != null);
        assert (baseName != null);
        log.fine("Starting BranchDescriptorTools.generateJunctions (2)!");
        SimpleObject3D root = new SimpleObject3D();
        root.setName(baseName);
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRootOrig, "RnaStem3D");
        assert (stemSet.size() > 0);
        if (stemSet.size() > 0) {
            Vector3D origPos = stemSet.get(0).getPosition();
            log.fine("First leaf vector: " + origPos);
            Object3D stemRoot = (Object3D)stemRootOrig.cloneDeep();
            Object3DSet junctions = BranchDescriptorTools.generateJunctions(stemRoot, branchDescriptorOffset, corridorDescriptor, rmsTolerance, loopLengthSumMax, checkIntHelices);
            if (junctions.size() == 0) {
                log.fine("no junctions were found in structure!");
            }
            for (int i = 0; i < junctions.size(); ++i) {
                Object3D junction = junctions.get(i);
                log.fine("Generated junction " + (i + 1) + " with position: " + junction.getPosition());
                String newName = "j" + (i + 1);
                junction.setName(newName);
                root.insertChild(junction);
            }
            assert (origPos.distance(Object3DTools.collectByClassName(stemRootOrig, "RnaStem3D").get(0).getPosition()) < 0.001);
            log.fine("First leaf vector at end of method: " + Object3DTools.findFirstLeaf(stemRootOrig));
        } else {
            log.fine("no atoms were found in structure!");
        }
        log.fine("Quitting BranchDescriptorTools.generateJunctions (2)!");
        return root;
    }

    public static Object3D generateKissingLoops(Object3D stemRootOrig, String baseName, int branchDescriptorOffset, double rmsTolerance) {
        assert (stemRootOrig != null);
        assert (baseName != null);
        log.fine("Starting BranchDescriptorTools.generateKissingLoops (1)!");
        SimpleObject3D root = new SimpleObject3D();
        root.setName(baseName);
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRootOrig, "RnaStem3D");
        assert (stemSet.size() > 0);
        if (stemSet.size() > 0) {
            Object3D stemRoot = (Object3D)stemRootOrig.cloneDeep();
            Object3DSet kissingLoops = BranchDescriptorTools.generateKissingLoops(stemRoot, branchDescriptorOffset, rmsTolerance);
            if (kissingLoops.size() == 0) {
                log.fine("no kissing loops were found in structure!");
            }
            for (int i = 0; i < kissingLoops.size(); ++i) {
                Object3D kissingLoop = kissingLoops.get(i);
                log.fine("Generated kissingLoop " + (i + 1) + " with position: " + kissingLoop.getPosition());
                String newName = "k" + (i + 1);
                kissingLoop.setName(newName);
                root.insertChild(kissingLoop);
            }
        } else {
            log.fine("no atoms were found in structure!");
        }
        log.fine("Quitting BranchDescriptorTools.generateKissingLoops (1)!");
        return root;
    }

    public static Object3D generateKissingLoops(Object3D stemRootOrig, String baseName, int branchDescriptorOffset, double rmsTolerance, boolean intHelixCheck) {
        assert (stemRootOrig != null);
        assert (baseName != null);
        log.fine("Starting BranchDescriptorTools.generateKissingLoops (1)!");
        SimpleObject3D root = new SimpleObject3D();
        root.setName(baseName);
        Object3DSet stemSet = Object3DTools.collectByClassName(stemRootOrig, "RnaStem3D");
        assert (stemSet.size() > 0);
        if (stemSet.size() > 0) {
            Object3D stemRoot = (Object3D)stemRootOrig.cloneDeep();
            Object3DSet kissingLoops = BranchDescriptorTools.generateKissingLoops(stemRoot, branchDescriptorOffset, rmsTolerance, intHelixCheck);
            if (kissingLoops.size() == 0) {
                log.fine("no kissing loops were found in structure!");
            }
            for (int i = 0; i < kissingLoops.size(); ++i) {
                Object3D kissingLoop = kissingLoops.get(i);
                log.fine("Generated kissingLoop " + (i + 1) + " with position: " + kissingLoop.getPosition());
                String newName = "k" + (i + 1);
                kissingLoop.setName(newName);
                root.insertChild(kissingLoop);
            }
        } else {
            log.fine("no atoms were found in structure!");
        }
        log.fine("Quitting BranchDescriptorTools.generateKissingLoops (1)!");
        return root;
    }
}

