/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.BranchDescriptor3D;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DPotential;

public class BranchDescriptorPotential
implements Object3DPotential {
    private BranchDescriptor3D branch;
    public static final double COLLISION_PENALTY = 10000.0;

    public BranchDescriptorPotential(BranchDescriptor3D branch) {
        this.branch = branch;
    }

    @Override
    public double computeValue(Object3D obj) {
        assert (obj instanceof BranchDescriptor3D);
        BranchDescriptor3D b = (BranchDescriptor3D)obj;
        Vector3D dv = b.getPosition().minus(this.branch.getPosition());
        if (!(dv.length() > 0.0)) {
            return 10000.0;
        }
        dv.normalize();
        double ang1 = dv.angle(this.branch.getDirection()) / Math.PI;
        double ang2 = (Math.PI - dv.angle(b.getDirection())) / Math.PI;
        return 0.5 * (ang1 + ang2);
    }

    public BranchDescriptor3D getBranch() {
        return this.branch;
    }
}

