/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.BranchDescriptorOptimizer;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.MonteCarloBranchDescriptorOptimizer;
import rnadesign.rnamodel.MorphBranchDescriptorOptimizer;
import rnadesign.rnamodel.SimpleBranchDescriptorOptimizer;
import rnadesign.rnamodel.StretchedBranchDescriptorOptimizer;

public class BranchDescriptorOptimizerFactory {
    public static final int SIMPLE_OPTIMIZER = 1;
    public static final int STRETCH_OPTIMIZER = 2;
    public static final int MONTE_CARLO_OPTIMIZER = 3;
    public static final int MORPH_OPTIMIZER = 4;

    public static BranchDescriptorOptimizer generate(int optimizerCode, FitParameters prm) {
        switch (optimizerCode) {
            case 1: {
                return new SimpleBranchDescriptorOptimizer(prm);
            }
            case 2: {
                return new StretchedBranchDescriptorOptimizer(prm);
            }
            case 3: {
                return new MonteCarloBranchDescriptorOptimizer(prm);
            }
            case 4: {
                return new MorphBranchDescriptorOptimizer(prm);
            }
        }
        assert (false);
        return null;
    }
}

