/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import chemistrytools.ChemicalElement;
import chemistrytools.DefaultChemicalElement;
import chemistrytools.PeriodicTableImp;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnadesign.rnamodel.Atom3D;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class AtomTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static double defaultCollisionDistance = 2.0;

    public static boolean isPO3Bond(String name1, String name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        if (name1.compareTo(name2) > 0) {
            return AtomTools.isPO3Bond(name2, name1);
        }
        return name2.equals("P") && ("O3*".equals(name1) || "O3'".equals(name1));
    }

    public static int countAtomCollisions(Object3DSet atomSet, double collisionDistance, Level verboseLevel) {
        int counter = 0;
        boolean reportFlag = true;
        for (int i = 0; i < atomSet.size(); ++i) {
            Atom3D atom1 = (Atom3D)atomSet.get(i);
            if (atom1.getElement() == null || atom1.getElement() != null && "H".equals(atom1.getElement().getShortName())) continue;
            for (int j = i + 1; j < atomSet.size(); ++j) {
                if (!(atom1.distance(atomSet.get(j)) < collisionDistance)) continue;
                Atom3D atom2 = (Atom3D)atomSet.get(j);
                if (atom1.getParent() == atom2.getParent() || atom2.getElement() == null || atom2.getElement() != null && "H".equals(atom2.getElement().getShortName()) || AtomTools.isPO3Bond(atom1.getName(), atom2.getName())) continue;
                ++counter;
                if (!reportFlag) continue;
                log.info("Collision: " + atom1.getFullName() + " ( " + atom1.getName() + " ) " + atom2.getFullName() + " ( " + atom2.getName() + " ) ");
            }
        }
        return counter;
    }

    public static boolean isCovalentlyBonded(Atom3D a1, Atom3D a2) {
        if (a1.getLinks().find(a1, a2) != null) {
            return true;
        }
        return a1.getPosition().distance(a2.getPosition()) < 1.5;
    }

    public static boolean isHydrogen(Atom3D atom) {
        if (atom.getElement() != null) {
            return "H".equals(atom.getElement().getShortName());
        }
        return atom.getName().charAt(0) == 'H';
    }

    public static char getElementChar(Atom3D atom) {
        if (atom.getElement() != null) {
            return atom.getElement().getShortName().charAt(0);
        }
        return atom.getName().charAt(0);
    }

    public static int countExternalCollisions(Object3DSet atomSet1, Object3DSet atomSet2, double collisionDistance) {
        int counter = 0;
        for (int i = 0; i < atomSet1.size(); ++i) {
            Atom3D atom1 = (Atom3D)atomSet1.get(i);
            if (atom1.getElement() != null && "H".equals(atom1.getElement().getShortName())) continue;
            for (int j = 0; j < atomSet2.size(); ++j) {
                Atom3D atom2;
                if (!(atom1.distance(atomSet2.get(j)) < collisionDistance) || (atom2 = (Atom3D)atomSet2.get(j)).getElement() != null && "H".equals(atom2.getElement().getShortName())) continue;
                ++counter;
            }
        }
        return counter;
    }

    private static int countExternalCollisions(Vector3D[] positions, Object3D subTree, Object3D largeTree, double collisionDistance) {
        if (subTree == largeTree) {
            return 0;
        }
        int counter = 0;
        if (largeTree instanceof Atom3D) {
            Vector3D pos = largeTree.getPosition();
            for (int i = 0; i < positions.length; ++i) {
                if (!(positions[i].distance(pos) < collisionDistance)) continue;
                ++counter;
            }
        }
        for (int i = 0; i < largeTree.size(); ++i) {
            counter += AtomTools.countExternalCollisions(positions, subTree, largeTree.getChild(i), collisionDistance);
        }
        return counter;
    }

    public static int countExternalCollisions(Object3DSet atomSet, Object3D subTree, Object3D largeTree, Object3DSet ignoreTrees, double collisionDistance) {
        int compCount = 0;
        if (subTree == largeTree) {
            return 0;
        }
        for (int i = 0; i < ignoreTrees.size(); ++i) {
            if (ignoreTrees.get(i) != largeTree) continue;
            return 0;
        }
        int counter = 0;
        if (largeTree instanceof Atom3D) {
            Vector3D pos = largeTree.getPosition();
            for (int i = 0; i < atomSet.size(); ++i) {
                if (atomSet.get(i) == largeTree) continue;
                if (atomSet.get(i).getPosition().distance(pos) < collisionDistance) {
                    ++counter;
                }
                ++compCount;
            }
        }
        for (int i = 0; i < largeTree.size(); ++i) {
            counter += AtomTools.countExternalCollisions(atomSet, subTree, largeTree.getChild(i), ignoreTrees, collisionDistance);
        }
        return counter;
    }

    public static int countExternalCollisions(Vector3D[] positions, Object3DSet atomSet, Object3D subTree, Object3D largeTree, Object3DSet ignoreTrees, double collisionDistance) {
        assert (positions.length == atomSet.size());
        if (subTree == largeTree) {
            return 0;
        }
        for (int i = 0; i < ignoreTrees.size(); ++i) {
            if (ignoreTrees.get(i) != largeTree) continue;
            return 0;
        }
        int counter = 0;
        if (largeTree instanceof Atom3D) {
            Vector3D pos = largeTree.getPosition();
            for (int i = 0; i < positions.length; ++i) {
                if (atomSet.get(i) == largeTree || !(positions[i].distance(pos) < collisionDistance)) continue;
                ++counter;
            }
        }
        for (int i = 0; i < largeTree.size(); ++i) {
            counter += AtomTools.countExternalCollisions(positions, atomSet, subTree, largeTree.getChild(i), ignoreTrees, collisionDistance);
        }
        return counter;
    }

    public static int countExternalCollisions(Object3D subTree, Object3D largeTree, double collisionDistance) {
        Object3DSet atomSet1 = Object3DTools.collectByClassName(subTree, "Atom3D");
        Vector3D[] positions = new Vector3D[atomSet1.size()];
        for (int i = 0; i < atomSet1.size(); ++i) {
            positions[i] = atomSet1.get(i).getPosition();
        }
        return AtomTools.countExternalCollisions(positions, subTree, largeTree, collisionDistance);
    }

    public static int countExternalCollisions(Object3D subTree, Object3D largeTree, Object3DSet ignoreTrees, double collisionDistance) {
        Object3DSet atomSet1 = Object3DTools.collectByClassName(subTree, "Atom3D");
        Vector3D[] positions = new Vector3D[atomSet1.size()];
        for (int i = 0; i < atomSet1.size(); ++i) {
            positions[i] = atomSet1.get(i).getPosition();
        }
        return AtomTools.countExternalCollisions(positions, atomSet1, subTree, largeTree, ignoreTrees, collisionDistance);
    }

    public static Vector3D centerOfMass(List<Atom3D> objSet) {
        Vector3D sum = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < objSet.size(); ++i) {
            sum.add(objSet.get(i).getPosition());
        }
        sum.scale(1.0 / (double)objSet.size());
        return sum;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object3DLinkSetBundle convertGraphToMolecule(Object3D root, LinkSet links, String nameBase) {
        int i;
        SimpleObject3D resultObj = new SimpleObject3D();
        resultObj.setName(nameBase);
        resultObj.setPosition(root.getPosition());
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        for (i = 0; i < root.size(); ++i) {
            ChemicalElement element;
            Atom3D atom;
            block11: {
                atom = new Atom3D(root.getChild(i).getPosition());
                String suggested = root.getChild(i).getProperty("atom_element");
                element = null;
                if (suggested != null && suggested.length() > 0) {
                    element = new DefaultChemicalElement(suggested);
                } else {
                    int linkOrder = links.getLinkOrder(root.getChild(i));
                    if (linkOrder > 0) {
                        if (linkOrder < 5) {
                            element = PeriodicTableImp.generateDefaultChemicalElementByValency(linkOrder);
                            break block11;
                        } else {
                            log.warning("Object has link order greater four, cannot be mapped to chemical element, ignoring: " + root.getChild(i).getFullName());
                            continue;
                        }
                    }
                    log.warning("Object with link order zero detected, ignoring: " + root.getChild(i).getFullName());
                    continue;
                }
            }
            if (element != null) {
                atom.setElement(element);
                atom.setName(element.getShortName());
            } else {
                log.warning("Cannot generate chemical element representing " + Object3DTools.getFullName(root.getChild(i)));
            }
            resultObj.insertChildSave(atom);
        }
        i = 0;
        while (i < root.size()) {
            for (int j = i + 1; j < root.size(); ++j) {
                int linkNumber = links.getLinkNumber(root.getChild(i), root.getChild(j));
                if (linkNumber <= 0) continue;
                resultLinks.add(new SimpleLink(resultObj.getChild(i), resultObj.getChild(j)));
            }
            ++i;
        }
        return new SimpleObject3DLinkSetBundle(resultObj, resultLinks);
    }
}

