/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.Residue3D;
import sequence.LetterSymbol;
import sequence.Residue;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleObject3D;

public class AminoAcid3D
extends SimpleObject3D
implements Residue3D {
    private String assignedName = "";
    private int assignedNumber;
    private int pos;
    private final String CLASS_NAME = "AminoAcid3D";
    private LetterSymbol symbol;

    public AminoAcid3D() {
        this.assignedNumber = 0;
        this.pos = 0;
    }

    public AminoAcid3D(LetterSymbol symbol, int pos, Vector3D position) {
        super(position);
        this.symbol = symbol;
        this.pos = pos;
        this.assignedNumber = 0;
    }

    public Object clone() {
        assert (false);
        return new AminoAcid3D(this.symbol, this.pos, this.getRelativePosition());
    }

    @Override
    public int getAssignedNumber() {
        return this.assignedNumber;
    }

    @Override
    public String getAssignedName() {
        return this.assignedName;
    }

    @Override
    public int getAtomCount() {
        return this.size();
    }

    @Override
    public Atom3D getAtom(int n) {
        return (Atom3D)this.getChild(n);
    }

    @Override
    public String getClassName() {
        return "AminoAcid3D";
    }

    @Override
    public int getCovalentBondOrder(Atom3D atom1, Atom3D atom2) {
        assert (false);
        return -1;
    }

    @Override
    public List<Atom3D> getCovalentlyBondedAtoms(Atom3D atom) {
        ArrayList<Atom3D> resultAtoms = new ArrayList<Atom3D>();
        AminoAcid3D res = (AminoAcid3D)atom.getParent();
        for (int j = 0; j < res.size(); ++j) {
            Atom3D atomOther = (Atom3D)this.getChild(j);
            if (atom == atomOther || this.getCovalentBondOrder(atom, atomOther) <= 0) continue;
            resultAtoms.add(atomOther);
        }
        return resultAtoms;
    }

    @Override
    public Object getParentObject() {
        return this.getParent();
    }

    @Override
    public LetterSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public int getResidueNumberInPdb() {
        String prop = this.getProperty("pdb_residue_id");
        if (prop == null) {
            return this.getPos() + 1;
        }
        return Integer.parseInt(prop);
    }

    @Override
    public boolean isKnownResidue() {
        char c = this.getName().charAt(0);
        return c != 'X';
    }

    @Override
    public boolean isSameSequence(Residue other) {
        if (other instanceof AminoAcid3D) {
            AminoAcid3D otherNuc = (AminoAcid3D)other;
            return this.getParent() == otherNuc.getParent();
        }
        return false;
    }

    @Override
    public void setSymbol(LetterSymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public void read(InputStream is) {
    }

    @Override
    public void setAssignedName(String name) {
        this.assignedName = name;
    }

    @Override
    public void setAssignedNumber(int number) {
        this.assignedNumber = number;
    }

    @Override
    public void setParentObject(Object obj) {
        if (obj instanceof Object3D) {
            super.setParent((Object3D)obj);
        }
        throw new RuntimeException("Parent of Nucleotide3D class must be an Object3D");
    }

    @Override
    public void setPos(int pos) {
        this.pos = pos;
    }
}

