/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.AbstractPdbWriter;
import rnadesign.rnamodel.AminoAcid3D;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.Protein3DTools;
import rnadesign.rnamodel.ProteinStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;

public class AmberPdbWriter
extends AbstractPdbWriter {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String PDB_CHAR_PROPERTY = "pdb_chain_char";
    public static final char DEFAULT_STRAND_CHAR = ' ';
    private char strandChar = (char)32;
    private int currentResidueOutputId = 1;
    private int residueCount = 1;
    private int formatId = 3;

    public AmberPdbWriter() {
        this.reset();
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public void reset() {
        this.lineCounter = 1;
        this.resetStrandChar();
        this.residueCount = 1;
        this.currentResidueOutputId = 1;
    }

    public void resetStrandChar() {
        this.strandChar = (char)32;
    }

    @Override
    public void write(OutputStream os, Object3D node) {
        PrintStream pw = new PrintStream(os);
        pw.println(this.writeString(node));
    }

    public char getStrandChar() {
        return this.strandChar;
    }

    public static char getOriginalStrandChar(BioPolymer strand) {
        String chainString;
        Properties properties = strand.getProperties();
        if (properties != null && (chainString = properties.getProperty(PDB_CHAR_PROPERTY)) != null && chainString.length() == 1) {
            return chainString.charAt(0);
        }
        return ' ';
    }

    public char getStrandChar(NucleotideStrand strand) {
        if (this.originalMode == 1 && strand != null) {
            return AmberPdbWriter.getOriginalStrandChar(strand);
        }
        return this.strandChar;
    }

    public static char nextStrandChar(char c) {
        return ' ';
    }

    public void incStrandChar() {
        assert (false);
    }

    private int getResidueOutputNumber(Nucleotide3D nuc, int currentCount) {
        int result = 0;
        switch (this.originalMode) {
            case 1: {
                result = nuc.getResidueNumberInPdb();
                break;
            }
            case 2: {
                result = nuc.getPos() + 1;
                break;
            }
            case 3: {
                result = nuc.getResidueNumberInName();
                break;
            }
            case 4: {
                result = this.currentResidueOutputId;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    private String writeNucleotide(Nucleotide3D nuc, char strandChar, String lastChar) {
        String result = "";
        char nucChar = nuc.getSymbol().getCharacter();
        String residueName = "R" + nucChar + lastChar;
        if (nuc.getAtomCount() > 0) {
            for (int i = 0; i < nuc.getAtomCount(); ++i) {
                result = result + this.writeAtom(nuc.getAtom(i), residueName, strandChar, this.residueCount) + PackageConstants.ENDL;
            }
        } else {
            Atom3D atom = new Atom3D(nuc.getPosition());
            atom.setName("C4*");
            result = this.writeAtom(atom, residueName, strandChar, this.residueCount) + PackageConstants.ENDL;
        }
        return result;
    }

    private String writeAminoAcid(AminoAcid3D aa, char strandChar) {
        String result = "";
        char aaChar = aa.getSymbol().getCharacter();
        String residueName = Protein3DTools.oneLetterToThreeLetter(aaChar);
        if (residueName.length() > 1) {
            residueName = residueName.substring(0, 1);
        }
        if (aa.getAtomCount() > 0) {
            for (int i = 0; i < aa.getAtomCount(); ++i) {
                result = result + this.writeAtom(aa.getAtom(i), residueName, strandChar, this.residueCount) + PackageConstants.ENDL;
            }
        } else {
            Atom3D atom = new Atom3D(aa.getPosition());
            atom.setName("C");
            result = this.writeAtom(atom, residueName, strandChar, this.residueCount) + PackageConstants.ENDL;
        }
        return result;
    }

    public String writeStrand(NucleotideStrand strand, char strandChar, int startPos, int endPos) {
        log.fine("Writing nucleotide strand with character: " + strandChar);
        String result = "";
        for (int i = startPos; i < endPos; ++i) {
            String lastChar = "";
            if (i == startPos) {
                lastChar = "5";
            } else if (i == endPos - 1) {
                lastChar = "3";
            }
            result = result + this.writeNucleotide((Nucleotide3D)strand.getResidue(i), strandChar, lastChar);
            ++this.residueCount;
        }
        result = result + "TER                                          " + PackageConstants.ENDL;
        log.fine("Finished writing nucleotide strand with character: " + strandChar);
        this.incStrandChar();
        return result;
    }

    public String writeStrand(NucleotideStrand strand, char strandChar) {
        return this.writeStrand(strand, strandChar, 0, strand.getResidueCount());
    }

    private String writeProteinStrand(ProteinStrand strand, char strandChar) {
        String result = "";
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            result = result + this.writeAminoAcid((AminoAcid3D)strand.getResidue(i), strandChar);
            ++this.residueCount;
        }
        result = result + "TER                                          " + PackageConstants.ENDL;
        this.incStrandChar();
        return result;
    }

    private String writeStringInternal(Object3D node) {
        Object3D parent;
        NucleotideStrand strand;
        StringBuffer result = new StringBuffer();
        if (this.remarkMode) {
            List<String> remarks = this.extractPropertiesAsRemarks(node);
            for (String s : remarks) {
                result.append(s + PackageConstants.ENDL);
            }
        }
        if (this.objectTester != null && !this.objectTester.check(node)) {
            return "";
        }
        if (node instanceof NucleotideStrand) {
            strand = (NucleotideStrand)node;
            return this.writeStrand(strand, this.getStrandChar(strand));
        }
        if (node instanceof ProteinStrand) {
            return this.writeProteinStrand((ProteinStrand)node, this.strandChar);
        }
        if (node instanceof Nucleotide3D) {
            Nucleotide3D nucleotide = (Nucleotide3D)node;
            parent = nucleotide.getParent();
            NucleotideStrand strand2 = null;
            if (parent instanceof NucleotideStrand) {
                strand2 = (NucleotideStrand)parent;
            }
            return this.writeNucleotide(nucleotide, this.getStrandChar(strand2), "");
        }
        if (node instanceof AminoAcid3D) {
            return this.writeAminoAcid((AminoAcid3D)node, this.strandChar);
        }
        if (node instanceof Atom3D) {
            Object3D parent2;
            strand = null;
            parent = node.getParent();
            if (parent != null && (parent2 = parent.getParent()) instanceof NucleotideStrand) {
                strand = (NucleotideStrand)parent2;
            }
            return this.writeAtom((Atom3D)node, "UNK", this.getStrandChar(strand), 1) + PackageConstants.ENDL;
        }
        if (!this.junctionMode && (node instanceof StrandJunction3D || node instanceof BranchDescriptor3D)) {
            return result.toString();
        }
        for (int i = 0; i < node.size(); ++i) {
            result = result.append(this.writeStringInternal(node.getChild(i)));
        }
        return result.toString();
    }

    @Override
    public String writeString(Object3D node) {
        this.reset();
        if (debugMode) {
            Object3DSet strandSet = Object3DTools.collectByClassName(node, "RnaStrand");
            System.out.println("Starting AmberPdbWriter for RNA strands:");
            for (int i = 0; i < strandSet.size(); ++i) {
                System.out.println(strandSet.get(i).getFullName());
            }
        }
        return this.writeStringInternal(node);
    }

    @Override
    public void write(OutputStream os, LinkSet links) {
        PrintStream pw = new PrintStream(os);
        pw.println("");
    }
}

