/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ApplicationBugException;
import graphtools.IntPair;
import graphtools.IntegerList;
import graphtools.IntegerListList;
import graphtools.PathTools;
import java.util.ArrayList;
import java.util.logging.Logger;
import rnadesign.rnamodel.GridTiler;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaPhysicalProperties;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnasecondary.SimpleStem;
import rnasecondary.Stem;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;

public abstract class AbstractGridTiler
implements GridTiler {
    protected static RnaPhysicalProperties rpp = new RnaPhysicalProperties();
    protected int verboseLevel = 0;
    private Logger log = Logger.getLogger("NanoTiler_debug");

    protected int estimateSegmentResidueCount(double pathLength, int residuePerLoopCount) {
        double curveLength = (double)residuePerLoopCount * 5.0;
        int result = (int)((pathLength - curveLength) / RnaConstants.HELIX_RISE);
        if (result < 0) {
            result = 0;
        }
        return result += residuePerLoopCount;
    }

    int estimateResidueCount(IntegerList path, Object3DSet objectSet, int residuePerLoopCount) {
        int result = 0;
        for (int i = 1; i < path.size(); ++i) {
            Vector3D pos1 = objectSet.get(path.get(i - 1)).getPosition();
            Vector3D pos2 = objectSet.get(path.get(i)).getPosition();
            double length = pos1.distance(pos2);
            result += this.estimateSegmentResidueCount(length, residuePerLoopCount);
        }
        return result;
    }

    protected String generateSequenceString(int residueCount, char defaultChar) {
        char[] seqChars = new char[residueCount];
        for (int i = 0; i < residueCount; ++i) {
            seqChars[i] = defaultChar;
        }
        return new String(seqChars);
    }

    protected Object3DLinkSetBundle generateStrand(IntegerList path, Object3DSet objectSet, String name, char defaultSequenceChar, int residuePerLoopCount) {
        RnaStrand strand;
        Object3DLinkSetBundle bundle;
        int someExtra = 0;
        int residueCount = this.estimateResidueCount(path, objectSet, residuePerLoopCount) + someExtra;
        this.log.fine("Called estimate residue count: " + objectSet.size() + " path: " + path + " result: " + residueCount);
        String sequenceString = this.generateSequenceString(residueCount, defaultSequenceChar);
        String sequenceName = name + ".s";
        Vector3D startPos = objectSet.get(path.get(0)).getPosition();
        Vector3D direction = objectSet.get(path.get(1)).getPosition().minus(startPos);
        try {
            bundle = Rna3DTools.generateSimpleRnaStrand(name, sequenceString, startPos, direction);
            strand = (RnaStrand)bundle.getObject3D();
        }
        catch (UnknownSymbolException e) {
            throw new ApplicationBugException("Internal error when trying to generate " + sequenceName + " sequence: " + sequenceString);
        }
        strand.setPosition(objectSet.get(path.get(0)).getPosition());
        this.log.fine("Finished AbstractGridTiler.generateStrand: " + bundle.getObject3D().size() + " " + bundle.getLinks().size());
        return bundle;
    }

    private boolean isCircularPath(IntegerList path) {
        return path.size() > 2 && path.get(0) == path.get(path.size() - 1);
    }

    protected IntPair getResidueRange(IntegerList pathOrig, Object3DSet objectSet, int objectId1, int objectId2, int residuePerLoopCount) {
        int i;
        this.log.fine("Started getResidueRange with path: " + pathOrig + " ids: " + objectId1 + " " + objectId2);
        boolean circularMode = false;
        IntegerList path = pathOrig;
        if (this.isCircularPath(pathOrig)) {
            path = pathOrig.subset(0, pathOrig.size() - 1);
            circularMode = true;
            this.log.fine("Circular mode detected! Using: " + path);
        }
        IntegerList initialPath = new IntegerList();
        IntegerList mainPath = new IntegerList();
        boolean watsonStrand = false;
        if (path.get(0) == objectId1 && path.get(path.size() - 1) == objectId2 && path.size() > 2) {
            this.log.fine("Special case 1: segement between start and end point of path!");
            mainPath.add(path.get(0));
            mainPath.add(path.get(path.size() - 1));
            for (i = 0; i < path.size(); ++i) {
                initialPath.add(path.get(i));
            }
        } else if (path.get(0) == objectId2 && path.get(path.size() - 1) == objectId1 && path.size() > 2) {
            this.log.fine("Special case 2: segement between start and end point of path!");
            watsonStrand = true;
            mainPath.add(path.get(path.size() - 1));
            mainPath.add(path.get(0));
            for (i = 0; i < path.size(); ++i) {
                initialPath.add(path.get(i));
            }
        } else {
            this.log.fine("General case: segement not touching start and end points of path!");
            initialPath.add(path.get(0));
            for (i = 1; i < path.size(); ++i) {
                boolean found = false;
                if (path.get(i - 1) == objectId1 && path.get(i) == objectId2) {
                    watsonStrand = true;
                    found = true;
                } else if (path.get(i - 1) == objectId2 && path.get(i) == objectId1) {
                    watsonStrand = false;
                    found = true;
                }
                if (found) {
                    mainPath.add(path.get(i - 1));
                    mainPath.add(path.get(i));
                    break;
                }
                initialPath.add(path.get(i));
            }
        }
        if (watsonStrand) {
            this.log.fine("Watson-strand mode! initial and main paths: " + initialPath + " , " + mainPath);
        }
        int initialResidues = this.estimateResidueCount(initialPath, objectSet, residuePerLoopCount);
        int mainResidues = this.estimateResidueCount(mainPath, objectSet, residuePerLoopCount);
        if (mainResidues <= 0) {
            throw new ApplicationBugException("Internal error in getResidueRange: " + initialPath + " , " + mainPath + " , " + initialResidues + " " + mainResidues);
        }
        IntPair result = watsonStrand ? new IntPair(initialResidues, initialResidues + mainResidues - 1) : new IntPair(initialResidues + mainResidues - 1, initialResidues);
        this.log.fine("Finished getResidueRange with result: " + result);
        return result;
    }

    private boolean isWatsonStrand(IntPair pair) {
        return pair.getFirst() <= pair.getSecond();
    }

    protected Stem generateStem(IntegerList path1, IntegerList path2, RnaStrand strand1, RnaStrand strand2, Object3DSet objectSet, int objectId1, int objectId2, int residuePerLoopCount) {
        this.log.fine("Starting generateStem with paths: " + path1 + " , " + path2 + " object ids: " + objectId1 + " " + objectId2);
        IntPair residueRange1 = this.getResidueRange(path1, objectSet, objectId1, objectId2, residuePerLoopCount);
        IntPair residueRange2 = this.getResidueRange(path2, objectSet, objectId1, objectId2, residuePerLoopCount);
        if (this.isWatsonStrand(residueRange2)) {
            throw new ApplicationBugException("Internal error (152) in SimpleGridTiler.generateStem ! ");
        }
        this.log.fine("Residue range of path " + path1.toString() + " ids: " + objectId1 + " " + objectId2 + " : " + residueRange1);
        this.log.fine("Residue range of path " + path2.toString() + " ids: " + objectId1 + " " + objectId2 + " : " + residueRange2);
        int startPos = residueRange1.getFirst();
        int stopPos = residueRange2.getFirst();
        int length = Math.abs(residueRange1.getSecond() - residueRange1.getFirst()) + 1;
        this.log.fine("Calling new SimpleStem with " + startPos + " " + stopPos + " " + length + " " + strand1.sequenceString() + " " + strand2.sequenceString());
        if (startPos < 0 || stopPos < 0 || length < 0) {
            throw new ApplicationBugException("Internal error (1) in SimpleGridTiler.generateStem ! " + startPos + " " + stopPos + " " + length + " " + strand1.getResidueCount() + " " + strand2.getResidueCount());
        }
        if (!SimpleStem.isValid(startPos, stopPos, length, strand1.getResidueCount(), strand2.getResidueCount())) {
            this.log.fine("oops, stem parameters are not valid: " + startPos + " " + stopPos + " " + length + " " + strand1.getResidueCount() + strand2.getResidueCount());
            return null;
        }
        SimpleStem stem = new SimpleStem(startPos, stopPos, length, strand1, strand2);
        if (!stem.isValid()) {
            this.log.fine("oh uh... : " + stem.getStartPos() + " " + stem.getStopPos() + " " + stem.size());
            return null;
        }
        return stem;
    }

    protected Object3DLinkSetBundle generateStem3D(IntegerListList paths, Object3DSet objectSet, Object3DSet strands, Link link, String stemName, Object3D nucleotideDB, int offset) {
        Object3DLinkSetBundle stem3d;
        this.log.fine("Starting generateStem3D!");
        int id1 = objectSet.indexOf(link.getObj1());
        int id2 = objectSet.indexOf(link.getObj2());
        if (id1 < 0 || id2 < 0) {
            throw new ApplicationBugException("Malformed Object3D Link found in generateStem!");
        }
        ArrayList<Integer> foundPaths = new ArrayList<Integer>();
        for (int i = 0; i < paths.size(); ++i) {
            IntegerList path = paths.get(i);
            if (PathTools.containsPair(path, id1, id2)) {
                foundPaths.add(new Integer(i));
            }
            if (!PathTools.containsPair(path, id2, id1)) continue;
            foundPaths.add(new Integer(i));
        }
        if (foundPaths.size() < 2) {
            throw new ApplicationBugException("no two paths found in generateStem!");
        }
        if (foundPaths.size() > 2) {
            throw new ApplicationBugException("more than two paths found in generateStem!");
        }
        int pathId1 = (Integer)foundPaths.get(0);
        int pathId2 = (Integer)foundPaths.get(1);
        this.log.fine("Using path (=strand) ids: " + pathId1 + " " + pathId2);
        RnaStrand strand1 = (RnaStrand)strands.get(pathId1);
        RnaStrand strand2 = (RnaStrand)strands.get(pathId2);
        IntPair residueRange1 = this.getResidueRange(paths.get(pathId1), objectSet, id1, id2, 2 * offset);
        this.log.fine("Residue range of first path: " + residueRange1);
        if (this.isWatsonStrand(residueRange1)) {
            this.log.fine("First path is Watson strand!");
            Stem stem = this.generateStem(paths.get(pathId1), paths.get(pathId2), strand1, strand2, objectSet, id1, id2, 2 * offset);
            if (stem == null) {
                this.log.fine("Warning: generated stem was null!");
                return null;
            }
            if (!stem.isValid()) {
                this.log.fine("Warning: generated stem is not valid!");
                return null;
            }
            Vector3D startPos3d = objectSet.get(id1).getPosition();
            Vector3D direction = objectSet.get(id2).getPosition().minus(objectSet.get(id1).getPosition());
            assert (direction.lengthSquare() > 0.0);
            direction.normalize();
            Vector3D xDir = Vector3DTools.generateRandomOrthogonalDirection(direction);
            xDir.normalize();
            Vector3D yDir = direction.cross(xDir);
            CoordinateSystem3D cs = new CoordinateSystem3D(startPos3d, xDir, yDir);
            SimpleBranchDescriptor3D branchDescriptor = new SimpleBranchDescriptor3D(strand2, strand1, stem.getStopPos(), stem.getStartPos(), cs);
            this.log.severe("calling outdated method Rna3DTools.generateRnaStem3D!");
            stem3d = Rna3DTools.generateRnaStem3D(strand1, strand2, stem.getStartPos(), stem.getStopPos(), stem.size(), offset, true, stemName, branchDescriptor, nucleotideDB);
        } else {
            this.log.fine("First path is Crick strand!");
            Stem stem = this.generateStem(paths.get(pathId2), paths.get(pathId1), strand2, strand1, objectSet, id1, id2, 2 * offset);
            if (stem == null) {
                this.log.fine("Warning: stem is null!");
                return null;
            }
            if (!stem.isValid()) {
                this.log.fine("Warning: generated stem is not valid!");
                return null;
            }
            Vector3D startPos3d = objectSet.get(id1).getPosition();
            Vector3D direction = objectSet.get(id2).getPosition().minus(objectSet.get(id1).getPosition());
            assert (direction.lengthSquare() > 0.0);
            direction.normalize();
            Vector3D xDir = Vector3DTools.generateRandomOrthogonalDirection(direction);
            xDir.normalize();
            Vector3D yDir = direction.cross(xDir);
            CoordinateSystem3D cs = new CoordinateSystem3D(startPos3d, xDir, yDir);
            SimpleBranchDescriptor3D branchDescriptor = new SimpleBranchDescriptor3D(strand1, strand2, stem.getStartPos(), stem.getStopPos(), cs);
            this.log.severe("calling outdated method Rna3DTools.generateRnaStem3D!");
            stem3d = Rna3DTools.generateRnaStem3D(strand2, strand1, stem.getStartPos(), stem.getStopPos(), stem.size(), offset, true, stemName, branchDescriptor, nucleotideDB);
        }
        this.log.fine("Finished generateStem3D!");
        return stem3d;
    }

    private void setStrandCoordinates(Object3DSet strandSet, Object3DSet stemSet, Object3D resultObjects, LinkSet stemLinks) {
        for (int i = 0; i < strandSet.size(); ++i) {
            Rna3DTools.interpolateNonStems((RnaStrand)strandSet.get(i), resultObjects);
        }
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int n) {
        this.verboseLevel = n;
    }
}

