/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.List;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.Object3D;

public class AI3DTools {
    public static final String TMP_TOKEN = "__RINGFIX_HELIXSTATUS";
    public static final String TMP_TOKEN_PLACED = "occupied";
    public static final String TMP_TOKEN_JUNCTIONCLASS = "__JUNCTION_CLASS";

    public static boolean strandEquivalent(NucleotideStrand strand1, NucleotideStrand strand2) {
        assert (strand1 != null);
        assert (strand2 != null);
        return strand1.sequenceString().equals(strand2.sequenceString());
    }

    public static Vector3D[] strandResiduePositions(BioPolymer strand, String atomName) {
        Vector3D[] result = new Vector3D[strand.getResidueCount()];
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            Object3D atom = strand.getResidue3D(i).getChild(atomName);
            result[i] = atom != null ? atom.getPosition() : strand.getResidue3D(i).getPosition();
        }
        return result;
    }

    public static boolean checkStrandDuplicate(BioPolymer strand1, BioPolymer strand2, double rmsCutoff, String atomName) {
        boolean firstTest = strand1.sequenceString().equals(strand2.sequenceString());
        if (!firstTest) {
            return false;
        }
        double rms = Vector3DTools.computeRms(AI3DTools.strandResiduePositions(strand1, atomName), AI3DTools.strandResiduePositions(strand2, atomName));
        return rms < rmsCutoff;
    }

    public static boolean junctionEquivalent(StrandJunction3D junction1, StrandJunction3D junction2) {
        if (junction1 instanceof KissingLoop3D ? !(junction2 instanceof KissingLoop3D) : junction2 instanceof KissingLoop3D) {
            return false;
        }
        if (junction1.getStrandCount() != junction2.getStrandCount()) {
            return false;
        }
        for (int i = 0; i < junction1.getStrandCount(); ++i) {
            if (AI3DTools.strandEquivalent(junction1.getStrand(i), junction2.getStrand(i))) continue;
            return false;
        }
        return true;
    }

    public static List<List<StrandJunction3D>> classifyJunctions(List<StrandJunction3D> junctions) {
        assert (junctions != null);
        ArrayList<List<StrandJunction3D>> junctionClasses = new ArrayList<List<StrandJunction3D>>();
        int count = 0;
        for (StrandJunction3D junction : junctions) {
            boolean found = false;
            for (int i = 0; i < junctionClasses.size(); ++i) {
                assert (((List)junctionClasses.get(i)).size() > 0);
                if (!AI3DTools.junctionEquivalent((StrandJunction3D)((List)junctionClasses.get(i)).get(0), junction)) continue;
                ((List)junctionClasses.get(i)).add(junction);
                junction.setProperty(TMP_TOKEN_JUNCTIONCLASS, "" + i);
                ++count;
                found = true;
                break;
            }
            if (found) continue;
            ArrayList<StrandJunction3D> newClass = new ArrayList<StrandJunction3D>();
            newClass.add(junction);
            junction.setProperty(TMP_TOKEN_JUNCTIONCLASS, "" + junctionClasses.size());
            junctionClasses.add(newClass);
            ++count;
        }
        assert (junctionClasses != null && count == junctions.size());
        return junctionClasses;
    }
}

