/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import java.util.logging.Logger;
import rnadesign.rnacontrol.Kaleidoscope;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.SymmetryTools;
import symmetry.Cell;
import symmetry.SpaceGroup;
import tools3d.CoordinateSystem;
import tools3d.LatticeSection;
import tools3d.Positionable3D;
import tools3d.Vector3D;
import tools3d.ZBuffer;

public class SymmetryKaleidoscope
implements Kaleidoscope {
    Logger log = Logger.getLogger("NanoTiler_debug");
    Cell cell;
    LatticeSection section;
    CoordinateSystem[] coordinateSystems;

    public SymmetryKaleidoscope(SpaceGroup spaceGroup, Cell cell, LatticeSection section) throws Object3DGraphControllerException {
        this.cell = cell;
        this.section = section;
        this.coordinateSystems = SymmetryTools.generateCoordinateSystems(spaceGroup, cell);
    }

    void transform(Positionable3D obj, CoordinateSystem cs, Vector3D shift) {
        obj.activeTransform(cs);
        obj.translate(shift);
    }

    @Override
    public void apply(ZBuffer zBuffer) {
        this.log.fine("applying SymmetryKaleidoscope with section: " + this.section);
        assert (this.section.getVolume() > 0);
        int origSize = zBuffer.size();
        for (int i = this.section.getXMin(); i < this.section.getXMax(); ++i) {
            Vector3D shiftX = this.cell.getX().mul(i);
            for (int j = this.section.getYMin(); j < this.section.getYMax(); ++j) {
                Vector3D shiftY = this.cell.getY().mul(j);
                for (int k = this.section.getZMin(); k < this.section.getZMax(); ++k) {
                    Vector3D shiftZ = this.cell.getZ().mul(k);
                    Vector3D shift = shiftX.plus(shiftY).plus(shiftZ);
                    this.log.info("Applying shift: " + shift);
                    for (int jj = 0; jj < this.coordinateSystems.length; ++jj) {
                        if (i == 0 && j == 0 && k == 0 && jj == 0) continue;
                        this.log.info("Applying coordinate system: " + this.coordinateSystems[jj]);
                        CoordinateSystem cs = this.coordinateSystems[jj];
                        for (int ii = 0; ii < origSize; ++ii) {
                            Positionable3D newPos = (Positionable3D)zBuffer.get(ii).cloneDeep();
                            this.transform(newPos, cs, shift);
                            zBuffer.add(newPos);
                        }
                    }
                }
            }
        }
    }

    @Override
    public int getSymmetryCount() {
        return this.section.getVolume();
    }
}

