/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import java.util.List;
import java.util.Properties;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.ScriptGenerator;
import rnadesign.rnacontrol.TraceGraphDBScriptGenerator;
import rnadesign.rnacontrol.TraceGraphScriptGenerator2;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.symmetry2.SymEdgeConstraint;

public class ScriptController {
    public static String generateGraphTraceScript(Object3D graphRoot, LinkSet links, String name, List<SymEdgeConstraint> symConstraints, Properties params, String algorithm, boolean kissingLoopMode) throws Object3DGraphControllerException {
        ScriptGenerator generator = null;
        if ("helix".equals(algorithm)) {
            generator = new TraceGraphScriptGenerator2(graphRoot, links, name, symConstraints, params);
        } else if ("db".equals(algorithm)) {
            generator = new TraceGraphDBScriptGenerator(graphRoot, links, name, symConstraints, params, kissingLoopMode);
        } else {
            throw new Object3DGraphControllerException("Unknown trance script generator algorithm: " + algorithm + " . Defined are: helix|db");
        }
        assert (generator != null);
        return generator.generate();
    }
}

