/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnacontrol.JunctionController;
import rnadesign.rnacontrol.PdbJunctionControllerParameters;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.SimpleStrandJunctionDB;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import rnadesign.rnamodel.StrandJunctionDBTools;

public class PdbJunctionController
implements JunctionController {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String JUNCTION_DB_NAME = "junctionDB";
    public static final String KISSING_LOOP_DB_NAME = "kissingLoopDB";
    public static final int JUNCTIONS_LENGTH = 11;
    public static final int JUNCTION_ORDER_LENGTH = 22;
    public static final int ORIGINAL_JUNCTIONSTRING_LENGTH = 155;
    public static final int ORIGINAL_J_LENGTH = 144;
    public static final int KISSINGLOOPS_LENGTH = 15;
    public static final int ORIGINAL_KISSINGLOOPSTRING_LENGTH = 159;
    public static final int ORIGINAL_K_LENGTH = 144;
    public static final int LOOP_LENGTH_SUM_MAX = 50;
    private int branchDescriptorOffset = 2;
    private CorridorDescriptor corridorDescriptor = new CorridorDescriptor(0.0, 2.0);
    private StrandJunctionDB junctionDB;
    private StrandJunctionDB kissingLoopDB;
    private String nameFileName;
    private String readDir;
    private String writeDir;
    private boolean noWriteFlag = false;
    private int maxOrders = 4;
    private int loopLengthSumMax = 50;
    private int stemLengthMin = 3;
    private boolean rnaMode = true;
    private boolean randomMode = true;
    private boolean intHelixCheck = true;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public PdbJunctionController() {
    }

    public PdbJunctionController(int maxOrders, String nameFileName, String readDir, String writeDir, boolean noWriteFlag, boolean rnaMode, int branchDescriptorOffset, int stemLengthMin, CorridorDescriptor corridorDescriptor, int loopLengthSumMax, boolean intHelixChecker) {
        this.maxOrders = maxOrders;
        this.nameFileName = nameFileName;
        this.readDir = readDir;
        this.writeDir = writeDir;
        this.noWriteFlag = noWriteFlag;
        this.rnaMode = rnaMode;
        this.branchDescriptorOffset = branchDescriptorOffset;
        this.stemLengthMin = stemLengthMin;
        this.corridorDescriptor = corridorDescriptor;
        this.loopLengthSumMax = loopLengthSumMax;
        this.intHelixCheck = intHelixChecker;
        this.init();
        log.info("Generated PdbJunction controller with minimum stem length " + stemLengthMin);
    }

    public PdbJunctionController(int maxOrders, String nameFileName, String readDir, String writeDir, boolean noWriteFlag, boolean rnaMode, int branchDescriptorOffset, int stemLengthMin, CorridorDescriptor corridorDescriptor, int loopLengthSumMax) {
        this(maxOrders, nameFileName, readDir, writeDir, noWriteFlag, rnaMode, branchDescriptorOffset, stemLengthMin, corridorDescriptor, loopLengthSumMax, true);
    }

    public PdbJunctionController(PdbJunctionControllerParameters prm) {
        this(prm.orderMax, prm.nameFileName, prm.readDir, prm.writeDir, prm.noWriteFlag, prm.rnaMode, prm.branchDescriptorOffset, prm.stemLengthMin, prm.corridorDescriptor, prm.loopLengthSumMax, prm.intHelixCheck);
        log.info("Generated PdbJunction controller using parameter object with minimum stem length " + this.stemLengthMin);
    }

    public PdbJunctionControllerParameters getParameters() {
        return new PdbJunctionControllerParameters(this.maxOrders, this.nameFileName, this.readDir, this.writeDir, this.noWriteFlag, this.rnaMode, this.branchDescriptorOffset, this.stemLengthMin, this.corridorDescriptor, this.loopLengthSumMax, this.intHelixCheck);
    }

    private void init() {
        log.fine("Calling init!!");
        try {
            String[] fileNames = this.readNames(this.nameFileName);
            int[] cloneDownSizes = this.readCloneDownSizes(this.nameFileName);
            this.junctionDB = new SimpleStrandJunctionDB(this.maxOrders);
            this.kissingLoopDB = new SimpleStrandJunctionDB(this.maxOrders);
            this.kissingLoopDB.setName(KISSING_LOOP_DB_NAME);
            log.fine("Starting to parse PDB files.");
            StrandJunctionDBTools.parsePdbFilesToDB(this.junctionDB, this.kissingLoopDB, fileNames, cloneDownSizes, this.readDir, this.writeDir, this.noWriteFlag, this.rnaMode, this.randomMode, this.branchDescriptorOffset, this.stemLengthMin, this.corridorDescriptor, this.loopLengthSumMax, this.intHelixCheck);
            log.fine("PdbJunctionController initialized!");
            log.fine("Junctions:" + NEWLINE + this.junctionDB.infoString());
            log.fine("Kissing Loops:" + NEWLINE + this.kissingLoopDB.infoString());
            assert (this.isValid());
        }
        catch (IOException ioe) {
            log.severe("Error reading file names: " + ioe.getMessage());
        }
    }

    public String getJunctionString() {
        if (this.junctionDB == null) {
            return "No junction data defined.";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i <= 10; ++i) {
            buf.append("Number of loaded junctions of order " + i + " : " + this.junctionDB.size(i) + "\n");
        }
        return buf.toString();
    }

    public String getKissingLoopString() {
        if (this.kissingLoopDB == null) {
            return "No kissing loop data defined.";
        }
        return "Number of loaded kissing loops: " + this.kissingLoopDB.size(2);
    }

    @Override
    public boolean isValid() {
        return this.junctionDB != null && this.kissingLoopDB != null;
    }

    @Override
    public StrandJunctionDB getJunctionDB() {
        log.fine("called getJunctionDB");
        if (!this.isValid()) {
            log.finest("starting init");
            this.init();
        }
        log.finest("junctionDB: " + this.junctionDB);
        return this.junctionDB;
    }

    @Override
    public StrandJunctionDB getKissingLoopDB() {
        log.fine("called getKissingLoopDB");
        if (!this.isValid()) {
            log.finest("starting init.");
            this.init();
        }
        log.finest("kissingLoopDB: " + this.kissingLoopDB);
        return this.kissingLoopDB;
    }

    @Override
    public String infoString() {
        log.finest("called infoString.");
        return this.getJunctionString() + NEWLINE + this.getKissingLoopString();
    }

    public static String generateSuperposableJunctionString(int order, int n, double rmsLimit, StrandJunctionDB db) {
        int[] junctions = db.getSuperposableJunctions(order, n, rmsLimit);
        log.fine("Found " + junctions.length + " superposable objects for junction " + order + " " + (n + 1));
        StringBuffer buf = new StringBuffer();
        buf.append("" + order + " " + n);
        for (int i = 0; i < junctions.length; ++i) {
            buf.append(" " + (junctions[i] + 1));
        }
        return buf.toString();
    }

    public static void printSuperposableJunctions(double rmsLimit, StrandJunctionDB db, PrintStream ps) {
        if (db == null) {
            log.warning("No junction database defined.");
            return;
        }
        for (int order = 1; order < db.size(); ++order) {
            for (int n = 0; n < db.size(order); ++n) {
                String s = PdbJunctionController.generateSuperposableJunctionString(order, n, rmsLimit, db);
                ps.println(s);
            }
        }
    }

    @Override
    public void printSuperposableJunctions(double rmsLimit, PrintStream ps) {
        PdbJunctionController.printSuperposableJunctions(rmsLimit, this.junctionDB, ps);
    }

    @Override
    public void printSuperposableKissingLoops(double rmsLimit, PrintStream ps) {
        PdbJunctionController.printSuperposableJunctions(rmsLimit, this.kissingLoopDB, ps);
    }

    @Override
    public List<Properties> rankJunctionFits(BranchDescriptor3D b1, BranchDescriptor3D b2, int n1Min, int n1Max, int n2Min, int n2Max) {
        return this.junctionDB.rankLoopFits(b1, b2, n1Min, n1Max, n2Min, n2Max);
    }

    @Override
    public List<Properties> rankKissingLoopFits(BranchDescriptor3D b1, BranchDescriptor3D b2, int n1Min, int n1Max, int n2Min, int n2Max) {
        List<Properties> result = this.kissingLoopDB.rankLoopFits(b1, b2, n1Min, n1Max, n2Min, n2Max);
        return result;
    }

    public void reset(PdbJunctionControllerParameters prm) {
        log.fine("Called reset: " + prm);
        this.branchDescriptorOffset = prm.branchDescriptorOffset;
        this.loopLengthSumMax = prm.loopLengthSumMax;
        this.corridorDescriptor = prm.corridorDescriptor;
        this.maxOrders = prm.orderMax;
        this.nameFileName = prm.nameFileName;
        this.readDir = prm.readDir;
        this.writeDir = prm.writeDir;
        this.noWriteFlag = prm.noWriteFlag;
        this.rnaMode = prm.rnaMode;
        this.stemLengthMin = prm.stemLengthMin;
        this.junctionDB = null;
        this.kissingLoopDB = null;
        this.init();
    }

    private String[] readNames(String fileName) throws IOException {
        log.fine("called readNames");
        try {
            String line;
            log.fine("fileName: " + fileName);
            FileInputStream fis = new FileInputStream(fileName);
            DataInputStream dis = new DataInputStream(fis);
            ArrayList<String> list = new ArrayList<String>();
            while ((line = dis.readLine()) != null) {
                String s = line.trim();
                String[] words = s.split(" ");
                if (words.length > 0 && words[0].length() > 0) {
                    list.add(words[0]);
                } else if (s.length() > 0) {
                    list.add(s);
                }
                if (line != null) continue;
            }
            String[] result = new String[list.size()];
            fis.close();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)list.get(i);
            }
            return result;
        }
        catch (NullPointerException e) {
            log.warning(e + ":  " + e.getMessage());
            return null;
        }
    }

    private int[] readCloneDownSizes(String fileName) throws IOException {
        log.fine("called readNames");
        int[] result = null;
        try {
            String line;
            log.fine("fileName: " + fileName);
            FileInputStream fis = new FileInputStream(fileName);
            DataInputStream dis = new DataInputStream(fis);
            ArrayList<Integer> list = new ArrayList<Integer>();
            while ((line = dis.readLine()) != null && line.length() != 0) {
                String s = line.trim();
                String[] words = s.split(" ");
                if (words.length > 1 && words[1].length() > 0) {
                    list.add(Integer.parseInt(words[1]));
                } else {
                    list.add(0);
                }
                if (line != null) continue;
            }
            result = new int[list.size()];
            fis.close();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (Integer)list.get(i);
            }
        }
        catch (NullPointerException e) {
            log.warning(e + ":  " + e.getMessage());
            return null;
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing integer for clone down lengths: " + nfe.getMessage());
        }
        return result;
    }

    public List<StrandJunction3D> retrieveJunctions(DBElementDescriptor dbElement) {
        if (dbElement.getType() == 2) {
            return this.kissingLoopDB.retrieveJunctions(dbElement);
        }
        return this.junctionDB.retrieveJunctions(dbElement);
    }

    public List<StrandJunction3D> retrieveAllJunctions() {
        ArrayList<StrandJunction3D> result = new ArrayList<StrandJunction3D>();
        if (this.junctionDB != null) {
            result.addAll(this.junctionDB.retrieveAllJunctions());
        }
        if (this.kissingLoopDB != null) {
            result.addAll(this.kissingLoopDB.retrieveAllJunctions());
        }
        return result;
    }
}

