/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import guitools.BeanEditor;
import guitools.XMLBeanEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import rnadesign.designapp.rnagui.RotationWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.RotationDescriptor;
import tools3d.SimpleRotationDescriptor;
import tools3d.Vector3D;

public class XMLRotationWizard
implements RotationWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    Object3DGraphController controller;
    BeanEditor beanEditor = new XMLBeanEditor();
    Component frame;

    @Override
    public void addActionListener(ActionListener listener) {
        this.beanEditor.addActionListener(listener);
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component frame) {
        if (controller.getGraph().getSelectionRoot() == null) {
            return;
        }
        this.controller = controller;
        this.frame = frame;
        SimpleRotationDescriptor rotator = new SimpleRotationDescriptor();
        this.init(rotator);
        this.beanEditor.addActionListener(new DoneActionListener());
        this.beanEditor.launchEdit(rotator, frame);
    }

    @Override
    public RotationDescriptor getRotator() {
        SimpleRotationDescriptor rotator = (SimpleRotationDescriptor)this.beanEditor.getObject();
        if (rotator != null) {
            rotator.setAngle(rotator.getAngle() * (Math.PI / 180));
        }
        return rotator;
    }

    private void init(RotationDescriptor rotator) {
        rotator.setCenter(new Vector3D(1.0E-4, 1.0E-4, 1.0E-4));
        rotator.setAxis(new Vector3D(1.0, 0.0, 0.0));
        rotator.setAngle(90.0);
    }

    @Override
    public boolean isFinished() {
        return this.beanEditor.isFinished();
    }

    private class DoneActionListener
    implements ActionListener {
        private DoneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Calling DoneActionListener in RnaStrandWizard!");
            if (XMLRotationWizard.this.isFinished()) {
                log.fine("Calling DoneActionListener in RnaStrandWizard: text editor was finished!");
                RotationDescriptor rotator = XMLRotationWizard.this.getRotator();
                if (rotator != null && rotator.isValid()) {
                    XMLRotationWizard.this.controller.getGraph().rotateSelected(rotator);
                    log.fine("Here was adding of graph!");
                } else {
                    log.info("Rotator was null or invalid!");
                }
                log.fine("Rotating object tree!");
            } else {
                log.fine("Calling DoneActionListener in XMLRotationWizard: text editor was NOT finished!");
            }
            if (XMLRotationWizard.this.frame != null) {
                XMLRotationWizard.this.frame.repaint();
            }
            log.fine("RnaStrandWizard finished!");
        }
    }
}

