/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.Wizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class ShiftWizard
implements Wizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private static final int COL_SIZE_SELECTION = 20;
    private static final int COL_SIZE_DOUBLE = 8;
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    public static final String FRAME_TITLE = "Shift Wizard";
    private JTextField selectionField;
    private JTextField xField;
    private JTextField yField;
    private JTextField zField;
    private CommandApplication application;
    private List<String> shiftHistory;
    private List<String> selectHistory;

    public ShiftWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.shiftHistory = new ArrayList<String>();
        this.selectHistory = new ArrayList<String>();
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout());
        this.selectionField = new JTextField(this.getSelectionString(), 20);
        top.add(new JLabel("Shift:"));
        top.add(this.selectionField);
        JPanel shiftPanel = new JPanel();
        shiftPanel.setLayout(new FlowLayout());
        this.xField = new JTextField("0.0", 8);
        this.yField = new JTextField("0.0", 8);
        this.zField = new JTextField("0.0", 8);
        shiftPanel.add(new JLabel("Shift: x:"));
        shiftPanel.add(this.xField);
        shiftPanel.add(new JLabel(" y:"));
        shiftPanel.add(this.yField);
        shiftPanel.add(new JLabel(" z:"));
        shiftPanel.add(this.zField);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Shift");
        button.addActionListener(new ShiftButtonListener());
        bottomPanel.add(button);
        button = new JButton("Undo");
        button.addActionListener(new UndoListener());
        bottomPanel.add(button);
        button = new JButton("Redo");
        button.addActionListener(new RedoListener());
        bottomPanel.add(button);
        button = new JButton("Close");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)top, "North");
        f.add((Component)shiftPanel, "Center");
        f.add((Component)bottomPanel, "South");
    }

    private String getSelectionString() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "all";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    private class UndoListener
    implements ActionListener {
        private UndoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectCommand;
            assert (ShiftWizard.this.shiftHistory.size() == ShiftWizard.this.selectHistory.size());
            int commandIndex = ShiftWizard.this.shiftHistory.size() - 1;
            if (commandIndex < 0) {
                JOptionPane.showMessageDialog(ShiftWizard.this.frame, "There are no commands to undo!");
                return;
            }
            String commandToUndo = (String)ShiftWizard.this.shiftHistory.get(commandIndex);
            try {
                while (!commandToUndo.startsWith("shift")) {
                    commandToUndo = (String)ShiftWizard.this.shiftHistory.get(--commandIndex);
                }
            }
            catch (IndexOutOfBoundsException ie) {
                log.severe("Command history did not include shift! " + ie.getMessage());
            }
            if (commandIndex != ShiftWizard.this.shiftHistory.size() - 1) {
                if ((commandIndex -= ShiftWizard.this.shiftHistory.size() - 1 - commandIndex) < 0) {
                    JOptionPane.showMessageDialog(ShiftWizard.this.frame, "No more commands.");
                    return;
                }
                commandToUndo = (String)ShiftWizard.this.shiftHistory.get(commandIndex);
                if (!commandToUndo.startsWith("shift")) {
                    JOptionPane.showMessageDialog(ShiftWizard.this.frame, "Unshift cannot be undone. Try Redo.");
                }
            }
            String shiftCommand = "unshift " + commandToUndo.substring("shift ".length());
            String previousSelectCommand = selectCommand = (String)ShiftWizard.this.selectHistory.get(commandIndex);
            if (commandIndex - 1 >= 0) {
                previousSelectCommand = (String)ShiftWizard.this.selectHistory.get(commandIndex - 1);
            }
            assert (selectCommand.startsWith("select "));
            assert (previousSelectCommand.startsWith("select "));
            if (!selectCommand.equals(previousSelectCommand)) {
                selectCommand = previousSelectCommand;
                ShiftWizard.this.selectionField.setText(selectCommand.substring("select ".length()));
            }
            try {
                ShiftWizard.this.application.runScriptLine(shiftCommand);
                ShiftWizard.this.shiftHistory.add(shiftCommand);
                ShiftWizard.this.application.runScriptLine(selectCommand);
                ShiftWizard.this.selectHistory.add(selectCommand);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(ShiftWizard.this.frame, "Error executing undo command: " + shiftCommand + " or " + selectCommand + " : " + ce.getMessage());
            }
        }
    }

    private class RedoListener
    implements ActionListener {
        private RedoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ShiftWizard.this.shiftHistory.size() <= 0) {
                JOptionPane.showMessageDialog(ShiftWizard.this.frame, "Cannot redo. No action performed.");
                return;
            }
            String redoCommand = (String)ShiftWizard.this.shiftHistory.get(ShiftWizard.this.shiftHistory.size() - 1);
            if (redoCommand.startsWith("unshift")) {
                redoCommand = "shift " + redoCommand.substring("unshift ".length());
                String selectCommand = (String)ShiftWizard.this.selectHistory.get(ShiftWizard.this.selectHistory.size() - 2);
                try {
                    ShiftWizard.this.application.runScriptLine(redoCommand);
                    ShiftWizard.this.shiftHistory.add(redoCommand);
                    ShiftWizard.this.application.runScriptLine(selectCommand);
                    ShiftWizard.this.selectHistory.add(selectCommand);
                }
                catch (CommandException ce) {
                    JOptionPane.showMessageDialog(ShiftWizard.this.frame, "Error executing undo command: " + redoCommand + " or " + selectCommand + " : " + ce.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(ShiftWizard.this.frame, "Cannot redo shift. Try Undo.");
                return;
            }
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShiftWizard.this.frame.setVisible(false);
            ShiftWizard.this.frame = null;
            ShiftWizard.this.finished = true;
        }
    }

    private class ShiftButtonListener
    implements ActionListener {
        private ShiftButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectCommand = "select " + ShiftWizard.this.selectionField.getText().trim();
            String command = "shift " + ShiftWizard.this.xField.getText().trim() + " " + ShiftWizard.this.yField.getText().trim() + " " + ShiftWizard.this.zField.getText().trim();
            try {
                ShiftWizard.this.application.runScriptLine(selectCommand);
                ShiftWizard.this.selectHistory.add(selectCommand);
                ShiftWizard.this.application.runScriptLine(command);
                ShiftWizard.this.shiftHistory.add(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(ShiftWizard.this.frame, "Error executing command: " + selectCommand + " or " + command + " : " + ce.getMessage());
            }
        }
    }
}

