/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import SecondaryStructureDesign.SecondaryStructureEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SimpleMutableSecondaryStructure;
import sequence.DuplicateNameException;

public class SecondaryStructureEditorWizard
implements GeneralWizard {
    private Object3DGraphController graphController;
    public static final String FRAME_TITLE = "Secondary Structure Editor";
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    boolean finished = false;

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void cleanUp() {
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        MutableSecondaryStructure structure = null;
        try {
            structure = graphController.generateSecondaryStructure();
        }
        catch (DuplicateNameException dne) {
            structure = new SimpleMutableSecondaryStructure();
        }
        assert (structure != null);
        final MutableSecondaryStructure ss = structure;
        final Component c = parentFrame;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame frame = null;
                JDialog dialog = new JDialog(frame, SecondaryStructureEditorWizard.FRAME_TITLE, true);
                dialog.setLayout(new BorderLayout());
                dialog.add(new SecondaryStructureEditorPanel(ss, dialog));
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SecondaryStructureEditorWizard.this.finished = true;
                    }
                });
                dialog.setDefaultCloseOperation(2);
                dialog.pack();
                dialog.setLocationRelativeTo(c);
                dialog.setVisible(true);
            }
        });
        try {
            while (!this.finished) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

