/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.Wizard;

public class QuaderWizard
implements Wizard {
    private static final int COL_SIZE_INT = 3;
    private static final String FRAME_TITLE = "Quader Wizard";
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private JTextField xMinField;
    private JTextField yMinField;
    private JTextField zMinField;
    private JTextField xMaxField;
    private JTextField yMaxField;
    private JTextField zMaxField;

    public QuaderWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BoxLayout(f, 1));
        JPanel minMaxPanel = new JPanel(new GridLayout(4, 3));
        this.xMinField = new JTextField("0", 3);
        this.yMinField = new JTextField("0", 3);
        this.zMinField = new JTextField("0", 3);
        this.xMaxField = new JTextField("1", 3);
        this.yMaxField = new JTextField("1", 3);
        this.zMaxField = new JTextField("1", 3);
        minMaxPanel.add(new JLabel());
        minMaxPanel.add(new JLabel("min"));
        minMaxPanel.add(new JLabel("max"));
        minMaxPanel.add(new JLabel("x"));
        minMaxPanel.add(this.xMinField);
        minMaxPanel.add(this.xMaxField);
        minMaxPanel.add(new JLabel("y"));
        minMaxPanel.add(this.yMinField);
        minMaxPanel.add(this.yMaxField);
        minMaxPanel.add(new JLabel("z"));
        minMaxPanel.add(this.zMinField);
        minMaxPanel.add(this.zMaxField);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        f.add(minMaxPanel);
        f.add(buttonPanel);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int xMin = Integer.parseInt(QuaderWizard.this.xMinField.getText().trim());
            int yMin = Integer.parseInt(QuaderWizard.this.yMinField.getText().trim());
            int zMin = Integer.parseInt(QuaderWizard.this.zMinField.getText().trim());
            int xMax = Integer.parseInt(QuaderWizard.this.xMaxField.getText().trim());
            int yMax = Integer.parseInt(QuaderWizard.this.yMaxField.getText().trim());
            int zMax = Integer.parseInt(QuaderWizard.this.zMaxField.getText().trim());
            String command = "quader " + xMin + " " + yMin + " " + zMin + " " + xMax + " " + yMax + " " + zMax;
            try {
                QuaderWizard.this.application.runScriptLine(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(QuaderWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QuaderWizard.this.frame.setVisible(false);
            QuaderWizard.this.frame = null;
            QuaderWizard.this.finished = true;
        }
    }
}

