/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import rnadesign.designapp.rnagui.Object3DPainter;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.designapp.rnagui.SimpleOriginFactory;
import rnadesign.rnacontrol.CameraController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.SimpleCameraController;
import tools3d.Positionable3D;
import tools3d.ZBuffer;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Primitive3D;

public class PointPainter
implements Object3DPainter {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    int[] xTmpArray;
    int[] yTmpArray;
    boolean originMode = true;
    Primitive3D[] originPrimitives;
    CameraController cameraController = new SimpleCameraController();
    private RnaGuiParameters params;
    private ZBuffer zBuf = new ZBuffer();

    PointPainter(RnaGuiParameters p) {
        this.params = p;
        SimpleOriginFactory originFactory = new SimpleOriginFactory();
        this.originPrimitives = originFactory.createOrigin();
    }

    @Override
    public void copy(Object3DPainter other) {
        if (other instanceof PointPainter) {
            PointPainter c = (PointPainter)other;
            this.cameraController.copy(c.cameraController);
            this.params.copy(c.params);
        }
    }

    public void drawObject3D(Graphics2D g2, Object3D obj3d) {
        if (obj3d == null) {
            log.warning("Called drawObject3D with null object!");
            return;
        }
        Point2D point = this.cameraController.project(obj3d.getPosition());
        double posX = point.getX();
        double posY = point.getY();
        g2.drawLine((int)point.getX(), (int)point.getY(), (int)point.getX(), (int)point.getY());
    }

    public void drawPrimitive(Graphics2D g2, Primitive3D p3d) {
        if (p3d == null) {
            log.warning("Called drawPrimitive with null object!");
            return;
        }
        if (p3d.size() <= 0) {
            // empty if block
        }
        g2.setXORMode(p3d.getColor());
        if (p3d.size() == 1) {
            Point2D point = this.cameraController.project(p3d.getPoint(0));
            double posX = point.getX();
            double posY = point.getY();
            g2.drawLine((int)posX, (int)posY, (int)posX, (int)posY);
        } else if (p3d.size() == 2) {
            Point2D pointA = this.cameraController.project(p3d.getPoint(0));
            Point2D pointB = this.cameraController.project(p3d.getPoint(1));
            g2.draw(new Line2D.Double(pointA, pointB));
        } else {
            if (this.xTmpArray == null || this.xTmpArray.length != p3d.size()) {
                this.xTmpArray = new int[p3d.size()];
                this.yTmpArray = new int[p3d.size()];
            }
            for (int i = 0; i < p3d.size(); ++i) {
                Point2D point = this.cameraController.project(p3d.getPoint(i));
                this.xTmpArray[i] = (int)point.getX();
                this.xTmpArray[i] = (int)point.getY();
            }
            g2.fill(new Polygon(this.xTmpArray, this.yTmpArray, this.xTmpArray.length));
        }
    }

    public void drawPositionable(Graphics2D g2, Positionable3D p3d) {
        if (p3d instanceof Primitive3D) {
            this.drawPrimitive(g2, (Primitive3D)p3d);
        } else if (p3d instanceof Object3D) {
            this.drawObject3D(g2, (Object3D)p3d);
        }
    }

    @Override
    public CameraController getCameraController() {
        return this.cameraController;
    }

    public boolean getOriginMode() {
        return this.originMode;
    }

    @Override
    public void paint(Graphics g, Object3DGraphController graphController) {
        int i;
        if (graphController.getGraph().getObjectCount() == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        graphController.getGraph().resetIterator();
        boolean counter = false;
        this.zBuf.reset();
        this.zBuf.setDirection(this.cameraController.getCamera().getViewDirection());
        if (this.originMode) {
            for (i = 0; i < this.originPrimitives.length; ++i) {
                this.zBuf.add(this.originPrimitives[i]);
            }
        }
        this.zBuf.sort();
        for (i = this.zBuf.size() - 1; i >= 0; --i) {
            this.drawPositionable(g2, this.zBuf.get(i));
        }
    }

    @Override
    public void removeForbidden(String s) {
        assert (false);
    }

    @Override
    public void addForbidden(String s) {
        assert (false);
    }

    @Override
    public void clearForbidden() {
        assert (false);
    }

    @Override
    public void setCameraController(CameraController p) {
        this.cameraController = p;
    }

    public void setOriginMode(boolean originMode) {
        this.originMode = originMode;
    }
}

