/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import tools3d.objects3d.Object3D;

public class Object3DTreeModel
implements TreeModel {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean showAncestors = false;
    private Vector<TreeModelListener> treeModelListeners = new Vector();
    private Object3D rootObject;

    public Object3DTreeModel(Object3D root) {
        this.rootObject = root;
    }

    public void showAncestor(boolean b, Object newRoot) {
        this.showAncestors = b;
        Object3D oldRoot = this.rootObject;
        if (newRoot != null) {
            this.rootObject = (Object3D)newRoot;
        }
        this.fireTreeStructureChanged(oldRoot);
    }

    protected void fireTreeStructureChanged(Object3D oldRoot) {
        log.fine("Calling fireTreeStructureChanged");
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < len; ++i) {
            this.treeModelListeners.elementAt(i).treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object3D p = (Object3D)parent;
        return p.getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        Object3D p = (Object3D)parent;
        return p.size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Object3D p = (Object3D)parent;
        return p.getIndexOfChild((Object3D)child);
    }

    @Override
    public Object getRoot() {
        return this.rootObject;
    }

    @Override
    public boolean isLeaf(Object node) {
        Object3D p = (Object3D)node;
        return p.size() == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        log.info("*** valueForPathChanged : " + path + " --> " + newValue);
    }
}

