/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.InvalidParametersException;
import rnadesign.rnacontrol.Object3DGraphController;

public class MinimizeWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private JTextField stepField;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private int numSteps = 100;
    private double scale = 1.0;
    private static String[] algorithmNames = new String[]{"Monte Carlo", "Elastic Network Extrapolation"};
    private int algorithmId = 0;
    private JComboBox algorithmChoice;
    private Object3DGraphController graphController;
    public static final String FRAME_TITLE = "Minimization setup Wizard";

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void cleanUp() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame = null;
        }
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        boolean result = this.checkValues();
        if (result) {
            this.frame = new JFrame(FRAME_TITLE);
            this.addComponents(this.frame);
            this.frame.pack();
            this.frame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(parentFrame, "No objects defined so far!");
        }
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new FlowLayout());
        center.setPreferredSize(new Dimension(400, 400));
        if (this.graphController == null) {
            log.info("GraphController is null before generating left and right tree panels!");
        }
        this.algorithmChoice = new JComboBox<String>(algorithmNames);
        JPanel middlePanel = new JPanel();
        this.stepField = new JTextField("" + this.numSteps, 6);
        middlePanel.setPreferredSize(new Dimension(300, 200));
        middlePanel.setLayout(new FlowLayout());
        middlePanel.add(this.algorithmChoice);
        middlePanel.add(new JLabel("Number of steps: "));
        middlePanel.add(this.stepField);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setPreferredSize(new Dimension(300, 200));
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        JPanel southPanel = new JPanel();
        southPanel.add(middlePanel);
        southPanel.add(bottomPanel);
        f.add((Component)southPanel, "South");
    }

    private boolean checkValues() {
        return this.graphController.getGraph().getObjectCount() > 0;
    }

    private void readOutValues() {
        this.algorithmId = this.algorithmChoice.getSelectedIndex();
        this.numSteps = Integer.parseInt(this.stepField.getText().trim());
    }

    private boolean isValid() {
        this.readOutValues();
        return this.numSteps >= 0 && this.scale > 0.0;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MinimizeWizard.this.cleanUp();
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MinimizeWizard.this.readOutValues();
            if (MinimizeWizard.this.isValid()) {
                try {
                    int algorithmCode = 0;
                    switch (MinimizeWizard.this.algorithmId) {
                        case 0: {
                            algorithmCode = 1;
                            break;
                        }
                        case 1: {
                            algorithmCode = 2;
                        }
                    }
                    MinimizeWizard.this.graphController.minimize(MinimizeWizard.this.numSteps, MinimizeWizard.this.scale, algorithmCode);
                    MinimizeWizard.this.cleanUp();
                }
                catch (InvalidParametersException exception) {
                    JOptionPane.showMessageDialog(MinimizeWizard.this.frame, "The current parameters were not ok!");
                }
            } else {
                JOptionPane.showMessageDialog(MinimizeWizard.this.frame, "The current parameters are not ok!");
            }
        }
    }
}

