/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.Wizard;

public class LaunchRnaInverseWizard
implements Wizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private JTextField stepField;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private static String[] algorithmNames = new String[]{"RNAinverseGroup v1"};
    private boolean importFlag = true;
    private JCheckBox importBox;
    private double rmsLimit = 3.0;
    private CommandApplication application;
    public static final String FRAME_TITLE = "Sequence optimization Wizard";

    public LaunchRnaInverseWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void cleanUp() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame = null;
        }
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        boolean result = this.checkValues();
        if (result) {
            this.frame = new JFrame(FRAME_TITLE);
            this.addComponents(this.frame);
            this.frame.pack();
            this.frame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(parentFrame, "No objects defined so far!");
        }
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new FlowLayout());
        center.setPreferredSize(new Dimension(400, 400));
        JPanel middlePanel = new JPanel();
        middlePanel.setPreferredSize(new Dimension(300, 200));
        middlePanel.setLayout(new FlowLayout());
        middlePanel.add(new JLabel("Launch sequence optimization? "));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout());
        this.importBox = new JCheckBox();
        topPanel.add(new JLabel("Import sequences:"));
        topPanel.add(this.importBox);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setPreferredSize(new Dimension(300, 200));
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Launch");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        JPanel southPanel = new JPanel();
        southPanel.add(middlePanel);
        southPanel.add(bottomPanel);
        f.add((Component)topPanel, "North");
        f.add((Component)southPanel, "South");
    }

    private boolean checkValues() {
        return true;
    }

    private void readOutValues() {
        this.importFlag = this.importBox.isSelected();
    }

    private boolean isValid() {
        this.readOutValues();
        return true;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LaunchRnaInverseWizard.this.cleanUp();
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LaunchRnaInverseWizard.this.readOutValues();
            if (LaunchRnaInverseWizard.this.isValid()) {
                String command = "optimize_sequences import=" + LaunchRnaInverseWizard.this.importFlag + " rms=" + LaunchRnaInverseWizard.this.rmsLimit;
                try {
                    LaunchRnaInverseWizard.this.application.runScriptLine(command);
                    LaunchRnaInverseWizard.this.cleanUp();
                }
                catch (CommandException ce) {
                    JOptionPane.showMessageDialog(LaunchRnaInverseWizard.this.frame, "Error executing command: " + command + " : " + ce.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(LaunchRnaInverseWizard.this.frame, "The current parameters are not ok!");
            }
        }
    }
}

