/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import guitools.BeanEditor;
import guitools.XMLBeanEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleRnaStrand;
import sequence.DnaTools;
import sequence.Sequence;
import sequence.SimpleSequence;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;

public class LaunchMcSymWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    Object3DGraphController controller;
    BeanEditor beanEditor = new XMLBeanEditor();
    Component frame;

    @Override
    public void addActionListener(ActionListener listener) {
        this.beanEditor.addActionListener(listener);
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component frame) {
        this.controller = controller;
        this.frame = frame;
        SimpleRnaStrand strand = new SimpleRnaStrand();
        this.initStrand(strand);
        this.beanEditor.addActionListener(new DoneActionListener());
        this.beanEditor.launchEdit(strand, frame);
    }

    private Sequence generateInitSequence() {
        String s = "NNNNNNNNNNNNNNNNNNNN";
        String name = "unnamed";
        SimpleSequence result = null;
        try {
            result = new SimpleSequence(s, name, DnaTools.AMBIGUOUS_RNA_ALPHABET);
        }
        catch (UnknownSymbolException e) {
            // empty catch block
        }
        return result;
    }

    private void initStrand(RnaStrand strand) {
        assert (false);
        strand.setRelativePosition(new Vector3D(10.0, 20.0, 10.0));
    }

    @Override
    public boolean isFinished() {
        return this.beanEditor.isFinished();
    }

    private class DoneActionListener
    implements ActionListener {
        private DoneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Calling DoneActionListener in RnaStrandWizard!");
            if (LaunchMcSymWizard.this.isFinished()) {
                log.fine("Calling DoneActionListener in LaunchMcSymWizard: text editor was finished!");
            } else {
                log.fine("Calling DoneActionListener in LaunchMcSymWizard: text editor was NOT finished!");
            }
            if (LaunchMcSymWizard.this.frame != null) {
                LaunchMcSymWizard.this.frame.repaint();
            }
            log.fine("RnaStrandWizard finished!");
        }
    }
}

