/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class HideGraphicsWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame;
    private JCheckBox atomsBox;
    private JCheckBox moleculesBox;
    private JCheckBox nucleotidesBox;
    private JCheckBox strandsBox;
    private boolean addAtomsFlag = false;
    private boolean addMoleculesFlag = false;
    private boolean addNucleotidesFlag = false;
    private boolean addStrandsFlag = false;
    private String FRAME_TITLE = "Hide Graphics";
    private Object3DGraphController graphController;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private boolean finished = false;

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(this.FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        JPanel topPanel = new JPanel();
        JPanel sPanel = new JPanel();
        JPanel checkPanel = new JPanel();
        this.atomsBox = new JCheckBox("hide atoms", this.addAtomsFlag);
        this.moleculesBox = new JCheckBox("hide molecules", this.addMoleculesFlag);
        this.nucleotidesBox = new JCheckBox("hide nucleotides", this.addNucleotidesFlag);
        this.strandsBox = new JCheckBox("hide strands", this.addStrandsFlag);
        topPanel.add(this.atomsBox);
        topPanel.add(this.moleculesBox);
        topPanel.add(this.nucleotidesBox);
        topPanel.add(this.strandsBox);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        f.add((Component)topPanel, "North");
        f.add((Component)bottomPanel, "South");
    }

    private void readOutValues() {
        this.addAtomsFlag = this.atomsBox.isSelected();
        this.addMoleculesFlag = this.moleculesBox.isSelected();
        this.addNucleotidesFlag = this.nucleotidesBox.isSelected();
        this.addStrandsFlag = this.strandsBox.isSelected();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HideGraphicsWizard.this.frame.setVisible(false);
            HideGraphicsWizard.this.frame = null;
            HideGraphicsWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HideGraphicsWizard.this.readOutValues();
            HideGraphicsWizard.this.frame.setVisible(false);
            HideGraphicsWizard.this.frame = null;
            HideGraphicsWizard.this.finished = true;
        }
    }
}

