/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.BadSyntaxException;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.UnknownCommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class HelpWizard
implements GeneralWizard {
    private static final int COL_SIZE = 15;
    private boolean finished = false;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame = null;
    private JTextArea resultsField;
    private JButton button;
    private JComboBox commandChoice;
    private CommandApplication application;
    private NanoTilerInterpreter interpreter;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    private String[] commandNames;
    public static final String FRAME_TITLE = "Help";

    public HelpWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.interpreter = (NanoTilerInterpreter)application.getInterpreter();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private void initCommandNames() {
        this.commandNames = new String[this.interpreter.countKnownCommands()];
        StringTokenizer tokenizer = new StringTokenizer(this.interpreter.getKnownCommandNames());
        for (int k = 0; k < this.commandNames.length; ++k) {
            this.commandNames[k] = tokenizer.nextToken();
        }
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.initCommandNames();
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        this.commandChoice = new JComboBox<String>(this.commandNames);
        this.commandChoice.addActionListener(new MenuListener());
        this.resultsField = new JTextArea(20, 30);
        this.resultsField.setLineWrap(true);
        this.resultsField.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.resultsField);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(20);
        centerPanel.add(scroll);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.add(new JLabel("Select the command that you would like to receive help for:              "));
        topPanel.add(this.commandChoice);
        JPanel buttonPanel = new JPanel();
        this.button = new JButton("Done");
        this.button.addActionListener(new DoneListener());
        buttonPanel.add(this.button);
        f.add((Component)topPanel, "North");
        f.add((Component)buttonPanel, "South");
        f.add((Component)centerPanel, "Center");
        try {
            try {
                Command command = this.interpreter.interpretLine(this.commandNames[0]);
                String helpText = command.getLongHelpText();
                this.resultsField.setText(helpText);
            }
            catch (BadSyntaxException exc) {}
        }
        catch (UnknownCommandException ex) {
            // empty catch block
        }
    }

    private class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedCommand = (String)((JComboBox)e.getSource()).getSelectedItem();
            try {
                try {
                    Command command = HelpWizard.this.interpreter.interpretLine(selectedCommand);
                    String helpText = command.getLongHelpText();
                    HelpWizard.this.resultsField.setText(helpText);
                }
                catch (BadSyntaxException exc) {
                    Object command = null;
                }
            }
            catch (UnknownCommandException ex) {
                log.severe("Unknown Command");
            }
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpWizard.this.frame.setVisible(false);
            HelpWizard.this.frame = null;
            HelpWizard.this.finished = true;
        }
    }
}

