/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import rnadesign.designapp.rnagui.GeometryPainter;
import rnadesign.designapp.rnagui.Object3DPainter;
import rnadesign.designapp.rnagui.RainbowColorModel;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.designapp.rnagui.SimpleOriginFactory;
import rnadesign.designapp.rnagui.WireGeometryPainter;
import rnadesign.rnacontrol.CameraController;
import rnadesign.rnacontrol.Kaleidoscope;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.SimpleCameraController;
import tools3d.AbstractGeometryElement;
import tools3d.Drawable;
import tools3d.Geometry;
import tools3d.GeometryColorModel;
import tools3d.Positionable3D;
import tools3d.Shape3D;
import tools3d.Shape3DSet;
import tools3d.ZBuffer;
import tools3d.objects3d.Primitive3D;

public class GeneralGeometryPainter
implements Object3DPainter {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    int[] xTmpArray;
    int[] yTmpArray;
    double geometryAngleDelta = 0.5235987755982988;
    boolean originMode = false;
    boolean debugMode = false;
    Primitive3D[] originPrimitives;
    GeometryPainter geometryPainter = new WireGeometryPainter();
    GeometryColorModel colorModel = new RainbowColorModel();
    CameraController cameraController = new SimpleCameraController();
    Object3DGraphController graphController;
    private RnaGuiParameters params;
    private ZBuffer zBuf = new ZBuffer();

    GeneralGeometryPainter(RnaGuiParameters p, GeometryPainter geometryPainter, Object3DGraphController graphController) {
        this.params = p;
        SimpleOriginFactory originFactory = new SimpleOriginFactory();
        this.originPrimitives = originFactory.createOrigin();
        this.geometryPainter = geometryPainter;
        this.geometryPainter.setCameraController(this.cameraController);
        this.graphController = graphController;
    }

    @Override
    public void addForbidden(String forbiddenClassName) {
        this.geometryPainter.addForbidden(forbiddenClassName);
    }

    @Override
    public void clearForbidden() {
        this.geometryPainter.clearForbidden();
    }

    @Override
    public void removeForbidden(String forbiddenClassName) {
        this.geometryPainter.removeForbidden(forbiddenClassName);
    }

    @Override
    public void copy(Object3DPainter other) {
        if (other instanceof GeneralGeometryPainter) {
            GeneralGeometryPainter c = (GeneralGeometryPainter)other;
            this.cameraController.copy(c.cameraController);
            this.params.copy(c.params);
        }
    }

    public void drawPrimitive(Graphics2D g2, Primitive3D p3d) {
        if (p3d == null) {
            log.severe("Called drawPrimitive with null object!");
            return;
        }
        Color colorSave = g2.getColor();
        g2.setColor(p3d.getColor());
        if (p3d.size() > 0) {
            if (p3d.size() == 1) {
                Point2D point = this.cameraController.project(p3d.getPoint(0));
                double posX = point.getX();
                double posY = point.getY();
                g2.fill(new Ellipse2D.Double(posX, posY, this.params.circleRad, this.params.circleRad));
            } else if (p3d.size() == 2) {
                Point2D pointA = this.cameraController.project(p3d.getPoint(0));
                Point2D pointB = this.cameraController.project(p3d.getPoint(1));
                g2.draw(new Line2D.Double(pointA, pointB));
            } else {
                if (this.xTmpArray == null || this.xTmpArray.length != p3d.size()) {
                    this.xTmpArray = new int[p3d.size()];
                    this.yTmpArray = new int[p3d.size()];
                }
                for (int i = 0; i < p3d.size(); ++i) {
                    Point2D point = this.cameraController.project(p3d.getPoint(i));
                    this.xTmpArray[i] = (int)point.getX();
                    this.xTmpArray[i] = (int)point.getY();
                }
                g2.fill(new Polygon(this.xTmpArray, this.yTmpArray, this.xTmpArray.length));
            }
        }
        g2.setColor(colorSave);
    }

    @Override
    public CameraController getCameraController() {
        return this.cameraController;
    }

    @Override
    public void paint(Graphics g, Object3DGraphController graphController) {
        int i;
        if (graphController.getGraph() == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        boolean counter = false;
        this.zBuf.reset();
        this.zBuf.setDirection(this.cameraController.getViewDirection());
        Shape3DSet shapeSet = graphController.getShapeSet();
        if (shapeSet != null) {
            for (i = 0; i < shapeSet.size(); ++i) {
                AbstractGeometryElement posi;
                int j;
                Shape3D shape = shapeSet.get(i);
                Geometry geometry = shape.createGeometry(this.geometryAngleDelta);
                if (geometry == null) continue;
                for (j = 0; j < geometry.getNumberPoints(); ++j) {
                    posi = geometry.getPoint(j);
                    if (!this.geometryPainter.isPaintable(posi)) continue;
                    this.zBuf.add(posi);
                }
                for (j = 0; j < geometry.getNumberEdges(); ++j) {
                    posi = geometry.getEdge(j);
                    if (!this.geometryPainter.isPaintable(posi)) continue;
                    this.zBuf.add(posi);
                }
                for (j = 0; j < geometry.getNumberFaces(); ++j) {
                    posi = geometry.getFace(j);
                    if (!this.geometryPainter.isPaintable(posi)) continue;
                    this.zBuf.add(posi);
                }
            }
        } else if (this.debugMode) {
            log.warning("shape set was null in GeneralGeometryPainter!");
        }
        if (this.originMode) {
            for (i = 0; i < this.originPrimitives.length; ++i) {
                this.zBuf.add(this.originPrimitives[i]);
            }
        }
        Kaleidoscope kaleidoscope = graphController.getKaleidoscope();
        assert (kaleidoscope != null);
        if (kaleidoscope != null && kaleidoscope.getSymmetryCount() > 1) {
            int origSize = this.zBuf.size();
            kaleidoscope.apply(this.zBuf);
        }
        this.zBuf.sort();
        for (int i2 = this.zBuf.size() - 1; i2 >= 0; --i2) {
            Positionable3D pobj = this.zBuf.get(i2);
            if (pobj instanceof Primitive3D) {
                this.drawPrimitive(g2, (Primitive3D)pobj);
                continue;
            }
            if (pobj instanceof Drawable) {
                this.geometryPainter.paint((Graphics)g2, (Drawable)pobj);
                continue;
            }
            log.warning("unpaintable object in zBuffer!");
        }
    }

    @Override
    public void setCameraController(CameraController p) {
        this.cameraController = p;
        this.geometryPainter.setCameraController(p);
    }
}

