/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class FuseStrandsWizard
implements GeneralWizard {
    private static final int COL_SIZE_NAME = 20;
    private static final String FRAME_TITLE = "GenLink Wizard";
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Object3DGraphController graphController;
    private JLabel label;
    private JTextField selectionField1;
    private JTextField selectionField2;
    private Vector<String> tree;
    private String[] allowedNames = new String[]{"RnaStrand"};
    private String[] forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;

    public FuseStrandsWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        JPanel westCenterPanel = new JPanel();
        westCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Strand 1: ");
        westCenterPanel.add((Component)this.label, "North");
        this.selectionField1 = new JTextField(this.getSelectionText(), 20);
        westCenterPanel.add((Component)this.selectionField1, "Center");
        westCenterPanel.add((Component)new TreePanel(this.selectionField1), "South");
        centerPanel.add((Component)westCenterPanel, "West");
        JPanel centerCenterPanel = new JPanel();
        centerCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Strand 2: ");
        centerCenterPanel.add((Component)this.label, "North");
        this.selectionField2 = new JTextField(this.getSelectionText(), 20);
        centerCenterPanel.add((Component)this.selectionField2, "Center");
        centerCenterPanel.add((Component)new TreePanel(this.selectionField2), "South");
        centerPanel.add((Component)centerCenterPanel, "East");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Fuse Strands");
        button.addActionListener(new FuseStrandsListener());
        buttonPanel.add(button);
        f.add((Component)centerPanel, "Center");
        f.add((Component)buttonPanel, "South");
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        if (controller == null) {
            log.info("GraphController received by lauchWizard is null!");
        }
        this.graphController = controller;
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextField field;

        public SelectionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)FuseStrandsWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)FuseStrandsWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.setText(text);
            }
        }
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextField field) {
            Object3DGraphController controller = ((AbstractDesigner)FuseStrandsWizard.this.application).getGraphController();
            FuseStrandsWizard.this.tree = controller.getGraph().getTree(FuseStrandsWizard.this.allowedNames, FuseStrandsWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            FuseStrandsWizard.this.treePanel = new JPanel();
            FuseStrandsWizard.this.treeList = new JList(FuseStrandsWizard.this.tree);
            FuseStrandsWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            FuseStrandsWizard.this.treeScroll = new JScrollPane(FuseStrandsWizard.this.treeList);
            FuseStrandsWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            FuseStrandsWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            FuseStrandsWizard.this.treeScroll.setPreferredSize(new Dimension(300, 200));
            FuseStrandsWizard.this.treePanel.add(FuseStrandsWizard.this.treeScroll);
            this.add((Component)FuseStrandsWizard.this.treePanel, "South");
        }
    }

    private class FuseStrandsListener
    implements ActionListener {
        private FuseStrandsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "fusestrands " + FuseStrandsWizard.this.selectionField1.getText().trim() + " " + FuseStrandsWizard.this.selectionField2.getText().trim();
            try {
                FuseStrandsWizard.this.application.runScriptLine(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(FuseStrandsWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FuseStrandsWizard.this.frame.setVisible(false);
            FuseStrandsWizard.this.frame = null;
            FuseStrandsWizard.this.finished = true;
        }
    }
}

